/*
 * Decompiled with CFR 0.152.
 */
package com.Zrips.CMI.Modules.Teleportations;

import com.Zrips.CMI.CMI;
import com.Zrips.CMI.Containers.RandomTeleport;
import com.Zrips.CMI.Locale.CMILC;
import com.Zrips.CMI.Modules.Permissions.PermissionsManager;
import com.Zrips.CMI.Modules.Teleportations.CMIChunkSnapShot;
import com.Zrips.CMI.Modules.Teleportations.CMIRunningRandomTeleports;
import com.Zrips.CMI.Modules.Teleportations.CMITeleportLocation;
import com.Zrips.CMI.Modules.Teleportations.CMITeleportType;
import com.Zrips.CMI.Modules.Teleportations.PositionRelativeData;
import com.Zrips.CMI.Modules.Worlds.CMIBiome;
import com.Zrips.CMI.commands.list.rt;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import net.Zrips.CMILib.Container.CMILocation;
import net.Zrips.CMILib.Container.CMIVectorInt3D;
import net.Zrips.CMILib.Container.CMIWorld;
import net.Zrips.CMILib.Container.CuboidArea;
import net.Zrips.CMILib.FileHandler.ConfigReader;
import net.Zrips.CMILib.Items.CMIMC;
import net.Zrips.CMILib.Items.CMIMaterial;
import net.Zrips.CMILib.Version.Version;
import org.bukkit.Bukkit;
import org.bukkit.ChunkSnapshot;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Biome;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;

public class RandomTeleportationManager {
    private CMI plugin;
    Set<String> cacheFilling = new HashSet<String>();
    private HashMap<String, RandomTeleport> randomTeleports = new HashMap();
    private int randomTeleportCooldown = 3;
    private int randomTeleportMaxTries = 10;
    private List<Biome> randomTeleportExcludedBiomes = new ArrayList<Biome>();
    static Random random = new Random(System.nanoTime());
    private static final String fileName = "RandomTeleportations.yml";
    ConcurrentHashMap<UUID, CMIRunningRandomTeleports> playerRandomTeleports = new ConcurrentHashMap();
    String[] substrings = new String[]{"...", "..", "."};

    public RandomTeleportationManager(CMI cMI) {
        this.plugin = cMI;
    }

    public void loadConfig() {
        Object object;
        boolean bl;
        boolean bl2;
        boolean bl3;
        int n;
        boolean bl4;
        boolean bl5;
        boolean bl6;
        boolean bl7;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        Object object2;
        ConfigReader configReader = null;
        try {
            configReader = new ConfigReader((Plugin)CMI.getInstance(), "Settings" + File.separator + fileName);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (configReader == null) {
            CMI.getInstance().consoleMessage("&cFailed to load Settings" + File.separator + fileName + " file");
            return;
        }
        ConfigReader configReader2 = CMI.getInstance().getConfigManager().getConfig();
        if (configReader2.getC().isConfigurationSection("RandomTeleportation")) {
            configReader.getC().set("RandomTeleportation", configReader2.getC().get("RandomTeleportation"));
        }
        HashSet<String> hashSet = new HashSet<String>();
        for (World world2 : Bukkit.getWorlds()) {
            hashSet.add(world2.getName());
        }
        boolean bl8 = false;
        this.randomTeleports.clear();
        configReader.addComment("RandomTeleportation.Cooldown", new String[]{"How long force player to wait before using command again."});
        this.randomTeleportCooldown = configReader.get("RandomTeleportation.Cooldown", 5);
        configReader.addComment("RandomTeleportation.MaxTries", new String[]{"How many times to try find correct location for teleportation.", "Keep it at low number, as player always can try again after delay"});
        this.randomTeleportMaxTries = configReader.get("RandomTeleportation.MaxTries", 20);
        configReader.addComment("RandomTeleportation.ExcludedBiomes", new String[]{"List of biomes to exclude from random teleportation"});
        List list2 = configReader.get("RandomTeleportation.ExcludedBiomes", Arrays.asList("Ocean", "Deep ocean", "Deep cold ocean", "Cold ocean", "Deep lukewarm ocean", "Lukewarm ocean", "Warm ocean", "River"));
        ConfigurationSection configurationSection2 = list2.iterator();
        while (configurationSection2.hasNext()) {
            object2 = (String)configurationSection2.next();
            object2 = ((String)object2).replace(" ", "").replace("_", "");
            Biome[] biomeArray = Biome.values();
            int n7 = biomeArray.length;
            int n8 = 0;
            while (n8 < n7) {
                Object object3 = biomeArray[n8];
                if (object3.name().replace("_", "").equalsIgnoreCase((String)object2)) {
                    this.randomTeleportExcludedBiomes.add((Biome)object3);
                }
                ++n8;
            }
        }
        configReader.addComment("RandomTeleportation.AutoGenerateWorlds", new String[]{"If this set to true we will generate random teleport default settings for all detected worlds", "Setting to false will no longer generate world setups, but you can add them manually if needed"});
        object2 = configReader.get("RandomTeleportation.AutoGenerateWorlds", Boolean.valueOf(true));
        if (configReader.getC().isConfigurationSection("RandomTeleportation.Worlds") && (configurationSection2 = configReader.getC().getConfigurationSection("RandomTeleportation.Worlds")) != null) {
            for (Object object3 : configurationSection2.getKeys(false)) {
                World world3;
                Set set;
                String string = "RandomTeleportation.Worlds." + (String)object3 + ".";
                boolean bl9 = configReader.get(String.valueOf(string) + "Enabled", Boolean.valueOf(true));
                if (!bl8) {
                    configReader.addComment(String.valueOf(string) + "MaxTries", new String[]{"Amount of times we should try to find valid location. This is mostly directly correlates with amount of chunks we will check", "If set to 0 we will use default MaxTries set at the top of file"});
                }
                int n9 = n6 = (n6 = configReader.get(String.valueOf(string) + "MaxTries", 0)) < 1 ? this.randomTeleportMaxTries : n6;
                if (!bl8) {
                    configReader.addComment("RandomTeleportation.Worlds." + (String)object3, new String[]{"World name to use this feature. Add another one with appropriate name to enable random teleportation"});
                }
                if (!bl8) {
                    configReader.addComment(String.valueOf(string) + "Range.Max", new String[]{"Max coordinate to teleport, setting to 1000, player can be teleported between -1000 and 1000 blocks between defined center location", "For example having centerX at 2000 and centerZ at 3000 while MaxRange is set to 1500 we will teleport player between x:500;z:1500 and x:3500;z:4500 coordinates"});
                }
                n5 = configReader.get(String.valueOf(string) + "Range.Max", configReader.getC().getInt(String.valueOf(string) + "MaxRange", 1000));
                if (!bl8) {
                    configReader.addComment(String.valueOf(string) + "Range.Min", new String[]{"If maxcord set to 1000 and mincord to 500, then player can be teleported between -1000 to -500 and 1000 to 500 coordinates"});
                }
                n4 = configReader.get(String.valueOf(string) + "Range.Min", configReader.getC().getInt(String.valueOf(string) + "MinRange", 500));
                n3 = configReader.get(String.valueOf(string) + "Center.X", configReader.getC().getInt(String.valueOf(string) + "CenterX", 0));
                n2 = configReader.get(String.valueOf(string) + "Center.Z", configReader.getC().getInt(String.valueOf(string) + "CenterZ", 0));
                if (!bl8) {
                    configReader.addComment(String.valueOf(string) + "Circle", new String[]{"Shape of area player can be teleported into. If your map is square shaped then keep this at false"});
                }
                bl7 = configReader.get(String.valueOf(string) + "Circle", Boolean.valueOf(false));
                if (!bl8) {
                    configReader.addComment(String.valueOf(string) + "SurfaceOnly", new String[]{"With this option we will only attempt to teleport player on highest block and ignore any cave teleportations", "Exception when you have Ignore.Leaves set to true which will attempt to place player under the tree leaves if there is any empty space"});
                }
                bl6 = configReader.get(String.valueOf(string) + "SurfaceOnly", Boolean.valueOf(configReader.getC().getBoolean(String.valueOf(string) + "surfaceOnly", false)));
                if (!bl8) {
                    configReader.addComment(String.valueOf(string) + "FromAnotherWorld", new String[]{"When enabled player will be able to random teleport at specied world while being in another one"});
                }
                bl5 = configReader.get(String.valueOf(string) + "FromAnotherWorld", Boolean.valueOf(true));
                if (!bl8) {
                    configReader.addComment(String.valueOf(string) + "RequireWorldPermission", new String[]{"When enabled player will be required to have (" + PermissionsManager.CMIPerm.randomteleport_$1.getPermission(new String[]{object3}) + ") permission node to random teleport inside this world"});
                }
                bl4 = configReader.get(String.valueOf(string) + "RequireWorldPermission", Boolean.valueOf(false));
                if (!bl8) {
                    configReader.addComment(String.valueOf(string) + "YLimits.Min", new String[]{"Location detection limitations on Y axis. If you want to minimize teleportations underground then you can set this value to 63", "Higher limitations might increase time needed to find valid one"});
                }
                n = configReader.get(String.valueOf(string) + "YLimits.Min", configReader.getC().getInt(String.valueOf(string) + "minY", 0));
                int n10 = configReader.get(String.valueOf(string) + "YLimits.Max", configReader.getC().getInt(String.valueOf(string) + "maxY", 256));
                boolean bl10 = configReader.get(String.valueOf(string) + "Ignore.Water", Boolean.valueOf(configReader.getC().getBoolean(String.valueOf(string) + "IgnoreWater", false)));
                bl3 = configReader.get(String.valueOf(string) + "Ignore.Lava", Boolean.valueOf(configReader.getC().getBoolean(String.valueOf(string) + "IgnoreLava", false)));
                bl2 = configReader.get(String.valueOf(string) + "Ignore.Leaves", Boolean.valueOf(configReader.getC().getBoolean(String.valueOf(string) + "IgnoreLeaves", false)));
                bl = configReader.get(String.valueOf(string) + "Ignore.PowderSnow", Boolean.valueOf(configReader.getC().getBoolean(String.valueOf(string) + "ignorePowderSnow", false)));
                if (!bl8) {
                    configReader.addComment(String.valueOf(string) + "Ignore.Materials", new String[]{"List of floor materials we should ignore when random teleporting"});
                }
                ArrayList arrayList = new ArrayList();
                arrayList.addAll(configReader.get(String.valueOf(string) + "Ignore.Materials", configReader.getC().getList(String.valueOf(string) + "ignoredMaterials", new ArrayList())));
                Set set2 = arrayList.stream().map(CMIMaterial::get).filter(cMIMaterial -> cMIMaterial != null && !cMIMaterial.isNone()).collect(Collectors.toCollection(HashSet::new));
                if (!bl8) {
                    configReader.addComment(String.valueOf(string) + "Ignore.Biomes", new String[]{"List of biomes we should ignore when random teleporting", "Keeping it empty will include all of them", "If this is empty and ExcludedBiomes contains set biomes then we will use it"});
                }
                if ((object = (Set)configReader.get(String.valueOf(string) + "Ignore.Biomes", new ArrayList()).stream().map(CMIBiome::get).filter(Objects::nonNull).collect(Collectors.toCollection(HashSet::new))).isEmpty()) {
                    object.addAll(this.getRandomTeleportExcludedBiomes());
                }
                if (!bl8) {
                    configReader.addComment(String.valueOf(string) + "PreferredBiomes", new String[]{"List of biomes we should look for when random teleporting", "If this contains biome names then we will ignore Ignore.Biomes section"});
                }
                if (!(set = (Set)configReader.get(String.valueOf(string) + "PreferredBiomes", new ArrayList()).stream().map(CMIBiome::get).filter(Objects::nonNull).collect(Collectors.toCollection(HashSet::new))).isEmpty()) {
                    object.clear();
                }
                if ((world3 = this.plugin.getUtilManager().getWorld((String)object3)) == null) {
                    this.plugin.consoleMessage("&e(RandomTeleportation) Can't find world with (" + (String)object3 + ") name");
                }
                bl8 = true;
                hashSet.remove(object3);
                RandomTeleport randomTeleport = new RandomTeleport(bl9, n5, n4, new CMILocation((String)object3, (double)n3, 63.0, (double)n2)).setCircle(bl7).setIgnoreLava(bl3).setIgnoreLeaves(bl2).setIgnoreWater(bl10).setIgnorePowderSnow(bl).setIgnoredMaterials(set2).setMinY(n).setMaxY(n10).setFromAnotherWorld(bl5).setRequireWorldPermission(bl4).setSurfaceOnly(bl6).setIgnoredBiomes((Set<Biome>)object).setPreferredBiomes(set).setMaxTries(n6);
                if (!bl7 && world3 != null) {
                    try {
                        Location location = world3.getWorldBorder().getCenter();
                        double d = world3.getWorldBorder().getSize() / 2.0;
                        double d2 = location.getX() - d;
                        double d3 = location.getX() + d;
                        double d4 = location.getZ() - d;
                        double d5 = location.getZ() + d;
                        double d6 = randomTeleport.getCenter().getX() - (double)randomTeleport.getMaxDistance();
                        double d7 = randomTeleport.getCenter().getX() + (double)randomTeleport.getMaxDistance();
                        double d8 = randomTeleport.getCenter().getZ() - (double)randomTeleport.getMaxDistance();
                        double d9 = randomTeleport.getCenter().getZ() + (double)randomTeleport.getMaxDistance();
                        if (d2 > d6) {
                            this.plugin.consoleMessage("&5Random teleport location is out of &6minimal (" + d2 + " -> " + d6 + ") &5world border &6X &5coordinate bounds for &6" + world3.getName() + " &5world. Please update values.");
                        }
                        if (d3 < d7) {
                            this.plugin.consoleMessage("&5Random teleport location is out of &6maximal (" + d3 + " -> " + d7 + ") &5world border &6X &5coordinate bounds for &6" + world3.getName() + " &5world. Please update values.");
                        }
                        if (d4 > d8) {
                            this.plugin.consoleMessage("&5Random teleport location is out of &6minimal (" + d4 + " -> " + d8 + ") &5world border &6Z &5coordinate bounds for &6" + world3.getName() + " &5world. Please update values.");
                        }
                        if (d5 < d9) {
                            this.plugin.consoleMessage("&5Random teleport location is out of &6maximal (" + d5 + " -> " + d9 + ") &5world border &6Z &5coordinate bounds for &6" + world3.getName() + " &5world. Please update values.");
                        }
                    }
                    catch (NoSuchMethodError noSuchMethodError) {
                        // empty catch block
                    }
                }
                this.randomTeleports.put((String)object3, randomTeleport);
            }
        }
        if (((Boolean)object2).booleanValue()) {
            for (ConfigurationSection configurationSection2 : Bukkit.getWorlds()) {
                if (!hashSet.contains(configurationSection2.getName())) continue;
                String string = configurationSection2.getName();
                string = string.replace(".", "_");
                String string2 = "RandomTeleportation.Worlds." + string + ".";
                boolean bl11 = configReader.get(String.valueOf(string2) + "Enabled", Boolean.valueOf(true));
                n6 = configReader.get(String.valueOf(string2) + "MaxTries", 0);
                n5 = configReader.get(String.valueOf(string2) + "Range.Max", 1000);
                n4 = configReader.get(String.valueOf(string2) + "Range.Min", 500);
                n3 = configReader.get(String.valueOf(string2) + "Center.X", 0);
                n2 = configReader.get(String.valueOf(string2) + "Center.Z", 0);
                bl7 = configReader.get(String.valueOf(string2) + "Circle", Boolean.valueOf(false));
                bl6 = configReader.get(String.valueOf(string2) + "Ignore.Water", Boolean.valueOf(true));
                bl5 = configReader.get(String.valueOf(string2) + "Ignore.Lava", Boolean.valueOf(true));
                bl4 = configReader.get(String.valueOf(string2) + "Ignore.Leaves", Boolean.valueOf(true));
                n = configReader.get(String.valueOf(string2) + "Ignore.PowderSnow", Boolean.valueOf(false)).booleanValue();
                ArrayList arrayList = new ArrayList();
                arrayList.addAll(configReader.get(String.valueOf(string2) + "Ignore.Materials", arrayList));
                configReader.get(String.valueOf(string2) + "Ignore.Biomes", new ArrayList());
                configReader.get(String.valueOf(string2) + "PreferredBiomes", new ArrayList());
                Set set = arrayList.stream().map(CMIMaterial::get).filter(cMIMaterial -> cMIMaterial != null && !cMIMaterial.isNone()).collect(Collectors.toCollection(HashSet::new));
                bl3 = configReader.get(String.valueOf(string2) + "SurfaceOnly", Boolean.valueOf(false));
                bl2 = configReader.get(String.valueOf(string2) + "FromAnotherWorld", Boolean.valueOf(true));
                bl = configReader.get(String.valueOf(string2) + "RequireWorldPermission", Boolean.valueOf(false));
                int n11 = configReader.get(String.valueOf(string2) + "YLimits.Min", CMIWorld.getMinHeight((World)configurationSection2));
                int n12 = configReader.get(String.valueOf(string2) + "YLimits.Max", CMIWorld.getMaxHeight((World)configurationSection2));
                object = new RandomTeleport(bl11, n5, n4, new CMILocation((World)configurationSection2, (double)n3, (double)(CMIWorld.getMaxHeight((World)configurationSection2) / 2), (double)n2));
                ((RandomTeleport)object).setCircle(bl7);
                ((RandomTeleport)object).setCircle(bl7).setIgnoreLava(bl5).setIgnoreWater(bl6).setIgnoreLeaves(bl4).setIgnorePowderSnow(n != 0).setIgnoredMaterials(set).setMinY(n11).setMaxY(n12).setFromAnotherWorld(bl2).setRequireWorldPermission(bl).setSurfaceOnly(bl3);
                this.randomTeleports.put(configurationSection2.getName(), (RandomTeleport)object);
            }
        }
        configReader.save();
    }

    public RandomTeleport getRandomTeleport(World world2) {
        return this.getRandomTeleport(world2, false);
    }

    public RandomTeleport getRandomTeleport(World world2, boolean bl) {
        if (world2 == null) {
            return null;
        }
        RandomTeleport randomTeleport = this.randomTeleports.get(world2.getName());
        return randomTeleport == null ? null : (randomTeleport.isEnabled() && randomTeleport.getCenter().getWorld() != null ? randomTeleport : (bl ? randomTeleport : null));
    }

    public HashMap<String, RandomTeleport> getRandomTeleports() {
        return this.randomTeleports;
    }

    public int getRandomTeleportMaxTries() {
        return this.randomTeleportMaxTries;
    }

    public int getRandomTeleportCooldown() {
        return this.randomTeleportCooldown;
    }

    public List<Biome> getRandomTeleportExcludedBiomes() {
        return this.randomTeleportExcludedBiomes;
    }

    public CompletableFuture<CMITeleportLocation> getRandomTeleportationLocation(RandomTeleport randomTeleport, Location location, CompletableFuture<CMIChunkSnapShot> completableFuture) {
        return completableFuture.thenComposeAsync(cMIChunkSnapShot -> CompletableFuture.supplyAsync(() -> {
            CMITeleportLocation cMITeleportLocation = new CMITeleportLocation(cMIChunkSnapShot.getWorld());
            ChunkSnapshot chunkSnapshot = cMIChunkSnapShot.getSnapshot();
            int n = -999;
            int n2 = -999;
            PositionRelativeData positionRelativeData = new PositionRelativeData(location);
            Boolean bl = null;
            boolean bl2 = false;
            int n3 = randomTeleport.getMaxY() - 2;
            while (n3 > randomTeleport.getMinY()) {
                if (n != -999 || this.plugin.getTeleportHandler().isEmptySpaceForPlayer(chunkSnapshot, n3, positionRelativeData)) {
                    n = n3;
                    CMIMaterial cMIMaterial = this.plugin.getTeleportHandler().getBlockType(chunkSnapshot, n3 - 1, positionRelativeData);
                    if (bl == null) {
                        if (cMIMaterial.containsCriteria(CMIMC.LEAVES)) {
                            bl = true;
                        } else if (!cMIMaterial.isAir()) {
                            bl = false;
                        }
                    }
                    if (!this.plugin.getTeleportHandler().isEmpty(cMIMaterial, false) && this.plugin.getTeleportHandler().isEmptySpaceForPlayer(chunkSnapshot, n3, positionRelativeData)) {
                        try {
                            Biome biome = chunkSnapshot.getBiome(positionRelativeData.getLocalX(), n3, positionRelativeData.getLocalZ());
                            if (randomTeleport.isIgnoredBiome(biome)) {
                                return cMITeleportLocation;
                            }
                            if (!randomTeleport.getPreferredBiomes().isEmpty() && !randomTeleport.getPreferredBiomes().contains(biome)) {
                                return cMITeleportLocation;
                            }
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                        if (randomTeleport.isIgnoreLava() && this.plugin.getTeleportHandler().isBad(cMIMaterial)) {
                            if (randomTeleport.isSurfaceOnly()) {
                                break;
                            }
                        } else if (randomTeleport.isIgnoreWater() && (cMIMaterial.isWater() || this.plugin.getTeleportHandler().getBlockType(chunkSnapshot, n3, positionRelativeData).isWater())) {
                            bl2 = true;
                            if (randomTeleport.isSurfaceOnly()) {
                                break;
                            }
                        } else if (randomTeleport.isIgnorePowderedSnow() && cMIMaterial.equals((Object)CMIMaterial.POWDER_SNOW)) {
                            if (randomTeleport.isSurfaceOnly()) {
                                break;
                            }
                        } else if (randomTeleport.isIgnoreLeaves() && cMIMaterial.containsCriteria(CMIMC.LEAVES)) {
                            if (randomTeleport.isSurfaceOnly() && bl != null && !bl.booleanValue()) {
                                break;
                            }
                        } else if (randomTeleport.isIgnoreMaterials() && randomTeleport.isIgnoredMaterial(cMIMaterial)) {
                            if (randomTeleport.isSurfaceOnly()) {
                                break;
                            }
                        } else if (!randomTeleport.isIgnoreWater() || !bl2) {
                            bl2 = false;
                            n2 = n3;
                            break;
                        }
                    }
                }
                --n3;
            }
            cMITeleportLocation.setYaw(random.nextInt(359));
            if (n2 > -999) {
                return cMITeleportLocation.setPosition(new Vector((double)location.getBlockX() + 0.5, (double)n2, (double)location.getBlockZ() + 0.5));
            }
            return cMITeleportLocation;
        }));
    }

    public CompletableFuture<Boolean> randomTeleport(Player player, World world2) {
        if (world2 == null) {
            return CompletableFuture.completedFuture(false);
        }
        RandomTeleport randomTeleport = this.plugin.getRandomTeleportationManager().getRandomTeleport(world2);
        if (randomTeleport == null) {
            return CompletableFuture.completedFuture(false);
        }
        if (this.playerRandomTeleports.containsKey(player.getUniqueId()) && this.playerRandomTeleports.get(player.getUniqueId()).getEndTime() > System.currentTimeMillis()) {
            return CompletableFuture.completedFuture(false);
        }
        int n = this.plugin.getUtilManager().getMaxWorldHeight(world2);
        this.playerRandomTeleports.put(player.getUniqueId(), new CMIRunningRandomTeleports());
        return CompletableFuture.supplyAsync(() -> {
            Vector vector;
            CuboidArea cuboidArea = null;
            try {
                Location location = world2.getWorldBorder().getCenter();
                double d = world2.getWorldBorder().getSize();
                vector = location.toVector();
                cuboidArea = new CuboidArea(world2);
                cuboidArea.setHighPoint(vector.clone().setY(600).setX(vector.getX() + d).setZ(vector.getZ() + d));
                cuboidArea.setLowPoint(vector.clone().setY(-600).setX(vector.getX() - d).setZ(vector.getZ() - d));
            }
            catch (Throwable throwable2) {
                // empty catch block
            }
            int n2 = randomTeleport.getMaxTries();
            while (n2 > 0) {
                int n3 = n2 % this.substrings.length;
                CMILC.sendMessage(player, String.valueOf(CMILC.getIM(rt.class.getSimpleName(), "searching", new Object[0])) + this.substrings[n3]);
                --n2;
                CMIVectorInt3D cMIVectorInt3D = randomTeleport.getRandomLocation();
                vector = new Location(world2, (double)cMIVectorInt3D.getX(), (double)(world2.getEnvironment().equals((Object)World.Environment.NETHER) ? n - 10 : n / 2), (double)cMIVectorInt3D.getZ());
                if (vector.getBlockY() > randomTeleport.getMaxY()) {
                    vector.setY((double)randomTeleport.getMaxY());
                }
                if (cuboidArea != null && !cuboidArea.containsLoc((Location)vector)) continue;
                CompletableFuture<CMIChunkSnapShot> completableFuture = this.plugin.getTeleportHandler().getSnapshot((Location)vector, true, true);
                CompletableFuture<CMITeleportLocation> completableFuture2 = this.getRandomTeleportationLocation(randomTeleport, (Location)vector, completableFuture);
                Boolean bl = false;
                try {
                    CompletionStage<Boolean> completionStage = RandomTeleportationManager.teleportPlayerRandom(player, PlayerTeleportEvent.TeleportCause.PLUGIN, completableFuture2);
                    if (Version.isCurrentEqualOrHigher((Version)Version.v1_13_R1)) {
                        completionStage = ((CompletableFuture)completionStage).orTimeout(10L, TimeUnit.SECONDS);
                    }
                    completionStage = ((CompletableFuture)completionStage).exceptionally(throwable -> {
                        this.playerRandomTeleports.remove(player.getUniqueId());
                        return false;
                    });
                    bl = (Boolean)((CompletableFuture)completionStage).get();
                }
                catch (Throwable throwable3) {
                    throwable3.printStackTrace();
                    this.playerRandomTeleports.remove(player.getUniqueId());
                    Thread.currentThread().interrupt();
                }
                if (!bl.booleanValue()) continue;
                this.playerRandomTeleports.remove(player.getUniqueId());
                return bl;
            }
            this.playerRandomTeleports.remove(player.getUniqueId());
            return false;
        });
    }

    private static CompletableFuture<Boolean> teleportPlayerRandom(Player player, PlayerTeleportEvent.TeleportCause teleportCause, CompletableFuture<CMITeleportLocation> completableFuture) {
        return completableFuture.thenComposeAsync(cMITeleportLocation -> {
            if (cMITeleportLocation.getPosition() == null) {
                return CompletableFuture.completedFuture(false);
            }
            cMITeleportLocation.setType(CMITeleportType.randomTp);
            return CMI.getInstance().getTeleportHandler().finalizeTeleportation(player, teleportCause, (CMITeleportLocation)cMITeleportLocation);
        });
    }
}

