/*
 * Decompiled with CFR 0.152.
 */
package com.Zrips.CMI.Modules.Skin;

import com.Zrips.CMI.CMI;
import com.Zrips.CMI.Modules.Skin.CMISkin;
import com.Zrips.CMI.utils.UUIDFetcher;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.UUID;
import javax.net.ssl.HttpsURLConnection;
import net.Zrips.CMILib.CMILib;
import net.Zrips.CMILib.FileHandler.ConfigReader;
import net.Zrips.CMILib.Version.Schedulers.CMIScheduler;
import net.Zrips.CMILib.Version.Version;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.plugin.java.JavaPlugin;

public class SkinManager {
    public HashMap<UUID, CMISkin> skinCacheByUUID = new HashMap();
    public HashMap<String, CMISkin> skinCacheByName = new HashMap();
    CMI plugin;
    private boolean SteveOnOff = true;
    private boolean AutoApply = false;
    private boolean RequireSpecificPerm = false;
    private long SkinUpdateTimer = 60L;
    private long SkinRequestFrequency = 60L;
    Long lastUpdateRequest = 0L;
    boolean saving = false;
    private String fileName = "SkinsCache.yml";

    public SkinManager(CMI cMI) {
        this.plugin = cMI;
    }

    public void loadConfig() {
        ConfigReader configReader = this.plugin.getConfigManager().getConfig();
        configReader.addComment("Skins.AutoApply", new String[]{"Applies skin to player automatically on his login to server if he doesnt have one already set", "This will always set to skin by target player name"});
        this.AutoApply = configReader.get("Skins.AutoApply", Boolean.valueOf(false));
        configReader.addComment("Skins.SteveOnOff", new String[]{"Sets player sking to Steve when turning skin off and lets server to handle it", "If its false, then skin will be changed to online one"});
        this.SteveOnOff = configReader.get("Skins.SteveOnOff", Boolean.valueOf(true));
        configReader.addComment("Skins.RequireSpecificPerm", new String[]{"Requests from player specific permission for that skin cmi.command.skin.perm.[skinName]"});
        this.RequireSpecificPerm = configReader.get("Skins.RequireSpecificPerm", Boolean.valueOf(false));
        configReader.addComment("Skins.SkinUpdateTimer", new String[]{"Defines time in minutes how offten we want to update skin information from online Mojang servers", "Keep in mind that your server can only send 1 request every minute, so keep it at a decent amount, hour or more", "So if you have this set to 1 hour, then player skin information will be updated if player old skin information is older then 1 hour", "This only triggers when player joins server or changes skin manually"});
        this.SkinUpdateTimer = configReader.get("Skins.SkinUpdateTimer", 1320);
        this.SkinUpdateTimer = this.SkinUpdateTimer < 5L ? 5L : this.SkinUpdateTimer;
        configReader.addComment("Skins.SkinRequestFrequency", new String[]{"Defines time in minutes how offten we want to send requests to Mojang servers", "This is to limit amount of requests in specific time to avoid cluter with possible requests"});
        this.SkinRequestFrequency = configReader.get("Skins.SkinRequestFrequency", 10);
        this.SkinRequestFrequency = this.SkinRequestFrequency < 1L ? 1L : this.SkinRequestFrequency;
    }

    public void removeSkinFromCache(String string) {
        CMISkin cMISkin = this.skinCacheByName.remove(string);
        if (cMISkin != null) {
            this.skinCacheByUUID.remove(cMISkin.getUuid());
        }
    }

    public boolean applySkin(Player player, String string) {
        UUID uUID;
        if (player == null) {
            return false;
        }
        if (string == null) {
            return false;
        }
        if (string.length() == 36) {
            uUID = UUID.fromString(string);
        } else {
            CMISkin cMISkin = this.skinCacheByName.get(string);
            if (cMISkin != null) {
                uUID = cMISkin.getUuid();
            } else if (!this.plugin.preFetchUUIDS().containsKey(string)) {
                uUID = UUIDFetcher.getUUID(string);
                this.plugin.preFetchUUIDS().put(string, uUID);
            } else {
                uUID = this.plugin.preFetchUUIDS().get(string);
            }
        }
        if (uUID == null) {
            return false;
        }
        return this.applySkin(player, uUID);
    }

    public boolean applySkin(Player player, UUID uUID) {
        if (player == null || !player.isOnline() || Version.isCurrentEqual((Version)Version.v1_7_R4)) {
            return false;
        }
        try {
            CMIScheduler.runTask((JavaPlugin)this.plugin, () -> {
                if (this.plugin.getAnimationManager().isSitting(player)) {
                    this.plugin.getAnimationManager().removePlayerFromChair(player);
                }
            });
            boolean bl = this.setSkin(CMILib.getInstance().getReflectionManager().getProfile(player), uUID);
            this.plugin.getNMS().updatePlayerViaPackets(player);
            player.updateInventory();
            return bl;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean setSkin(GameProfile gameProfile, UUID uUID) {
        if (this.checkCache(gameProfile, uUID)) {
            return true;
        }
        try {
            HttpsURLConnection httpsURLConnection = (HttpsURLConnection)new URL(String.format("https://sessionserver.mojang.com/session/minecraft/profile/%s?unsigned=false", uUID.toString().replace("-", ""))).openConnection();
            if (httpsURLConnection.getResponseCode() == 200) {
                InputStream inputStream = httpsURLConnection.getInputStream();
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
                try {
                    String string = bufferedReader.readLine();
                    String string2 = "";
                    Iterator iterator = bufferedReader.lines().iterator();
                    while (true) {
                        if (!iterator.hasNext()) {
                            string = string2.replace(" ", "");
                            if (string.contains("name")) break;
                            boolean bl = this.checkCache(gameProfile, uUID);
                            return bl;
                        }
                        string2 = String.valueOf(string2) + (String)iterator.next();
                    }
                    String string3 = string.split("\"name\":\"")[1].split("\"")[0];
                    if (!string.contains("value")) {
                        boolean bl = this.checkCache(gameProfile, uUID);
                        return bl;
                    }
                    String string4 = string.split("\"value\":\"")[1].split("\"")[0];
                    if (!string.contains("signature")) {
                        boolean bl = this.checkCache(gameProfile, uUID);
                        return bl;
                    }
                    String string5 = string.split("\"signature\":\"")[1].split("\"")[0];
                    CMISkin cMISkin = new CMISkin(string3, uUID, string4, string5);
                    cMISkin.setLastUpdate(System.currentTimeMillis());
                    this.lastUpdateRequest = System.currentTimeMillis();
                    this.skinCacheByUUID.put(uUID, cMISkin);
                    this.skinCacheByName.put(string3, cMISkin);
                    CMIScheduler.runTaskAsynchronously((JavaPlugin)this.plugin, () -> {
                        if (!this.saving) {
                            this.save(cMISkin);
                        }
                    });
                    if (gameProfile == null) return true;
                    gameProfile.getProperties().removeAll((Object)"textures");
                    gameProfile.getProperties().put((Object)"textures", (Object)new Property("textures", string4, string5));
                    return true;
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                    return true;
                }
                finally {
                    bufferedReader.close();
                    inputStream.close();
                    httpsURLConnection.disconnect();
                }
            }
            if (this.checkCache(gameProfile, uUID)) {
                return true;
            }
            System.out.println("Connection could not be opened (Response code " + httpsURLConnection.getResponseCode() + ", " + httpsURLConnection.getResponseMessage() + ")");
            return false;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    private boolean checkCache(GameProfile gameProfile, UUID uUID) {
        if (gameProfile == null) {
            return false;
        }
        CMISkin cMISkin = this.skinCacheByUUID.get(uUID);
        if (cMISkin != null && cMISkin.getSkin() != null && cMISkin.getSignature() != null && cMISkin.getLastUpdate() + this.SkinUpdateTimer * 60L * 1000L > System.currentTimeMillis()) {
            gameProfile.getProperties().removeAll((Object)"textures");
            gameProfile.getProperties().put((Object)"textures", (Object)new Property("textures", cMISkin.getSkin(), cMISkin.getSignature()));
            return true;
        }
        return false;
    }

    public CMISkin getSkin(String string) {
        CMISkin cMISkin;
        if (string == null) {
            return null;
        }
        UUID uUID = null;
        if (string.length() == 36) {
            uUID = UUID.fromString(string);
        } else {
            cMISkin = this.skinCacheByName.get(string);
            if (cMISkin != null && cMISkin.getLastUpdate() + this.SkinUpdateTimer * 60L * 1000L > System.currentTimeMillis()) {
                return cMISkin;
            }
            if (!this.plugin.preFetchUUIDS().containsKey(string)) {
                uUID = UUIDFetcher.getUUID(string);
                this.plugin.preFetchUUIDS().put(string, uUID);
            } else {
                uUID = this.plugin.preFetchUUIDS().get(string);
            }
        }
        if (uUID == null) {
            return null;
        }
        cMISkin = this.skinCacheByUUID.get(uUID);
        if (cMISkin != null && cMISkin.getLastUpdate() + this.SkinUpdateTimer * 60L * 1000L > System.currentTimeMillis()) {
            return cMISkin;
        }
        this.setSkin(null, uUID);
        return this.skinCacheByUUID.get(uUID);
    }

    public void save(CMISkin cMISkin) {
        this.saving = true;
        File file = new File(this.plugin.getDataFolder(), "Saves" + File.separator + this.fileName);
        if (!file.exists()) {
            try {
                file.createNewFile();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        YamlConfiguration yamlConfiguration = YamlConfiguration.loadConfiguration((File)file);
        String string = cMISkin.getUuid().toString();
        yamlConfiguration.set(String.valueOf(string) + ".name", (Object)cMISkin.getName());
        yamlConfiguration.set(String.valueOf(string) + ".skin", (Object)cMISkin.getSkin());
        yamlConfiguration.set(String.valueOf(string) + ".signature", (Object)cMISkin.getSignature());
        yamlConfiguration.set(String.valueOf(string) + ".lastUpdate", (Object)(cMISkin.getLastUpdate() == 0L ? null : cMISkin.getLastUpdate()));
        try {
            yamlConfiguration.save(file);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        this.saving = false;
    }

    public void load() {
        try {
            Long l = System.currentTimeMillis();
            CMI.getInstance().safeRenameFile("skinsCache.yml", "Saves" + File.separator + this.fileName);
            File file = new File(this.plugin.getDataFolder(), "Saves" + File.separator + this.fileName);
            if (!file.exists()) {
                try {
                    file.createNewFile();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
                return;
            }
            YamlConfiguration yamlConfiguration = YamlConfiguration.loadConfiguration((File)file);
            for (String string : yamlConfiguration.getKeys(false)) {
                UUID uUID = UUID.fromString(string);
                if (uUID == null) continue;
                String string2 = yamlConfiguration.getString(String.valueOf(string) + ".name");
                String string3 = yamlConfiguration.getString(String.valueOf(string) + ".skin");
                String string4 = yamlConfiguration.getString(String.valueOf(string) + ".signature");
                Long l2 = 0L;
                if (yamlConfiguration.isLong(String.valueOf(string) + ".lastUpdate")) {
                    l2 = yamlConfiguration.getLong(String.valueOf(string) + ".lastUpdate");
                }
                CMISkin cMISkin = new CMISkin(string2, uUID, string3, string4);
                cMISkin.setLastUpdate(l2);
                this.skinCacheByUUID.put(uUID, cMISkin);
                this.skinCacheByName.put(string2, cMISkin);
            }
            this.plugin.loadMessage(this.skinCacheByUUID.size(), "skin cache entries", System.currentTimeMillis() - l);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean isSteveOnOff() {
        return this.SteveOnOff;
    }

    public void setSteveOnOff(boolean bl) {
        this.SteveOnOff = bl;
    }

    public boolean isRequireSpecificPerm() {
        return this.RequireSpecificPerm;
    }

    public void setRequireSpecificPerm(boolean bl) {
        this.RequireSpecificPerm = bl;
    }

    public boolean isAutoApply() {
        return this.AutoApply;
    }
}

