/*
 * Decompiled with CFR 0.152.
 */
package com.Zrips.CMI.Modules.ShulkerBoxInventory;

import com.Zrips.CMI.CMI;
import com.Zrips.CMI.Containers.CMIUser;
import com.Zrips.CMI.Locale.CMILC;
import com.Zrips.CMI.Modules.Permissions.PermissionsManager;
import com.Zrips.CMI.Modules.ShulkerBoxInventory.ShulkerInv;
import com.Zrips.CMI.events.CMIBackpackOpenEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.Zrips.CMILib.CMILib;
import net.Zrips.CMILib.FileHandler.ConfigReader;
import net.Zrips.CMILib.Items.CMIMaterial;
import net.Zrips.CMILib.Locale.LC;
import net.Zrips.CMILib.NBT.CMINBT;
import net.Zrips.CMILib.Time.CMITimeManager;
import net.Zrips.CMILib.Version.Version;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.block.BlockState;
import org.bukkit.block.ShulkerBox;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BlockStateMeta;
import org.bukkit.inventory.meta.ItemMeta;

public class ShulkerBoxManager {
    HashMap<UUID, ShulkerInv> map = new HashMap();
    private CMI plugin;
    public static final String identifier = "CMIBackPack";
    private boolean PreventInCombat = true;
    private double CostToOpen = 0.0;

    public ShulkerBoxManager(CMI cMI) {
        this.plugin = cMI;
    }

    public boolean stillHaveItem(Player player) {
        ShulkerInv shulkerInv = this.map.get(player.getUniqueId());
        if (shulkerInv == null) {
            return false;
        }
        ItemStack[] itemStackArray = player.getInventory().getContents();
        int n = itemStackArray.length;
        int n2 = 0;
        while (n2 < n) {
            CMINBT cMINBT;
            Integer n3;
            ItemStack itemStack = itemStackArray[n2];
            if (itemStack != null && CMIMaterial.isShulkerBox((Material)itemStack.getType()) && (n3 = (cMINBT = new CMINBT(itemStack)).getInt(identifier)) != null && n3.equals(shulkerInv.getSourceId())) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public void closeAll() {
        for (Map.Entry<UUID, ShulkerInv> entry : this.map.entrySet()) {
            Player player = CMIUser.getOnlinePlayer(entry.getKey());
            if (player == null) continue;
            player.closeInventory();
        }
    }

    public boolean isEditing(Player player) {
        if (this.map.isEmpty()) {
            return false;
        }
        return this.map.containsKey(player.getUniqueId());
    }

    private Inventory getExisting(Player player) {
        ShulkerInv shulkerInv = this.map.get(player.getUniqueId());
        if (shulkerInv != null) {
            Inventory inventory = shulkerInv.getCustomInv();
            player.closeInventory();
            return inventory;
        }
        return null;
    }

    public void loadConfig() {
        ConfigReader configReader = this.plugin.getConfigManager().getConfig();
        configReader.addComment("ShulkerBoxes.PreventInCombat", new String[]{"When set to true, players will not have option to open shulker boxes while in combat", "Combat timer can be defined under combat section"});
        this.PreventInCombat = configReader.get("ShulkerBoxes.PreventInCombat", Boolean.valueOf(true));
        configReader.addComment("ShulkerBoxes.CostToOpen", new String[]{"Money cost to open shulker box, if player doesn't have enough money then we will not allow to open shulker box from inventory", "Setting this to 0 will disable money requirement", "This can be bypassed with " + PermissionsManager.CMIPerm.openshulker_free.getPermission() + " permission node"});
        this.CostToOpen = configReader.get("ShulkerBoxes.CostToOpen", Double.valueOf(0.0));
    }

    public void openShulkerBox(Player player, ItemStack itemStack) {
        CMIUser cMIUser;
        if (itemStack == null || itemStack.getAmount() > 1) {
            return;
        }
        Inventory inventory = this.plugin.getNMS().getShulkerInv(itemStack);
        if (inventory == null) {
            return;
        }
        CMINBT cMINBT = new CMINBT(itemStack);
        if (!cMINBT.hasNBT(identifier)) {
            return;
        }
        Inventory inventory2 = this.getExisting(player);
        if (this.PreventInCombat && (cMIUser = this.plugin.getPlayerManager().getUser(player)).isInCombatWithPlayer()) {
            CMILC.info_combat_CantUseShulkerBox.sendMessage(player, "[time]", CMITimeManager.to24hourShort((Long)((long)CMI.getInstance().getPlayerCombatManager().getCombatTimer() * 1000L - (System.currentTimeMillis() - cMIUser.getGotLastDamageFromPlayer()))));
            return;
        }
        if (inventory2 == null) {
            inventory2 = Bukkit.createInventory((InventoryHolder)inventory.getHolder(), (int)27, (String)CMILib.getInstance().getItemManager().getItem(itemStack).getDisplayName());
        }
        int n = 0;
        while (n < inventory.getContents().length) {
            inventory2.setItem(n, inventory.getContents()[n]);
            ++n;
        }
        if (this.plugin.getShulkerBoxManager().isEditing(player)) {
            this.updateShulkerItem(player);
        }
        player.closeInventory();
        ShulkerInv shulkerInv = new ShulkerInv(player, inventory2);
        shulkerInv.setShulkerBox(itemStack);
        shulkerInv.setSourceId(cMINBT.getInt(identifier));
        CMIBackpackOpenEvent cMIBackpackOpenEvent = new CMIBackpackOpenEvent(shulkerInv, this.CostToOpen);
        Bukkit.getPluginManager().callEvent((Event)cMIBackpackOpenEvent);
        if (cMIBackpackOpenEvent.isCancelled()) {
            return;
        }
        if (cMIBackpackOpenEvent.getCostToOpen() > 0.0 && !PermissionsManager.CMIPerm.openshulker_free.hasPermission((CommandSender)player)) {
            CMIUser cMIUser2 = CMIUser.getUser(player);
            if (!cMIUser2.hasMoney(cMIBackpackOpenEvent.getCostToOpen())) {
                LC.econ_notEnoughMoney.sendMessage((Object)player, new Object[]{"[amount]", cMIBackpackOpenEvent.getCostToOpen()});
                return;
            }
            cMIUser2.withdraw(cMIBackpackOpenEvent.getCostToOpen());
            CMILC.info_combat_CostToOpen.sendMessage(cMIBackpackOpenEvent.getPlayer(), "[amount]", this.plugin.getEconomyManager().format(cMIBackpackOpenEvent.getCostToOpen()));
        }
        this.map.put(cMIBackpackOpenEvent.getPlayer().getUniqueId(), cMIBackpackOpenEvent.getShulkerbackpack());
        cMIBackpackOpenEvent.getPlayer().openInventory(cMIBackpackOpenEvent.getGuiInv());
        if (Version.isCurrentEqualOrHigher((Version)Version.v1_17_R1)) {
            player.updateInventory();
        }
    }

    public void updateShulkerItem(Player player) {
        ItemStack itemStack;
        ShulkerInv shulkerInv = this.map.get(player.getUniqueId());
        if (shulkerInv == null) {
            return;
        }
        ItemStack itemStack2 = null;
        ItemStack[] itemStackArray = player.getInventory().getContents();
        int n = itemStackArray.length;
        int n2 = 0;
        while (n2 < n) {
            CMINBT cMINBT;
            Integer n3;
            itemStack = itemStackArray[n2];
            if (itemStack != null && CMIMaterial.isShulkerBox((Material)itemStack.getType()) && (n3 = (cMINBT = new CMINBT(itemStack)).getInt(identifier)) != null && n3.equals(shulkerInv.getSourceId())) {
                itemStack2 = itemStack;
                break;
            }
            ++n2;
        }
        if (itemStack2 == null) {
            return;
        }
        itemStack = this.plugin.getNMS().getShulkerInv(itemStack2);
        if (itemStack == null) {
            return;
        }
        ItemStack[] itemStackArray2 = shulkerInv.getCustomInv().getContents();
        itemStack.setStorageContents(itemStackArray2);
        this.setShulkerInv(itemStack2, itemStackArray2);
    }

    public void remove(Player player) {
        this.map.remove(player.getUniqueId());
    }

    public boolean isShulkerBox(ItemStack itemStack) {
        BlockStateMeta blockStateMeta;
        block18: {
            block17: {
                ItemMeta itemMeta;
                block16: {
                    block15: {
                        block14: {
                            if (Version.isCurrentEqualOrHigher((Version)Version.v1_20_R4)) {
                                block13: {
                                    block12: {
                                        try {
                                            if (itemStack != null) break block12;
                                            return false;
                                        }
                                        catch (Exception exception) {
                                            return false;
                                        }
                                    }
                                    ItemMeta itemMeta2 = itemStack.getItemMeta();
                                    if (itemMeta2 instanceof BlockStateMeta) break block13;
                                    return false;
                                }
                                return CMIMaterial.get((ItemStack)itemStack).isShulkerBox();
                            }
                            try {
                                if (itemStack != null) break block14;
                                return false;
                            }
                            catch (Exception exception) {
                                return false;
                            }
                        }
                        itemMeta = itemStack.getItemMeta();
                        if (itemMeta != null) break block15;
                        return false;
                    }
                    if (itemMeta instanceof BlockStateMeta) break block16;
                    return false;
                }
                blockStateMeta = (BlockStateMeta)itemMeta;
                if (blockStateMeta.hasBlockState()) break block17;
                return false;
            }
            if (blockStateMeta.getBlockState() != null) break block18;
            return false;
        }
        return blockStateMeta.getBlockState() instanceof ShulkerBox;
    }

    public List<ItemStack> getShulkerBoxContents(ItemStack itemStack) {
        ArrayList<ItemStack> arrayList = new ArrayList<ItemStack>();
        ItemMeta itemMeta = itemStack.getItemMeta();
        if (itemMeta == null) {
            return arrayList;
        }
        if (!(itemMeta instanceof BlockStateMeta)) {
            return arrayList;
        }
        BlockStateMeta blockStateMeta = (BlockStateMeta)itemMeta;
        if (!blockStateMeta.hasBlockState()) {
            return arrayList;
        }
        if (blockStateMeta.getBlockState() == null) {
            return arrayList;
        }
        if (!(blockStateMeta.getBlockState() instanceof ShulkerBox)) {
            return arrayList;
        }
        ShulkerBox shulkerBox = (ShulkerBox)blockStateMeta.getBlockState();
        if (shulkerBox.getInventory() == null) {
            return arrayList;
        }
        ItemStack[] itemStackArray = shulkerBox.getInventory().getContents();
        int n = itemStackArray.length;
        int n2 = 0;
        while (n2 < n) {
            ItemStack itemStack2 = itemStackArray[n2];
            arrayList.add(itemStack2);
            ++n2;
        }
        return arrayList;
    }

    public void updateEntireShulkerInv(Player player, ItemStack[] itemStackArray) {
        ShulkerInv shulkerInv = this.map.get(player.getUniqueId());
        if (shulkerInv == null) {
            return;
        }
        ItemStack itemStack = null;
        ItemStack[] itemStackArray2 = player.getInventory().getContents();
        int n = itemStackArray2.length;
        int n2 = 0;
        while (n2 < n) {
            CMINBT cMINBT;
            Integer n3;
            ItemStack itemStack2 = itemStackArray2[n2];
            if (itemStack2 != null && CMIMaterial.isShulkerBox((Material)itemStack2.getType()) && (n3 = (cMINBT = new CMINBT(itemStack2)).getInt(identifier)) != null && n3.equals(shulkerInv.getSourceId())) {
                itemStack = itemStack2;
                break;
            }
            ++n2;
        }
        if (itemStack == null) {
            return;
        }
        this.setShulkerInv(itemStack, itemStackArray);
    }

    public void setShulkerInv(ItemStack itemStack, ItemStack[] itemStackArray) {
        if (itemStack == null) {
            return;
        }
        if (Version.isCurrentEqualOrHigher((Version)Version.v1_20_R4)) {
            ItemMeta itemMeta = itemStack.getItemMeta();
            if (!(itemMeta instanceof BlockStateMeta)) {
                return;
            }
            BlockStateMeta blockStateMeta = (BlockStateMeta)itemMeta;
            if (!(blockStateMeta.getBlockState() instanceof ShulkerBox)) {
                return;
            }
            ShulkerBox shulkerBox = (ShulkerBox)blockStateMeta.getBlockState();
            if (shulkerBox.getInventory() == null) {
                return;
            }
            shulkerBox.getInventory().setContents(itemStackArray);
            blockStateMeta.setBlockState((BlockState)shulkerBox);
            itemStack.setItemMeta((ItemMeta)blockStateMeta);
            return;
        }
        ItemMeta itemMeta = itemStack.getItemMeta();
        if (itemMeta == null) {
            return;
        }
        if (!(itemMeta instanceof BlockStateMeta)) {
            return;
        }
        BlockStateMeta blockStateMeta = (BlockStateMeta)itemMeta;
        if (!blockStateMeta.hasBlockState()) {
            return;
        }
        if (blockStateMeta.getBlockState() == null) {
            return;
        }
        if (!(blockStateMeta.getBlockState() instanceof ShulkerBox)) {
            return;
        }
        ShulkerBox shulkerBox = (ShulkerBox)blockStateMeta.getBlockState();
        if (shulkerBox.getInventory() == null) {
            return;
        }
        shulkerBox.getInventory().setContents(itemStackArray);
        blockStateMeta.setBlockState((BlockState)shulkerBox);
        itemStack.setItemMeta((ItemMeta)blockStateMeta);
    }
}

