/*
 * Decompiled with CFR 0.152.
 */
package com.Zrips.CMI.Modules.Selection;

import com.Zrips.CMI.CMI;
import com.Zrips.CMI.Modules.Permissions.PermissionsManager;
import com.Zrips.CMI.events.CMISelectionEvent;
import net.Zrips.CMILib.Items.CMIMaterial;
import net.Zrips.CMILib.Locale.LC;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;

public class SelectionListener
implements Listener {
    private CMI plugin;

    public SelectionListener(CMI cMI) {
        this.plugin = cMI;
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onSelection(PlayerInteractEvent playerInteractEvent) {
        if (playerInteractEvent.getPlayer() == null) {
            return;
        }
        if (playerInteractEvent.getAction() != Action.LEFT_CLICK_BLOCK && playerInteractEvent.getAction() != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        Player player = playerInteractEvent.getPlayer();
        CMIMaterial cMIMaterial = CMIMaterial.get((ItemStack)player.getItemInHand());
        if (cMIMaterial != this.plugin.getConfigManager().getSelectionTool().getCMIType()) {
            return;
        }
        if (player.getGameMode() == GameMode.CREATIVE) {
            playerInteractEvent.setCancelled(true);
        }
        if (!PermissionsManager.CMIPerm.select.hasPermission((CommandSender)player)) {
            return;
        }
        Block block = playerInteractEvent.getClickedBlock();
        if (playerInteractEvent.getAction() == Action.LEFT_CLICK_BLOCK) {
            Location location = block.getLocation();
            this.plugin.getSelectionManager().placeLoc1(player, location, true);
            CMISelectionEvent cMISelectionEvent = new CMISelectionEvent(player, this.plugin.getSelectionManager().getSelectionCuboid(player));
            Bukkit.getPluginManager().callEvent((Event)cMISelectionEvent);
            LC.Selection_PrimaryPoint.sendMessage((Object)player, new Object[]{"[point]", LC.Selection_CoordsTop.getLocale(new Object[]{location.getBlockX(), location.getBlockY(), location.getBlockZ()})});
            playerInteractEvent.setCancelled(true);
        } else if (playerInteractEvent.getAction() == Action.RIGHT_CLICK_BLOCK) {
            boolean bl = false;
            try {
                if (playerInteractEvent.getHand() == EquipmentSlot.HAND) {
                    bl = true;
                }
            }
            catch (Exception | NoSuchMethodError throwable) {
                bl = true;
            }
            if (bl) {
                Location location = block.getLocation();
                this.plugin.getSelectionManager().placeLoc2(player, location, true);
                CMISelectionEvent cMISelectionEvent = new CMISelectionEvent(player, this.plugin.getSelectionManager().getSelectionCuboid(player));
                Bukkit.getPluginManager().callEvent((Event)cMISelectionEvent);
                LC.Selection_SecondaryPoint.sendMessage((Object)player, new Object[]{"[point]", LC.Selection_CoordsBottom.getLocale(new Object[]{location.getBlockX(), location.getBlockY(), location.getBlockZ()})});
                playerInteractEvent.setCancelled(true);
            }
        }
        if (this.plugin.getSelectionManager().hasPlacedBoth(player)) {
            this.plugin.getSelectionManager().showSelectionInfo(player);
        }
    }
}

