/*
 * Decompiled with CFR 0.152.
 */
package com.Zrips.CMI.Modules.Scavenger;

import com.Zrips.CMI.CMI;
import com.Zrips.CMI.Containers.CMIUser;
import com.Zrips.CMI.Locale.CMILC;
import com.Zrips.CMI.Modules.Scavenger.CMIScavengeItem;
import com.Zrips.CMI.Modules.Worth.WorthEnchantment;
import com.Zrips.CMI.commands.list.scavenge;
import java.io.File;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import net.Zrips.CMILib.Enchants.CMIEnchantment;
import net.Zrips.CMILib.FileHandler.ConfigReader;
import net.Zrips.CMILib.GUI.CMIGui;
import net.Zrips.CMILib.GUI.CMIGuiButton;
import net.Zrips.CMILib.GUI.GUIManager;
import net.Zrips.CMILib.Items.CMIMaterial;
import net.Zrips.CMILib.Locale.LC;
import net.Zrips.CMILib.Version.Schedulers.CMIScheduler;
import net.Zrips.CMILib.Version.Version;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.EnchantmentStorageMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.Repairable;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class ScavengeManager {
    private CMI plugin;
    public static Double baseBreakPercentage = 0.0;
    public static Double eachBreakPercentage = 0.0;
    public static Double eachBreakPercentageLevel = 0.0;
    public static Double baseEnchantFailPercentage = 0.0;
    public static Double levelEnchantFailPercentage = 0.0;
    public static Double levelEnchantFailMaxChance = 100.0;
    public static Double LowerLevelChanceBase = 100.0;
    public static Double LowerLevelForEachLevel = 100.0;
    public static Double LowerLevelMaxChance = 100.0;
    public static Double itemBreakMaxBreakChance = 100.0;
    public static Double EnchantBaseCost = 0.0;
    public static Double EnchantBaseCostExtra = 0.0;
    public static Double IngredientReturnBase = 0.0;
    public static boolean ItemMaterialDurabilityCheck = true;
    public static boolean InvertBlackList = false;
    public static boolean AllowItemPickups = false;
    public static boolean ResetRepairCost = true;
    public static Double ItemBreakDurabilityChange = 0.0;
    public static Set<CMIMaterial> blackList = new HashSet<CMIMaterial>();
    private static final int slotOfItem = 13;

    public ScavengeManager(CMI cMI) {
        this.plugin = cMI;
    }

    public void loadConfig() {
        ConfigReader configReader = null;
        try {
            configReader = new ConfigReader((Plugin)this.plugin, "Settings" + File.separator + "Scavenge.yml");
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
        ConfigReader configReader2 = this.plugin.getConfigManager().getConfig();
        if (configReader2.getC().isConfigurationSection("Scavenge") && !configReader.getC().isConfigurationSection("Scavenge")) {
            configReader.set("Scavenge", (Object)configReader2.getC().getConfigurationSection("Scavenge"));
            configReader.save();
            try {
                configReader = new ConfigReader((Plugin)this.plugin, "Settings" + File.separator + "Scavenge.yml");
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return;
            }
        }
        configReader.addComment("Scavenge.ItemBreak.Base", new String[]{"Defined percentage for item to break when salvaging it", "Value can be from 0 to 100, where 100 means that each time player extract enchant, item breaks", "This can allow player to extract enchantments without breaking item itself", "Set it to 100 if you want to always break item", "Keep in mind that broken item will go throw ingredient return process", "Attention! Items without enchants will have 100% break chance"});
        baseBreakPercentage = configReader.get("Scavenge.ItemBreak.Base", Double.valueOf(8.0));
        baseBreakPercentage = baseBreakPercentage < 0.0 ? 0.0 : (baseBreakPercentage > 100.0 ? 100.0 : baseBreakPercentage);
        configReader.addComment("Scavenge.ItemBreak.ForEachEnchant", new String[]{"Adds extra chance to break item depending on how many enchants item has", "In example having base chance of 8% and having this set to 2 while having item with 3 enchants will result into 8+(2*3)=14% chance to break item"});
        eachBreakPercentage = configReader.get("Scavenge.ItemBreak.ForEachEnchant", Double.valueOf(2.0));
        eachBreakPercentage = eachBreakPercentage < 0.0 ? 0.0 : (eachBreakPercentage > 100.0 ? 100.0 : eachBreakPercentage);
        configReader.addComment("Scavenge.ItemBreak.ForEachEnchantLevel", new String[]{"Adds extra chance to break item depending on enchant level", "This will take into consideration enchantment max and current levels", "Having this set to 7.5 means, that enchantment at max level will have 7.5% extra chance to to break item", "But if you have sharpness 2 which has max level of 5, then only 3% fail chance will be added"});
        eachBreakPercentageLevel = configReader.get("Scavenge.ItemBreak.ForEachEnchantLevel", Double.valueOf(2.0));
        eachBreakPercentageLevel = eachBreakPercentageLevel < 0.0 ? 0.0 : (eachBreakPercentageLevel > 100.0 ? 100.0 : eachBreakPercentageLevel);
        configReader.addComment("Scavenge.ItemBreak.MaxBreakChance", new String[]{"Defines in percentage a max chance to break item when extracting enchants", "This can limit chance to particular one in case it gets to 100% and it would always break"});
        itemBreakMaxBreakChance = configReader.get("Scavenge.ItemBreak.MaxBreakChance", Double.valueOf(100.0));
        itemBreakMaxBreakChance = itemBreakMaxBreakChance < 0.0 ? 0.0 : (itemBreakMaxBreakChance > 100.0 ? 100.0 : itemBreakMaxBreakChance);
        configReader.addComment("Scavenge.ItemBreak.BreakDurabilityCheck", new String[]{"Value between 0 and 100 which defines extra fail chance when items doesnt have max durability", "Having this set to 50 will mean that item at 1 left durability will have fail chance increase by 50%", "Items which are not damaged will not experience any fail chance increase"});
        ItemBreakDurabilityChange = configReader.get("Scavenge.ItemBreak.BreakDurabilityCheck", Double.valueOf(50.0));
        ItemBreakDurabilityChange = ItemBreakDurabilityChange < 0.0 ? 0.0 : (ItemBreakDurabilityChange > 100.0 ? 100.0 : ItemBreakDurabilityChange);
        configReader.addComment("Scavenge.ItemBreak.DurabilityCheck", new String[]{"When set to true, items durability will be taken into consideration when extracting ingredients", "In example if item has 100 max durability and current is at 50, then only half of ingredients will be considered for extraction", "This doesnt mean that player gets 50% of them, it only means that half of possible ingredients will go throw IngredientReturn process"});
        ItemMaterialDurabilityCheck = configReader.get("Scavenge.ItemBreak.DurabilityCheck", Boolean.valueOf(true));
        configReader.addComment("Scavenge.ItemBreak.IngredientReturn.Base", new String[]{"Defines in percentage a max chance to return ingredients of item if it fails extraction process", "This will apply for each ingredient that item has", "Recipe to make that item should exist in database, or it will not return any ingredients"});
        IngredientReturnBase = configReader.get("Scavenge.ItemBreak.IngredientReturn.Base", Double.valueOf(25.0));
        IngredientReturnBase = IngredientReturnBase < 0.0 ? 0.0 : (IngredientReturnBase > 100.0 ? 100.0 : IngredientReturnBase);
        configReader.addComment("Scavenge.EnchantExtractionFail.Base", new String[]{"Adds base chance to fail enchantment extraction", "When enchantment fails, player will not get enchant book with appropriate enchantment"});
        baseEnchantFailPercentage = configReader.get("Scavenge.EnchantExtractionFail.Base", Double.valueOf(10.0));
        baseEnchantFailPercentage = baseEnchantFailPercentage < 0.0 ? 0.0 : (baseEnchantFailPercentage > 100.0 ? 100.0 : baseEnchantFailPercentage);
        configReader.addComment("Scavenge.EnchantExtractionFail.ForEachLevel", new String[]{"Adds extra chance to fail enchantment extraction depending on enchantment level", "This will take into consideration enchantment max and current levels", "Having this set to 75 means, that enchantment at max level will have 75% chance to fail extraction process", "But if you have sharpness 2 which has max level of 5, then only 30% chance to fail will get applied", "While enchants like Aquaaffinity will always have max fail chance as you can only have it at level 1"});
        levelEnchantFailPercentage = configReader.get("Scavenge.EnchantExtractionFail.ForEachLevel", Double.valueOf(10.0));
        levelEnchantFailPercentage = levelEnchantFailPercentage < 0.0 ? 0.0 : (levelEnchantFailPercentage > 100.0 ? 100.0 : levelEnchantFailPercentage);
        configReader.addComment("Scavenge.EnchantExtractionFail.MaxFailChance", new String[]{"Defines in percentage a max chance to fail enchantment extraction", "This can limit chance to particular one in case it gets to 100% and it would always fail"});
        levelEnchantFailMaxChance = configReader.get("Scavenge.EnchantExtractionFail.MaxFailChance", Double.valueOf(75.0));
        levelEnchantFailMaxChance = levelEnchantFailMaxChance < 0.0 ? 0.0 : (levelEnchantFailMaxChance > 100.0 ? 100.0 : levelEnchantFailMaxChance);
        configReader.addComment("Scavenge.EnchantExtractionFail.LevelLower.Base", new String[]{"Defines a chance lowering enchant level if it fails extraction", "This is secondary step when extraction fails and will only apply when it does", "If Enchant is at level 1 already, then player will not get enchanted book at all", "If you want to avoid lowering level of enchant when it fails extraction, set this to 100", "If you want to always lower level down when extracting enchantments, then set EnchantExtractionFail.Base to 100 and set this to 100"});
        LowerLevelChanceBase = configReader.get("Scavenge.EnchantExtractionFail.LevelLower.Base", Double.valueOf(50.0));
        LowerLevelChanceBase = LowerLevelChanceBase < 0.0 ? 0.0 : (LowerLevelChanceBase > 100.0 ? 100.0 : LowerLevelChanceBase);
        configReader.addComment("Scavenge.EnchantExtractionFail.LevelLower.ForEachLevel", new String[]{"Will adjust level lowering chance depending on enchant level to defined max amount at max level", "This will mean that higher levels will have higher chance to be lowered"});
        LowerLevelForEachLevel = configReader.get("Scavenge.EnchantExtractionFail.LevelLower.ForEachLevel", Double.valueOf(5.0));
        LowerLevelForEachLevel = LowerLevelForEachLevel < 0.0 ? 0.0 : (LowerLevelForEachLevel > 100.0 ? 100.0 : LowerLevelForEachLevel);
        configReader.addComment("Scavenge.EnchantExtractionFail.LevelLower.MaxChance", new String[]{"Will adjust level lower chance depending on enchant level to defined max amount at max level"});
        LowerLevelMaxChance = configReader.get("Scavenge.EnchantExtractionFail.LevelLower.MaxChance", Double.valueOf(75.0));
        LowerLevelMaxChance = LowerLevelMaxChance < 0.0 ? 0.0 : (LowerLevelMaxChance > 100.0 ? 100.0 : LowerLevelMaxChance);
        configReader.addComment("Scavenge.Cost.Base", new String[]{"Defined base cost of extraction. Set to 0 if you want to make it free"});
        EnchantBaseCost = configReader.get("Scavenge.Cost.Base", Double.valueOf(100.0));
        EnchantBaseCost = EnchantBaseCost < 0.0 ? 0.0 : EnchantBaseCost;
        configReader.addComment("Scavenge.Cost.Extra", new String[]{"Extra cost which depends on enchantment worth which can be defined with /cmi setenchantworth ", "This value is in percentage from worth value of that each enchantment and item", "So if you have base cost of 100, extra cost of 5% and you are trying to extract sharpness 5 which worth is 1000 and item sell hand worth is 100, then you will have to pay 155 for extraction process"});
        EnchantBaseCostExtra = configReader.get("Scavenge.Cost.Extra", Double.valueOf(5.0));
        EnchantBaseCostExtra = EnchantBaseCostExtra < 0.0 ? 0.0 : EnchantBaseCostExtra;
        configReader.addComment("Scavenge.BlackList", new String[]{"List of materials to block from being scavenged"});
        List list2 = configReader.get("Scavenge.BlackList", Arrays.asList("diamond", "ironingot", "goldingot", "coal", "IRON_NUGGET", "GOLD_NUGGET"));
        blackList.clear();
        for (String string : list2) {
            CMIMaterial cMIMaterial = CMIMaterial.get((String)string);
            if (cMIMaterial == null && !string.equalsIgnoreCase("Material1") && !string.equalsIgnoreCase("Material2")) {
                this.plugin.consoleMessage("&cCan't recognize blacklisted scavenger material (" + string + ")");
            }
            if (cMIMaterial == null) continue;
            blackList.add(cMIMaterial);
        }
        configReader.addComment("Scavenge.BlackToWhiteList", new String[]{"When set to true, balck list becomes whitelist and will allow scavanging of items defined in a blacklist only"});
        InvertBlackList = configReader.get("Scavenge.BlackToWhiteList", Boolean.valueOf(false));
        configReader.addComment("Scavenge.AllowItemPickups", new String[]{"When set to false while player have open scavange UI they will not be able to pickup item from ground"});
        AllowItemPickups = configReader.get("Scavenge.AllowItemPickups", Boolean.valueOf(false));
        configReader.addComment("Scavenge.ResetRepairCost", new String[]{"When enabled items, likes swords, after being salvagted if they dint broke then their repair cost will be reset so players can enchant it as like its a new one instead of making it to dificult to be enchanted"});
        ResetRepairCost = configReader.get("Scavenge.ResetRepairCost", Boolean.valueOf(true));
        configReader.save();
    }

    public void openExtractor(final Player player) {
        if (player == null || !player.isOnline()) {
            return;
        }
        CMIGui cMIGui = new CMIGui(player){

            public void onClose() {
                ItemStack itemStack = this.getInv().getItem(13);
                if (itemStack != null) {
                    CMIUser cMIUser = ScavengeManager.this.plugin.getPlayerManager().getUser(player);
                    cMIUser.getInventory().addItem(itemStack);
                }
            }

            public void outsideClick(GUIManager.GUIClickType gUIClickType) {
                1 var2_2 = this;
                if (gUIClickType == GUIManager.GUIClickType.LeftShift || gUIClickType == GUIManager.GUIClickType.RightShift) {
                    CMIScheduler.runTaskLater((JavaPlugin)ScavengeManager.this.plugin, () -> ScavengeManager.this.updateExtractor(var2_2), (long)1L);
                }
            }

            public void onOpen() {
                1 var1_1 = this;
                CMIScheduler.runTaskLater((JavaPlugin)ScavengeManager.this.plugin, () -> ScavengeManager.this.updateExtractor(var1_1), (long)1L);
            }
        };
        cMIGui.setInvSize(GUIManager.GUIRows.r6);
        CMIGuiButton cMIGuiButton = new CMIGuiButton(13){

            public void click(GUIManager.GUIClickType gUIClickType) {
                2 var2_2 = this;
                CMIScheduler.runTaskLater((JavaPlugin)ScavengeManager.this.plugin, () -> ScavengeManager.this.processClick(var2_2), (long)1L);
            }
        };
        cMIGui.setAllowShift(true);
        cMIGuiButton.unlockField();
        this.updateExtractor(cMIGui);
        cMIGui.addButton(cMIGuiButton);
        cMIGui.fillEmptyButtons();
        cMIGui.setAllowItemPickup(AllowItemPickups);
        cMIGui.open();
    }

    private void processClick(CMIGuiButton cMIGuiButton) {
        this.updateExtractor(cMIGuiButton.getGui(), null);
    }

    private void processClick(CMIGuiButton cMIGuiButton, GUIManager.GUIClickType gUIClickType) {
        this.updateExtractor(cMIGuiButton.getGui(), gUIClickType);
    }

    private void updateExtractor(CMIGui cMIGui) {
        this.updateExtractor(cMIGui, null);
    }

    /*
     * WARNING - void declaration
     */
    private void updateExtractor(final CMIGui cMIGui, GUIManager.GUIClickType gUIClickType) {
        Serializable serializable;
        if (cMIGui.getPlayer() == null || cMIGui.getPlayer().getOpenInventory() == null || !cMIGui.isOpened()) {
            return;
        }
        ItemStack itemStack2 = cMIGui.getInv().getItem(13);
        final Player player = cMIGui.getPlayer();
        final CMIScavengeItem cMIScavengeItem = new CMIScavengeItem(itemStack2);
        int n = 27;
        while (n < 45) {
            cMIGui.getButtons().remove(n);
            ++n;
        }
        n = cMIScavengeItem.getEnchants().size() / 2;
        int n2 = 30 - n;
        int n3 = n2 = n2 < 26 ? 26 : n2;
        if (cMIScavengeItem.canScavenge()) {
            serializable = new HashMap();
            cMIScavengeItem.getIngredients().forEach(itemStack -> {
                Integer n2 = serializable.compute(CMIMaterial.get((ItemStack)itemStack), (cMIMaterial, n) -> n == null ? itemStack.getAmount() : n + itemStack.getAmount());
            });
            for (Map.Entry object : cMIScavengeItem.getEnchants().entrySet()) {
                double d;
                double d2;
                EnchantmentStorageMeta enchantmentStorageMeta;
                if (!itemStack2.containsEnchantment((Enchantment)object.getKey())) continue;
                ++n2;
                ItemStack itemStack3 = CMIMaterial.ENCHANTED_BOOK.newItemStack();
                if (itemStack3.getItemMeta() instanceof EnchantmentStorageMeta) {
                    enchantmentStorageMeta = (EnchantmentStorageMeta)itemStack3.getItemMeta();
                    enchantmentStorageMeta.addEnchant((Enchantment)object.getKey(), ((Integer)object.getValue()).intValue(), true);
                    itemStack3.setItemMeta((ItemMeta)enchantmentStorageMeta);
                }
                n2 = n2 > 44 ? 44 : n2;
                enchantmentStorageMeta = new CMIGuiButton(Integer.valueOf(n2), itemStack3);
                WorthEnchantment worthEnchantment = this.plugin.getWorthManager().getEnchantWorth((Enchantment)object.getKey(), (Integer)object.getValue());
                if (worthEnchantment != null && worthEnchantment.getSellPrice() > 0.0) {
                    enchantmentStorageMeta.addLore(CMILC.getIM(scavenge.class.getSimpleName(), "enchantWorth", "[price]", worthEnchantment.getSellPrice()));
                }
                if ((d2 = cMIScavengeItem.getEnchantExtractionFailChance((Enchantment)object.getKey())) > 0.0) {
                    enchantmentStorageMeta.addLore(CMILC.getIM(scavenge.class.getSimpleName(), "enchantFailChance", "[chance]", d2));
                }
                if ((d = cMIScavengeItem.getEnchantLevelLowerChance((Enchantment)object.getKey())) > 0.0 && (Integer)object.getValue() > 1) {
                    enchantmentStorageMeta.addLore(CMILC.getIM(scavenge.class.getSimpleName(), "enchantLevelChance", "[chance]", d));
                }
                cMIGui.replaceButton((CMIGuiButton)enchantmentStorageMeta);
            }
        }
        serializable = Double.valueOf(cMIScavengeItem.getExtractionCost());
        if (itemStack2 != null && !CMIMaterial.isAir((Material)itemStack2.getType())) {
            CMIGuiButton n5 = new CMIGuiButton(cMIScavengeItem.canScavenge() ? CMIMaterial.LIME_STAINED_GLASS_PANE : (cMIScavengeItem.getRecipeResultAmount() > itemStack2.getAmount() ? CMIMaterial.LIGHT_BLUE_STAINED_GLASS_PANE : CMIMaterial.RED_STAINED_GLASS_PANE)){

                public void click(GUIManager.GUIClickType gUIClickType) {
                    Iterator<Map.Entry<Enchantment, Integer>> iterator;
                    if (!cMIScavengeItem.canScavenge()) {
                        return;
                    }
                    CMIUser cMIUser = ScavengeManager.this.plugin.getPlayerManager().getUser(player);
                    ItemStack itemStack = cMIGui.getInv().getItem(13);
                    if (itemStack == null || CMIMaterial.isAir((Material)itemStack.getType())) {
                        return;
                    }
                    double d = cMIScavengeItem.getExtractionCost();
                    boolean bl = false;
                    if (gUIClickType != null && gUIClickType == GUIManager.GUIClickType.LeftShift) {
                        bl = true;
                    }
                    if (bl) {
                        d *= (double)itemStack.getAmount();
                    }
                    if (!cMIUser.hasMoney(d)) {
                        LC.econ_notEnoughMoney.sendMessage((Object)cMIUser.getPlayer(), new Object[]{"[amount]", d});
                        return;
                    }
                    cMIUser.withdraw(d);
                    double d2 = cMIScavengeItem.getItemBreakChance();
                    HashSet<Enchantment> hashSet = new HashSet<Enchantment>();
                    if (itemStack.getAmount() == 1) {
                        for (Map.Entry entry2 : itemStack.getEnchantments().entrySet()) {
                            int n = itemStack.removeEnchantment((Enchantment)entry2.getKey());
                            if (n != 0) continue;
                            hashSet.add((Enchantment)entry2.getKey());
                        }
                    }
                    cMIGui.getInv().setItem(13, null);
                    if (!ScavengeManager.this.isFailed(d2)) {
                        ItemMeta itemMeta;
                        if (ResetRepairCost && (itemMeta = itemStack.getItemMeta()) instanceof Repairable) {
                            iterator = (Repairable)itemMeta;
                            iterator.setRepairCost(1);
                            itemStack.setItemMeta((ItemMeta)iterator);
                        }
                        for (Enchantment enchantment : itemStack.getEnchantments().keySet()) {
                            itemStack.removeEnchantment(enchantment);
                        }
                        cMIUser.getInventory().addItem(itemStack);
                    } else {
                        HashMap<CMIMaterial, Integer> hashMap = new HashMap<CMIMaterial, Integer>();
                        iterator = cMIScavengeItem.getIngredients(ItemMaterialDurabilityCheck, true);
                        Iterator iterator2 = iterator.iterator();
                        while (iterator2.hasNext()) {
                            ItemStack itemStack2 = (ItemStack)iterator2.next();
                            int n = 0;
                            while (n < (bl ? itemStack.getAmount() / cMIScavengeItem.getRecipeResultAmount() : 1)) {
                                if (!ScavengeManager.this.isFailed(100.0 - cMIScavengeItem.getIngredientReturnChance())) {
                                    Object object;
                                    CMIMaterial cMIMaterial = CMIMaterial.get((ItemStack)itemStack2);
                                    ItemStack itemStack3 = cMIMaterial.newItemStack();
                                    itemStack3.setAmount(itemStack2.getAmount());
                                    if (Version.isCurrentEqualOrHigher((Version)Version.v1_13_R1) && itemStack3.getItemMeta() instanceof Damageable) {
                                        object = (Damageable)itemStack3.getItemMeta();
                                        object.setDamage(1);
                                        itemStack3.setItemMeta((ItemMeta)object);
                                    }
                                    cMIUser.getInventory().addItem(itemStack3);
                                    object = (Integer)hashMap.get(cMIMaterial);
                                    if (object == null) {
                                        object = 0;
                                    }
                                    hashMap.put(cMIMaterial, (Integer)object + itemStack2.getAmount());
                                }
                                ++n;
                            }
                        }
                        if (itemStack.getAmount() > 1 && !bl) {
                            itemStack.setAmount(itemStack.getAmount() - cMIScavengeItem.getRecipeResultAmount());
                            cMIGui.getInv().setItem(13, itemStack);
                        }
                        String string = "";
                        for (Map.Entry entry : hashMap.entrySet()) {
                            if (!string.isEmpty()) {
                                string = String.valueOf(string) + LC.info_ListSpliter.getLocale(new Object[0]);
                            }
                            string = String.valueOf(string) + CMILC.getIM(scavenge.class.getSimpleName(), "gotIngredientsFormat", "[material]", ((CMIMaterial)entry.getKey()).getName(), "[amount]", entry.getValue());
                        }
                        if (!string.isEmpty()) {
                            cMIUser.sendMessage(CMILC.getIM(scavenge.class.getSimpleName(), "gotIngredients", "[itemList]", string));
                        }
                        if (!cMIScavengeItem.getEnchants().isEmpty()) {
                            cMIUser.sendMessage(CMILC.getIM(scavenge.class.getSimpleName(), "itemBroke", "[chance]", d2));
                        }
                    }
                    for (Map.Entry<Enchantment, Integer> entry : cMIScavengeItem.getEnchants().entrySet()) {
                        if (hashSet.contains(entry.getKey())) continue;
                        double d3 = cMIScavengeItem.getEnchantExtractionFailChance(entry.getKey());
                        int n = 0;
                        while (n < (bl ? itemStack.getAmount() : 1)) {
                            if (!ScavengeManager.this.isFailed(d3)) {
                                double d4 = cMIScavengeItem.getEnchantLevelLowerChance(entry.getKey());
                                if (ScavengeManager.this.isFailed(d4)) {
                                    if (entry.getValue() > 1) {
                                        cMIUser.getInventory().addItem(cMIScavengeItem.createBook(entry.getKey(), entry.getValue() - 1));
                                    }
                                } else {
                                    cMIUser.getInventory().addItem(cMIScavengeItem.createBook(entry.getKey()));
                                }
                            } else {
                                cMIUser.sendMessage(CMILC.getIM(scavenge.class.getSimpleName(), "enchantFailed", "[enchant]", CMIEnchantment.getName((Enchantment)entry.getKey()), "[level]", entry.getValue(), "[chance]", d3));
                            }
                            ++n;
                        }
                    }
                    ScavengeManager.this.updateExtractor(cMIGui);
                }
            };
            if (cMIScavengeItem.canScavenge()) {
                n5.setName(CMILC.getIM(scavenge.class.getSimpleName(), "confirm", "[price]", this.plugin.getEconomyManager().format((Double)serializable)));
                double d = cMIScavengeItem.getItemBreakChance();
                if (d > 0.0) {
                    if (d < 100.0) {
                        n5.addLore(CMILC.getIM(scavenge.class.getSimpleName(), "itemBreakChance", "[chance]", d));
                        if (cMIScavengeItem.getBreakChanceByItemDurability() > 0.0) {
                            n5.addLore(CMILC.getIM(scavenge.class.getSimpleName(), "itemBreakChanceExtra", "[durability]", cMIScavengeItem.getLeftDurabilityPercentage(), "[chance]", cMIScavengeItem.getBreakChanceByItemDurability()));
                        }
                    } else {
                        n5.addLore(CMILC.getIM(scavenge.class.getSimpleName(), "itemBreak", new Object[0]));
                    }
                    n5.addLore(CMILC.getIM(scavenge.class.getSimpleName(), "ingredientReturnChance", "[chance]", cMIScavengeItem.getIngredientReturnChance()));
                }
            } else {
                n5.setName(CMILC.getIM(scavenge.class.getSimpleName(), "cantScavenge", new Object[0]));
                if (itemStack2.getAmount() < cMIScavengeItem.getRecipeResultAmount()) {
                    n5.addLore(CMILC.getIML(scavenge.class.getSimpleName(), "moreLore", "[amount]", cMIScavengeItem.getRecipeResultAmount()));
                }
            }
            int n4 = 45;
            while (n4 < 54) {
                n5.setSlot(Integer.valueOf(n4));
                cMIGui.replaceButton(n5);
                ++n4;
            }
        } else {
            void var9_15;
            int n4 = 45;
            while (var9_15 < 54) {
                CMIGuiButton cMIGuiButton = new CMIGuiButton(Integer.valueOf((int)var9_15), CMIMaterial.YELLOW_STAINED_GLASS_PANE);
                cMIGuiButton.setName(CMILC.getIM(scavenge.class.getSimpleName(), "insertItem", new Object[0]));
                cMIGui.replaceButton(cMIGuiButton);
                ++var9_15;
            }
        }
        if ((Double)serializable > 0.0 && cMIScavengeItem.canScavenge()) {
            cMIGui.updateTitle(CMILC.getIM(scavenge.class.getSimpleName(), "scavengeCost", "[cost]", this.plugin.getEconomyManager().format((Double)serializable)));
        } else if (itemStack2 != null && itemStack2.getAmount() < cMIScavengeItem.getRecipeResultAmount()) {
            cMIGui.updateTitle(CMILC.getIM(scavenge.class.getSimpleName(), "moreTitle", "[input]", itemStack2.getAmount(), "[required]", cMIScavengeItem.getRecipeResultAmount()));
        } else {
            cMIGui.updateTitle(CMILC.getIM(scavenge.class.getSimpleName(), "title", new Object[0]));
        }
        cMIGui.fillEmptyButtons();
    }

    private double format(double d) {
        return (double)((int)(d * 100.0)) / 100.0;
    }

    private boolean isFailed(double d) {
        if (d >= 100.0) {
            return true;
        }
        Random random = new Random();
        double d2 = random.nextDouble() * 100.0;
        return d2 < d;
    }
}

