/*
 * Decompiled with CFR 0.152.
 */
package com.Zrips.CMI.Modules.SavedItems;

import com.Zrips.CMI.CMI;
import com.Zrips.CMI.Containers.Snd;
import com.Zrips.CMI.Modules.SavedItems.SavedItem;
import com.Zrips.CMI.utils.Util;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import net.Zrips.CMILib.CMILib;
import net.Zrips.CMILib.Colors.CMIChatColor;
import net.Zrips.CMILib.Items.CMIItemStack;
import net.Zrips.CMILib.Messages.CMIMessages;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class SavedItemManager {
    private LinkedHashMap<String, LinkedHashMap<String, SavedItem>> map = new LinkedHashMap();
    public static final String defaultCategory = "dc";
    private CMI plugin;
    private String fileName = "SavedItems.yml";

    public SavedItemManager(CMI cMI) {
        this.plugin = cMI;
    }

    public void addSavedItem(SavedItem savedItem) {
        String string = savedItem.getCategory();
        if (string == null) {
            string = defaultCategory;
        }
        string = string.toLowerCase();
        LinkedHashMap<String, SavedItem> linkedHashMap = this.map.getOrDefault(string, new LinkedHashMap());
        linkedHashMap.put(savedItem.getName().toLowerCase(), savedItem);
        this.map.put(string, linkedHashMap);
    }

    public boolean removeSavedItem(SavedItem savedItem) {
        return this.removeSavedItem(savedItem.getCategory(), savedItem.getName());
    }

    public boolean removeSavedItem(String string, String string2) {
        boolean bl;
        LinkedHashMap<String, SavedItem> linkedHashMap;
        if (string == null) {
            string = defaultCategory;
        }
        if ((linkedHashMap = this.map.get(string = string.toLowerCase())) == null) {
            return false;
        }
        boolean bl2 = bl = linkedHashMap.remove(string2.toLowerCase()) != null;
        if (bl) {
            this.save();
        }
        return bl;
    }

    public SavedItem getSavedItem(String string, String string2) {
        LinkedHashMap<String, SavedItem> linkedHashMap;
        if (string2 == null) {
            return null;
        }
        if (string == null) {
            string = defaultCategory;
        }
        if ((linkedHashMap = this.map.get(string = string.toLowerCase())) == null) {
            return null;
        }
        return linkedHashMap.get(string2.toLowerCase());
    }

    public LinkedHashMap<String, LinkedHashMap<String, SavedItem>> getSavedItemMap() {
        return this.map;
    }

    public Set<SavedItem> getSavedItems(String string) {
        LinkedHashMap<String, SavedItem> linkedHashMap2;
        LinkedHashSet<SavedItem> linkedHashSet = new LinkedHashSet<SavedItem>();
        if (string == null) {
            string = defaultCategory;
        }
        if ((string = string.toLowerCase()).equalsIgnoreCase("all")) {
            for (LinkedHashMap<String, SavedItem> linkedHashMap2 : this.map.values()) {
                for (SavedItem savedItem : linkedHashMap2.values()) {
                    linkedHashSet.add(savedItem);
                }
            }
        }
        if ((linkedHashMap2 = this.map.get(string)) == null) {
            return linkedHashSet;
        }
        for (SavedItem savedItem : linkedHashMap2.values()) {
            linkedHashSet.add(savedItem);
        }
        return linkedHashSet;
    }

    /*
     * WARNING - void declaration
     */
    public void load() {
        String[] stringArray;
        Long l = System.currentTimeMillis();
        CMI.getInstance().safeRenameFile(this.fileName, "Saves" + File.separator + this.fileName);
        Util.fixItemStackFile(new File(this.plugin.getDataFolder(), "Saves" + File.separator + this.fileName));
        File file = new File(this.plugin.getDataFolder(), "Saves" + File.separator + this.fileName);
        if (!file.exists()) {
            try {
                file.createNewFile();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            return;
        }
        YamlConfiguration yamlConfiguration = null;
        try {
            yamlConfiguration = YamlConfiguration.loadConfiguration((File)file);
        }
        catch (Throwable throwable) {
            return;
        }
        this.map.clear();
        if (yamlConfiguration.getKeys(false).isEmpty()) {
            return;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Map.Entry<String, LinkedHashMap<String, SavedItem>> object22 : this.map.entrySet()) {
            for (SavedItem savedItem : object22.getValue().values()) {
                arrayList.add(String.valueOf(savedItem.getCategory()) + "-" + savedItem.getName().toLowerCase());
            }
        }
        Map map = yamlConfiguration.getValues(false);
        boolean bl = false;
        Iterator<Object> iterator = map.entrySet().iterator();
        if (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            try {
                stringArray = yamlConfiguration.getConfigurationSection((String)entry.getKey()).getValues(false);
                if (stringArray.containsKey("Item")) {
                    try {
                        Util.fixHeadNameSection(yamlConfiguration.getConfigurationSection(String.valueOf((String)entry.getKey()) + ".Item"));
                        ItemStack.deserialize((Map)yamlConfiguration.getConfigurationSection(String.valueOf((String)entry.getKey()) + ".Item").getValues(true));
                        bl = true;
                    }
                    catch (Throwable throwable) {}
                }
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
        if (bl) {
            for (Map.Entry entry : map.entrySet()) {
                void var10_28;
                block30: {
                    stringArray = yamlConfiguration.getConfigurationSection((String)entry.getKey()).getValues(false);
                    SavedItem savedItem = this.getSavedItem(null, (String)entry.getKey());
                    if (savedItem == null) {
                        SavedItem savedItem2 = new SavedItem((String)entry.getKey());
                    } else {
                        savedItem.reset();
                    }
                    try {
                        if (!stringArray.containsKey("Item")) break block30;
                        Util.fixHeadNameSection(yamlConfiguration.getConfigurationSection(String.valueOf((String)entry.getKey()) + ".Item"));
                        ItemStack itemStack = ItemStack.deserialize((Map)yamlConfiguration.getConfigurationSection(String.valueOf((String)entry.getKey()) + ".Item").getValues(true));
                        var10_28.setItem(itemStack);
                    }
                    catch (Throwable throwable) {
                        CMIMessages.sendMessage((CommandSender)Bukkit.getConsoleSender(), (String)("Cant load saved item (" + (String)entry.getKey() + ")"));
                        throwable.printStackTrace();
                        continue;
                    }
                }
                this.addSavedItem((SavedItem)var10_28);
            }
        } else {
            for (Map.Entry entry : map.entrySet()) {
                stringArray = yamlConfiguration.getConfigurationSection((String)entry.getKey()).getValues(false);
                for (Map.Entry entry2 : stringArray.entrySet()) {
                    SavedItem savedItem;
                    String string;
                    block31: {
                        Map map2 = yamlConfiguration.getConfigurationSection(String.valueOf((String)entry.getKey()) + "." + (String)entry2.getKey()).getValues(false);
                        string = (String)entry.getKey();
                        savedItem = this.getSavedItem(string, (String)entry2.getKey());
                        if (savedItem == null) {
                            savedItem = new SavedItem((String)entry2.getKey());
                        } else {
                            savedItem.reset();
                        }
                        savedItem.setCategory(string);
                        try {
                            if (!map2.containsKey("Item")) break block31;
                            ConfigurationSection configurationSection = yamlConfiguration.getConfigurationSection(String.valueOf((String)entry.getKey()) + "." + (String)entry2.getKey() + ".Item");
                            Util.fixHeadNameSection(configurationSection);
                            ItemStack itemStack = ItemStack.deserialize((Map)configurationSection.getValues(true));
                            savedItem.setItem(itemStack);
                        }
                        catch (Throwable throwable) {
                            CMIMessages.sendMessage((CommandSender)Bukkit.getConsoleSender(), (String)("Cant load saved item (" + (String)entry2.getKey() + ")"));
                            throwable.printStackTrace();
                            continue;
                        }
                    }
                    this.addSavedItem(savedItem);
                    arrayList.remove(String.valueOf(string) + "-" + savedItem.getName().toLowerCase());
                }
            }
        }
        for (String string : arrayList) {
            void var10_35;
            stringArray = string.split("-", 2);
            Object var10_33 = null;
            if (!stringArray[0].equalsIgnoreCase("NULL")) {
                String string2 = stringArray[0];
            }
            this.removeSavedItem((String)var10_35, stringArray[1]);
        }
        if (!this.map.isEmpty()) {
            this.plugin.loadMessage(this.savedItemCount(), "saved items", System.currentTimeMillis() - l);
        }
    }

    public int savedItemCount() {
        int n = 0;
        for (LinkedHashMap<String, SavedItem> linkedHashMap : this.map.values()) {
            n += linkedHashMap.size();
        }
        return n;
    }

    public void save() {
        File file = new File(this.plugin.getDataFolder(), "Saves" + File.separator + this.fileName);
        if (!file.exists()) {
            try {
                file.createNewFile();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            return;
        }
        YamlConfiguration yamlConfiguration = YamlConfiguration.loadConfiguration((File)file);
        for (String object : yamlConfiguration.getKeys(false)) {
            yamlConfiguration.set(object, null);
        }
        for (Map.Entry entry : this.map.entrySet()) {
            for (SavedItem savedItem : ((LinkedHashMap)entry.getValue()).values()) {
                String string;
                String string2 = savedItem.getName();
                if (yamlConfiguration.isConfigurationSection(string2)) {
                    yamlConfiguration.set(string2, null);
                }
                if ((string = savedItem.getCategory()) == null) {
                    string = defaultCategory;
                }
                yamlConfiguration.set(String.valueOf(string) + "." + string2 + ".Item", (Object)savedItem.getItem().serialize());
            }
        }
        try {
            yamlConfiguration.save(file);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public ItemStack getUpatedItemClone(Player player, SavedItem savedItem) {
        ItemStack itemStack = savedItem.getItem().clone();
        CMIItemStack cMIItemStack = CMILib.getInstance().getItemManager().getItem(itemStack);
        if (itemStack.hasItemMeta() && itemStack.getItemMeta().hasDisplayName()) {
            cMIItemStack.setDisplayName(this.processText(cMIItemStack.getDisplayName(), player, savedItem));
        }
        List list2 = cMIItemStack.getLore();
        cMIItemStack.clearLore();
        for (String string : list2) {
            cMIItemStack.addLore(this.processText(string, player, savedItem));
        }
        return itemStack;
    }

    public String processText(String string, Player player, SavedItem savedItem) {
        string = CMIChatColor.translate((String)string);
        Snd snd = new Snd().setSender(player).setTarget(player);
        string = this.plugin.getLM().updateSnd(snd, string);
        if (player != null) {
            string = string.replaceAll(String.valueOf("(?i)(\\{username\\})"), player.getName());
            string = string.replaceAll(String.valueOf("(?i)(\\{displayname\\})"), player.getDisplayName());
            string = string.replaceAll(String.valueOf("(?i)(\\{worldname\\})"), player.getWorld().getName());
        }
        if (savedItem != null) {
            string = string.replaceAll(String.valueOf("(?i)(\\{saveditemname\\})"), savedItem.getName());
            Random random = new Random(System.currentTimeMillis());
            List<Object> list2 = Arrays.asList(Bukkit.getOnlinePlayers().toArray());
            if (!list2.isEmpty()) {
                int n = list2.size();
                int n2 = random.nextInt(n) + 1;
                Player player2 = (Player)list2.get(n2 - 1);
                string = string.replaceAll(String.valueOf("(?i)(\\{randomplayer\\})"), player2.getName());
            }
        }
        return string;
    }
}

