/*
 * Decompiled with CFR 0.152.
 */
package com.Zrips.CMI.Modules.Region;

import com.Zrips.CMI.CMI;
import com.Zrips.CMI.Modules.Region.CMIRegion;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.Chunk;
import org.bukkit.World;

public class WorldInfo {
    private transient Map<String, List<Boolean>> regionChunks = Collections.synchronizedMap(new HashMap());
    private CMIRegion center;
    private long totalChunks = 0L;
    private long lastChecked = -1L;
    private World world;
    private Integer range = null;

    public WorldInfo clone() {
        WorldInfo worldInfo = new WorldInfo(this.world, this.center);
        worldInfo.setRegion(new HashMap<String, List<Boolean>>(this.regionChunks));
        worldInfo.setTotalChunks(this.totalChunks);
        return worldInfo;
    }

    public WorldInfo(World world2, CMIRegion cMIRegion) {
        this.world = world2;
        this.center = cMIRegion;
    }

    public void setRegion(Map<String, List<Boolean>> map) {
        this.regionChunks = map;
    }

    public Map<String, List<Boolean>> getRegion() {
        return this.regionChunks;
    }

    private static String toString(CMIRegion cMIRegion) {
        return String.valueOf(cMIRegion.getX()) + ":" + cMIRegion.getZ();
    }

    public Boolean getRegionsChunk(CMIRegion cMIRegion, int n) {
        List<Boolean> list2 = this.regionChunks.get(WorldInfo.toString(cMIRegion));
        if (list2 == null) {
            return null;
        }
        return list2.get(n);
    }

    public List<Boolean> getRegionPlaces(CMIRegion cMIRegion) {
        return this.regionChunks.get(WorldInfo.toString(cMIRegion));
    }

    public WorldInfo setRegionPlaces(CMIRegion cMIRegion, List<Boolean> list2) {
        this.regionChunks.put(WorldInfo.toString(cMIRegion), list2);
        return this;
    }

    public CMIRegion getNextChunkLoc(boolean bl) {
        return CMI.getInstance().getRegionManager().getNextChunkLocation(this, bl);
    }

    public Chunk getNextChunk(boolean bl) {
        return CMI.getInstance().getRegionManager().getNextChunk(this, bl);
    }

    public void setRegionChunks(CMIRegion cMIRegion, List<Boolean> list2) {
        this.regionChunks.put(WorldInfo.toString(cMIRegion), list2);
    }

    public CMIRegion getCenter() {
        if (this.center == null) {
            this.center = new CMIRegion(0, 0);
        }
        return this.center;
    }

    public void setCenter(CMIRegion cMIRegion) {
        this.center = cMIRegion;
    }

    public long getTotalChunks() {
        return this.totalChunks;
    }

    public void setTotalChunks(long l) {
        this.totalChunks = l;
    }

    public void addTotalChunks(int n) {
        this.totalChunks += (long)n;
    }

    public void addTotalChunks() {
        ++this.totalChunks;
    }

    public long getLastChecked() {
        return this.lastChecked;
    }

    public boolean allChecked() {
        return this.lastChecked >= this.totalChunks;
    }

    public long getLeftToScan() {
        return this.totalChunks - this.lastChecked < 0L ? 0L : this.totalChunks - this.lastChecked;
    }

    public long getNextPlace() {
        return this.lastChecked + 1L;
    }

    public void setLastChecked(long l) {
        this.lastChecked = l;
    }

    public void addLastChecked() {
        ++this.lastChecked;
    }

    public World getWorld() {
        return this.world;
    }

    public void setWorld(World world2) {
        this.world = world2;
    }

    public Integer getRange() {
        return this.range;
    }

    public void setRange(Integer n) {
        this.range = n;
    }
}

