/*
 * Decompiled with CFR 0.152.
 */
package com.Zrips.CMI.Modules.Ranks;

import com.Zrips.CMI.CMI;
import com.Zrips.CMI.Containers.CMIPlayerInventory;
import com.Zrips.CMI.Containers.CMIUser;
import com.Zrips.CMI.Locale.CMILC;
import com.Zrips.CMI.Modules.Hooks.CMIHookType;
import com.Zrips.CMI.Modules.ModuleHandling.CMIModule;
import com.Zrips.CMI.Modules.Particl.ParticleManager;
import com.Zrips.CMI.Modules.Permissions.PermissionInfo;
import com.Zrips.CMI.Modules.Permissions.PermissionsManager;
import com.Zrips.CMI.Modules.Ranks.AuraSkillsManager;
import com.Zrips.CMI.Modules.Ranks.AureliumManager;
import com.Zrips.CMI.Modules.Ranks.CMIRank;
import com.Zrips.CMI.Modules.Ranks.CMIRankPlaceholder;
import com.Zrips.CMI.Modules.Ranks.InformTimer;
import com.Zrips.CMI.Modules.Ranks.JobsManager;
import com.Zrips.CMI.Modules.Ranks.McMMOManager;
import com.Zrips.CMI.Modules.Ranks.rankPlaceholderType;
import com.Zrips.CMI.Modules.Statistics.StatsManager;
import com.Zrips.CMI.commands.list.rankup;
import java.io.File;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.Zrips.CMILib.CMILib;
import net.Zrips.CMILib.Colors.CMIChatColor;
import net.Zrips.CMILib.Container.CMINumber;
import net.Zrips.CMILib.Entities.CMIEntityType;
import net.Zrips.CMILib.FileHandler.ConfigReader;
import net.Zrips.CMILib.Items.CMIItemStack;
import net.Zrips.CMILib.Items.CMIMaterial;
import net.Zrips.CMILib.Locale.LC;
import net.Zrips.CMILib.Messages.CMIMessages;
import net.Zrips.CMILib.RawMessages.RawMessage;
import net.Zrips.CMILib.Shadow.ShadowCommand;
import net.Zrips.CMILib.Shadow.ShadowCommandType;
import net.Zrips.CMILib.Time.CMITimeManager;
import net.Zrips.CMILib.Version.Schedulers.CMIScheduler;
import net.Zrips.CMILib.Version.Schedulers.CMITask;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitScheduler;

public class RankManager {
    private LinkedHashMap<String, CMIRank> ranks = new LinkedHashMap();
    private HashMap<UUID, Long> nextCheck = new HashMap();
    private HashMap<UUID, Long> nextAutoRecalculate = new HashMap();
    private HashMap<UUID, InformTimer> nextInform = new HashMap();
    private CMI plugin;
    BukkitScheduler scheduler;
    private HashMap<UUID, CMIRank> ranksCache = new HashMap();
    CMITask sched = null;
    CMITask recSched = null;
    HashMap<UUID, rankCache> percentCache = new HashMap();
    NumberFormat formatter = new DecimalFormat("#0.00");
    private String fileName = "Ranks.yml";
    private int Delay = 30;
    private int Recalculation = 0;
    private boolean OnlyHours = false;
    private boolean includeMinutes = false;
    private boolean async = false;
    private boolean ListSamePathOnly = false;
    private int PlayerDelay = 120;
    private boolean progressBar = true;
    private boolean permissionCheck = false;
    private boolean strictPermissionCheck = false;
    private ParticleManager.CMIPresetAnimations RanksEffect = ParticleManager.CMIPresetAnimations.GColumn;

    public CMIRank getNullRank(CMIUser cMIUser) {
        return this.ranksCache.get(cMIUser.getUniqueId());
    }

    public CMIRank getRank(CMIUser cMIUser) {
        return this.ranksCache.computeIfAbsent(cMIUser.getUniqueId(), uUID -> CMI.getInstance().getRankManager().getDefaultRank(cMIUser.getPlayer(false)));
    }

    /*
     * WARNING - void declaration
     */
    public CMIRank recalculateRank(CMIUser cMIUser) {
        void var3_8;
        PermissionInfo object3;
        CMIRank cMIRank = null;
        if (cMIUser.isOnline() && CMI.getInstance().getRankManager().isPermissionCheck() && (object3 = CMI.getInstance().getPermissionsManager().getPermissionInfo(cMIUser.getPlayer(), PermissionsManager.CMIPerm.rank_$1, (Long)0L)) != null && !object3.getValues().isEmpty()) {
            for (String string : object3.getValues()) {
                CMIRank cMIRank2;
                if (!PermissionsManager.CMIPerm.rank_$1.hasPermission((CommandSender)cMIUser.getPlayer(), string) || (cMIRank2 = CMI.getInstance().getRankManager().getRank(string)) == null || cMIRank != null && cMIRank.getWeight() >= cMIRank2.getWeight()) continue;
                cMIRank = cMIRank2;
            }
        }
        for (Map.Entry<String, CMIRank> entry : CMI.getInstance().getRankManager().getRanks().entrySet()) {
            if (!entry.getValue().isDefaultRank() || cMIRank != null && cMIRank.getWeight() >= entry.getValue().getWeight()) continue;
            cMIRank = entry.getValue();
        }
        CMIRank cMIRank3 = this.getNullRank(cMIUser);
        if (cMIRank3 == null || cMIRank != null && cMIRank3.getWeight() < cMIRank.getWeight()) {
            CMIRank cMIRank4 = cMIRank;
        }
        return var3_8;
    }

    public void setRank(CMIUser cMIUser, CMIRank cMIRank) {
        this.ranksCache.put(cMIUser.getUniqueId(), cMIRank);
    }

    public RankManager(CMI cMI) {
        this.plugin = cMI;
    }

    private boolean isNextCheck(UUID uUID) {
        Long l = this.nextCheck.get(uUID);
        if (l == null || l < System.currentTimeMillis()) {
            this.nextCheck.put(uUID, System.currentTimeMillis() + (long)this.PlayerDelay);
            return true;
        }
        return false;
    }

    private boolean isNextAutoRecalculate(UUID uUID) {
        Long l = this.nextAutoRecalculate.get(uUID);
        if (l == null || l < System.currentTimeMillis()) {
            this.nextAutoRecalculate.put(uUID, System.currentTimeMillis() + (long)this.Recalculation);
            return true;
        }
        return false;
    }

    private boolean isNextInform(UUID uUID) {
        InformTimer informTimer = this.nextInform.get(uUID);
        if (informTimer == null) {
            this.nextInform.put(uUID, new InformTimer(System.currentTimeMillis() + (long)this.PlayerDelay));
            return true;
        }
        if (informTimer.getNextCheck() < System.currentTimeMillis()) {
            informTimer.addTimesInformed();
            informTimer.setNextCheck(System.currentTimeMillis() + (long)this.PlayerDelay + informTimer.getTimesInformed() * (long)this.PlayerDelay);
            return true;
        }
        return false;
    }

    public void removeFromCheck(UUID uUID) {
        this.nextCheck.remove(uUID);
        this.nextAutoRecalculate.remove(uUID);
        this.nextInform.remove(uUID);
    }

    public void stop() {
        if (this.sched != null) {
            this.sched.cancel();
            this.sched = null;
        }
        if (this.recSched != null) {
            this.recSched.cancel();
            this.recSched = null;
        }
        this.percentCache.clear();
    }

    public void autoRecheck() {
        if (!CMIModule.ranks.isEnabled()) {
            return;
        }
        if (this.Recalculation <= 0) {
            return;
        }
        this.recSched = CMIScheduler.scheduleSyncRepeatingTask((JavaPlugin)this.plugin, () -> {
            for (Player player : Bukkit.getOnlinePlayers()) {
                CMIUser cMIUser;
                if (!this.isNextAutoRecalculate(player.getUniqueId()) || (cMIUser = CMIUser.getUser(player)) == null) continue;
                this.recalculateRank(cMIUser);
            }
        }, (long)0L, (long)200L);
    }

    private void cycle() {
        for (Player player : Bukkit.getOnlinePlayers()) {
            List<CMIRank> list2;
            CMIRank cMIRank;
            CMIUser cMIUser;
            if (!this.isNextCheck(player.getUniqueId()) || (cMIUser = CMIUser.getUser(player)) == null || (cMIRank = cMIUser.getRank()) == null || (list2 = cMIRank.getNextValidRankUps(cMIUser)).isEmpty()) continue;
            boolean bl = this.isNextInform(player.getUniqueId());
            int n = 0;
            for (CMIRank cMIRank2 : list2) {
                if (!cMIRank2.isAutoRankup() || cMIRank2.isRankUpConfirmation()) continue;
                ++n;
            }
            int n2 = n;
            if (n2 > 1) {
                this.plugin.consoleMessage("&cUser " + player.getName() + " can rankup into " + n2 + " ranks from " + cMIRank.getName() + " at once. This needs to be fixed");
            }
            for (CMIRank cMIRank2 : list2) {
                if (!cMIRank2.isAutoRankup()) continue;
                CMIScheduler.runTask((JavaPlugin)this.plugin, () -> {
                    if (cMIRank2.isRankUpConfirmation() && bl) {
                        String string = ShadowCommand.addShadowCmd((Player)player, (String)("cmi rankup " + cMIUser.getName() + " " + cMIRank2.getName() + " confirm"), (Boolean)false, (ShadowCommandType)ShadowCommandType.Player);
                        String string2 = "cmi shadowcmd " + string;
                        RawMessage rawMessage = new RawMessage();
                        rawMessage.addText(CMILC.getIM(rankup.class.getSimpleName(), "confirm", "[ranks]", cMIRank2.getDisplayName(), "[rank]", cMIRank2.getDisplayName())).addHover("&6" + cMIRank2.getName()).addCommand(string2);
                        rawMessage.show(player);
                    }
                    if (cMIRank2.isAutoRankup() && !cMIRank2.isRankUpConfirmation() && n2 == 1) {
                        cMIUser.setRank(cMIRank2);
                        cMIRank2.finalizeRankup(cMIUser);
                    }
                });
            }
        }
    }

    public void run() {
        if (!CMIModule.ranks.isEnabled()) {
            return;
        }
        if (this.Delay <= 0) {
            return;
        }
        this.sched = this.async ? CMIScheduler.runTimerAsync((JavaPlugin)this.plugin, this::cycle, (long)0L, (long)((long)this.Delay * 20L)) : CMIScheduler.scheduleSyncRepeatingTask((JavaPlugin)this.plugin, this::cycle, (long)0L, (long)((long)this.Delay * 20L));
    }

    public void addRank(CMIRank cMIRank) {
        this.ranks.put(cMIRank.getName().toLowerCase(), cMIRank);
        LinkedHashMap<StatsManager.CMIStatistic, LinkedHashMap<Object, Long>> linkedHashMap = cMIRank.getStatRequirements();
        LinkedHashMap<StatsManager.CMIStatistic, LinkedHashMap> linkedHashMap2 = new LinkedHashMap<StatsManager.CMIStatistic, LinkedHashMap>();
        for (Map.Entry<StatsManager.CMIStatistic, LinkedHashMap<Object, Long>> entry : new LinkedHashMap<StatsManager.CMIStatistic, LinkedHashMap<Object, Long>>(linkedHashMap).entrySet()) {
            LinkedHashMap<Object, Long> linkedHashMap3 = entry.getValue();
            if (linkedHashMap3.get("none") == null) continue;
            LinkedHashMap linkedHashMap4 = (LinkedHashMap)linkedHashMap.remove((Object)entry.getKey());
            linkedHashMap2.put(entry.getKey(), linkedHashMap4);
        }
        linkedHashMap.putAll(linkedHashMap2);
    }

    public HashMap<String, CMIRank> getRanks() {
        return this.ranks;
    }

    public CMIRank getRank(String string) {
        if (string == null) {
            return null;
        }
        return this.ranks.get(string.toLowerCase());
    }

    public CMIRank getDefaultRank(Player player) {
        CMIRank cMIRank = null;
        if (player != null && player.isOnline()) {
            for (Map.Entry<String, CMIRank> entry : this.ranks.entrySet()) {
                if (!PermissionsManager.CMIPerm.rank_$1.hasSetPermission((CommandSender)player, entry.getKey()) || cMIRank != null && cMIRank.getWeight() >= entry.getValue().getWeight()) continue;
                cMIRank = entry.getValue();
            }
        }
        if (cMIRank == null) {
            for (Map.Entry<String, CMIRank> entry : this.ranks.entrySet()) {
                if (!entry.getValue().isDefaultRank()) continue;
                return entry.getValue();
            }
        }
        return cMIRank;
    }

    public boolean canRankUpAuto(CMIUser cMIUser) {
        CMIRank cMIRank = cMIUser.getRank();
        if (cMIRank == null) {
            return false;
        }
        for (CMIRank cMIRank2 : cMIRank.getNextValidRankUps(cMIUser)) {
            if (cMIRank2 == null || !cMIRank2.isAutoRankup()) continue;
            return true;
        }
        return false;
    }

    public rankupFailType canRankUp(CMIUser cMIUser, CMIRank cMIRank) {
        if (cMIRank == null) {
            return rankupFailType.NoRank;
        }
        Player player = cMIUser.getPlayer();
        if (player == null) {
            return rankupFailType.NoRank;
        }
        if (cMIRank.getMoneyCost() > 0.0 && !cMIUser.hasMoney(cMIRank.getMoneyCost())) {
            return rankupFailType.Money;
        }
        if (cMIRank.getExpCost() > 0.0 && cMIRank.getExpCost() > (double)cMIUser.getExp()) {
            return rankupFailType.Exp;
        }
        if (cMIRank.getVotes() > 0 && CMIHookType.Votifier.isEnabled() && cMIRank.getVotes() > cMIUser.getVotifierVotes()) {
            return rankupFailType.Votes;
        }
        for (Map.Entry<StatsManager.CMIStatistic, LinkedHashMap<Object, Long>> entry : cMIRank.getStatRequirements().entrySet()) {
            for (Map.Entry<Object, Long> entry2 : entry.getValue().entrySet()) {
                Long l = cMIUser.getStatistic(entry.getKey(), entry2.getKey());
                if (l >= entry2.getValue()) continue;
                return rankupFailType.Stats;
            }
        }
        for (Map.Entry<String, String> entry : cMIRank.getPermRequirements().entrySet()) {
            if (player.hasPermission(entry.getKey())) continue;
            return rankupFailType.Perm;
        }
        if (CMIHookType.mcMMO.isEnabled()) {
            for (Map.Entry<String, Integer> entry : cMIRank.getMcmmoRequirements().entrySet()) {
                int n = McMMOManager.getSkillLevel(player, entry.getKey());
                if (n >= entry.getValue()) continue;
                return rankupFailType.McMMO;
            }
        }
        if (CMIHookType.AureliumSkills.isEnabled()) {
            for (Map.Entry<String, Integer> entry : cMIRank.getAureliumRequirements().entrySet()) {
                int n = AureliumManager.getSkillLevel(player, entry.getKey());
                if (n >= entry.getValue()) continue;
                return rankupFailType.Aurelium;
            }
        }
        if (CMIHookType.AuraSkills.isEnabled()) {
            for (Map.Entry<String, Integer> entry : cMIRank.getAuraSkillsRequirements().entrySet()) {
                int n = AuraSkillsManager.getSkillLevel(player, entry.getKey());
                if (n >= entry.getValue()) continue;
                return rankupFailType.AuraSkills;
            }
        }
        if (CMIHookType.Jobs.isEnabled()) {
            for (Map.Entry<String, Integer> entry : cMIRank.getJobsRequirements().entrySet()) {
                int n = JobsManager.getJobsLevel(player, entry.getKey());
                if (n >= entry.getValue()) continue;
                return rankupFailType.Jobs;
            }
        }
        if (!cMIRank.getItemRequirements().isEmpty()) {
            HashMap<String, CMIItemStack> hashMap = RankManager.getInvContentsAmounts(player);
            for (Map.Entry<CMIItemStack, Integer> entry : cMIRank.getItemRequirements().entrySet()) {
                CMIItemStack cMIItemStack = hashMap.get(entry.getKey().getCMIType().toString());
                if (cMIItemStack == null) {
                    return rankupFailType.Items;
                }
                if (cMIItemStack.getAmount() >= entry.getValue()) continue;
                return rankupFailType.Items;
            }
        }
        if (!cMIRank.getPlaceholderRequirements().isEmpty()) {
            for (Map.Entry<String, CMIRankPlaceholder> entry : cMIRank.getPlaceholderRequirements().entrySet()) {
                if (!(entry.getValue().percent(player) < 100.0)) continue;
                return rankupFailType.Placeholoder;
            }
        }
        return rankupFailType.None;
    }

    private static HashMap<String, CMIItemStack> getInvContentsAmounts(Player player) {
        HashMap<String, CMIItemStack> hashMap = new HashMap<String, CMIItemStack>();
        ItemStack[] itemStackArray = player.getInventory().getContents();
        int n = itemStackArray.length;
        int n2 = 0;
        while (n2 < n) {
            ItemStack itemStack = itemStackArray[n2];
            if (itemStack != null) {
                Inventory inventory;
                CMIMaterial cMIMaterial = CMIMaterial.get((ItemStack)itemStack);
                String string = cMIMaterial.toString();
                if (cMIMaterial.isShulkerBox() && (inventory = CMI.getInstance().getNMS().getShulkerInv(itemStack)) != null) {
                    ItemStack[] itemStackArray2 = inventory.getContents();
                    int n3 = itemStackArray2.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        ItemStack itemStack2 = itemStackArray2[n4];
                        if (itemStack2 == null) {
                            ++n4;
                            continue;
                        }
                        break;
                    }
                } else if (!cMIMaterial.isEquipment() || itemStack.getDurability() <= 0) {
                    inventory = hashMap.get(string);
                    if (inventory == null) {
                        inventory = new CMIItemStack(itemStack.clone());
                    } else {
                        inventory.setAmount(inventory.getAmount() + itemStack.getAmount());
                    }
                    hashMap.put(string, (CMIItemStack)inventory);
                }
            }
            ++n2;
        }
        return hashMap;
    }

    public boolean removeContents(Player player, LinkedHashMap<CMIItemStack, Integer> linkedHashMap) {
        CMIUser cMIUser = this.plugin.getPlayerManager().getUser(player);
        if (cMIUser == null) {
            return false;
        }
        for (Map.Entry<CMIItemStack, Integer> entry : linkedHashMap.entrySet()) {
            cMIUser.getInventory().removeItemByCriteria(entry.getKey().getItemStack(), new CMIPlayerInventory.itemCheckType[0]);
        }
        return true;
    }

    public void listStatsRequirements(CommandSender commandSender, CMIUser cMIUser, CMIRank cMIRank) {
        for (Map.Entry<StatsManager.CMIStatistic, LinkedHashMap<Object, Long>> entry : cMIRank.getStatRequirements().entrySet()) {
            for (Map.Entry<Object, Long> entry2 : entry.getValue().entrySet()) {
                long l = cMIUser.getStatistic(entry.getKey(), entry2.getKey());
                String string = "none";
                string = entry2.getKey() instanceof CMIEntityType ? ((CMIEntityType)entry2.getKey()).getTranslatedName() : (entry2.getKey() instanceof CMIMaterial ? ((CMIMaterial)entry2.getKey()).getName() : (String)entry2.getKey());
                String string2 = l >= entry2.getValue() ? LC.info_variables_TrueColor.getLocale(new Object[0]) : LC.info_variables_FalseColor.getLocale(new Object[0]);
                String string3 = !string.equalsIgnoreCase("none") ? CMILC.getIM("rankinfo", "requiredStatsExtra", "[type]", RankManager.firstCap(string)) : "";
                CMILC.info("rankinfo", commandSender, "requiredStats", "[name]", CMILC.getIM("stats", "Statistics." + (Object)((Object)entry.getKey()), new Object[0]), "[extra]", string3, "[color]", string2, "[current]", this.translateValue(entry.getKey(), l), "[needed]", this.translateValue(entry.getKey(), entry2.getValue()));
            }
        }
    }

    public HashMap<StatsManager.CMIStatistic, LinkedHashMap<Object, rankCurrentRequirement>> getStatsRequirements(CMIUser cMIUser, CMIRank cMIRank) {
        HashMap<StatsManager.CMIStatistic, LinkedHashMap<Object, rankCurrentRequirement>> hashMap = new HashMap<StatsManager.CMIStatistic, LinkedHashMap<Object, rankCurrentRequirement>>();
        for (Map.Entry<StatsManager.CMIStatistic, LinkedHashMap<Object, Long>> entry : cMIRank.getStatRequirements().entrySet()) {
            for (Map.Entry<Object, Long> entry2 : entry.getValue().entrySet()) {
                rankCurrentRequirement rankCurrentRequirement2 = new rankCurrentRequirement(entry2.getValue(), cMIUser.getStatistic(entry.getKey(), entry2.getKey()));
                LinkedHashMap<Object, rankCurrentRequirement> linkedHashMap = hashMap.get((Object)entry.getKey());
                if (linkedHashMap == null) {
                    linkedHashMap = new LinkedHashMap();
                }
                linkedHashMap.put(entry2.getKey(), rankCurrentRequirement2);
                hashMap.put(entry.getKey(), linkedHashMap);
            }
        }
        return hashMap;
    }

    public Double getStatsDonePercentage(CMIUser cMIUser, CMIRank cMIRank) {
        HashMap<StatsManager.CMIStatistic, LinkedHashMap<Object, rankCurrentRequirement>> hashMap = this.plugin.getRankManager().getStatsRequirements(cMIUser, cMIRank);
        if (hashMap.isEmpty()) {
            return null;
        }
        rankCache rankCache2 = this.percentCache.get(cMIUser.getUniqueId());
        if (rankCache2 != null && !rankCache2.timeToCheck(rankupType.Stats)) {
            return rankCache2.getCache(rankupType.Stats);
        }
        Double d = 0.0;
        Double d2 = 0.0;
        for (Map.Entry<StatsManager.CMIStatistic, LinkedHashMap<Object, rankCurrentRequirement>> entry : hashMap.entrySet()) {
            for (Map.Entry<Object, rankCurrentRequirement> entry2 : entry.getValue().entrySet()) {
                d = d + 1.0;
                Double d3 = 100.0;
                if (entry2.getValue().getNeed() > entry2.getValue().getHave()) {
                    d3 = (double)entry2.getValue().getHave().longValue() * 100.0 / entry2.getValue().getNeed().doubleValue();
                }
                d2 = d2 + d3;
            }
        }
        if (d == 0.0) {
            return null;
        }
        d2 = d2 / d;
        if (rankCache2 == null) {
            rankCache2 = new rankCache();
        }
        rankCache2.setCache(rankupType.Stats, d2);
        this.percentCache.put(cMIUser.getUniqueId(), rankCache2);
        return d2;
    }

    private static String firstCap(String string) {
        return String.valueOf(string.substring(0, 1).toUpperCase()) + string.substring(1);
    }

    private void calculate(Double d, donePercentage donePercentage2, int n) {
        if (d == null) {
            return;
        }
        donePercentage2.addPercent(d);
        donePercentage2.addIncrement(n);
    }

    public Double getOverallDonePercentage(CMIUser cMIUser, CMIRank cMIRank) {
        donePercentage donePercentage2 = new donePercentage();
        this.calculate(this.getMoneyDonePercentage(cMIUser, cMIRank), donePercentage2, 1);
        this.calculate(this.getExpDonePercentage(cMIUser, cMIRank), donePercentage2, 1);
        this.calculate(this.getVoteDonePercentage(cMIUser, cMIRank), donePercentage2, 1);
        this.calculate(this.getStatsDonePercentage(cMIUser, cMIRank), donePercentage2, 1);
        this.calculate(this.getPermDonePercentage(cMIUser, cMIRank), donePercentage2, 1);
        this.calculate(this.getPlaceholderDonePercentage(cMIUser, cMIRank), donePercentage2, 1);
        this.calculate(this.getAureliumDonePercentage(cMIUser, cMIRank), donePercentage2, 1);
        this.calculate(this.getAuraSkillsDonePercentage(cMIUser, cMIRank), donePercentage2, 1);
        this.calculate(this.getJobsDonePercentage(cMIUser, cMIRank), donePercentage2, 1);
        this.calculate(this.getItemDonePercentage(cMIUser, cMIRank), donePercentage2, 1);
        if ((double)donePercentage2.getTimes() == 0.0) {
            return 0.0;
        }
        return donePercentage2.getPercent() / (double)donePercentage2.getTimes();
    }

    public Double getMoneyDonePercentage(CMIUser cMIUser, CMIRank cMIRank) {
        if (cMIRank.getMoneyCost() <= 0.0) {
            return null;
        }
        double d = cMIUser.getBalance();
        if (d > cMIRank.getMoneyCost()) {
            return 100.0;
        }
        return d * 100.0 / cMIRank.getMoneyCost();
    }

    public void listMoneyRequirements(CommandSender commandSender, CMIUser cMIUser, CMIRank cMIRank) {
        if (cMIRank.getMoneyCost() > 0.0) {
            double d = cMIUser.getBalance();
            String string = LC.info_variables_FalseColor.getLocale(new Object[0]);
            if (d >= cMIRank.getMoneyCost()) {
                string = LC.info_variables_TrueColor.getLocale(new Object[0]);
            }
            CMILC.info("rankinfo", commandSender, "requiredMoney", "[name]", cMIRank.getName(), "[color]", string, "[current]", String.format("%.0f", d), "[needed]", String.format("%.0f", cMIRank.getMoneyCost()));
        }
    }

    public Double getExpDonePercentage(CMIUser cMIUser, CMIRank cMIRank) {
        if (cMIRank.getExpCost() <= 0.0) {
            return null;
        }
        double d = cMIUser.getTotalExp();
        if (d > cMIRank.getExpCost()) {
            return 100.0;
        }
        return d * 100.0 / cMIRank.getExpCost();
    }

    public void listExpRequirements(CommandSender commandSender, CMIUser cMIUser, CMIRank cMIRank) {
        if (cMIRank.getExpCost() > 0.0) {
            double d = cMIUser.getTotalExp();
            String string = LC.info_variables_FalseColor.getLocale(new Object[0]);
            if (d >= cMIRank.getExpCost()) {
                string = LC.info_variables_TrueColor.getLocale(new Object[0]);
            }
            CMILC.info("rankinfo", commandSender, "requiredExp", "[name]", cMIRank.getName(), "[color]", string, "[current]", d, "[needed]", cMIRank.getExpCost());
        }
    }

    public Double getVoteDonePercentage(CMIUser cMIUser, CMIRank cMIRank) {
        if (cMIRank.getVotes() <= 0 || !CMIHookType.Votifier.isEnabled()) {
            return null;
        }
        int n = cMIUser.getVotifierVotes();
        if (n > cMIRank.getVotes()) {
            return 100.0;
        }
        return (double)n * 100.0 / (double)cMIRank.getVotes();
    }

    public void listVoteRequirements(CommandSender commandSender, CMIUser cMIUser, CMIRank cMIRank) {
        if (cMIRank.getVotes() > 0 && CMIHookType.Votifier.isEnabled()) {
            int n = cMIUser.getVotifierVotes();
            String string = LC.info_variables_FalseColor.getLocale(new Object[0]);
            if (n >= cMIRank.getVotes()) {
                string = LC.info_variables_TrueColor.getLocale(new Object[0]);
            }
            CMILC.info("rankinfo", commandSender, "requiredVotes", "[name]", cMIRank.getName(), "[color]", string, "[current]", n, "[needed]", cMIRank.getVotes());
        }
    }

    public void listPermRequirements(CommandSender commandSender, CMIUser cMIUser, CMIRank cMIRank) {
        if (!cMIRank.getPermRequirements().isEmpty()) {
            RawMessage rawMessage = new RawMessage();
            rawMessage.addText(CMILC.getIM("rankinfo", "requiredPerm", new Object[0]));
            String string = "";
            for (Map.Entry<String, String> entry : cMIRank.getPermRequirements().entrySet()) {
                String string2;
                String string3 = LC.info_variables_FalseColor.getLocale(new Object[0]);
                if (cMIUser.getPlayer().hasPermission(entry.getKey())) {
                    string3 = LC.info_variables_TrueColor.getLocale(new Object[0]);
                }
                String string4 = string2 = entry.getValue() == null ? entry.getKey() : entry.getValue();
                if (!string.isEmpty()) {
                    rawMessage.addText(LC.info_ListSpliter.getLocale(new Object[0]));
                }
                rawMessage.addText(String.valueOf(string3) + string2).addHover(String.valueOf(string3) + entry.getKey());
                string = String.valueOf(string) + " ";
            }
            rawMessage.show(commandSender);
        }
    }

    public Double getPermDonePercentage(CMIUser cMIUser, CMIRank cMIRank) {
        if (cMIRank.getPermRequirements().isEmpty()) {
            return null;
        }
        rankCache rankCache2 = this.percentCache.get(cMIUser.getUniqueId());
        if (rankCache2 != null && !rankCache2.timeToCheck(rankupType.Perm)) {
            return rankCache2.getCache(rankupType.Perm);
        }
        Double d = 0.0;
        Double d2 = 0.0;
        for (Map.Entry<String, String> entry : cMIRank.getPermRequirements().entrySet()) {
            d = d + 1.0;
            d2 = cMIUser.getPlayer().hasPermission(entry.getKey()) ? Double.valueOf(d2 + 100.0) : Double.valueOf(d2 + 0.0);
        }
        if (d == 0.0) {
            return null;
        }
        d2 = d2 / d;
        if (rankCache2 == null) {
            rankCache2 = new rankCache();
        }
        rankCache2.setCache(rankupType.Perm, d2);
        this.percentCache.put(cMIUser.getUniqueId(), rankCache2);
        return CMINumber.clamp((double)d2, (double)0.0, (double)100.0);
    }

    public Double getPlaceholderDonePercentage(CMIUser cMIUser, CMIRank cMIRank) {
        if (cMIRank.getPlaceholderRequirements().isEmpty()) {
            return null;
        }
        rankCache rankCache2 = this.percentCache.get(cMIUser.getUniqueId());
        if (rankCache2 != null && !rankCache2.timeToCheck(rankupType.Placeholoder)) {
            return rankCache2.getCache(rankupType.Placeholoder);
        }
        Double d = 0.0;
        for (Map.Entry<String, CMIRankPlaceholder> entry : cMIRank.getPlaceholderRequirements().entrySet()) {
            d = d + entry.getValue().percent(cMIUser.getPlayer(false));
        }
        d = d / (double)cMIRank.getPlaceholderRequirements().size();
        if (rankCache2 == null) {
            rankCache2 = new rankCache(2000L);
        }
        rankCache2.setCache(rankupType.Placeholoder, d);
        this.percentCache.put(cMIUser.getUniqueId(), rankCache2);
        return CMINumber.clamp((double)d, (double)0.0, (double)100.0);
    }

    public void listPlaceholderRequirements(CommandSender commandSender, CMIUser cMIUser, CMIRank cMIRank) {
        if (cMIRank.getPlaceholderRequirements().isEmpty()) {
            return;
        }
        RawMessage rawMessage = new RawMessage();
        rawMessage.addText(CMILC.getIM("rankinfo", "requiredPlaceholder", new Object[0]));
        Player player = cMIUser.getPlayer();
        if (player == null) {
            return;
        }
        String string = "";
        for (Map.Entry<String, CMIRankPlaceholder> entry : cMIRank.getPlaceholderRequirements().entrySet()) {
            CMIRankPlaceholder cMIRankPlaceholder = entry.getValue();
            String string2 = LC.info_variables_FalseColor.getLocale(new Object[0]);
            if (cMIRankPlaceholder.percent(player) >= 100.0) {
                string2 = LC.info_variables_TrueColor.getLocale(new Object[0]);
            }
            if (!string.isEmpty()) {
                rawMessage.addText(LC.info_ListSpliter.getLocale(new Object[0]));
            }
            string = "s";
            rawMessage.addText(CMILC.getIM("rankinfo", "requiredPlaceholderList", "[message]", cMIRankPlaceholder.getMessage(), "[color]", string2));
            Object object = cMIRankPlaceholder.getValue();
            if (object instanceof Double && (Double)object % 1.0 == 0.0) {
                object = ((Double)object).intValue();
            }
            rawMessage.addHover(CMILC.getIM("rankinfo", "requiredPlaceholderHover", "[needed]", object, "[color]", string2, "[current]", CMI.getInstance().getPlaceholderAPIManager().updatePlaceHolders(player, cMIRankPlaceholder.getPlaceholder())));
        }
        rawMessage.show(commandSender);
    }

    public Double getAureliumDonePercentage(CMIUser cMIUser, CMIRank cMIRank) {
        if (!CMIHookType.AureliumSkills.isEnabled()) {
            return null;
        }
        if (cMIRank.getAureliumRequirements().isEmpty()) {
            return null;
        }
        rankCache rankCache2 = this.percentCache.get(cMIUser.getUniqueId());
        if (rankCache2 != null && !rankCache2.timeToCheck(rankupType.Aurelium)) {
            return rankCache2.getCache(rankupType.Aurelium);
        }
        Player player = cMIUser.getPlayer();
        if (player == null) {
            return null;
        }
        Double d = 0.0;
        Double d2 = 0.0;
        for (Map.Entry<String, Integer> entry : cMIRank.getAureliumRequirements().entrySet()) {
            d = d + 1.0;
            String string = entry.getKey();
            if (!AureliumManager.isSkillCorrect(string) && !string.equalsIgnoreCase("Power")) continue;
            int n = AureliumManager.getSkillLevel(player, string);
            d2 = n >= entry.getValue() ? Double.valueOf(d2 + 100.0) : Double.valueOf(d2 + (double)n * 100.0 / entry.getValue().doubleValue());
        }
        if (d == 0.0) {
            return null;
        }
        d2 = d2 / d;
        if (rankCache2 == null) {
            rankCache2 = new rankCache();
        }
        rankCache2.setCache(rankupType.Aurelium, d2);
        this.percentCache.put(cMIUser.getUniqueId(), rankCache2);
        return CMINumber.clamp((double)d2, (double)0.0, (double)100.0);
    }

    public void listAureliumRequirements(CommandSender commandSender, CMIUser cMIUser, CMIRank cMIRank) {
        if (!CMIHookType.AureliumSkills.isEnabled()) {
            return;
        }
        if (cMIRank.getAureliumRequirements().isEmpty()) {
            return;
        }
        RawMessage rawMessage = new RawMessage();
        rawMessage.addText(CMILC.getIM("rankinfo", "requiredAurelium", new Object[0]));
        Player player = cMIUser.getPlayer();
        if (player == null) {
            return;
        }
        String string = "";
        for (Map.Entry<String, Integer> entry : cMIRank.getAureliumRequirements().entrySet()) {
            String string2 = entry.getKey();
            if (!AureliumManager.isSkillCorrect(string2) && !string2.equalsIgnoreCase("Power")) continue;
            int n = AureliumManager.getSkillLevel(player, string2);
            String string3 = LC.info_variables_FalseColor.getLocale(new Object[0]);
            if (n >= entry.getValue()) {
                string3 = LC.info_variables_TrueColor.getLocale(new Object[0]);
            }
            if (!string.isEmpty()) {
                rawMessage.addText(LC.info_ListSpliter.getLocale(new Object[0]));
            }
            string = "s";
            rawMessage.addText(CMILC.getIM("rankinfo", "requiredAureliumList", "[name]", AureliumManager.getRealSkillName(commandSender, entry.getKey()), "[color]", string3, "[current]", AureliumManager.getSkillLevel(player, string2), "[needed]", entry.getValue())).addHover(CMILC.getIM("rankinfo", "requiredAureliumListHover", "[name]", AureliumManager.getRealSkillName(commandSender, entry.getKey()), "[color]", string3, "[current]", AureliumManager.getSkillLevel(player, string2), "[needed]", entry.getValue()));
        }
        rawMessage.show(commandSender);
    }

    public Double getAuraSkillsDonePercentage(CMIUser cMIUser, CMIRank cMIRank) {
        if (!CMIHookType.AuraSkills.isEnabled()) {
            return null;
        }
        if (cMIRank.getAuraSkillsRequirements().isEmpty()) {
            return null;
        }
        rankCache rankCache2 = this.percentCache.get(cMIUser.getUniqueId());
        if (rankCache2 != null && !rankCache2.timeToCheck(rankupType.AuraSkills)) {
            return rankCache2.getCache(rankupType.AuraSkills);
        }
        Player player = cMIUser.getPlayer();
        if (player == null) {
            return null;
        }
        Double d = 0.0;
        Double d2 = 0.0;
        for (Map.Entry<String, Integer> entry : cMIRank.getAuraSkillsRequirements().entrySet()) {
            d = d + 1.0;
            String string = entry.getKey();
            if (!AuraSkillsManager.isSkillCorrect(string) && !string.equalsIgnoreCase("Power")) continue;
            int n = AuraSkillsManager.getSkillLevel(player, string);
            d2 = n >= entry.getValue() ? Double.valueOf(d2 + 100.0) : Double.valueOf(d2 + (double)n * 100.0 / entry.getValue().doubleValue());
        }
        if (d == 0.0) {
            return null;
        }
        d2 = d2 / d;
        if (rankCache2 == null) {
            rankCache2 = new rankCache();
        }
        rankCache2.setCache(rankupType.AuraSkills, d2);
        this.percentCache.put(cMIUser.getUniqueId(), rankCache2);
        return CMINumber.clamp((double)d2, (double)0.0, (double)100.0);
    }

    public void listAuraSkillsRequirements(CommandSender commandSender, CMIUser cMIUser, CMIRank cMIRank) {
        if (!CMIHookType.AuraSkills.isEnabled()) {
            return;
        }
        if (cMIRank.getAuraSkillsRequirements().isEmpty()) {
            return;
        }
        RawMessage rawMessage = new RawMessage();
        rawMessage.addText(CMILC.getIM("rankinfo", "requiredAuraSkills", new Object[0]));
        Player player = cMIUser.getPlayer();
        if (player == null) {
            return;
        }
        String string = "";
        for (Map.Entry<String, Integer> entry : cMIRank.getAuraSkillsRequirements().entrySet()) {
            String string2 = entry.getKey();
            if (!AuraSkillsManager.isSkillCorrect(string2) && !string2.equalsIgnoreCase("Power")) continue;
            int n = AuraSkillsManager.getSkillLevel(player, string2);
            String string3 = LC.info_variables_FalseColor.getLocale(new Object[0]);
            if (n >= entry.getValue()) {
                string3 = LC.info_variables_TrueColor.getLocale(new Object[0]);
            }
            if (!string.isEmpty()) {
                rawMessage.addText(LC.info_ListSpliter.getLocale(new Object[0]));
            }
            string = "s";
            rawMessage.addText(CMILC.getIM("rankinfo", "requiredAuraSkillsList", "[name]", AuraSkillsManager.getRealSkillName(commandSender, entry.getKey()), "[color]", string3, "[current]", AuraSkillsManager.getSkillLevel(player, string2), "[needed]", entry.getValue())).addHover(CMILC.getIM("rankinfo", "requiredAuraSkillsListHover", "[name]", AuraSkillsManager.getRealSkillName(commandSender, entry.getKey()), "[color]", string3, "[current]", AuraSkillsManager.getSkillLevel(player, string2), "[needed]", entry.getValue()));
        }
        rawMessage.show(commandSender);
    }

    public Double getMcMMODonePercentage(CMIUser cMIUser, CMIRank cMIRank) {
        if (!CMIHookType.mcMMO.isEnabled()) {
            return null;
        }
        if (cMIRank.getMcmmoRequirements().isEmpty()) {
            return null;
        }
        rankCache rankCache2 = this.percentCache.get(cMIUser.getUniqueId());
        if (rankCache2 != null && !rankCache2.timeToCheck(rankupType.McMMO)) {
            return rankCache2.getCache(rankupType.McMMO);
        }
        Player player = cMIUser.getPlayer();
        if (player == null) {
            return null;
        }
        Double d = 0.0;
        Double d2 = 0.0;
        for (Map.Entry<String, Integer> entry : cMIRank.getMcmmoRequirements().entrySet()) {
            d = d + 1.0;
            String string = entry.getKey();
            if (!McMMOManager.isSkillCorrect(string) && !string.equalsIgnoreCase("Power")) continue;
            int n = McMMOManager.getSkillLevel(player, string);
            d2 = n >= entry.getValue() ? Double.valueOf(d2 + 100.0) : Double.valueOf(d2 + (double)n * 100.0 / entry.getValue().doubleValue());
        }
        if (d == 0.0) {
            return null;
        }
        d2 = d2 / d;
        if (rankCache2 == null) {
            rankCache2 = new rankCache();
        }
        rankCache2.setCache(rankupType.McMMO, d2);
        this.percentCache.put(cMIUser.getUniqueId(), rankCache2);
        return CMINumber.clamp((double)d2, (double)0.0, (double)100.0);
    }

    public void listMcmmoRequirements(CommandSender commandSender, CMIUser cMIUser, CMIRank cMIRank) {
        if (!CMIHookType.mcMMO.isEnabled()) {
            return;
        }
        if (cMIRank.getMcmmoRequirements().isEmpty()) {
            return;
        }
        RawMessage rawMessage = new RawMessage();
        rawMessage.addText(CMILC.getIM("rankinfo", "requiredMcmmo", new Object[0]));
        Player player = cMIUser.getPlayer();
        if (player == null) {
            return;
        }
        String string = "";
        for (Map.Entry<String, Integer> entry : cMIRank.getMcmmoRequirements().entrySet()) {
            String string2 = entry.getKey();
            if (!McMMOManager.isSkillCorrect(string2) && !string2.equalsIgnoreCase("Power")) continue;
            int n = McMMOManager.getSkillLevel(player, string2);
            String string3 = LC.info_variables_FalseColor.getLocale(new Object[0]);
            if (n >= entry.getValue()) {
                string3 = LC.info_variables_TrueColor.getLocale(new Object[0]);
            }
            if (!string.isEmpty()) {
                rawMessage.addText(LC.info_ListSpliter.getLocale(new Object[0]));
            }
            string = "s";
            rawMessage.addText(CMILC.getIM("rankinfo", "requiredMcmmoList", "[name]", McMMOManager.getRealSkillName(entry.getKey()), "[color]", string3, "[current]", McMMOManager.getSkillLevel(player, string2), "[needed]", entry.getValue())).addHover(CMILC.getIM("rankinfo", "requiredMcmmoListHover", "[name]", McMMOManager.getRealSkillName(entry.getKey()), "[color]", string3, "[current]", McMMOManager.getSkillLevel(player, string2), "[needed]", entry.getValue()));
        }
        rawMessage.show(commandSender);
    }

    public Double getJobsDonePercentage(CMIUser cMIUser, CMIRank cMIRank) {
        if (!CMIHookType.Jobs.isEnabled()) {
            return null;
        }
        if (cMIRank.getJobsRequirements().isEmpty()) {
            return null;
        }
        rankCache rankCache2 = this.percentCache.get(cMIUser.getUniqueId());
        if (rankCache2 != null && !rankCache2.timeToCheck(rankupType.Jobs)) {
            return rankCache2.getCache(rankupType.Jobs);
        }
        Player player = cMIUser.getPlayer();
        if (player == null) {
            return null;
        }
        Double d = 0.0;
        Double d2 = 0.0;
        for (Map.Entry<String, Integer> entry : cMIRank.getJobsRequirements().entrySet()) {
            d = d + 1.0;
            String string = entry.getKey();
            if (!JobsManager.isJobCorrect(string) && !string.equalsIgnoreCase("TotalLevel")) continue;
            int n = JobsManager.getJobsLevel(player, string);
            d2 = n >= entry.getValue() ? Double.valueOf(d2 + 100.0) : Double.valueOf(d2 + (double)n * 100.0 / entry.getValue().doubleValue());
        }
        if (d == 0.0) {
            return null;
        }
        d2 = d2 / d;
        if (rankCache2 == null) {
            rankCache2 = new rankCache();
        }
        rankCache2.setCache(rankupType.Jobs, d2);
        this.percentCache.put(cMIUser.getUniqueId(), rankCache2);
        return CMINumber.clamp((double)d2, (double)0.0, (double)100.0);
    }

    public void listJobsRequirements(CommandSender commandSender, CMIUser cMIUser, CMIRank cMIRank) {
        if (!CMIHookType.Jobs.isEnabled()) {
            return;
        }
        if (cMIRank.getJobsRequirements().isEmpty()) {
            return;
        }
        RawMessage rawMessage = new RawMessage();
        rawMessage.addText(CMILC.getIM("rankinfo", "requiredJobs", new Object[0]));
        Player player = cMIUser.getPlayer();
        if (player == null) {
            return;
        }
        for (Map.Entry<String, Integer> entry : cMIRank.getJobsRequirements().entrySet()) {
            String string = entry.getKey();
            if (!JobsManager.isJobCorrect(string) && !string.equalsIgnoreCase("TotalLevel")) continue;
            int n = JobsManager.getJobsLevel(player, string);
            String string2 = LC.info_variables_FalseColor.getLocale(new Object[0]);
            if (n >= entry.getValue()) {
                string2 = LC.info_variables_TrueColor.getLocale(new Object[0]);
            }
            rawMessage.addText(CMILC.getIM("rankinfo", "requiredJobsList", "[name]", JobsManager.getRealJobName(entry.getKey()), "[color]", string2, "[current]", JobsManager.getJobsLevel(player, string), "[needed]", entry.getValue())).addHover(CMILC.getIM("rankinfo", "requiredJobsListHover", "[name]", JobsManager.getRealJobName(entry.getKey()), "[color]", string2, "[current]", JobsManager.getJobsLevel(player, string), "[needed]", entry.getValue()));
        }
        rawMessage.show(commandSender);
    }

    public Double getItemDonePercentage(CMIUser cMIUser, CMIRank cMIRank) {
        if (cMIRank.getItemRequirements().isEmpty()) {
            return null;
        }
        rankCache rankCache2 = this.percentCache.get(cMIUser.getUniqueId());
        if (rankCache2 != null && !rankCache2.timeToCheck(rankupType.Items)) {
            return rankCache2.getCache(rankupType.Items);
        }
        Player player = cMIUser.getPlayer();
        if (player == null) {
            return null;
        }
        Double d = 0.0;
        Double d2 = 0.0;
        HashMap<String, CMIItemStack> hashMap = RankManager.getInvContentsAmounts(player);
        for (Map.Entry<CMIItemStack, Integer> entry : cMIRank.getItemRequirements().entrySet()) {
            d = d + 1.0;
            CMIItemStack cMIItemStack = hashMap.get(entry.getKey().getCMIType().toString());
            int n = cMIItemStack != null ? cMIItemStack.getAmount() : 0;
            d2 = n >= entry.getValue() ? Double.valueOf(d2 + 100.0) : Double.valueOf(d2 + (double)n * 100.0 / entry.getValue().doubleValue());
        }
        if (d == 0.0) {
            return null;
        }
        d2 = d2 / d;
        if (rankCache2 == null) {
            rankCache2 = new rankCache();
        }
        rankCache2.setCache(rankupType.Items, d2);
        this.percentCache.put(cMIUser.getUniqueId(), rankCache2);
        return CMINumber.clamp((double)d2, (double)0.0, (double)100.0);
    }

    public void listItemRequirements(CommandSender commandSender, CMIUser cMIUser, CMIRank cMIRank) {
        if (cMIRank.getItemRequirements().isEmpty()) {
            return;
        }
        RawMessage rawMessage = new RawMessage();
        rawMessage.addText(CMILC.getIM("rankinfo", "requiredItem", new Object[0]));
        Player player = cMIUser.getPlayer();
        if (player == null) {
            return;
        }
        HashMap<String, CMIItemStack> hashMap = RankManager.getInvContentsAmounts(player);
        String string = "";
        for (Map.Entry<CMIItemStack, Integer> entry : cMIRank.getItemRequirements().entrySet()) {
            CMIItemStack cMIItemStack = entry.getKey();
            CMIItemStack cMIItemStack2 = hashMap.get(entry.getKey().getCMIType().toString());
            int n = cMIItemStack2 != null ? cMIItemStack2.getAmount() : 0;
            String string2 = LC.info_variables_FalseColor.getLocale(new Object[0]);
            if (n >= entry.getValue()) {
                string2 = LC.info_variables_TrueColor.getLocale(new Object[0]);
            }
            if (!string.isEmpty()) {
                rawMessage.addText(LC.info_ListSpliter.getLocale(new Object[0]));
            }
            rawMessage.addText(CMILC.getIM("rankinfo", "requiredItemsList", "[name]", cMIItemStack.getRealName(), "[color]", string2, "[current]", n, "[needed]", entry.getValue())).addHover(CMILC.getIM("rankinfo", "requiredItemListHover", "[name]", cMIItemStack.getRealName(), "[color]", string2, "[current]", n, "[needed]", entry.getValue()));
            string = String.valueOf(string) + ",";
        }
        rawMessage.show(commandSender);
    }

    public String translateValue(StatsManager.CMIStatistic cMIStatistic, Long l) {
        switch (cMIStatistic.getType()) {
            case Damage: {
                return this.formatter.format((double)l.longValue() / 10.0);
            }
            case Distance: {
                return this.convertDistance(l);
            }
            case Number: {
                break;
            }
            case Time: {
                if (!this.OnlyHours) {
                    return CMIChatColor.stripColor((String)CMITimeManager.to24hourShort((Long)l));
                }
                return CMIChatColor.stripColor((String)CMITimeManager.toOnlyHoursShort((Long)l, (boolean)true, (boolean)this.includeMinutes));
            }
        }
        return l.toString();
    }

    private String convertDistance(long l) {
        String string = l < 100L ? CMILC.getIM("rankinfo", "distanceCM", "[value]", l) : (l / 100L < 1000L ? CMILC.getIM("rankinfo", "distanceM", "[value]", (double)l / 100.0) : CMILC.getIM("rankinfo", "distanceKm", "[value]", (double)Math.round((double)l / 1000.0) / 100.0));
        return string;
    }

    public void load() {
        Long l = System.currentTimeMillis();
        CMI.getInstance().safeRenameFile(this.fileName.toLowerCase(), "Settings" + File.separator + this.fileName);
        ConfigReader configReader = null;
        try {
            configReader = new ConfigReader(new File(this.plugin.getDataFolder(), "Settings" + File.separator + this.fileName));
            configReader.load();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (configReader == null) {
            return;
        }
        this.percentCache.clear();
        configReader.header(Arrays.asList("Main server folder spigot.yml and check that stats saving prevention its set to false stats->disable-saving: false", "Player will get default rank group depending on set permission node cmi.rank.[groupName]", "Not enabled ranks will be ignored", "DisplayName section is optional and it will be used to represent rank ingame. This is NOT defining required permission node and you still need to use node name to rankup to this rank", "DefaultRank section defines if player can be assigned to this rank if he dont have any. There can be more than one default rank, and depending on permision node, first rank will be assigned to that player when needed", "PermissionRequirement section defines list of permissions player should have to rankup to that rank. Optional - For each permission node you can add its name which will be shown in /cmi rankinfo with : In example cmi.command.fly:Fly", "McMMORequirement section defines list of McMMO skills and levels player should have to rankup to that rank.", "AureliumRequirement section defines list of Aurelium skills and levels player should have to rankup to that rank.", "AuraSkillsRequirement section defines list of Aura skills and levels player should have to rankup to that rank.", "McMMO and Aurelium sections can use skill name as Power to indicate total sum of all skills", "JobsRequirement section defines list of Jobs and levels player should have to rankup to that rank.", "ItemRequirement section defines list of items player should have to rankup to that rank. Items will be taken after succesfull rankup from players inventory.", "AutoRankup section defines if player will be auto ranked to this rank if possible. Keep in mind that if there is more than one legit rankup, player will have to confirm to which rank he wants to rankup", "RankupConfirmation section defines if you want to add additional confirmation for this rankup. Usefull to avoid unintentional rankups. Keep in mind that autorankup will request confirmation for rankup to this rank even if there is only one legit rankup option", "NextRanks is list of possible next ranks from this rank. Can be one or can be dozens. Keep in mind that each rank requirements will be shown in chat and it can clutter quite allot if there is bunch of them at once", "MoneyCost defines how much player will have to pay to rankup to this rank", "ExpCost defines how much player will have to pay in exp to rankup to this rank", "Votes defines how much player will need to have votes to rankup to this rank", "Commands is list which will be performed on rankup. Can be additional actions, like message broadcast or anything alse", "Main section is StatsRequirements and it can have allot of different values in it:", "  In general format goes like this [mainStat](:optionalSubStat):amount", "  In example MonsterKills:100 will require from player to have 100 monster kills while MonsterKills:Zombie:100 will require to have 100 zombie kills. Both of them can be used if needed.", "    List of possible requirement and basic explanations:", "      Distance in blocks:", "        Travel - travel in total", "        Walk - has to walk", "        Sneak - has to sneak", "        Sprint - has to sprint", "        Swim - has to swim", "        Fall - has to fall", "        Climb - has to climb", "        Fly - has to fly", "        Dive - has to walk under water", "        MinecartTravel - has to travel with minecart", "        BoatTravel - has to travel with boat", "        PigTravel - has to ride pig", "        HorseTravel - has to ride horse", "        ElytraTravel - has to fly with elytra", "      Time in sec:", "        PlayTime - total play time", "        FromLastDeath - from last death", "        SneakTime - sneak time", "      Amounts:", "        GameQuit - how many times player left game", "        Jump - jump count", "        DamageDealt - total damage made", "        DamageTaken - total damage taken", "        Deaths - count of deaths", "        MobKills - total amount of mobs killed by player", "        PlayerKills - total amount of players killed. Indirect kills dont count", "        ItemEnchanted - amount of enchanted items", "        AnimalsBred - animals bred", "        FishCaught - fish caught", "        TalkedToVillager - times talked to villager", "        TradedWithVillager - traded with willager", "        CakeSlicesEaten - cake slices eaten", "        CauldronFilled - cauldron filled", "        CouldronUsed - couldron used", "        ArmorCleaned - times armor cleaned (leather armor)", "        BannerCleaned - times banner cleaned", "        BrewingstandInteractions - brewingstand interactions", "        BeaconInteractions - beacon interactions", "        CraftingTableInteractions - crafting table interactions", "        FurnaceInteractions - furnace interactions", "        DispenserInspected - dispenser inspected", "        DropperInspected - dropper inspected", "        HopperInspected - hopper inspected", "        ChestOpen - chest open", "        TrappedChestTriggered - trapped chest triggered", "        EnderchestOpened - enderchest opened", "        NoteblockPlayed - noteblock played", "        NoteblockTuned - noteblock tuned", "        FlowerPotted - flower potted", "        RecordPlayed - record played", "        SleeptInBed - sleept in bed", "        ShulkerBoxOpened - shulker box opened", "        ItemDropped - defines amount of dropped items. If specific item is not defined, then total amount is used", "        ItemPickups - defines amount of picked up items. If specific item is not defined, then total amount is used", "        BlocksMined - defines amount of blocks mined. If specific block is not defined, then total amount is used", "        BlocksPlaced - defines amount of blocks placed. If specific block is not defined, then total amount is used", "        ItemBreaks - defines amount of broken items. If specific item is not defined, then total amount is used", "        ItemCrafts - defines amount of crafted items. If specific item is not defined, then total amount is used", "        ItemsUsed - defines amount of item usage. like mining with pickaxe. If specific item is not defined, then total amount is used", "        MonsterKills - defines amount of monster kills. If specific monster is not defined, then total amount is used", "        KilledBy - defines amount of deaths by monster. If specific monster is not defined, then total amount is used"));
        configReader.save();
        LinkedHashMap<String, CMIRank> linkedHashMap = new LinkedHashMap<String, CMIRank>(this.ranks);
        this.ranks.clear();
        this.nextCheck.clear();
        this.nextInform.clear();
        if (configReader.getC().getKeys(false).isEmpty()) {
            return;
        }
        Map map = configReader.getC().getValues(false);
        for (Map.Entry entry : map.entrySet()) {
            Object object;
            block96: {
                object = linkedHashMap.get(((String)entry.getKey()).toLowerCase());
                if (object == null) {
                    object = new CMIRank((String)entry.getKey());
                } else {
                    ((CMIRank)object).reset();
                }
                try {
                    Object object2;
                    Object object3;
                    Object object4;
                    Object object5;
                    String string2;
                    ArrayList<String> arrayList;
                    Cloneable cloneable;
                    Map map2 = configReader.getC().getConfigurationSection((String)entry.getKey()).getValues(false);
                    if (map2.containsKey("Enabled")) {
                        ((CMIRank)object).setEnabled((Boolean)map2.get("Enabled"));
                    }
                    if (!((CMIRank)object).isEnabled()) continue;
                    if (map2.containsKey("DisplayName")) {
                        ((CMIRank)object).setDisplayName((String)map2.get("DisplayName"));
                    }
                    if (map2.containsKey("DefaultRank")) {
                        ((CMIRank)object).setDefaultRank((Boolean)map2.get("DefaultRank"));
                    }
                    if (map2.containsKey("AutoRankup")) {
                        ((CMIRank)object).setAutoRankup((Boolean)map2.get("AutoRankup"));
                    }
                    if (map2.containsKey("RankupConfirmation")) {
                        ((CMIRank)object).setRankUpConfirmation((Boolean)map2.get("RankupConfirmation"));
                    }
                    if (map2.containsKey("NextRanks")) {
                        if (map2.get("NextRanks") instanceof String) {
                            ((CMIRank)object).setNextRanksT(Arrays.asList((String)map2.get("NextRanks")));
                        } else {
                            ((CMIRank)object).setNextRanksT((List)map2.get("NextRanks"));
                        }
                    }
                    if (map2.containsKey("MoneyCost")) {
                        if (map2.get("MoneyCost") instanceof Double) {
                            ((CMIRank)object).setMoneyCost((Double)map2.get("MoneyCost"));
                        } else if (map2.get("MoneyCost") instanceof Integer) {
                            ((CMIRank)object).setMoneyCost(((Integer)map2.get("MoneyCost")).intValue());
                        } else if (map2.get("MoneyCost") instanceof Long) {
                            ((CMIRank)object).setMoneyCost(((Long)map2.get("MoneyCost")).longValue());
                        }
                    }
                    if (map2.containsKey("ExpCost")) {
                        if (map2.get("ExpCost") instanceof Double) {
                            ((CMIRank)object).setExpCost((Double)map2.get("ExpCost"));
                        } else if (map2.get("ExpCost") instanceof Integer) {
                            ((CMIRank)object).setExpCost(((Integer)map2.get("ExpCost")).intValue());
                        }
                    }
                    if (map2.containsKey("Votes")) {
                        if (map2.get("Votes") instanceof Double) {
                            ((CMIRank)object).setVotes(((Double)map2.get("Votes")).intValue());
                        } else if (map2.get("Votes") instanceof Integer) {
                            ((CMIRank)object).setVotes((Integer)map2.get("Votes"));
                        }
                    }
                    if (map2.containsKey("Commands")) {
                        if (map2.get("Commands") instanceof String) {
                            ((CMIRank)object).setCommands(Arrays.asList((String)map2.get("Commands")));
                        } else {
                            ((CMIRank)object).setCommands((List)map2.get("Commands"));
                        }
                    }
                    if (map2.containsKey("CommandsOnRankDown")) {
                        if (map2.get("CommandsOnRankDown") instanceof String) {
                            ((CMIRank)object).setCommandsOnRankDown(Arrays.asList((String)map2.get("CommandsOnRankDown")));
                        } else {
                            ((CMIRank)object).setCommandsOnRankDown((List)map2.get("CommandsOnRankDown"));
                        }
                    }
                    if (map2.containsKey("PermissionRequirement")) {
                        cloneable = new LinkedHashMap<String, String>();
                        arrayList = new ArrayList<String>();
                        if (map2.get("PermissionRequirement") instanceof String) {
                            string2 = (String)map2.get("PermissionRequirement");
                            arrayList.add(string2);
                        } else {
                            arrayList.addAll((List)map2.get("PermissionRequirement"));
                        }
                        for (String string2 : arrayList) {
                            object5 = null;
                            object4 = string2;
                            if (string2.contains(":")) {
                                object5 = string2.split(":")[1];
                                object4 = string2.split(":")[0];
                            }
                            ((HashMap)cloneable).put((String)object4, (String)object5);
                        }
                        ((CMIRank)object).setPermRequirements((LinkedHashMap<String, String>)cloneable);
                    }
                    if (map2.containsKey("PlaceholderRequirements")) {
                        cloneable = new LinkedHashMap();
                        arrayList = new ArrayList();
                        if (map2.get("PlaceholderRequirements") instanceof String) {
                            string2 = (String)map2.get("PlaceholderRequirements");
                            arrayList.add(string2);
                        } else {
                            arrayList.addAll((List)map2.get("PlaceholderRequirements"));
                        }
                        for (String string2 : arrayList) {
                            object5 = new CMIRankPlaceholder(string2);
                            if (((CMIRankPlaceholder)object5).getType().equals((Object)rankPlaceholderType.invalid)) {
                                CMIMessages.consoleMessage((String)("&cCould not decode ranks placeholder requirement as (" + string2 + ")"));
                                continue;
                            }
                            ((HashMap)cloneable).put(((CMIRankPlaceholder)object5).getPlaceholder(), object5);
                        }
                        ((CMIRank)object).setPlaceholderRequirements((LinkedHashMap<String, CMIRankPlaceholder>)cloneable);
                    }
                    if (map2.containsKey("McMMORequirement")) {
                        cloneable = new LinkedHashMap();
                        arrayList = new ArrayList();
                        if (map2.get("McMMORequirement") instanceof String) {
                            string2 = (String)map2.get("McMMORequirement");
                            arrayList.add(string2);
                        } else {
                            arrayList.addAll((List)map2.get("McMMORequirement"));
                        }
                        for (String string2 : arrayList) {
                            object5 = string2;
                            object4 = 0;
                            if (string2.contains(":")) {
                                try {
                                    object4 = Integer.parseInt(string2.split(":")[1]);
                                }
                                catch (Exception exception) {
                                    continue;
                                }
                                object5 = string2.split(":")[0];
                            }
                            if ((Integer)object4 == 0) continue;
                            ((HashMap)cloneable).put(object5, object4);
                        }
                        ((CMIRank)object).setMcmmoRequirements((LinkedHashMap<String, Integer>)cloneable);
                    }
                    if (map2.containsKey("AureliumRequirement")) {
                        cloneable = new LinkedHashMap();
                        arrayList = new ArrayList();
                        if (map2.get("AureliumRequirement") instanceof String) {
                            string2 = (String)map2.get("AureliumRequirement");
                            arrayList.add(string2);
                        } else {
                            arrayList.addAll((List)map2.get("AureliumRequirement"));
                        }
                        for (String string2 : arrayList) {
                            object5 = string2;
                            object4 = 0;
                            if (string2.contains(":")) {
                                try {
                                    object4 = Integer.parseInt(string2.split(":")[1]);
                                }
                                catch (Exception exception) {
                                    continue;
                                }
                                object5 = string2.split(":")[0];
                            }
                            if ((Integer)object4 == 0) continue;
                            ((HashMap)cloneable).put(object5, object4);
                        }
                        ((CMIRank)object).setAureliumRequirements((LinkedHashMap<String, Integer>)cloneable);
                    }
                    if (map2.containsKey("AuraSkillsRequirement")) {
                        cloneable = new LinkedHashMap();
                        arrayList = new ArrayList();
                        if (map2.get("AuraSkillsRequirement") instanceof String) {
                            string2 = (String)map2.get("AuraSkillsRequirement");
                            arrayList.add(string2);
                        } else {
                            arrayList.addAll((List)map2.get("AuraSkillsRequirement"));
                        }
                        for (String string2 : arrayList) {
                            object5 = string2;
                            object4 = 0;
                            if (string2.contains(":")) {
                                try {
                                    object4 = Integer.parseInt(string2.split(":")[1]);
                                }
                                catch (Exception exception) {
                                    continue;
                                }
                                object5 = string2.split(":")[0];
                            }
                            if ((Integer)object4 == 0) continue;
                            if (!((String)object5).contains("/") && !((String)object5).equalsIgnoreCase("power")) {
                                object5 = "auraskills/" + (String)object5;
                            }
                            ((HashMap)cloneable).put(object5, object4);
                        }
                        ((CMIRank)object).setAuraSkillsRequirements((LinkedHashMap<String, Integer>)cloneable);
                    }
                    if (map2.containsKey("JobsRequirement")) {
                        cloneable = new LinkedHashMap();
                        arrayList = new ArrayList();
                        if (map2.get("JobsRequirement") instanceof String) {
                            string2 = (String)map2.get("JobsRequirement");
                            arrayList.add((String)((Object)string2));
                        } else {
                            arrayList.addAll((List)map2.get("JobsRequirement"));
                        }
                        for (String string2 : arrayList) {
                            object5 = string2;
                            object4 = 0;
                            if (string2.contains(":")) {
                                try {
                                    object4 = Integer.parseInt(string2.split(":")[1]);
                                }
                                catch (Exception exception) {
                                    continue;
                                }
                                object5 = string2.split(":")[0];
                            }
                            if ((Integer)object4 == 0) continue;
                            ((HashMap)cloneable).put(object5, object4);
                        }
                        ((CMIRank)object).setJobsRequirements((LinkedHashMap<String, Integer>)cloneable);
                    }
                    if (map2.containsKey("ItemRequirement")) {
                        cloneable = new LinkedHashMap();
                        arrayList = new ArrayList();
                        if (map2.get("ItemRequirement") instanceof String) {
                            string2 = (String)map2.get("ItemRequirement");
                            arrayList.add((String)((Object)string2));
                        } else {
                            arrayList.addAll((List)map2.get("ItemRequirement"));
                        }
                        for (String string2 : arrayList) {
                            object5 = null;
                            int n = 0;
                            if (!string2.contains(":")) continue;
                            object3 = string2.split(":");
                            object5 = object3[0];
                            object2 = object3[1];
                            if (((String[])object3).length == 3) {
                                object5 = String.valueOf(object5) + ":" + object3[1];
                                object2 = object3[2];
                            }
                            try {
                                n = Integer.parseInt((String)object2);
                            }
                            catch (Exception exception) {
                                continue;
                            }
                            CMIItemStack cMIItemStack = CMILib.getInstance().getItemManager().getItem((String)object5);
                            if (cMIItemStack == null) {
                                this.plugin.consoleMessage("&cCan't determine item from " + (String)object5 + " name for " + ((CMIRank)object).getName() + " rank item requirement");
                                continue;
                            }
                            cMIItemStack.setAmount(n);
                            ((HashMap)cloneable).put(cMIItemStack, n);
                        }
                        ((CMIRank)object).setItemRequirements((LinkedHashMap<CMIItemStack, Integer>)cloneable);
                    }
                    if (!map2.containsKey("StatsRequirements")) break block96;
                    cloneable = new ArrayList();
                    arrayList = map2.get("StatsRequirements");
                    if (arrayList instanceof String) {
                        cloneable.add((String)((Object)arrayList));
                    } else {
                        cloneable.addAll((List)arrayList);
                    }
                    Iterator iterator = cloneable.iterator();
                    while (iterator.hasNext()) {
                        string2 = (String)iterator.next();
                        if (!string2.contains(":")) continue;
                        object5 = string2.split(":");
                        StatsManager.CMIStatistic cMIStatistic = this.plugin.getStatsManager().getStatisticByName((String)object5[0]);
                        if (cMIStatistic == null) {
                            this.plugin.consoleMessage("&eCant determine stat type " + (String)object5[0]);
                            continue;
                        }
                        object3 = "none";
                        if (((Object)object5).length > 2) {
                            object3 = object5[1];
                        }
                        object2 = 0L;
                        try {
                            object2 = ((Object)object5).length == 2 ? Long.valueOf(Long.parseLong((String)object5[1])) : Long.valueOf(Long.parseLong((String)object5[2]));
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                            this.plugin.consoleMessage("Cant determine amount " + string2);
                            continue;
                        }
                        if (cMIStatistic.getType() == StatsManager.svt.Time) {
                            object2 = (Long)object2 * 1000L;
                        }
                        if (cMIStatistic.getType() == StatsManager.svt.Distance) {
                            object2 = (Long)object2 * 100L;
                        }
                        ((CMIRank)object).addStatRequirement(cMIStatistic, (String)object3, (Long)object2);
                    }
                }
                catch (Exception exception) {
                    this.plugin.consoleMessage("Cant load rank (" + (String)entry.getKey() + ")");
                    exception.printStackTrace();
                    continue;
                }
            }
            this.addRank((CMIRank)object);
        }
        for (Map.Entry<String, CMIRank> entry : this.ranks.entrySet()) {
            entry.getValue().calculateNextRanks();
        }
        HashSet<CMIRank> hashSet = new HashSet<CMIRank>();
        for (Map.Entry entry : this.ranks.entrySet()) {
            if (!((CMIRank)entry.getValue()).getPreviousRanks().isEmpty()) continue;
            hashSet.add((CMIRank)entry.getValue());
        }
        for (CMIRank cMIRank : hashSet) {
            this.calculateWeight(cMIRank, 0);
        }
        this.plugin.loadMessage(this.ranks.size(), "ranks", System.currentTimeMillis() - l);
    }

    private void calculateWeight(CMIRank cMIRank, int n) {
        if (++n > 1000) {
            return;
        }
        cMIRank.setWeight(n);
        for (CMIRank cMIRank2 : cMIRank.getNextRanks()) {
            this.calculateWeight(cMIRank2, n);
        }
    }

    public void loadConfig() {
        ConfigReader configReader = this.plugin.getConfigManager().getConfig();
        configReader.addComment("Ranks.PermissionCheck", new String[]{"If set to true we will check players rank by his access to rank by permission node and prioritize any rank which has more weight over current one", "This means that in case player has access to third rank while recorded one is first one, we will prioritize third one", "While this is active using command like /cmi setrank will set players rank to highest one he has access too, so as long as player has permission access to third rank you cant go lower than this, ", "you will have to remove access to specific rank by removing permission node before trying to derank him"});
        this.permissionCheck = configReader.get("Ranks.PermissionCheck", Boolean.valueOf(false));
        configReader.addComment("Ranks.Recalculation", new String[]{"Defines how often in minutes plugin will recalculate players group", "Keeping it at 0 will disable this feature"});
        this.Recalculation = configReader.get("Ranks.Recalculation", 0) * 60 * 1000;
        configReader.addComment("Ranks.AutoRankUp.Delay", new String[]{"Defines how often in seconds plugin will check for possible player rankups", "Set it to 0 or less to disable auto rankup checks"});
        this.Delay = configReader.get("Ranks.AutoRankUp.Delay", 60);
        configReader.addComment("Ranks.AutoRankUp.Async", new String[]{"EXPERIMENTAL. When set to true, player rankup checks will be done in async mode", "In case of errors related to this feature being turned on, turn it off and report issue with error log to github"});
        this.async = configReader.get("Ranks.AutoRankUp.Async", Boolean.valueOf(false));
        configReader.addComment("Ranks.ListSamePathOnly", new String[]{"When set to true, command /cmi ranklist will output ranks from your rankup path which will exclude any rank from different paths or different rankup trees all together", "When set to false, all set ranks will be shown in the list"});
        this.ListSamePathOnly = configReader.get("Ranks.ListSamePathOnly", Boolean.valueOf(false));
        configReader.addComment("Ranks.AutoRankUp.PlayerDelay", new String[]{"Defines how often in seconds each separate player will be checked for rankup", "This is different than general check just to avoid couple players ranking up at same time", "This also defines how often player will be notified about possible rankup and it will proportionaly increase with each time player get notification to avoid annoying spam in chat", "Keep it longer or same as general delay time"});
        this.PlayerDelay = configReader.get("Ranks.AutoRankUp.PlayerDelay", 120);
        this.PlayerDelay *= 1000;
        configReader.addComment("Ranks.AutoRankUp.progressBar", new String[]{"Enable or disable progression bar in rank info window"});
        this.progressBar = configReader.get("Ranks.AutoRankUp.progressBar", Boolean.valueOf(true));
        configReader.addComment("Ranks.Effect", new String[]{"Name of particle animation as defined at Particles config section", "if you want to disable it, then set it to empty field"});
        this.RanksEffect = ParticleManager.CMIPresetAnimations.getByName(configReader.get("Ranks.EffectUp", "GColumn"));
        configReader.addComment("Ranks.OnlyHours", new String[]{"When set to true requirements which involve time will be shown in short format like '50 hours' instead of '2 days 2 hours'"});
        this.OnlyHours = configReader.get("Ranks.OnlyHours", Boolean.valueOf(false));
        configReader.addComment("Ranks.includeMinutes", new String[]{"When OnlyHours set to true you can add minutes to the output message instead of showing fractions. So you can have '5 hours 30 minutes' instead of 5.5hours'"});
        this.includeMinutes = configReader.get("Ranks.includeMinutes", Boolean.valueOf(true));
    }

    public boolean isProgressBar() {
        return this.progressBar;
    }

    public boolean isListSamePathOnly() {
        return this.ListSamePathOnly;
    }

    public ParticleManager.CMIPresetAnimations getRankEffect() {
        return this.RanksEffect;
    }

    public boolean isPermissionCheck() {
        return this.permissionCheck;
    }

    public boolean isStrictPermissionCheck() {
        return this.strictPermissionCheck;
    }

    private class donePercentage {
        private double percent = 0.0;
        private int times = 0;

        private donePercentage() {
        }

        public double getPercent() {
            return this.percent;
        }

        public void addPercent(double d) {
            this.percent += d;
        }

        public int getTimes() {
            return this.times;
        }

        public void incrementTimes() {
            ++this.times;
        }

        public void addIncrement(int n) {
            this.times += n;
        }
    }

    public class rankCache {
        HashMap<rankupType, Double> percentage = new HashMap();
        HashMap<rankupType, Long> nextPercentageCheck = new HashMap();
        long time = 5000L;

        public rankCache(long l) {
            this.time = l;
        }

        public rankCache() {
        }

        public boolean timeToCheck(rankupType rankupType2) {
            return !this.nextPercentageCheck.containsKey((Object)rankupType2) || this.nextPercentageCheck.get((Object)rankupType2) < System.currentTimeMillis();
        }

        public Double getCache(rankupType rankupType2) {
            return this.percentage.get((Object)rankupType2);
        }

        public void setCache(rankupType rankupType2, Double d) {
            this.percentage.put(rankupType2, d);
            this.nextPercentageCheck.put(rankupType2, System.currentTimeMillis() + this.time);
        }
    }

    public class rankCurrentRequirement {
        private Long need;
        private Long have;

        public rankCurrentRequirement(Long l, Long l2) {
            this.have = l2;
            this.need = l;
        }

        public Long getNeed() {
            return this.need;
        }

        public void setNeed(Long l) {
            this.need = l;
        }

        public Long getHave() {
            return this.have;
        }

        public void setHave(Long l) {
            this.have = l;
        }
    }

    public static enum rankupFailType {
        Money,
        Exp,
        Stats,
        McMMO,
        Aurelium,
        AuraSkills,
        Jobs,
        Placeholoder,
        Perm,
        None,
        NoRank,
        Items,
        Votes,
        SameRank;

    }

    public static enum rankupType {
        Money,
        Exp,
        Stats,
        McMMO,
        Aurelium,
        AuraSkills,
        Jobs,
        Perm,
        Placeholoder,
        Items,
        Votes;

    }
}

