/*
 * Decompiled with CFR 0.152.
 */
package com.Zrips.CMI.Modules.Portals;

import com.Zrips.CMI.Modules.Portals.RandomLoc;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.Zrips.CMILib.Container.CMILocation;
import net.Zrips.CMILib.Items.CMIMaterial;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.util.Vector;

public class CuboidArea {
    private Vector p1;
    private Vector p2;
    private Vector highPoints;
    private Vector lowPoints;
    private World world;
    private String worldName = null;
    private static final int MIN_HEIGHT = 0;

    public CuboidArea(World world2, Vector vector, Vector vector2) {
        this.highPoints = vector.clone();
        this.p1 = vector.clone();
        this.lowPoints = vector2.clone();
        this.p2 = vector2.clone();
        this.world = world2;
        this.recheck();
    }

    public CuboidArea(CMILocation cMILocation, CMILocation cMILocation2) {
        this.highPoints = cMILocation.toVector().clone();
        this.p1 = cMILocation.toVector().clone();
        this.lowPoints = cMILocation2.toVector().clone();
        this.p2 = cMILocation2.toVector().clone();
        this.world = cMILocation.getWorld();
        this.worldName = cMILocation.getWorldName();
        this.recheck();
    }

    public CuboidArea(Location location, Location location2) {
        this.highPoints = location.toVector().clone();
        this.p1 = location.toVector().clone();
        this.lowPoints = location2.toVector().clone();
        this.p2 = location2.toVector().clone();
        this.world = location.getWorld();
        this.recheck();
    }

    public CuboidArea clone() {
        CuboidArea cuboidArea = new CuboidArea(this.world);
        cuboidArea.highPoints = this.highPoints == null ? null : this.highPoints.clone();
        cuboidArea.lowPoints = this.lowPoints == null ? null : this.lowPoints.clone();
        cuboidArea.p1 = this.p1 == null ? null : this.p1.clone();
        cuboidArea.p2 = this.p2 == null ? null : this.p2.clone();
        return cuboidArea;
    }

    private void recheck() {
        if (this.p1 == null || this.p2 == null) {
            return;
        }
        this.highPoints = new Vector(Math.max(this.p1.getBlockX(), this.p2.getBlockX()), Math.max(this.p1.getBlockY(), this.p2.getBlockY()), Math.max(this.p1.getBlockZ(), this.p2.getBlockZ()));
        this.lowPoints = new Vector(Math.min(this.p1.getBlockX(), this.p2.getBlockX()), Math.min(this.p1.getBlockY(), this.p2.getBlockY()), Math.min(this.p1.getBlockZ(), this.p2.getBlockZ()));
    }

    public boolean valid() {
        return this.p1 != null && this.p2 != null;
    }

    public CuboidArea(World world2) {
        this.world = world2;
    }

    public boolean isAreaWithinArea(CuboidArea cuboidArea) {
        return this.containsLoc(cuboidArea.highPoints) && this.containsLoc(cuboidArea.lowPoints);
    }

    public Location getOutsideFreeLoc() {
        if (!this.valid()) {
            return null;
        }
        ArrayList<RandomLoc> arrayList = new ArrayList<RandomLoc>();
        int n = -1;
        while (n < this.getZSize() + 1) {
            arrayList.add(new RandomLoc(this.getLowPoint().getX(), 0.0, this.getLowPoint().getZ() + (double)n));
            arrayList.add(new RandomLoc(this.getLowPoint().getX() + (double)this.getXSize(), 0.0, this.getLowPoint().getZ() + (double)n));
            ++n;
        }
        n = -1;
        while (n < this.getXSize() + 1) {
            arrayList.add(new RandomLoc(this.getLowPoint().getX() + (double)n, 0.0, this.getLowPoint().getZ()));
            arrayList.add(new RandomLoc(this.getLowPoint().getX() + (double)n, 0.0, this.getLowPoint().getZ() + (double)this.getZSize()));
            ++n;
        }
        Location location = this.getMiddlePoint().toLocation(this.getWorld()).clone();
        boolean bl = false;
        int n2 = 0;
        int n3 = 30;
        while (!bl && n2 < n3) {
            ++n2;
            Random random = new Random(System.currentTimeMillis());
            if (arrayList.isEmpty()) break;
            int n4 = random.nextInt(arrayList.size());
            RandomLoc randomLoc = (RandomLoc)arrayList.get(n4);
            arrayList.remove(n4);
            double d = randomLoc.getX();
            double d2 = randomLoc.getZ();
            location.setX(d);
            location.setZ(d2);
            location.setY((double)this.getHighPoint().getBlockY());
            int n5 = this.getHighPoint().getBlockY();
            int n6 = n5 = this.getWorld().getEnvironment() == World.Environment.NETHER ? 100 : n5;
            while ((double)n6 > this.getLowPoint().getY()) {
                location.setY((double)n6);
                Block block = location.getBlock();
                Block block2 = location.clone().add(0.0, 1.0, 0.0).getBlock();
                Block block3 = location.clone().add(0.0, -1.0, 0.0).getBlock();
                if (block3.getType() != Material.AIR && block.getType() == Material.AIR && block2.getType() == Material.AIR) break;
                --n6;
            }
            if (location.getBlock().getType() != Material.AIR || location.clone().add(0.0, -1.0, 0.0).getBlock().getState().getType() == Material.LAVA || location.clone().add(0.0, -1.0, 0.0).getBlock().getState().getType().equals((Object)CMIMaterial.LAVA.getMaterial()) || location.clone().add(0.0, -1.0, 0.0).getBlock().getState().getType() == Material.WATER || location.clone().add(0.0, -1.0, 0.0).getBlock().getState().getType().equals((Object)CMIMaterial.WATER.getMaterial())) continue;
            bl = true;
            location.setY(location.getY() + 2.0);
            location.add(0.5, 0.0, 0.5);
            break;
        }
        return location;
    }

    public boolean containsLoc(Location location) {
        if (location == null) {
            return false;
        }
        if (location.getWorld() == null) {
            return false;
        }
        if (!location.getWorld().equals(this.world)) {
            return false;
        }
        return this.containsLoc(location.toVector(), 0);
    }

    public boolean containsLoc(Vector vector) {
        return this.containsLoc(vector, 0);
    }

    public boolean containsLoc(Location location, int n) {
        if (location == null) {
            return false;
        }
        if (!location.getWorld().equals(this.world)) {
            return false;
        }
        return this.containsLoc(location.toVector(), n);
    }

    public boolean containsLoc(Vector vector, int n) {
        if (vector == null) {
            return false;
        }
        if (this.lowPoints.getBlockX() - n > vector.getBlockX()) {
            return false;
        }
        if (this.highPoints.getBlockX() + n < vector.getBlockX()) {
            return false;
        }
        if (this.lowPoints.getBlockZ() - n > vector.getBlockZ()) {
            return false;
        }
        if (this.highPoints.getBlockZ() + n < vector.getBlockZ()) {
            return false;
        }
        if (this.lowPoints.getBlockY() - n > vector.getBlockY()) {
            return false;
        }
        return this.highPoints.getBlockY() + n >= vector.getBlockY();
    }

    public boolean checkCollision(CuboidArea cuboidArea) {
        if (cuboidArea.getWorld() == null || this.getWorld() == null) {
            return false;
        }
        if (!cuboidArea.getWorld().equals(this.getWorld())) {
            return false;
        }
        if (!this.valid()) {
            return false;
        }
        if (cuboidArea.containsLoc(this.lowPoints) || cuboidArea.containsLoc(this.highPoints) || this.containsLoc(cuboidArea.highPoints) || this.containsLoc(cuboidArea.lowPoints)) {
            return true;
        }
        return CuboidArea.advCuboidCheckCollision(this.highPoints, this.lowPoints, cuboidArea.highPoints, cuboidArea.lowPoints);
    }

    private static boolean advCuboidCheckCollision(Vector vector, Vector vector2, Vector vector3, Vector vector4) {
        int n = vector.getBlockX();
        int n2 = vector2.getBlockX();
        int n3 = vector.getBlockY();
        int n4 = vector2.getBlockY();
        int n5 = vector.getBlockZ();
        int n6 = vector2.getBlockZ();
        int n7 = vector3.getBlockX();
        int n8 = vector4.getBlockX();
        int n9 = vector3.getBlockY();
        int n10 = vector4.getBlockY();
        int n11 = vector3.getBlockZ();
        int n12 = vector4.getBlockZ();
        return (n >= n8 && n <= n7 || n2 >= n8 && n2 <= n7 || n7 >= n2 && n7 <= n || n8 >= n2 && n8 <= n) && (n3 >= n10 && n3 <= n9 || n4 >= n10 && n4 <= n9 || n9 >= n4 && n9 <= n3 || n10 >= n4 && n10 <= n3) && (n5 >= n12 && n5 <= n11 || n6 >= n12 && n6 <= n11 || n11 >= n6 && n11 <= n5 || n12 >= n6 && n12 <= n5);
    }

    public long getSize() {
        if (!this.valid()) {
            return 0L;
        }
        int n = this.highPoints.getBlockX() - this.lowPoints.getBlockX() + 1;
        int n2 = this.highPoints.getBlockZ() - this.lowPoints.getBlockZ() + 1;
        int n3 = this.highPoints.getBlockY() - this.lowPoints.getBlockY() + 1;
        return n * n3 * n2;
    }

    public int getXSize() {
        if (!this.valid()) {
            return 0;
        }
        return this.highPoints.getBlockX() - this.lowPoints.getBlockX() + 1;
    }

    public int getYSize() {
        if (!this.valid()) {
            return 0;
        }
        return this.highPoints.getBlockY() - this.lowPoints.getBlockY() + 1;
    }

    public int getZSize() {
        if (!this.valid()) {
            return 0;
        }
        return this.highPoints.getBlockZ() - this.lowPoints.getBlockZ() + 1;
    }

    @Deprecated
    public Location getHighLoc() {
        if (!this.valid()) {
            return null;
        }
        return new CMILocation(this.getWorld(), (double)this.highPoints.getBlockX(), (double)this.highPoints.getBlockY(), (double)this.highPoints.getBlockZ());
    }

    public Vector getHighPoint() {
        return this.highPoints;
    }

    @Deprecated
    public Location getLowLoc() {
        if (!this.valid()) {
            return null;
        }
        return new CMILocation(this.getWorld(), (double)this.lowPoints.getBlockX(), (double)this.lowPoints.getBlockY(), (double)this.lowPoints.getBlockZ());
    }

    public Vector getLowPoint() {
        return this.lowPoints;
    }

    public World getWorld() {
        return this.world;
    }

    public List<ChunkRef> getChunks() {
        return this.getChunks(0);
    }

    public List<ChunkRef> getChunks(int n) {
        ArrayList<ChunkRef> arrayList = new ArrayList<ChunkRef>();
        Vector vector = this.highPoints;
        Vector vector2 = this.lowPoints;
        int n2 = ChunkRef.getChunkCoord(vector2.getBlockX() - n);
        int n3 = ChunkRef.getChunkCoord(vector2.getBlockZ() - n);
        int n4 = ChunkRef.getChunkCoord(vector.getBlockX() + n);
        int n5 = ChunkRef.getChunkCoord(vector.getBlockZ() + n);
        int n6 = n2;
        while (n6 <= n4) {
            int n7 = n3;
            while (n7 <= n5) {
                arrayList.add(new ChunkRef(n6, n7));
                ++n7;
            }
            ++n6;
        }
        return arrayList;
    }

    public void setArea(CuboidArea cuboidArea) {
        this.highPoints = cuboidArea.getHighPoint().clone();
        this.lowPoints = cuboidArea.getLowPoint().clone();
        this.p1 = cuboidArea.p1.clone();
        this.p2 = cuboidArea.p2.clone();
        this.world = cuboidArea.getWorld();
        this.recheck();
    }

    public void setHighLocation(Location location) {
        if (location == null) {
            return;
        }
        this.world = location.getWorld();
        this.setHighPoint(location.toVector());
    }

    public void setHighPoint(Vector vector) {
        this.p1 = vector;
        this.recheck();
    }

    public void setLowLocation(Location location) {
        if (location == null) {
            return;
        }
        this.world = location.getWorld();
        this.setLowPoint(location.toVector());
    }

    public void setLowPoint(Vector vector) {
        this.p2 = vector;
        this.recheck();
    }

    public void setWorld(World world2) {
        this.world = world2;
    }

    public void setLocation(Location location) {
        if (location == null) {
            return;
        }
        this.world = location.getWorld();
        this.setPoint(location.toVector());
    }

    public void setPoint(Vector vector) {
        if (vector == null) {
            return;
        }
        if (this.p1 == null) {
            this.p1 = vector;
        } else {
            this.p2 = vector;
        }
        this.recheck();
    }

    @Deprecated
    public Location getMiddleLocation() {
        if (!this.valid()) {
            return null;
        }
        return new Location(this.world, (this.getLowPoint().getX() + this.getHighPoint().getX()) / 2.0, (this.getLowPoint().getY() + this.getHighPoint().getY()) / 2.0, (this.getLowPoint().getZ() + this.getHighPoint().getZ()) / 2.0);
    }

    public Vector getMiddlePoint() {
        if (!this.valid()) {
            return null;
        }
        return new Vector((this.getLowPoint().getX() + this.getHighPoint().getX()) / 2.0, (this.getLowPoint().getY() + this.getHighPoint().getY()) / 2.0, (this.getLowPoint().getZ() + this.getHighPoint().getZ()) / 2.0);
    }

    public String toString() {
        if (!this.valid()) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.lowPoints.getX()).append(":").append(this.lowPoints.getY()).append(":").append(this.lowPoints.getZ()).append(":").append(this.highPoints.getX()).append(":").append(this.highPoints.getY()).append(":").append(this.highPoints.getZ());
        return stringBuilder.toString();
    }

    public boolean shift(Player player, double d) {
        return this.shift(CuboidArea.getDirection(player), d);
    }

    public boolean shift(Direction direction, double d) {
        if (!this.valid()) {
            return false;
        }
        if (direction == null) {
            return false;
        }
        switch (direction) {
            case DOWN: {
                double d2 = (double)this.getLowPoint().getBlockY() - d;
                if (d2 < 0.0) {
                    d2 = 0.0;
                }
                this.getLowPoint().setY(d2);
                this.getHighPoint().setY((double)this.getHighPoint().getBlockY() - d);
                break;
            }
            case MINUSX: {
                this.getLowPoint().setX((double)this.getLowPoint().getBlockX() - d);
                this.getHighPoint().setX((double)this.getHighPoint().getBlockX() - d);
                break;
            }
            case MINUSZ: {
                this.getLowPoint().setZ((double)this.getLowPoint().getBlockZ() - d);
                this.getHighPoint().setZ((double)this.getHighPoint().getBlockZ() - d);
                break;
            }
            case PLUSX: {
                this.getHighPoint().setX((double)this.getHighPoint().getBlockX() + d);
                this.getLowPoint().setX((double)this.getLowPoint().getBlockX() + d);
                break;
            }
            case PLUSZ: {
                this.getHighPoint().setZ((double)this.getHighPoint().getBlockZ() + d);
                this.getLowPoint().setZ((double)this.getLowPoint().getBlockZ() + d);
                break;
            }
            case UP: {
                double d3 = (double)this.getHighPoint().getBlockY() + d;
                if (d3 > (double)this.getMaxWorldHeight()) {
                    d3 = this.getMaxWorldHeight();
                }
                this.getHighPoint().setY(d3);
                this.getLowPoint().setY((double)this.getLowPoint().getBlockY() + d);
                break;
            }
        }
        return true;
    }

    public boolean expand(Player player, double d) {
        return this.expand(CuboidArea.getDirection(player), d);
    }

    public boolean expand(Direction direction, double d) {
        if (!this.valid()) {
            return false;
        }
        if (direction == null) {
            return false;
        }
        switch (direction) {
            case DOWN: {
                double d2 = (double)this.getLowPoint().getBlockY() - d;
                if (d2 < 0.0) {
                    d2 = 0.0;
                }
                this.getLowPoint().setY(d2);
                break;
            }
            case MINUSX: {
                this.getLowPoint().setX((double)this.getLowPoint().getBlockX() - d);
                break;
            }
            case MINUSZ: {
                this.getLowPoint().setZ((double)this.getLowPoint().getBlockZ() - d);
                break;
            }
            case PLUSX: {
                this.getHighPoint().setX((double)this.getHighPoint().getBlockX() + d);
                break;
            }
            case PLUSZ: {
                this.getHighPoint().setZ((double)this.getHighPoint().getBlockZ() + d);
                break;
            }
            case UP: {
                double d3 = (double)this.getHighPoint().getBlockY() + d;
                if (d3 > (double)this.getMaxWorldHeight()) {
                    d3 = this.getMaxWorldHeight();
                }
                this.getHighPoint().setY(d3);
                break;
            }
        }
        return true;
    }

    public boolean contract(Player player, double d) {
        if (!this.valid()) {
            return false;
        }
        return this.contract(CuboidArea.getDirection(player), d);
    }

    public boolean contract(Direction direction, double d) {
        if (!this.valid()) {
            return false;
        }
        if (direction == null) {
            return false;
        }
        switch (direction) {
            case DOWN: {
                double d2 = (double)this.getHighPoint().getBlockY() - d;
                if (d2 > (double)this.getMaxWorldHeight()) {
                    d2 = this.getMaxWorldHeight();
                }
                d2 = (double)this.getHighPoint().getBlockY() - d;
                d2 = this.getLowPoint().getY() > d2 ? this.getLowPoint().getY() : d2;
                this.getHighPoint().setY(d2);
                break;
            }
            case MINUSX: {
                double d3 = (double)this.getHighPoint().getBlockX() - d;
                d3 = this.getLowPoint().getX() > d3 ? this.getLowPoint().getX() : d3;
                this.getHighPoint().setX(d3);
                break;
            }
            case MINUSZ: {
                double d4 = (double)this.getHighPoint().getBlockZ() - d;
                d4 = this.getLowPoint().getZ() > d4 ? this.getLowPoint().getZ() : d4;
                this.getHighPoint().setZ(d4);
                break;
            }
            case PLUSX: {
                double d5 = (double)this.getLowPoint().getBlockX() + d;
                d5 = this.getHighPoint().getX() < d5 ? this.getHighPoint().getX() : d5;
                this.getLowPoint().setX(d5);
                break;
            }
            case PLUSZ: {
                double d6 = (double)this.getLowPoint().getBlockZ() + d;
                d6 = this.getHighPoint().getZ() < d6 ? this.getHighPoint().getZ() : d6;
                this.getLowPoint().setZ(d6);
                break;
            }
            case UP: {
                double d7 = (double)this.getLowPoint().getBlockY() + d;
                if (d7 < 0.0) {
                    d7 = 0.0;
                }
                d7 = (double)this.getLowPoint().getBlockY() + d;
                d7 = this.getHighPoint().getY() < d7 ? this.getHighPoint().getY() : d7;
                this.getLowPoint().setY(d7);
                break;
            }
        }
        return true;
    }

    private int getMaxWorldHeight() {
        if (this.getWorld() == null) {
            return 256;
        }
        switch (this.getWorld().getEnvironment()) {
            case NETHER: {
                return 128;
            }
            case NORMAL: 
            case THE_END: {
                return 256;
            }
        }
        return 256;
    }

    private static Direction getDirection(Player player) {
        int n = (int)player.getLocation().getYaw();
        if (n < 0) {
            n += 360;
        }
        n += 45;
        int n2 = (n %= 360) / 90;
        float f = player.getLocation().getPitch();
        if (f < -50.0f) {
            return Direction.UP;
        }
        if (f > 50.0f) {
            return Direction.DOWN;
        }
        if (n2 == 1) {
            return Direction.MINUSX;
        }
        if (n2 == 3) {
            return Direction.PLUSX;
        }
        if (n2 == 2) {
            return Direction.MINUSZ;
        }
        if (n2 == 0) {
            return Direction.PLUSZ;
        }
        return null;
    }

    public String getWorldName() {
        return this.world == null ? this.worldName : this.world.getName();
    }

    public static final class ChunkRef {
        private final int z;
        private final int x;

        public static int getChunkCoord(int n) {
            return n >> 4;
        }

        public ChunkRef(Location location) {
            this.x = ChunkRef.getChunkCoord(location.getBlockX());
            this.z = ChunkRef.getChunkCoord(location.getBlockZ());
        }

        public ChunkRef(int n, int n2) {
            this.x = n;
            this.z = n2;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            ChunkRef chunkRef = (ChunkRef)object;
            return this.x == chunkRef.x && this.z == chunkRef.z;
        }

        public int hashCode() {
            return this.x ^ this.z;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("{ x: ").append(this.x).append(", z: ").append(this.z).append(" }");
            return stringBuilder.toString();
        }
    }

    public static enum Direction {
        UP,
        DOWN,
        PLUSX,
        PLUSZ,
        MINUSX,
        MINUSZ;

    }
}

