/*
 * Decompiled with CFR 0.152.
 */
package com.Zrips.CMI.Modules.Portals;

import com.Zrips.CMI.Modules.Portals.CMIPlane;
import com.Zrips.CMI.Modules.Portals.CMIVector2D;
import com.Zrips.CMI.Modules.Portals.CMIVector3D;
import java.util.concurrent.CompletableFuture;
import org.bukkit.util.Vector;

public class CMIPlaneIntersection {
    private CMIVector3D globalLoc;
    private CMIVector2D localLoc;
    private static final double _HPI = Math.PI / 180;

    public static CompletableFuture<CMIPlaneIntersection> get(Vector vector, Vector vector2, Vector vector3, CMIPlane cMIPlane) {
        return CompletableFuture.supplyAsync(() -> CMIPlaneIntersection.get(new CMIVector3D(vector), new CMIVector3D(vector2), new CMIVector3D(vector3), cMIPlane));
    }

    private static CMIPlaneIntersection get(CMIVector3D cMIVector3D, CMIVector3D cMIVector3D2, CMIVector3D cMIVector3D3, CMIPlane cMIPlane) {
        double d;
        cMIVector3D3.setX(cMIVector3D3.getX() + 1.0E-4);
        CMIVector3D cMIVector3D4 = CMIPlaneIntersection.intersectPoint(cMIVector3D, cMIVector3D2, cMIVector3D3, cMIPlane);
        if (cMIVector3D4 == null) {
            return null;
        }
        CMIPlaneIntersection cMIPlaneIntersection = new CMIPlaneIntersection();
        double d2 = Math.sqrt(Math.pow(cMIPlane.getCenter().getY() - cMIVector3D4.getY(), 2.0));
        CMIVector3D cMIVector3D5 = cMIVector3D4.minus(cMIPlane.getCenter());
        CMIVector3D cMIVector3D6 = cMIVector3D5.minus(cMIVector3D3.multiply(cMIVector3D3.dot(cMIVector3D5)));
        double d3 = cMIVector3D6.getX() + cMIVector3D6.getZ();
        CMIVector3D cMIVector3D7 = new CMIVector3D(1.0, 0.0, 1.0);
        CMIVector3D cMIVector3D8 = new CMIVector3D(0.0, 1.0, 0.0);
        double d4 = cMIVector3D5.dot(cMIVector3D8);
        double d5 = -(Math.toDegrees(Math.atan2(cMIVector3D3.getX(), cMIVector3D3.getZ())) - 180.0);
        d3 = cMIVector3D5.dot(cMIVector3D7);
        if (d5 <= 315.0 && d5 >= 135.0) {
            d3 = -d3;
        }
        if (cMIVector3D.dot(cMIVector3D3) < 0.0) {
            d3 = -d3;
        }
        if ((d = Math.abs(cMIVector3D4.getY()) - Math.abs(cMIPlane.getCenter().getY())) < 0.0) {
            d2 = -d2;
        }
        if (d3 < cMIPlane.getSizeMin().getX() || d3 > cMIPlane.getSizeMax().getX()) {
            return null;
        }
        if (d2 < cMIPlane.getSizeMin().getY() || d2 > cMIPlane.getSizeMax().getY()) {
            return null;
        }
        cMIPlaneIntersection.setGlobalLoc(cMIVector3D4);
        cMIPlaneIntersection.setLocalLoc(new CMIVector2D(d3, d2));
        return cMIPlaneIntersection;
    }

    private static CMIVector3D intersectPoint(CMIVector3D cMIVector3D, CMIVector3D cMIVector3D2, CMIVector3D cMIVector3D3, CMIVector3D cMIVector3D4) {
        CMIVector3D cMIVector3D5 = cMIVector3D2.minus(cMIVector3D4);
        double d = cMIVector3D5.dot(cMIVector3D3);
        double d2 = cMIVector3D.dot(cMIVector3D3);
        double d3 = d / d2;
        return cMIVector3D2.minus(cMIVector3D.times(d3));
    }

    public static CMIVector3D rotateAroundCenter(double d, double d2, double d3, double d4) {
        double d5 = 4.71238898038469 - Math.atan2(d2, d);
        double d6 = Math.sqrt(d2 * d2 + d * d);
        double d7 = Math.sin(d5) * d6;
        double d8 = d7 * Math.cos(Math.PI / 180 * d3);
        double d9 = Math.cos(d5) * d6;
        double d10 = d7 * Math.sin(Math.PI / 180 * d3);
        CMIVector3D cMIVector3D = new CMIVector3D(d8, d9, d10);
        if (d4 != 0.0) {
            cMIVector3D = CMIPlaneIntersection.rotateX(cMIVector3D, d4);
        }
        if (d3 != 0.0) {
            cMIVector3D = CMIPlaneIntersection.rotateY(cMIVector3D, -d3);
        }
        return cMIVector3D;
    }

    public static double xPosYaw(double d, double d2, double d3) {
        return Math.sin(d) * d2 * Math.cos(Math.PI / 180 * d3);
    }

    public static double yPosYaw(double d, double d2) {
        return Math.cos(d) * d2;
    }

    public static double zPosYaw(double d, double d2, double d3) {
        return Math.sin(d) * d2 * Math.sin(Math.PI / 180 * d3);
    }

    private static CMIVector3D rotateX(CMIVector3D cMIVector3D, double d) {
        double d2 = Math.cos(d);
        double d3 = Math.sin(d);
        double d4 = d2 * cMIVector3D.getY() - d3 * cMIVector3D.getZ();
        double d5 = d3 * cMIVector3D.getY() + d2 * cMIVector3D.getZ();
        return cMIVector3D.setY(d4).setZ(d5);
    }

    private static CMIVector3D rotateY(CMIVector3D cMIVector3D, double d) {
        double d2 = Math.cos(d);
        double d3 = Math.sin(d);
        double d4 = d2 * cMIVector3D.getX() + d3 * cMIVector3D.getZ();
        double d5 = -d3 * cMIVector3D.getX() + d2 * cMIVector3D.getZ();
        return cMIVector3D.setX(d4).setZ(d5);
    }

    private static CMIVector3D intersectPoint(CMIVector3D cMIVector3D, CMIVector3D cMIVector3D2, CMIVector3D cMIVector3D3, CMIPlane cMIPlane) {
        Vector vector = cMIPlane.getCenter().clone();
        vector.setY(vector.getY() + cMIPlane.getSizeMin().getY());
        CMIVector3D cMIVector3D4 = cMIVector3D2.minus(vector);
        double d = cMIVector3D4.dot(cMIVector3D3);
        double d2 = cMIVector3D.dot(cMIVector3D3);
        double d3 = d / d2;
        if (d3 > 0.0) {
            return null;
        }
        CMIVector3D cMIVector3D5 = cMIVector3D2.minus(cMIVector3D.times(d3));
        return cMIVector3D5;
    }

    public CMIVector3D getGlobalLoc() {
        return this.globalLoc;
    }

    public void setGlobalLoc(CMIVector3D cMIVector3D) {
        this.globalLoc = cMIVector3D;
    }

    public CMIVector2D getLocalLoc() {
        return this.localLoc;
    }

    public void setLocalLoc(CMIVector2D cMIVector2D) {
        this.localLoc = cMIVector2D;
    }
}

