/*
 * Decompiled with CFR 0.152.
 */
package com.Zrips.CMI.Modules.PlayerOptions;

import com.Zrips.CMI.Modules.PlayerOptions.PlayerOptionsManager;
import java.util.HashMap;
import net.Zrips.CMILib.Items.CMIMaterial;
import net.Zrips.CMILib.Version.Version;
import org.bukkit.inventory.ItemStack;

public enum PlayerOption {
    visibleHolograms(10, true, "&eVisible holograms", CMIMaterial.BLACK_STAINED_GLASS),
    shiftSignEdit(10, true, "&eSign shift edit", CMIMaterial.OAK_SIGN),
    totemBossBar(10, true, "&eTotem BossBar", CMIMaterial.TOTEM_OF_UNDYING),
    bossBarCompass(10, true, "&eCompass BossBar", CMIMaterial.COMPASS),
    tagSound(10, true, "&eChat tagging sound", CMIMaterial.PAPER),
    chatSpy(10, false, "&eChat spy", CMIMaterial.BUCKET),
    cmdSpy(10, false, "&eCommand spy", CMIMaterial.WATER_BUCKET),
    signSpy(10, false, "&eSign spy", CMIMaterial.LAVA_BUCKET),
    acceptingPM(10, true, "&eAccepting private messages", CMIMaterial.MAP),
    acceptingTPA(10, true, "&eAccepting teleportations to you", CMIMaterial.CLOCK),
    acceptingMoney(10, true, "&eAccepting money payments", CMIMaterial.KNOWLEDGE_BOOK),
    chatbubble(10, true, "&eChat bubbles", CMIMaterial.LANTERN, Version.v1_19_R3),
    pmSound(10, true, "&ePrivate messages sounds", CMIMaterial.STONE_BUTTON),
    rideMe(10, true, "&ePlayers can ride you", CMIMaterial.SADDLE),
    pveDamageNumbers(10, true, "&eShows PvE damage numbers", CMIMaterial.WOODEN_SWORD),
    pvpDamageNumbers(10, true, "&eShows PvP damage numbers", CMIMaterial.DIAMOND_SWORD),
    InformDurability(10, true, "&eInform on item durability loss", CMIMaterial.ANVIL);

    private int slot;
    private boolean defaults = true;
    private boolean globalEnabled = true;
    private ItemStack icon;
    private String desc;
    private Version versionFrom;
    private static HashMap<String, PlayerOption> cache;
    public static String defaultString;

    static {
        cache = new HashMap();
        PlayerOption[] playerOptionArray = PlayerOption.values();
        int n = playerOptionArray.length;
        int n2 = 0;
        while (n2 < n) {
            PlayerOption playerOption = playerOptionArray[n2];
            cache.put(playerOption.toString().toLowerCase(), playerOption);
            ++n2;
        }
        defaultString = "";
    }

    private PlayerOption(int n2, boolean bl, String string2, CMIMaterial cMIMaterial) {
        this(n2, bl, string2, cMIMaterial, null);
    }

    private PlayerOption(int n2, boolean bl, String string2, CMIMaterial cMIMaterial, Version version2) {
        this.slot = n2;
        this.versionFrom = version2;
        this.defaults = bl;
        this.desc = string2;
        this.icon = cMIMaterial.newItemStack();
    }

    public int getUISlot() {
        return this.slot;
    }

    public boolean isEnabled() {
        return this.defaults;
    }

    public String getDesc() {
        return this.desc;
    }

    public void setDesc(String string) {
        this.desc = string;
    }

    void setEnabled(Boolean bl) {
        this.defaults = bl;
    }

    public static PlayerOption get(String string) {
        return cache.get(string.toLowerCase());
    }

    private static String to(boolean bl) {
        return bl ? "1" : "0";
    }

    private static boolean from(String string) {
        return string.equals("1");
    }

    public static HashMap<PlayerOption, Boolean> fromString(String string) {
        HashMap<PlayerOption, Boolean> hashMap = new HashMap<PlayerOption, Boolean>();
        if (string == null || !string.contains(":")) {
            return hashMap;
        }
        String[] stringArray = string.split(":");
        int n = 0;
        PlayerOption[] playerOptionArray = PlayerOption.values();
        int n2 = playerOptionArray.length;
        int n3 = 0;
        while (n3 < n2) {
            PlayerOption playerOption = playerOptionArray[n3];
            if (stringArray.length > n) {
                hashMap.put(playerOption, PlayerOption.from(stringArray[n]));
            }
            ++n;
            ++n3;
        }
        return hashMap;
    }

    public static String toString(HashMap<PlayerOption, Boolean> hashMap) {
        StringBuilder stringBuilder = new StringBuilder();
        PlayerOption[] playerOptionArray = PlayerOption.values();
        int n = playerOptionArray.length;
        int n2 = 0;
        while (n2 < n) {
            PlayerOption playerOption = playerOptionArray[n2];
            Boolean bl = hashMap.get((Object)playerOption);
            if (bl == null) {
                bl = playerOption.isEnabled();
            }
            if (!stringBuilder.toString().isEmpty()) {
                stringBuilder.append(":");
            }
            stringBuilder.append(PlayerOption.to(bl));
            ++n2;
        }
        return stringBuilder.toString();
    }

    public static String toDefaultValueString() {
        return PlayerOptionsManager.defaultString;
    }

    public boolean isGlobalEnabled() {
        return this.globalEnabled;
    }

    public void setGlobalEnabled(boolean bl) {
        this.globalEnabled = bl;
    }

    public ItemStack getIcon() {
        return this.icon;
    }

    public void setIcon(ItemStack itemStack) {
        this.icon = itemStack;
    }

    public Version getVersionFrom() {
        return this.versionFrom;
    }
}

