/*
 * Decompiled with CFR 0.152.
 */
package com.Zrips.CMI.Modules.PlayerCombat;

import com.Zrips.CMI.CMI;
import com.Zrips.CMI.Containers.CMIUser;
import com.Zrips.CMI.Locale.CMILC;
import com.Zrips.CMI.Modules.Permissions.PermissionsManager;
import com.Zrips.CMI.Modules.PlayerOptions.PlayerOption;
import com.Zrips.CMI.commands.list.util;
import com.Zrips.CMI.events.CMIPvEEndEventAsync;
import com.Zrips.CMI.events.CMIPvEStartEventAsync;
import com.Zrips.CMI.events.CMIPvPEndEventAsync;
import com.Zrips.CMI.events.CMIPvPStartEventAsync;
import com.Zrips.CMI.utils.Util;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import net.Zrips.CMILib.BossBar.BossBarInfo;
import net.Zrips.CMILib.Messages.CMIMessages;
import net.Zrips.CMILib.Time.CMITimeManager;
import net.Zrips.CMILib.Version.Schedulers.CMIScheduler;
import net.Zrips.CMILib.Version.Version;
import org.bukkit.boss.BarColor;
import org.bukkit.boss.BarStyle;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Ambient;
import org.bukkit.entity.Animals;
import org.bukkit.entity.Creature;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Flying;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Monster;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.entity.PotionSplashEvent;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.java.JavaPlugin;

public class PlayerCombatListener
implements Listener {
    private CMI plugin;
    Set<UUID> ignoreFall = new HashSet<UUID>();
    public static List<String> harmfulList = Arrays.asList("blindness", "confusion", "harm", "hunger", "poison", "slow", "slow_digging", "weakness", "wither");
    Random rand = new Random();

    public PlayerCombatListener(CMI cMI) {
        this.plugin = cMI;
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void PlayerQuitEvent(PlayerQuitEvent playerQuitEvent) {
        CMIUser cMIUser = this.plugin.getPlayerManager().getUser(playerQuitEvent.getPlayer());
        if (cMIUser.isInCombatWithPlayer()) {
            this.plugin.getPlayerCombatManager().removePlayerFromCombat(cMIUser);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void PlayerJoinEvent(PlayerJoinEvent playerJoinEvent) {
        CMIUser cMIUser = this.plugin.getPlayerManager().getUser(playerJoinEvent.getPlayer());
        if (cMIUser.isInCombatWithPlayer()) {
            this.plugin.getPlayerCombatManager().addPlayerIntoCombat(cMIUser);
        }
    }

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public void onPlayerMove(PlayerCommandPreprocessEvent playerCommandPreprocessEvent) {
        Player player = playerCommandPreprocessEvent.getPlayer();
        if (!this.plugin.getPlayerCombatManager().isPlayerBlockCommands() && !this.plugin.getPlayerCombatManager().isMobBlockCommands()) {
            return;
        }
        CMIUser cMIUser = this.plugin.getPlayerManager().getUser(player);
        if (!cMIUser.isInCombatWithPlayer() && !cMIUser.isInCombatWithMob()) {
            return;
        }
        String string = playerCommandPreprocessEvent.getMessage();
        String string2 = string.startsWith("/") ? string.substring(1) : string;
        String string3 = string2.toLowerCase();
        if ((!this.plugin.getPlayerCombatManager().isAllowedPlayerCommand(string3) && cMIUser.isInCombatWithPlayer() && this.plugin.getPlayerCombatManager().isPlayerBlockCommands() || !this.plugin.getPlayerCombatManager().isAllowedMobCommand(string3) && cMIUser.isInCombatWithMob() && this.plugin.getPlayerCombatManager().isMobBlockCommands()) && !PermissionsManager.CMIPerm.pvp_cmdBypass.hasPermission((CommandSender)player)) {
            playerCommandPreprocessEvent.setCancelled(true);
            playerCommandPreprocessEvent.setMessage("/");
            CMILC.info_combat_CantUseCommand.sendMessage(player, "[time]", CMITimeManager.to24hourShort((Long)(cMIUser.getLeftCombatTime() + 1000L)));
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void CMIPvPEndEventAsync(CMIPvPEndEventAsync cMIPvPEndEventAsync) {
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void CMIPvPStartEventAsync(CMIPvPStartEventAsync cMIPvPStartEventAsync) {
        if (this.plugin.getPlayerCombatManager().isPDisableFlight().booleanValue() && cMIPvPStartEventAsync.getPlayer().getAllowFlight() && !PermissionsManager.CMIPerm.pvp_PFlyBypass.hasPermission((CommandSender)cMIPvPStartEventAsync.getPlayer())) {
            CMIScheduler.runTask((JavaPlugin)this.plugin, () -> {
                cMIPvPStartEventAsync.getPlayer().setFlying(false);
                cMIPvPStartEventAsync.getPlayer().setAllowFlight(false);
                CMIUser cMIUser = this.plugin.getPlayerManager().getUser(cMIPvPStartEventAsync.getPlayer());
                if (cMIUser != null) {
                    cMIUser.getFlightCharge().setEnabled(false);
                }
            });
            if (this.plugin.getPlayerCombatManager().isPDisableFallDamage() && !cMIPvPStartEventAsync.getPlayer().isOnGround()) {
                this.ignoreFall.add(cMIPvPStartEventAsync.getPlayer().getUniqueId());
            }
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void CMIPvPStartEventAsync(CMIPvEStartEventAsync cMIPvEStartEventAsync) {
        if (this.plugin.getPlayerCombatManager().isMDisableFlight().booleanValue() && cMIPvEStartEventAsync.getPlayer().getAllowFlight() && !PermissionsManager.CMIPerm.pvp_MFlyBypass.hasPermission((CommandSender)cMIPvEStartEventAsync.getPlayer())) {
            CMIScheduler.runTask((JavaPlugin)this.plugin, () -> {
                cMIPvEStartEventAsync.getPlayer().setFlying(false);
                cMIPvEStartEventAsync.getPlayer().setAllowFlight(false);
                CMIUser cMIUser = this.plugin.getPlayerManager().getUser(cMIPvEStartEventAsync.getPlayer());
                if (cMIUser != null) {
                    cMIUser.getFlightCharge().setEnabled(false);
                }
            });
            if (this.plugin.getPlayerCombatManager().isMDisableFallDamage() && !cMIPvEStartEventAsync.getPlayer().isOnGround()) {
                this.ignoreFall.add(cMIPvEStartEventAsync.getPlayer().getUniqueId());
            }
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void CMIPvEEndEventAsync(CMIPvEEndEventAsync cMIPvEEndEventAsync) {
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void playerDamageEvent(EntityDamageEvent entityDamageEvent) {
        if (entityDamageEvent.isCancelled()) {
            return;
        }
        if (entityDamageEvent.getCause() != EntityDamageEvent.DamageCause.FALL) {
            return;
        }
        if (!(entityDamageEvent.getEntity() instanceof Player)) {
            return;
        }
        if (this.ignoreFall.remove(entityDamageEvent.getEntity().getUniqueId())) {
            if (util.imortaldebug) {
                CMIMessages.consoleMessage((String)"PlayerCombat playerDamageEvent->EntityDamageEvent");
            }
            entityDamageEvent.setDamage(0.0);
            entityDamageEvent.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public void onSplashPotion(PotionSplashEvent potionSplashEvent) {
        if (potionSplashEvent.isCancelled()) {
            return;
        }
        boolean bl = false;
        for (Object object : potionSplashEvent.getPotion().getEffects()) {
            if (!harmfulList.contains(object.getType().getName().toLowerCase())) continue;
            bl = true;
            break;
        }
        if (!bl) {
            return;
        }
        for (LivingEntity livingEntity : potionSplashEvent.getAffectedEntities()) {
            CMIUser cMIUser;
            if (livingEntity.getType() != EntityType.PLAYER || (cMIUser = CMIUser.getUser((Player)livingEntity)) == null || cMIUser.getTeleportInvulnerability() <= System.currentTimeMillis()) continue;
            if (util.imortaldebug) {
                CMIMessages.consoleMessage((String)"PlayerCombat entityCombatEvent->PotionSplashEvent");
            }
            potionSplashEvent.setIntensity(livingEntity, 0.0);
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void entityPreCombatEvent(EntityDamageEvent entityDamageEvent) {
        if (entityDamageEvent.isCancelled()) {
            return;
        }
        if (entityDamageEvent.getEntity() instanceof Player) {
            return;
        }
        if (entityDamageEvent.getFinalDamage() < 0.0) {
            return;
        }
        if (!(entityDamageEvent instanceof EntityDamageByEntityEvent)) {
            return;
        }
        Entity entity = entityDamageEvent.getEntity();
        if (!(entity instanceof Monster || entity instanceof Animals || entity instanceof Ambient || entity instanceof Creature || entity instanceof Flying)) {
            return;
        }
        Player player = Util.getAttacker(entityDamageEvent);
        if (player == null) {
            return;
        }
        CMIUser cMIUser = this.plugin.getPlayerManager().getUser(player);
        if (cMIUser == null) {
            return;
        }
        if (this.plugin.getPlayerCombatManager().isPVENoGodDamage().booleanValue() && (cMIUser.isGod() || cMIUser.isTgod()) && !cMIUser.hasPermission(PermissionsManager.CMIPerm.pve_godBypass)) {
            if (this.plugin.getPlayerCombatManager().isPVENoGodDamageInform().booleanValue()) {
                CMILC.info_pve_noGodDamage.sendMessage(cMIUser, new Object[0]);
            }
            entityDamageEvent.setCancelled(true);
            return;
        }
        if (cMIUser.getTeleportInvulnerability() > System.currentTimeMillis()) {
            if (util.imortaldebug) {
                CMIMessages.consoleMessage((String)"PlayerCombat entityCombatEvent->EntityDamageEvent");
            }
            entityDamageEvent.setCancelled(true);
            return;
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void entityCombatEvent(EntityDamageEvent entityDamageEvent) {
        if (entityDamageEvent.isCancelled()) {
            return;
        }
        if (entityDamageEvent.getEntity() instanceof Player) {
            return;
        }
        if (entityDamageEvent.getFinalDamage() < 0.0) {
            return;
        }
        if (!(entityDamageEvent instanceof EntityDamageByEntityEvent)) {
            return;
        }
        Entity entity = entityDamageEvent.getEntity();
        if (!(entity instanceof Monster || entity instanceof Animals || entity instanceof Ambient || entity instanceof Creature || entity instanceof Flying)) {
            return;
        }
        Player player = Util.getAttacker(entityDamageEvent);
        if (player == null) {
            return;
        }
        CMIUser cMIUser = this.plugin.getPlayerManager().getUser(player);
        if (cMIUser == null || !cMIUser.isOnline()) {
            return;
        }
        cMIUser.setDidLastDamageToEntity(System.currentTimeMillis());
        if (this.plugin.getPlayerCombatManager().isMobShowBossBar()) {
            PlayerCombatListener.showBossBar(cMIUser, CMILC.info_combat_bossBarPve.getLocale(new Object[0]));
        }
        if (this.plugin.getPlayerCombatManager().isMobShowDamageNumbers() && cMIUser.getOptionState(PlayerOption.pveDamageNumbers).booleanValue()) {
            this.plugin.getPlayerCombatManager().showDamageNumber(player, entityDamageEvent.getFinalDamage(), entityDamageEvent.getEntity().getLocation().clone().add(this.rand.nextDouble() - 0.5, 1.5 + this.rand.nextDouble(), this.rand.nextDouble() - 0.5), false);
        }
    }

    private static void showBossBar(CMIUser cMIUser, String string) {
        if (Version.isCurrentEqualOrLower((Version)Version.v1_9_R1) && CMI.getInstance().getPlayerCombatManager().getCombatTimer() > 0) {
            return;
        }
        BossBarInfo bossBarInfo = new BossBarInfo(cMIUser.getPlayer(), "pvptimer");
        Double d = CMI.getInstance().getPlayerCombatManager().getCombatTimer();
        bossBarInfo.setKeepForTicks(Integer.valueOf(3));
        try {
            bossBarInfo.setColor(BarColor.RED);
            bossBarInfo.setStyle(BarStyle.SOLID);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        bossBarInfo.setTitleOfBar(string);
        bossBarInfo.setSeconds(-d.intValue());
        cMIUser.addBossBar(bossBarInfo);
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void PlayerForceCombatEvent(EntityDamageEvent entityDamageEvent) {
        if (!entityDamageEvent.isCancelled()) {
            return;
        }
        if (!this.plugin.getPlayerCombatManager().isSafeZoneDamage()) {
            return;
        }
        if (!(entityDamageEvent.getEntity() instanceof Player)) {
            return;
        }
        Player player = (Player)entityDamageEvent.getEntity();
        CMIUser cMIUser = this.plugin.getPlayerManager().getUser(player);
        if (cMIUser == null) {
            return;
        }
        if (!cMIUser.isInCombatWithPlayer()) {
            return;
        }
        if (util.imortaldebug) {
            CMIMessages.consoleMessage((String)"PlayerCombat PlayerForceCombatEvent->EntityDamageEvent");
        }
        entityDamageEvent.setCancelled(false);
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void PlayerPreCombatEvent(EntityDamageEvent entityDamageEvent) {
        if (entityDamageEvent.isCancelled()) {
            return;
        }
        if (!(entityDamageEvent.getEntity() instanceof Player)) {
            return;
        }
        if (entityDamageEvent.getFinalDamage() < 0.0) {
            return;
        }
        Player player = (Player)entityDamageEvent.getEntity();
        CMIUser cMIUser = this.plugin.getPlayerManager().getUser(player);
        if (cMIUser == null) {
            return;
        }
        if (!(entityDamageEvent instanceof EntityDamageByEntityEvent)) {
            if (cMIUser.getTeleportInvulnerability() > System.currentTimeMillis()) {
                entityDamageEvent.setCancelled(true);
                entityDamageEvent.setDamage(0.0);
            } else {
                cMIUser.setGotLastDamageAt(System.currentTimeMillis());
            }
            return;
        }
        Player player2 = Util.getAttacker(entityDamageEvent);
        if (player2 == null || player.equals(player2)) {
            return;
        }
        CMIUser cMIUser2 = this.plugin.getPlayerManager().getUser(player2);
        if (cMIUser2 != null) {
            if (this.plugin.getPlayerCombatManager().isPVPNoGodDamage().booleanValue() && (cMIUser2.isGod() || cMIUser2.isTgod()) && !cMIUser2.hasPermission(PermissionsManager.CMIPerm.pvp_godBypass)) {
                if (this.plugin.getPlayerCombatManager().isPVPNoGodDamageInform().booleanValue()) {
                    CMILC.info_pvp_noGodDamage.sendMessage(cMIUser2, new Object[0]);
                }
                entityDamageEvent.setCancelled(true);
                return;
            }
            if (cMIUser2.getTeleportInvulnerability() > System.currentTimeMillis()) {
                entityDamageEvent.setCancelled(true);
                if (util.imortaldebug) {
                    CMIMessages.consoleMessage((String)"PlayerCombat PlayerCombatEvent->EntityDamageEvent");
                }
                return;
            }
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void PlayerCombatEvent(EntityDamageEvent entityDamageEvent) {
        if (entityDamageEvent.isCancelled()) {
            return;
        }
        if (!(entityDamageEvent.getEntity() instanceof Player)) {
            return;
        }
        if (entityDamageEvent.getFinalDamage() < 0.0) {
            return;
        }
        Player player = (Player)entityDamageEvent.getEntity();
        CMIUser cMIUser = this.plugin.getPlayerManager().getUser(player);
        if (cMIUser == null) {
            return;
        }
        Entity entity = Util.getDamager(entityDamageEvent);
        if (!(entity instanceof Player)) {
            if (!(entity instanceof LivingEntity) && this.plugin.getPlayerCombatManager().isMobIncludeEnvironment()) {
                cMIUser.setGotLastDamageFromMob(System.currentTimeMillis());
                if (this.plugin.getPlayerCombatManager().isMobShowBossBar()) {
                    PlayerCombatListener.showBossBar(cMIUser, CMILC.info_combat_bossBarPvp.getLocale(new Object[0]));
                }
            }
            return;
        }
        if (!(entity instanceof Player)) {
            cMIUser.setGotLastDamageFromMob(System.currentTimeMillis());
            if (this.plugin.getPlayerCombatManager().isMobShowBossBar()) {
                PlayerCombatListener.showBossBar(cMIUser, CMILC.info_combat_bossBarPvp.getLocale(new Object[0]));
            }
            return;
        }
        Player player2 = (Player)entity;
        if (player.equals(player2)) {
            return;
        }
        CMIUser cMIUser2 = this.plugin.getPlayerManager().getUser(player2);
        if (cMIUser2 != null) {
            cMIUser2.setDidLastDamageToPlayer(System.currentTimeMillis());
            if (this.plugin.getPlayerCombatManager().isPlayerShowBossBar()) {
                PlayerCombatListener.showBossBar(cMIUser2, CMILC.info_combat_bossBarPvp.getLocale(new Object[0]));
            }
            if (this.plugin.getPlayerCombatManager().isMobShowDamageNumbers() && cMIUser2.getOptionState(PlayerOption.pvpDamageNumbers).booleanValue()) {
                this.plugin.getPlayerCombatManager().showDamageNumber(player2, entityDamageEvent.getFinalDamage(), entityDamageEvent.getEntity().getLocation().clone().add(this.rand.nextDouble() - 0.5, 2.0 + this.rand.nextDouble(), this.rand.nextDouble() - 0.5), true);
            }
        }
        if (this.plugin.getPlayerCombatManager().isIncludeVictim().booleanValue()) {
            cMIUser.setGotLastDamageFromPlayer(System.currentTimeMillis());
            if (this.plugin.getPlayerCombatManager().isPlayerShowBossBar()) {
                PlayerCombatListener.showBossBar(cMIUser, CMILC.info_combat_bossBarPvp.getLocale(new Object[0]));
            }
        }
        if (player.getHealth() > entityDamageEvent.getFinalDamage()) {
            return;
        }
        CMIUser cMIUser3 = CMIUser.getUser(player2);
        if (cMIUser3 == null) {
            return;
        }
        cMIUser3.addKill(cMIUser.getUniqueId());
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPlayerDeath(EntityDeathEvent entityDeathEvent) {
        if (!(entityDeathEvent.getEntity() instanceof Player)) {
            return;
        }
        Player player = (Player)entityDeathEvent.getEntity();
        CMIUser cMIUser = this.plugin.getPlayerManager().getUser(player);
        if (cMIUser == null) {
            return;
        }
        BossBarInfo bossBarInfo = cMIUser.getBossBar("pvptimer");
        if (bossBarInfo != null) {
            bossBarInfo.remove();
        }
        CMI.getInstance().getPlayerCombatManager().removePlayerFromCombat(cMIUser);
    }
}

