/*
 * Decompiled with CFR 0.152.
 */
package com.Zrips.CMI.Modules.PlayTime;

import com.Zrips.CMI.CMI;
import com.Zrips.CMI.Containers.CMIUser;
import com.Zrips.CMI.Modules.ModuleHandling.CMIModule;
import com.Zrips.CMI.Modules.PlayTime.CMIPlayTime;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.Zrips.CMILib.Items.CMIMaterial;
import net.Zrips.CMILib.Version.Schedulers.CMIScheduler;
import net.Zrips.CMILib.Version.Schedulers.CMITask;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.plugin.java.JavaPlugin;

public class PlayTimeManager {
    private CMITask autoTimerBukkitId = null;
    private CMI plugin;
    public static final Long checkIntervalMs = 60000L;
    protected Map<UUID, CMIPlayTime> playtimeCache = new HashMap<UUID, CMIPlayTime>();
    SimpleDateFormat formatter = new SimpleDateFormat("yyMMdd");
    Calendar calendar = Calendar.getInstance();
    private Runnable autoTimer = new Runnable(){

        @Override
        public void run() {
            try {
                PlayTimeManager.this.updatePlayTimes();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    };

    public CMIPlayTime getCMIPlayTime(UUID uUID) {
        return this.playtimeCache.computeIfAbsent(uUID, uUID2 -> new CMIPlayTime(CMIUser.getUser(uUID)));
    }

    public void setCMIPlayTime(UUID uUID, CMIPlayTime cMIPlayTime) {
        this.playtimeCache.put(uUID, cMIPlayTime);
    }

    public PlayTimeManager(CMI cMI) {
        this.plugin = cMI;
        if (CMIModule.cmiPlaytime.isEnabled()) {
            this.autoTimerBukkitId = CMIScheduler.scheduleSyncRepeatingTask((JavaPlugin)cMI, (Runnable)this.autoTimer, (long)0L, (long)(checkIntervalMs / 50L));
        }
    }

    public void stop() {
        if (this.autoTimerBukkitId != null) {
            this.autoTimerBukkitId.cancel();
            this.autoTimerBukkitId = null;
        }
    }

    private Integer getTodaysDate() {
        this.calendar.setTimeInMillis(System.currentTimeMillis());
        return Integer.parseInt(this.formatter.format(this.calendar.getTime()));
    }

    private Integer getYeastardayDate() {
        this.calendar.setTimeInMillis(System.currentTimeMillis());
        this.calendar.add(5, -1);
        return Integer.parseInt(this.formatter.format(this.calendar.getTime()));
    }

    Integer getWeekStartDate() {
        this.calendar.setTimeInMillis(System.currentTimeMillis());
        this.calendar.setFirstDayOfWeek(2);
        while (this.calendar.get(7) != 2) {
            this.calendar.add(5, -1);
        }
        return Integer.parseInt(this.formatter.format(this.calendar.getTime()));
    }

    Integer getMonthStartDate() {
        this.calendar.setTimeInMillis(System.currentTimeMillis());
        while (this.calendar.get(5) != 1) {
            this.calendar.add(5, -1);
        }
        return Integer.parseInt(this.formatter.format(this.calendar.getTime()));
    }

    private static int currentHour() {
        Date date = new Date();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar.get(11);
    }

    static Integer hourBack(int n) {
        Date date = new Date();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(11, -n);
        return calendar.get(11);
    }

    Integer getYearStartDate() {
        this.calendar.setTimeInMillis(System.currentTimeMillis());
        this.calendar.set(2, 1);
        this.calendar.set(6, 1);
        return Integer.parseInt(this.formatter.format(this.calendar.getTime()));
    }

    public Integer getDaysBackDate(int n) {
        this.calendar.setTimeInMillis(System.currentTimeMillis());
        this.calendar.add(5, -n);
        return Integer.parseInt(this.formatter.format(this.calendar.getTime()));
    }

    public void updatePlayTimes() {
        PlaytimeRange[] playtimeRangeArray = PlaytimeRange.values();
        int n = playtimeRangeArray.length;
        int n2 = 0;
        while (n2 < n) {
            PlaytimeRange playtimeRange = playtimeRangeArray[n2];
            playtimeRange.update();
            ++n2;
        }
        for (PlaytimeRange playtimeRange : Bukkit.getOnlinePlayers()) {
            CMIUser cMIUser = this.plugin.getPlayerManager().getUser((Player)playtimeRange);
            cMIUser.updatePlayTime();
        }
    }

    public String formatDate(int n) {
        int n2 = n / 10000;
        int n3 = (n - n2 * 10000) / 100;
        int n4 = n % 100;
        return String.valueOf(n4) + "/" + n3 + "/" + n2;
    }

    public static enum PlaytimeRange {
        thishour(10, false, CMIMaterial.LIME_WOOL),
        hourback(19, false, CMIMaterial.GREEN_WOOL),
        today(11, true, CMIMaterial.LIGHT_GRAY_WOOL),
        yesterday(20, true, CMIMaterial.GRAY_WOOL),
        thisweek(13, true, CMIMaterial.YELLOW_WOOL),
        week(22, true, CMIMaterial.BROWN_WOOL),
        thismonth(15, true, CMIMaterial.PINK_WOOL),
        month(24, true, CMIMaterial.RED_WOOL),
        thisyear(16, false, CMIMaterial.LIGHT_BLUE_WOOL),
        year(25, false, CMIMaterial.BLUE_WOOL),
        total(40, false, CMIMaterial.WHITE_WOOL);

        private Integer StartTime;
        private HashMap<UUID, Long> cache = new HashMap();
        private HashMap<UUID, Integer> cacheLastUpdate = new HashMap();
        private int slot;
        private boolean detailed;
        private CMIMaterial color;

        private PlaytimeRange(int n2, boolean bl, CMIMaterial cMIMaterial) {
            this.slot = n2;
            this.detailed = bl;
            this.color = cMIMaterial;
        }

        public void update() {
            Integer n = 0;
            switch (this) {
                case month: {
                    n = CMI.getInstance().getPlayTimeManager().getDaysBackDate(30);
                    break;
                }
                case week: {
                    n = CMI.getInstance().getPlayTimeManager().getDaysBackDate(7);
                    break;
                }
                case year: {
                    n = CMI.getInstance().getPlayTimeManager().getDaysBackDate(365);
                    break;
                }
                case thishour: {
                    n = PlayTimeManager.currentHour();
                    break;
                }
                case hourback: {
                    n = PlayTimeManager.hourBack(1);
                    break;
                }
                case thismonth: {
                    n = CMI.getInstance().getPlayTimeManager().getMonthStartDate();
                    break;
                }
                case thisweek: {
                    n = CMI.getInstance().getPlayTimeManager().getWeekStartDate();
                    break;
                }
                case thisyear: {
                    n = CMI.getInstance().getPlayTimeManager().getYearStartDate();
                    break;
                }
                case today: {
                    n = CMI.getInstance().getPlayTimeManager().getDaysBackDate(0);
                    if (n.equals(this.StartTime)) break;
                    PlaytimeRange.total.cache.clear();
                    PlaytimeRange.total.cacheLastUpdate.clear();
                    break;
                }
                case total: {
                    n = 0;
                    break;
                }
                case yesterday: {
                    n = CMI.getInstance().getPlayTimeManager().getDaysBackDate(1);
                    break;
                }
            }
            if (!n.equals(this.StartTime)) {
                this.cache.clear();
                this.cacheLastUpdate.clear();
            }
            this.StartTime = n;
        }

        public Integer getStartTime() {
            if (this.StartTime == null) {
                this.update();
            }
            return this.StartTime;
        }

        public Long getCache(UUID uUID) {
            return this.cache.get(uUID);
        }

        public void setCache(UUID uUID, Long l) {
            this.cache.put(uUID, l);
        }

        public Integer getCacheLastUpdate(UUID uUID) {
            return this.cacheLastUpdate.get(uUID);
        }

        public void setCacheLastUpdate(UUID uUID, Integer n) {
            this.cacheLastUpdate.put(uUID, n);
        }

        public static PlaytimeRange getByName(String string) {
            PlaytimeRange[] playtimeRangeArray = PlaytimeRange.values();
            int n = playtimeRangeArray.length;
            int n2 = 0;
            while (n2 < n) {
                PlaytimeRange playtimeRange = playtimeRangeArray[n2];
                if (playtimeRange.name().equalsIgnoreCase(string)) {
                    return playtimeRange;
                }
                ++n2;
            }
            return null;
        }

        public int getSlot() {
            return this.slot;
        }

        public void setSlot(int n) {
            this.slot = n;
        }

        public boolean isDetailed() {
            return this.detailed;
        }

        public CMIMaterial getColor() {
            return this.color;
        }

        public void setColor(CMIMaterial cMIMaterial) {
            this.color = cMIMaterial;
        }
    }
}

