/*
 * Decompiled with CFR 0.152.
 */
package com.Zrips.CMI.Modules.Particl;

import com.Zrips.CMI.CMI;
import com.Zrips.CMI.Modules.Particl.CMIPEAnimationInterface;
import com.Zrips.CMI.Modules.Particl.ParticleManager;
import java.util.ArrayList;
import java.util.List;
import net.Zrips.CMILib.Version.Schedulers.CMIScheduler;
import net.Zrips.CMILib.Version.Schedulers.CMITask;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.plugin.java.JavaPlugin;

public class CMIVisualEffect {
    private Player targetPlayerLocation;
    private Location loc;
    CMITask task = null;
    private int interval = 1;
    private Long until = null;
    private CMIPEAnimationInterface effectAnimation = null;
    List<Player> players = new ArrayList<Player>();
    Long nextPlayerUpdate;

    public CMIVisualEffect(Player player, ParticleManager.CMIPresetAnimations cMIPresetAnimations) {
        this(player, cMIPresetAnimations.getInter(player));
    }

    public CMIVisualEffect(Player player, CMIPEAnimationInterface cMIPEAnimationInterface) {
        if (cMIPEAnimationInterface != null) {
            if (cMIPEAnimationInterface.getCenter() != null) {
                this.loc = cMIPEAnimationInterface.getCenter().clone();
            }
            this.effectAnimation = cMIPEAnimationInterface;
            this.interval = cMIPEAnimationInterface.getInterval();
        }
        this.setTargetPlayer(player);
    }

    public CMIVisualEffect(Location location, CMIPEAnimationInterface cMIPEAnimationInterface) {
        this.loc = location;
        this.effectAnimation = cMIPEAnimationInterface;
        if (cMIPEAnimationInterface != null) {
            this.interval = cMIPEAnimationInterface.getInterval();
        }
    }

    private Location getLocation() {
        if (this.loc != null) {
            return this.loc;
        }
        return this.getTargetPlayer() != null ? (this.getTargetPlayer().isOnline() ? this.getTargetPlayer().getLocation() : null) : null;
    }

    public void show() {
        if (this.effectAnimation == null) {
            return;
        }
        this.task = CMIScheduler.runTimerAsync((JavaPlugin)CMI.getInstance(), () -> {
            Location location = this.getLocation();
            if (location == null) {
                this.stop();
                return;
            }
            if (this.nextPlayerUpdate == null || this.nextPlayerUpdate < System.currentTimeMillis()) {
                this.players = CMI.getInstance().getUtilManager().getPlayersFromRange(this.getEffect().isHideWithVanish() ? this.getTargetPlayer() : null, location, 32);
                this.nextPlayerUpdate = System.currentTimeMillis() + 1000L;
            }
            if (!this.effectAnimation.isFixedLocation() || this.effectAnimation.getCenter() == null) {
                this.effectAnimation.setCenter(location);
            }
            this.visualize();
            if (this.until == null || this.until < System.currentTimeMillis()) {
                this.stop();
                return;
            }
        }, (long)1L, (long)this.interval);
    }

    public void show(Player player) {
        this.players.clear();
        if (player != null) {
            this.players.add(player);
        }
        this.task = CMIScheduler.runTimerAsync((JavaPlugin)CMI.getInstance(), () -> {
            Location location = this.getLocation();
            if (location == null) {
                this.stop();
                return;
            }
            if (!this.effectAnimation.isFixedLocation() || this.effectAnimation.getCenter() == null) {
                this.effectAnimation.setCenter(location);
            }
            this.visualize();
            if (this.until == null || this.until < System.currentTimeMillis()) {
                this.stop();
                return;
            }
        }, (long)0L, (long)this.interval);
    }

    private void visualize() {
        CMIScheduler.runTaskAsynchronously((JavaPlugin)CMI.getInstance(), () -> {
            Location location = this.getLocation();
            if (location == null) {
                this.stop();
                return;
            }
            if (this.effectAnimation == null) {
                this.stop();
                return;
            }
            if (!this.effectAnimation.render(new ArrayList<Player>(this.players))) {
                this.stop();
                return;
            }
        });
    }

    public void stop() {
        if (this.task == null) {
            return;
        }
        this.task.cancel();
        this.task = null;
        CMI.getInstance().getParticleManager().removePlayerEffects(this);
    }

    public void pause() {
    }

    public void continueAnimation() {
    }

    public CMIPEAnimationInterface getEffect() {
        return this.effectAnimation;
    }

    public void setEffect(CMIPEAnimationInterface cMIPEAnimationInterface) {
        this.effectAnimation = cMIPEAnimationInterface;
    }

    public Player getTargetPlayer() {
        return this.targetPlayerLocation;
    }

    public void setTargetPlayer(Player player) {
        this.targetPlayerLocation = player;
        if (this.loc == null) {
            CMI.getInstance().getParticleManager().addPlayerEffect(this);
        }
    }

    public Long getUntil() {
        return this.until;
    }

    public void setUntil(Long l) {
        this.until = l;
    }

    public int getInterval() {
        return this.interval;
    }

    public void setInterval(int n) {
        this.interval = n;
    }
}

