/*
 * Decompiled with CFR 0.152.
 */
package com.Zrips.CMI.Modules.Packets;

import com.Zrips.CMI.CMI;
import com.Zrips.CMI.Containers.CMIInteractType;
import com.Zrips.CMI.Modules.Packets.FakeInfo;
import com.Zrips.CMI.events.CMIPlayerFakeEntityInteractEvent;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.HashSet;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.Zrips.CMILib.Version.Schedulers.CMIScheduler;
import net.Zrips.CMILib.Version.Version;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.plugin.java.JavaPlugin;

public class PacketHandler
extends ChannelDuplexHandler {
    private Player p;
    static ConcurrentHashMap<UUID, HashMap<packetNames, Long>> map = new ConcurrentHashMap();
    public static ConcurrentHashMap<Integer, FakeInfo> fakeEntities = new ConcurrentHashMap();
    public static ConcurrentHashMap<UUID, HashSet<Integer>> fakeEntitiesByPlayer = new ConcurrentHashMap();
    static Field entityIdField = null;
    static Field actionField = null;

    public PacketHandler(Player player) {
        this.p = player;
    }

    public static synchronized void addFakeEntity(FakeInfo fakeInfo) {
        fakeEntities.put(fakeInfo.getId(), fakeInfo);
        if (fakeInfo.getPlayer() != null) {
            HashSet<Integer> hashSet = fakeEntitiesByPlayer.getOrDefault(fakeInfo.getPlayer().getUniqueId(), new HashSet());
            hashSet.add(fakeInfo.getId());
            fakeEntitiesByPlayer.put(fakeInfo.getPlayer().getUniqueId(), hashSet);
        }
    }

    public static synchronized void clearFakeEntities() {
        for (FakeInfo fakeInfo : fakeEntities.values()) {
            if (fakeInfo.getPlayer() == null || !fakeInfo.getPlayer().isOnline()) continue;
            CMI.getInstance().getNMS().removeHologram(fakeInfo.getPlayer(), fakeInfo.getId());
        }
        fakeEntities.clear();
    }

    public static synchronized void removeFakeEntity(FakeInfo fakeInfo) {
        HashSet<Integer> hashSet;
        fakeEntities.remove(fakeInfo.getId());
        if (fakeInfo.getPlayer() != null && (hashSet = fakeEntitiesByPlayer.get(fakeInfo.getPlayer().getUniqueId())) != null) {
            hashSet.remove(fakeInfo.getId());
            if (hashSet.isEmpty()) {
                fakeEntitiesByPlayer.remove(fakeInfo.getPlayer().getUniqueId());
            }
        }
    }

    public static synchronized void clearCache(UUID uUID) {
        HashSet<Integer> hashSet = fakeEntitiesByPlayer.get(uUID);
        if (hashSet == null) {
            return;
        }
        map.remove(uUID);
        for (Integer n : hashSet) {
            fakeEntities.remove(n);
        }
        fakeEntitiesByPlayer.remove(uUID);
    }

    public void write(ChannelHandlerContext channelHandlerContext, Object object, ChannelPromise channelPromise) {
        super.write(channelHandlerContext, object, channelPromise);
    }

    public void channelRead(ChannelHandlerContext channelHandlerContext, Object object) {
        try {
            packetNames packetNames2 = packetNames.get(object.getClass().getSimpleName());
            if (packetNames2 != null) {
                switch (packetNames2) {
                    case PacketPlayInUseEntity: 
                    case ServerboundInteractPacket: {
                        this.processEntityInteractEvent(packetNames2, object);
                        break;
                    }
                    default: {
                        break;
                    }
                }
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        super.channelRead(channelHandlerContext, object);
    }

    private void processEntityInteractEvent(packetNames packetNames2, Object object) {
        if (fakeEntities.isEmpty()) {
            return;
        }
        if (!CMI.getInstance().isEnabled()) {
            return;
        }
        CMIScheduler.runTaskAsynchronously((JavaPlugin)CMI.getInstance(), () -> {
            try {
                Object obj = packetNames2.getPacket().cast(object);
                if (entityIdField == null) {
                    if (Version.isCurrentEqualOrHigher((Version)Version.v1_20_R4)) {
                        if (Version.isPaperBranch()) {
                            try {
                                entityIdField = obj.getClass().getDeclaredField("entityId");
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                        }
                        if (entityIdField == null) {
                            entityIdField = obj.getClass().getDeclaredField("b");
                        }
                    } else {
                        entityIdField = obj.getClass().getDeclaredField("a");
                    }
                    entityIdField.setAccessible(true);
                }
                if (actionField == null) {
                    if (Version.isCurrentEqualOrHigher((Version)Version.v1_20_R4)) {
                        if (Version.isPaperBranch()) {
                            try {
                                actionField = obj.getClass().getDeclaredField("action");
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                        }
                        if (actionField == null) {
                            actionField = obj.getClass().getDeclaredField("c");
                        }
                    } else {
                        actionField = Version.isCurrentEqualOrHigher((Version)Version.v1_17_R1) ? obj.getClass().getDeclaredField("b") : obj.getClass().getDeclaredField("action");
                    }
                    actionField.setAccessible(true);
                }
                int n = (Integer)entityIdField.get(obj);
                String string = null;
                string = Version.isCurrentEqualOrHigher((Version)Version.v1_17_R1) ? ((string = entityIdField.get(obj).getClass().getSimpleName()).isEmpty() ? "" : "Interact_at") : entityIdField.get(obj).toString();
                CMIInteractType cMIInteractType = CMIInteractType.LeftClick;
                if (string.equalsIgnoreCase("Interact_at")) {
                    cMIInteractType = CMIInteractType.RightClick;
                }
                this.registerClickEvent(packetNames2, n, cMIInteractType);
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        });
    }

    private void registerClickEvent(packetNames packetNames2, int n, CMIInteractType cMIInteractType) {
        CMIScheduler.runTask((JavaPlugin)CMI.getInstance(), () -> {
            HashMap<packetNames, Long> hashMap = map.get(this.p.getUniqueId());
            if (hashMap != null) {
                Long l = hashMap.get((Object)packetNames2);
                if (l != null && l + 100L >= System.currentTimeMillis()) {
                    return;
                }
                if (!fakeEntities.containsKey(n)) {
                    return;
                }
                FakeInfo fakeInfo = fakeEntities.get(n);
                CMIPlayerFakeEntityInteractEvent cMIPlayerFakeEntityInteractEvent = new CMIPlayerFakeEntityInteractEvent(this.p, n, fakeInfo.getObj(), cMIInteractType);
                Bukkit.getServer().getPluginManager().callEvent((Event)cMIPlayerFakeEntityInteractEvent);
                hashMap.put(packetNames2, System.currentTimeMillis());
                map.put(this.p.getUniqueId(), hashMap);
                return;
            }
            if (!fakeEntities.containsKey(n)) {
                return;
            }
            FakeInfo fakeInfo = fakeEntities.get(n);
            CMIPlayerFakeEntityInteractEvent cMIPlayerFakeEntityInteractEvent = new CMIPlayerFakeEntityInteractEvent(this.p, n, fakeInfo.getObj(), cMIInteractType);
            Bukkit.getServer().getPluginManager().callEvent((Event)cMIPlayerFakeEntityInteractEvent);
            HashMap<packetNames, Long> hashMap2 = new HashMap<packetNames, Long>();
            hashMap2.put(packetNames2, System.currentTimeMillis());
            map.put(this.p.getUniqueId(), hashMap2);
        });
    }

    private static enum packetNames {
        PacketPlayInSetCreativeSlot,
        PacketPlayInUseEntity,
        ServerboundInteractPacket,
        PacketPlayOutPlayerInfo,
        PacketPlayOutEntityVelocity,
        PacketPlayOutEntityTeleport,
        PacketPlayOutLookAt,
        PacketPlayOutCamera,
        PacketPlayOutEntityHeadRotation,
        PacketStatusOutServerInfo,
        PacketPlayOutScoreboardTeam,
        PacketPlayOutChat,
        PacketHandshakingInSetProtocol;

        static Class<?> packet;

        static {
            packet = null;
        }

        public static packetNames get(String string) {
            packetNames[] packetNamesArray = packetNames.values();
            int n = packetNamesArray.length;
            int n2 = 0;
            while (n2 < n) {
                packetNames packetNames2 = packetNamesArray[n2];
                if (packetNames2.toString().startsWith(string)) {
                    return packetNames2;
                }
                ++n2;
            }
            return null;
        }

        public Class<?> getPacket() {
            if (packet == null) {
                try {
                    packet = Version.isCurrentEqualOrHigher((Version)Version.v1_17_R1) ? Class.forName("net.minecraft.network.protocol.game." + this.toString()) : Class.forName("net.minecraft.server." + Version.getCurrent() + "." + this.toString());
                }
                catch (ClassNotFoundException classNotFoundException) {
                    classNotFoundException.printStackTrace();
                }
            }
            return packet;
        }
    }
}

