/*
 * Decompiled with CFR 0.152.
 */
package com.Zrips.CMI.Modules.Jail;

import com.Zrips.CMI.CMI;
import com.Zrips.CMI.Containers.CMIUser;
import com.Zrips.CMI.Locale.CMILC;
import com.Zrips.CMI.Modules.Jail.CMIJail;
import com.Zrips.CMI.Modules.Permissions.PermissionsManager;
import com.Zrips.CMI.commands.list.jail;
import com.Zrips.CMI.commands.list.util;
import com.Zrips.CMI.events.CMIAfkEnterEvent;
import com.Zrips.CMI.events.CMIAfkLeaveEvent;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.UUID;
import net.Zrips.CMILib.BossBar.BossBarInfo;
import net.Zrips.CMILib.Messages.CMIMessages;
import net.Zrips.CMILib.Version.Schedulers.CMIScheduler;
import net.Zrips.CMILib.Version.Version;
import org.bukkit.Location;
import org.bukkit.boss.BarColor;
import org.bukkit.boss.BarStyle;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.FoodLevelChangeEvent;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerPickupItemEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.plugin.java.JavaPlugin;

public class JailListener
implements Listener {
    private CMI plugin;
    protected Map<UUID, Long> lastUpdate;

    public JailListener(CMI cMI) {
        this.plugin = cMI;
        this.lastUpdate = new HashMap<UUID, Long>();
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void PlayerRespawnEventHunger(PlayerRespawnEvent playerRespawnEvent) {
        Player player = playerRespawnEvent.getPlayer();
        CMIUser cMIUser = this.plugin.getPlayerManager().getUser(player);
        if (cMIUser == null) {
            return;
        }
        if (!cMIUser.isJailed()) {
            return;
        }
        if (cMIUser.getCell().getTeleportInLocation() != null) {
            playerRespawnEvent.setRespawnLocation((Location)cMIUser.getCell().getTeleportInLocation());
        }
        CMIScheduler.runTaskLater((JavaPlugin)this.plugin, () -> {
            CMIJail cMIJail = this.plugin.getJailManager().getByLoc(player.getLocation());
            if (cMIJail != null) {
                return;
            }
            if (cMIUser.getCell().getTeleportInLocation() != null) {
                playerRespawnEvent.setRespawnLocation((Location)cMIUser.getCell().getTeleportInLocation());
            }
        }, (long)10L);
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void onFoodChange(FoodLevelChangeEvent foodLevelChangeEvent) {
        if (!(foodLevelChangeEvent.getEntity() instanceof Player)) {
            return;
        }
        Player player = (Player)foodLevelChangeEvent.getEntity();
        CMIUser cMIUser = this.plugin.getPlayerManager().getUser(player);
        if (cMIUser == null) {
            return;
        }
        if (!cMIUser.isJailed()) {
            return;
        }
        if (!this.plugin.getJailManager().isNoHunger()) {
            return;
        }
        if (player.getFoodLevel() < foodLevelChangeEvent.getFoodLevel()) {
            return;
        }
        foodLevelChangeEvent.setCancelled(true);
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPlayerMove(PlayerMoveEvent playerMoveEvent) {
        Player player = playerMoveEvent.getPlayer();
        if (player == null) {
            return;
        }
        if (!this.plugin.getJailManager().anyJailedOnline()) {
            return;
        }
        Location location = playerMoveEvent.getFrom();
        Location location2 = playerMoveEvent.getTo();
        if (playerMoveEvent.getTo() == null) {
            return;
        }
        if (location.getBlockX() == location2.getBlockX() && location.getBlockY() == location2.getBlockY() && location.getBlockZ() == location2.getBlockZ()) {
            return;
        }
        if (player.hasMetadata("NPC")) {
            return;
        }
        CMIUser cMIUser = CMIUser.getUser(player);
        if (cMIUser == null) {
            return;
        }
        if (!cMIUser.isJailed()) {
            return;
        }
        Long l = this.lastUpdate.get(player.getUniqueId());
        if (l != null && System.currentTimeMillis() - l < (long)this.plugin.getJailManager().getJailsCheckInterval()) {
            return;
        }
        this.lastUpdate.put(player.getUniqueId(), System.currentTimeMillis());
        CMIJail cMIJail = this.plugin.getJailManager().getByLoc(location2);
        if (cMIJail != null) {
            return;
        }
        if (!cMIUser.getCell().getJail().isPreventLeave()) {
            return;
        }
        cMIUser.getCell().teleportToCell(cMIUser);
        this.plugin.getJailManager().informAboutLeftTime(player);
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void PlayerQuitEvent(PlayerQuitEvent playerQuitEvent) {
        Player player = playerQuitEvent.getPlayer();
        if (player == null) {
            return;
        }
        this.lastUpdate.remove(player.getUniqueId());
        this.plugin.getJailManager().removeOnline(this.plugin.getPlayerManager().getUser(player));
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void PlayerJoinEvent(PlayerJoinEvent playerJoinEvent) {
        Player player = playerJoinEvent.getPlayer();
        if (player == null) {
            return;
        }
        CMIUser cMIUser = this.plugin.getPlayerManager().getUser(player);
        if (cMIUser == null) {
            return;
        }
        cMIUser.updateJailedTimeOnJoin();
        if (!cMIUser.isJailed()) {
            return;
        }
        this.plugin.getJailManager().placePlayerIntoJail(cMIUser);
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onPlayerInteract(InventoryClickEvent inventoryClickEvent) {
        if (!(inventoryClickEvent.getWhoClicked() instanceof Player)) {
            return;
        }
        Player player = (Player)inventoryClickEvent.getWhoClicked();
        CMIUser cMIUser = this.plugin.getPlayerManager().getUser(player);
        if (cMIUser == null) {
            return;
        }
        if (cMIUser.isJailed()) {
            inventoryClickEvent.setCancelled(true);
            this.plugin.getJailManager().informAboutLeftTime(player);
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onPlayerInteract(PlayerDropItemEvent playerDropItemEvent) {
        Player player = playerDropItemEvent.getPlayer();
        CMIUser cMIUser = this.plugin.getPlayerManager().getUser(player);
        if (cMIUser == null) {
            return;
        }
        if (cMIUser.isJailed()) {
            playerDropItemEvent.setCancelled(true);
            this.plugin.getJailManager().informAboutLeftTime(player);
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onHit(EntityDamageByEntityEvent entityDamageByEntityEvent) {
        if (!(entityDamageByEntityEvent.getDamager() instanceof Player)) {
            return;
        }
        Player player = (Player)entityDamageByEntityEvent.getDamager();
        CMIUser cMIUser = this.plugin.getPlayerManager().getUser(player);
        if (cMIUser == null) {
            return;
        }
        if (cMIUser.isJailed() && this.plugin.getJailManager().isPreventDamage()) {
            entityDamageByEntityEvent.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onPlayerDamage(EntityDamageEvent entityDamageEvent) {
        if (!(entityDamageEvent.getEntity() instanceof Player)) {
            return;
        }
        Player player = (Player)entityDamageEvent.getEntity();
        CMIUser cMIUser = this.plugin.getPlayerManager().getUser(player);
        if (cMIUser == null) {
            return;
        }
        if (!cMIUser.isJailed()) {
            return;
        }
        if (!EntityDamageEvent.DamageCause.STARVATION.equals((Object)entityDamageEvent.getCause())) {
            return;
        }
        player.setFoodLevel(20);
        entityDamageEvent.setCancelled(true);
        if (util.imortaldebug) {
            CMIMessages.consoleMessage((String)"Jail onPlayerDamage->EntityDamageEvent");
        }
    }

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public void onPlayerMove(PlayerCommandPreprocessEvent playerCommandPreprocessEvent) {
        Player player = playerCommandPreprocessEvent.getPlayer();
        if (playerCommandPreprocessEvent.isCancelled()) {
            return;
        }
        CMIUser cMIUser = this.plugin.getPlayerManager().getUser(player);
        if (cMIUser == null) {
            return;
        }
        if (!cMIUser.isJailed()) {
            return;
        }
        if (PermissionsManager.CMIPerm.command_jail_bypasscmd.hasPermission((CommandSender)player)) {
            return;
        }
        if (this.plugin.getJailManager().canUseCommand(playerCommandPreprocessEvent.getMessage())) {
            return;
        }
        this.plugin.getJailManager().informAboutLeftTime(player);
        CMILC.info(jail.class, (CommandSender)player, "noCommand", new Object[0]);
        playerCommandPreprocessEvent.setCancelled(true);
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void PlayerPickupItemEvent(PlayerPickupItemEvent playerPickupItemEvent) {
        if (!this.plugin.getJailManager().anyJailedOnline()) {
            return;
        }
        CMIUser cMIUser = this.plugin.getPlayerManager().getUser(playerPickupItemEvent.getPlayer());
        if (cMIUser == null) {
            return;
        }
        if (cMIUser.isJailed()) {
            playerPickupItemEvent.setCancelled(true);
            playerPickupItemEvent.getItem().setPickupDelay(playerPickupItemEvent.getItem().getPickupDelay() < 20 ? 20 : playerPickupItemEvent.getItem().getPickupDelay());
        }
    }

    @EventHandler(priority=EventPriority.LOW)
    public void AsyncPlayerChatEvent(AsyncPlayerChatEvent asyncPlayerChatEvent) {
        if (asyncPlayerChatEvent.isCancelled()) {
            return;
        }
        Player player = asyncPlayerChatEvent.getPlayer();
        CMIUser cMIUser = this.plugin.getPlayerManager().getUser(player);
        if (cMIUser == null) {
            return;
        }
        if (!cMIUser.isJailed()) {
            return;
        }
        if ((double)this.plugin.getJailManager().getJailChatRange().intValue() == 0.0) {
            return;
        }
        if (PermissionsManager.CMIPerm.chat_rangebypass.hasSetPermission((CommandSender)player, new String[0])) {
            return;
        }
        if ((double)this.plugin.getJailManager().getJailChatRange().intValue() <= -1.0) {
            CMILC.info(jail.class, (CommandSender)player, "cantTalk", new Object[0]);
            asyncPlayerChatEvent.setCancelled(true);
            return;
        }
        int n = this.plugin.getJailManager().getJailChatRange();
        HashSet hashSet = new HashSet(asyncPlayerChatEvent.getRecipients());
        if (n > 0) {
            for (Player player2 : hashSet) {
                double d;
                if (player2.getName().equals(player.getName())) continue;
                if (!player2.getWorld().equals(player.getWorld()) && !PermissionsManager.CMIPerm.chat_rangespy.hasSetPermission((CommandSender)player2, new String[0])) {
                    asyncPlayerChatEvent.getRecipients().remove(player2);
                    continue;
                }
                if (!player2.getWorld().equals(player.getWorld()) || !((d = player2.getLocation().distance(player.getLocation())) > (double)n) || PermissionsManager.CMIPerm.chat_rangespy.hasSetPermission((CommandSender)player2, new String[0])) continue;
                asyncPlayerChatEvent.getRecipients().remove(player2);
            }
            CMILC.info(jail.class, (CommandSender)player, "cantTalkRange", "[range]", n);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void CMIAfkEnterEvent(CMIAfkEnterEvent cMIAfkEnterEvent) {
        if (cMIAfkEnterEvent.isCancelled()) {
            return;
        }
        if (this.plugin.getJailManager().isNoAfk()) {
            CMIUser cMIUser = this.plugin.getPlayerManager().getUser(cMIAfkEnterEvent.getPlayer());
            cMIUser.removeBossBar(cMIUser.getBossBar("CMIJailBar"));
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void CMIAfkEnterEvent(CMIAfkLeaveEvent cMIAfkLeaveEvent) {
        if (!this.plugin.getJailManager().isNoAfk()) {
            return;
        }
        CMIUser cMIUser = this.plugin.getPlayerManager().getUser(cMIAfkLeaveEvent.getPlayer());
        if (!Version.isCurrentHigher((Version)Version.v1_8_R3)) {
            return;
        }
        cMIUser.removeBossBar(cMIUser.getBossBar("CMIJailBar"));
        BossBarInfo bossBarInfo = new BossBarInfo(cMIUser.getPlayer(), "CMIJailBar");
        if (!cMIUser.isJailed()) {
            return;
        }
        Double d = (double)cMIUser.getJailedForTime() / 1000.0 - 1.0;
        if (d <= 0.0) {
            return;
        }
        bossBarInfo.setKeepForTicks(Integer.valueOf(22));
        bossBarInfo.setColor(BarColor.GREEN);
        bossBarInfo.setTitleOfBar(CMILC.getIM(jail.class, "bossbar", new Object[0]));
        bossBarInfo.setAdjustPerc(Double.valueOf(-(1.0 / d)));
        bossBarInfo.setPercentage(d.doubleValue(), d.doubleValue());
        bossBarInfo.setStyle(BarStyle.SEGMENTED_20);
        bossBarInfo.setAuto(Integer.valueOf(20));
        cMIUser.addBossBar(bossBarInfo);
    }
}

