/*
 * Decompiled with CFR 0.152.
 */
package com.Zrips.CMI.Modules.Jail;

import com.Zrips.CMI.CMI;
import com.Zrips.CMI.Containers.CMIUser;
import com.Zrips.CMI.Modules.Jail.CMIJail;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.UUID;
import net.Zrips.CMILib.Container.CMILocation;
import net.Zrips.CMILib.Version.Schedulers.CMIScheduler;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.plugin.java.JavaPlugin;

public class CMIJailCell {
    private int id = 0;
    private CMILocation teleportInLocation;
    private World world;
    private Set<UUID> jailedOnes = new LinkedHashSet<UUID>();
    private CMIJail jail;

    public CMIJailCell(CMIJail cMIJail) {
        this.jail = cMIJail;
    }

    public Integer getId() {
        return this.id;
    }

    public void setId(int n) {
        this.id = n;
    }

    public void loadJailed(String string) {
        if (string == null || !string.contains(":")) {
            throw new Exception("Invalid jail cell jailed information...");
        }
        String[] stringArray = string.split(":");
        try {
            String[] stringArray2 = stringArray;
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String string2 = stringArray2[n2];
                UUID uUID = UUID.fromString(string2);
                if (uUID != null) {
                    this.jailedOnes.add(uUID);
                }
                ++n2;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new Exception("Invalid jail cell jailed information...");
        }
    }

    public void teleportToCell(CMIUser cMIUser) {
        if (cMIUser.getPlayer().getVehicle() != null) {
            CMI.getInstance().getAnimationManager().removePlayerFromChair(cMIUser.getPlayer());
        }
        CMIScheduler.runTask((JavaPlugin)CMI.getInstance(), () -> {
            if (!cMIUser.isOnline()) {
                return;
            }
            CMI.getInstance().getTeleportHandler().teleportPlayer(cMIUser.getPlayer(), (Location)this.getTeleportInLocation(), PlayerTeleportEvent.TeleportCause.PLUGIN);
        });
    }

    public CMILocation getTeleportInLocation() {
        return this.teleportInLocation;
    }

    @Deprecated
    public void setTeleportInLocation(Location location) {
        if (location != null) {
            this.teleportInLocation = new CMILocation(location);
        }
    }

    public void setTeleportInLocation(CMILocation cMILocation) {
        this.teleportInLocation = cMILocation;
    }

    public World getWorld() {
        return this.world;
    }

    public void setWorld(World world2) {
        this.world = world2;
    }

    public Set<UUID> getJailed() {
        return this.jailedOnes;
    }

    public void setJailed(HashSet<UUID> hashSet) {
        this.jailedOnes = hashSet;
    }

    public void addJailed(UUID uUID) {
        this.jailedOnes.add(uUID);
    }

    public void removeJailed(UUID uUID) {
        this.jailedOnes.remove(uUID);
    }

    public CMIJail getJail() {
        return this.jail;
    }
}

