/*
 * Decompiled with CFR 0.152.
 */
package com.Zrips.CMI.Modules.InteractiveCommand;

import com.Zrips.CMI.CMI;
import com.Zrips.CMI.Config;
import com.Zrips.CMI.Modules.Hooks.CMIHookType;
import com.Zrips.CMI.Modules.InteractiveCommand.CMIInteractiveCommand;
import com.Zrips.CMI.Modules.InteractiveCommand.CMINPC;
import com.Zrips.CMI.Modules.Portals.CuboidArea;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.UUID;
import net.Zrips.CMILib.Container.CMILocation;
import net.Zrips.CMILib.FileHandler.ConfigReader;
import net.Zrips.CMILib.Messages.CMIMessages;
import net.Zrips.CMILib.Version.Schedulers.CMIScheduler;
import net.Zrips.CMILib.Version.Schedulers.CMITask;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class InteractiveCommandManager {
    CMI plugin;
    private boolean checkCitizens = false;
    HashMap<String, Map<CuboidArea.ChunkRef, Set<CMIInteractiveCommand>>> map = new HashMap();
    HashMap<UUID, CMIInteractiveCommand> entMap = new HashMap();
    HashMap<Integer, CMIInteractiveCommand> citiznesMap = new HashMap();
    LinkedHashMap<String, CMIInteractiveCommand> nameMap = new LinkedHashMap();
    private CMITask saveTask = null;
    boolean saving = false;
    private String fileName = "InteractiveCommands.yml";

    public InteractiveCommandManager(CMI cMI) {
        this.plugin = cMI;
    }

    public Entity getEntityByUUID(UUID uUID) {
        for (World world2 : Bukkit.getWorlds()) {
            for (Entity entity : world2.getEntities()) {
                if (!entity.getUniqueId().equals(uUID)) continue;
                return entity;
            }
        }
        return null;
    }

    public void deleteIC(CMIInteractiveCommand cMIInteractiveCommand) {
        this.nameMap.remove(cMIInteractiveCommand.getName().toLowerCase());
        this.clearLocationsFromIC(cMIInteractiveCommand);
        for (UUID object : cMIInteractiveCommand.getUUIDList()) {
            this.entMap.remove(object);
        }
        for (CMINPC cMINPC : cMIInteractiveCommand.getUUIDMap().values()) {
            if (cMINPC.getId() == null) continue;
            this.citiznesMap.remove(cMINPC.getId());
        }
    }

    public void clearLocationsFromIC(CMIInteractiveCommand cMIInteractiveCommand) {
        for (Map.Entry<String, Map<CuboidArea.ChunkRef, Set<CMIInteractiveCommand>>> entry : this.map.entrySet()) {
            for (Map.Entry<CuboidArea.ChunkRef, Set<CMIInteractiveCommand>> entry2 : entry.getValue().entrySet()) {
                entry2.getValue().remove(cMIInteractiveCommand);
            }
        }
    }

    public void addEntity(UUID uUID, CMIInteractiveCommand cMIInteractiveCommand) {
        Integer n;
        this.entMap.put(uUID, cMIInteractiveCommand);
        if (CMIHookType.Citizens.isEnabled() && (n = this.plugin.getCitizensManager().getEntityId(uUID)) != null) {
            this.citiznesMap.put(n, cMIInteractiveCommand);
        }
    }

    public CMIInteractiveCommand addInteractiveCommand(CMIInteractiveCommand cMIInteractiveCommand) {
        return this.addInteractiveCommand(cMIInteractiveCommand, true);
    }

    @Deprecated
    public CMIInteractiveCommand addInteractiveCommand(CMIInteractiveCommand cMIInteractiveCommand, boolean bl) {
        return this.addInteractiveCommand(cMIInteractiveCommand, bl, null);
    }

    public CMIInteractiveCommand addInteractiveCommand(CMIInteractiveCommand cMIInteractiveCommand, boolean bl, Location location) {
        Object object;
        if (!cMIInteractiveCommand.getLocList().isEmpty()) {
            HashSet<CMILocation> serializable = new HashSet<CMILocation>();
            if (location == null) {
                serializable.addAll(cMIInteractiveCommand.getLocList());
            } else {
                serializable.add(new CMILocation(location));
            }
            object = cMIInteractiveCommand.getLocList().iterator();
            while (object.hasNext()) {
                CuboidArea.ChunkRef chunkRef;
                Set<CMIInteractiveCommand> set;
                CMILocation cMILocation = object.next();
                if (cMILocation == null || cMILocation.getWorldName() == null) {
                    this.plugin.consoleMessage("&eCant determine world for (" + cMIInteractiveCommand.getName() + ") interactable command. Skipping location");
                    continue;
                }
                if (location != null && bl && (cMILocation.getBlock() == null || cMILocation.getBlock().getType().equals((Object)Material.AIR))) {
                    if (cMIInteractiveCommand.isPublic()) continue;
                    this.plugin.consoleMessage("&eCant add interactive command for air type block (" + cMIInteractiveCommand.getName() + ")");
                    continue;
                }
                Map<CuboidArea.ChunkRef, Set<CMIInteractiveCommand>> map = this.map.get(cMILocation.getWorldName());
                if (map == null) {
                    map = new HashMap<CuboidArea.ChunkRef, Set<CMIInteractiveCommand>>();
                }
                if ((set = map.get(chunkRef = new CuboidArea.ChunkRef((Location)cMILocation))) == null) {
                    set = new HashSet<CMIInteractiveCommand>();
                }
                set.add(cMIInteractiveCommand);
                map.put(chunkRef, set);
                this.map.put(cMILocation.getWorldName(), map);
            }
        }
        if (!cMIInteractiveCommand.getUUIDList().isEmpty()) {
            for (UUID uUID : cMIInteractiveCommand.getUUIDList()) {
                this.entMap.put(uUID, cMIInteractiveCommand);
                if (!CMIHookType.Citizens.isEnabled() || (object = this.plugin.getCitizensManager().getEntityId(uUID)) == null) continue;
                this.citiznesMap.put((Integer)object, cMIInteractiveCommand);
            }
        }
        this.nameMap.put(cMIInteractiveCommand.getName().toLowerCase(), cMIInteractiveCommand);
        if (bl) {
            this.save();
        }
        return cMIInteractiveCommand;
    }

    public Set<CMIInteractiveCommand> getFullList() {
        return new HashSet<CMIInteractiveCommand>(this.nameMap.values());
    }

    public Set<CMIInteractiveCommand> getSortedByDistance(Location location) {
        Map.Entry<String, CMIInteractiveCommand> entry2;
        HashMap hashMap = new HashMap();
        ArrayList<CMIInteractiveCommand> arrayList = new ArrayList<CMIInteractiveCommand>();
        TreeMap<String, CMIInteractiveCommand> treeMap = new TreeMap<String, CMIInteractiveCommand>();
        for (Map.Entry<String, CMIInteractiveCommand> entry2 : this.nameMap.entrySet()) {
            if (entry2.getValue().getLocList().isEmpty() || !Config.InteractiveCommandsSort) {
                treeMap.put((String)entry2.getKey(), (CMIInteractiveCommand)entry2.getValue());
                continue;
            }
            boolean bl = false;
            double d = 0.0;
            int n = 0;
            for (CMILocation cMILocation : ((CMIInteractiveCommand)entry2.getValue()).getLocList()) {
                if (location.getWorld() != cMILocation.getWorld()) continue;
                bl = true;
                d += location.distance((Location)cMILocation);
                if (++n >= 10) break;
            }
            if (!bl) {
                arrayList.add((CMIInteractiveCommand)entry2.getValue());
                continue;
            }
            int n2 = (int)(d / (double)n);
            hashMap.put(entry2.getValue(), n2);
        }
        hashMap = this.plugin.getSortingManager().sortByValueObject(hashMap);
        entry2 = new LinkedHashSet();
        for (Map.Entry entry3 : hashMap.entrySet()) {
            entry2.add((CMIInteractiveCommand)entry3.getKey());
        }
        if (!arrayList.isEmpty()) {
            for (CMIInteractiveCommand cMIInteractiveCommand : arrayList) {
                treeMap.put(cMIInteractiveCommand.getName(), cMIInteractiveCommand);
            }
        }
        for (Map.Entry entry4 : treeMap.entrySet()) {
            entry2.add((CMIInteractiveCommand)entry4.getValue());
        }
        return entry2;
    }

    public CMIInteractiveCommand getByUUID(UUID uUID) {
        if (this.checkCitizens) {
            this.checkCitizens();
            this.checkCitizens = false;
        }
        return this.entMap.get(uUID);
    }

    public CMIInteractiveCommand getByCitizensId(Integer n) {
        if (n == null) {
            return null;
        }
        if (this.checkCitizens) {
            this.checkCitizens();
            this.checkCitizens = false;
        }
        return this.citiznesMap.get(n);
    }

    private void checkCitizens() {
        int n = 0;
        CMIHookType.Citizens.update();
        if (!CMIHookType.Citizens.isEnabled()) {
            return;
        }
        boolean bl = false;
        for (Map.Entry<String, CMIInteractiveCommand> entry : this.nameMap.entrySet()) {
            for (CMINPC cMINPC : entry.getValue().getCitizensCache()) {
                Comparable<StringBuilder> comparable;
                Integer n2 = null;
                boolean bl2 = false;
                if (cMINPC.getUuid() != null && (n2 = this.plugin.getCitizensManager().getEntityId(cMINPC.getUuid())) != null) {
                    cMINPC.setId(n2);
                    entry.getValue().addUUID(cMINPC.getUuid(), n2);
                    cMINPC.setSecondaryUUID(this.plugin.getCitizensManager().getEntityUUID(cMINPC.getId()));
                    this.entMap.put(cMINPC.getUuid(), entry.getValue());
                    this.citiznesMap.put(n2, entry.getValue());
                    ++n;
                    bl2 = true;
                    bl = true;
                }
                if (n2 == null) {
                    comparable = this.plugin.getCitizensManager().getEntityRealUUID(cMINPC.getId());
                    if (comparable != null) {
                        entry.getValue().addUUID((UUID)comparable, cMINPC.getId());
                        cMINPC.setSecondaryUUID(this.plugin.getCitizensManager().getEntityUUID(cMINPC.getId()));
                        this.entMap.put((UUID)comparable, entry.getValue());
                        ++n;
                        bl2 = true;
                        bl = true;
                    }
                    this.citiznesMap.put(cMINPC.getId(), entry.getValue());
                }
                if (bl2) continue;
                comparable = new StringBuilder();
                ((StringBuilder)comparable).append("&eFailed to find NPC for " + entry.getKey() + " ");
                if (cMINPC.getId() != null) {
                    ((StringBuilder)comparable).append("by " + cMINPC.getId() + " id ");
                }
                if (cMINPC.getUuid() != null) {
                    ((StringBuilder)comparable).append(" " + cMINPC.getUuid().toString() + " uuid ");
                }
                CMI.getInstance().consoleMessage(((StringBuilder)comparable).toString());
            }
            entry.getValue().getCitizensCache().clear();
        }
        CMI.getInstance().consoleMessage("Loaded " + n + " citizen NPC's as interactable entities");
        if (bl) {
            this.save();
        }
    }

    public CMIInteractiveCommand getByName(String string) {
        return this.nameMap.get(string.toLowerCase());
    }

    public CMIInteractiveCommand removeLoc(CMILocation cMILocation) {
        if (cMILocation == null) {
            return null;
        }
        World world2 = cMILocation.getWorld();
        if (world2 == null) {
            return null;
        }
        String string = world2.getName();
        if (string == null) {
            return null;
        }
        if (!this.map.containsKey(string)) {
            return null;
        }
        CuboidArea.ChunkRef chunkRef = new CuboidArea.ChunkRef((Location)cMILocation);
        Map<CuboidArea.ChunkRef, Set<CMIInteractiveCommand>> map = this.map.get(string);
        if (map.containsKey(chunkRef)) {
            for (CMIInteractiveCommand cMIInteractiveCommand : map.get(chunkRef)) {
                if (cMIInteractiveCommand == null) continue;
                for (CMILocation cMILocation2 : cMIInteractiveCommand.getLocList()) {
                    if (cMILocation2.getBlockX() != cMILocation.getBlockX() || cMILocation2.getBlockY() != cMILocation.getBlockY() || cMILocation2.getBlockZ() != cMILocation.getBlockZ()) continue;
                    cMIInteractiveCommand.getLocList().remove(cMILocation2);
                    this.save();
                    return cMIInteractiveCommand;
                }
            }
        }
        return null;
    }

    public CMIInteractiveCommand removeEntity(UUID uUID) {
        Integer n;
        if (uUID == null) {
            return null;
        }
        CMIInteractiveCommand cMIInteractiveCommand = this.entMap.remove(uUID);
        if (cMIInteractiveCommand == null) {
            return null;
        }
        if (CMIHookType.Citizens.isEnabled() && (n = this.plugin.getCitizensManager().getEntityId(uUID)) != null) {
            this.citiznesMap.remove(n);
        }
        cMIInteractiveCommand.getUUIDMap().remove(uUID);
        return cMIInteractiveCommand;
    }

    public CMIInteractiveCommand getByLoc(Location location) {
        if (location == null) {
            return null;
        }
        World world2 = location.getWorld();
        if (world2 == null) {
            return null;
        }
        String string = world2.getName();
        if (string == null) {
            return null;
        }
        if (!this.map.containsKey(string)) {
            return null;
        }
        CuboidArea.ChunkRef chunkRef = new CuboidArea.ChunkRef(location);
        Map<CuboidArea.ChunkRef, Set<CMIInteractiveCommand>> map = this.map.get(string);
        if (map.containsKey(chunkRef)) {
            for (CMIInteractiveCommand cMIInteractiveCommand : map.get(chunkRef)) {
                if (cMIInteractiveCommand == null) continue;
                for (CMILocation cMILocation : cMIInteractiveCommand.getLocList()) {
                    if (cMILocation.getBlockX() != location.getBlockX() || cMILocation.getBlockY() != location.getBlockY() || cMILocation.getBlockZ() != location.getBlockZ()) continue;
                    return cMIInteractiveCommand;
                }
            }
        }
        return null;
    }

    public void save() {
        if (this.saveTask != null) {
            return;
        }
        this.saveTask = CMIScheduler.runTaskLater((JavaPlugin)this.plugin, () -> {
            this.forceSave();
            this.saveTask = null;
        }, (long)100L);
    }

    public void forceSave() {
        if (this.saving) {
            return;
        }
        this.saving = true;
        try {
            ConfigReader configReader = null;
            try {
                configReader = new ConfigReader((Plugin)CMI.getInstance(), "Saves" + File.separator + this.fileName);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (configReader == null) {
                return;
            }
            for (CMIInteractiveCommand cMIInteractiveCommand : this.getFullList()) {
                try {
                    String string = cMIInteractiveCommand.getName().replace(".", "_");
                    List<String> list2 = cMIInteractiveCommand.getLocListAsString();
                    configReader.set(String.valueOf(string) + ".Locations", list2.isEmpty() ? null : list2);
                    configReader.set(String.valueOf(string) + ".UUID", cMIInteractiveCommand.getUUIDStringListSave().isEmpty() ? null : cMIInteractiveCommand.getUUIDStringListSave());
                    List<CMINPC> list3 = cMIInteractiveCommand.getNPCList();
                    if (!list3.isEmpty()) {
                        ArrayList<String> arrayList = new ArrayList<String>();
                        for (CMINPC cMINPC : list3) {
                            arrayList.add(String.valueOf(cMINPC.getId() == null ? -1 : cMINPC.getId()) + "_" + (cMINPC.getUuid() == null ? this.plugin.getServerUUID().toString() : cMINPC.getUuid().toString()) + "_" + (cMINPC.getSecondaryUUID() == null ? "0" : cMINPC.getSecondaryUUID().toString()));
                        }
                        configReader.set(String.valueOf(string) + ".NPC", arrayList.isEmpty() ? null : arrayList);
                    }
                    configReader.set(String.valueOf(string) + ".Commands", cMIInteractiveCommand.getCommands());
                    if (cMIInteractiveCommand.containsSigntext()) {
                        configReader.set(String.valueOf(string) + ".SignLines", cMIInteractiveCommand.getSignLines());
                    } else {
                        configReader.set(String.valueOf(string) + ".SignLines", null);
                    }
                    if (cMIInteractiveCommand.isPublic()) {
                        configReader.set(String.valueOf(string) + ".Public", (Object)true);
                    } else {
                        configReader.set(String.valueOf(string) + ".Public", null);
                    }
                    if (cMIInteractiveCommand.isCancelInteraction()) {
                        configReader.set(String.valueOf(string) + ".CancelInt", (Object)true);
                    } else {
                        configReader.set(String.valueOf(string) + ".CancelInt", null);
                    }
                    if (!cMIInteractiveCommand.isSignRequiresPerm()) {
                        configReader.set(String.valueOf(string) + ".ReqPerm", (Object)false);
                        continue;
                    }
                    configReader.set(String.valueOf(string) + ".ReqPerm", null);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            configReader.save();
        }
        catch (Error | Exception throwable) {
            throwable.printStackTrace();
        }
        this.saving = false;
    }

    public void load() {
        Long l = System.currentTimeMillis();
        this.plugin.safeRenameFile("interactiveCommands.yml", "Saves" + File.separator + this.fileName);
        ConfigReader configReader = null;
        try {
            configReader = new ConfigReader((Plugin)CMI.getInstance(), "Saves" + File.separator + this.fileName);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (configReader == null) {
            return;
        }
        this.map.clear();
        this.entMap.clear();
        this.citiznesMap.clear();
        this.nameMap.clear();
        if (configReader.getC().getKeys(false).isEmpty()) {
            return;
        }
        Map map = configReader.getC().getValues(false);
        for (Map.Entry entry : map.entrySet()) {
            CMIInteractiveCommand cMIInteractiveCommand;
            block33: {
                String string = (String)entry.getKey();
                cMIInteractiveCommand = new CMIInteractiveCommand(string);
                try {
                    String[] stringArray;
                    Map map2 = configReader.getC().getConfigurationSection((String)entry.getKey()).getValues(false);
                    if (map2.containsKey("Location")) {
                        for (Object object : (List)map2.get("Location")) {
                            try {
                                cMIInteractiveCommand.addLoc(new CMILocation((Location)object));
                            }
                            catch (Exception exception) {
                                exception.printStackTrace();
                            }
                        }
                    }
                    if (map2.containsKey("Locations")) {
                        for (Object object : (List)map2.get("Locations")) {
                            try {
                                stringArray = this.plugin.getPlayerManager().convertStringToLocation((String)object);
                                if (stringArray == null) continue;
                                cMIInteractiveCommand.addLoc((CMILocation)stringArray);
                            }
                            catch (Exception exception) {
                                exception.printStackTrace();
                            }
                        }
                    }
                    if (map2.containsKey("ID")) {
                        try {
                            for (Object object : (List)map2.get("ID")) {
                                cMIInteractiveCommand.getCitizensCache().add(new CMINPC((Integer)object));
                                this.checkCitizens = true;
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if (map2.containsKey("NPC")) {
                        for (Object object : (List)map2.get("NPC")) {
                            try {
                                stringArray = ((String)object).split("_");
                                int n = Integer.parseInt(stringArray[0]);
                                UUID uUID = null;
                                if (stringArray.length > 1 && stringArray[1].length() == 36) {
                                    uUID = UUID.fromString(stringArray[1]);
                                }
                                UUID uUID2 = null;
                                if (stringArray.length > 2 && stringArray[2].length() == 36) {
                                    uUID2 = UUID.fromString(stringArray[2]);
                                }
                                cMIInteractiveCommand.getCitizensCache().add(new CMINPC(uUID).setId(n).setSecondaryUUID(uUID2));
                                this.checkCitizens = true;
                            }
                            catch (Exception exception) {
                                exception.printStackTrace();
                            }
                        }
                    }
                    if (map2.containsKey("UUID")) {
                        for (Object object : (List)map2.get("UUID")) {
                            try {
                                if (cMIInteractiveCommand.hasUUID(UUID.fromString((String)object))) continue;
                                cMIInteractiveCommand.addUUID(UUID.fromString((String)object), null);
                            }
                            catch (Exception exception) {
                                exception.printStackTrace();
                            }
                        }
                    }
                    if (map2.containsKey("Commands")) {
                        cMIInteractiveCommand.setCommands((List)map2.get("Commands"));
                    }
                    if (map2.containsKey("SignLines")) {
                        cMIInteractiveCommand.setSignLines((List)map2.get("SignLines"));
                    }
                    if (map2.containsKey("CancelInt")) {
                        cMIInteractiveCommand.setCancelInteraction((Boolean)map2.get("CancelInt"));
                    }
                    if (map2.containsKey("Public")) {
                        cMIInteractiveCommand.setPublic((Boolean)map2.get("Public"));
                    }
                    if (!map2.containsKey("ReqPerm")) break block33;
                    cMIInteractiveCommand.setSignRequiresPerm((Boolean)map2.get("ReqPerm"));
                }
                catch (Exception exception) {
                    CMIMessages.sendMessage((CommandSender)Bukkit.getConsoleSender(), (String)("Cant load interactive command (" + (String)entry.getKey() + ")"));
                    exception.printStackTrace();
                    continue;
                }
            }
            this.addInteractiveCommand(cMIInteractiveCommand, false);
        }
        this.plugin.loadMessage(this.nameMap.size(), "interactive commands", System.currentTimeMillis() - l);
    }

    public CMITask getSaveTask() {
        return this.saveTask;
    }
}

