/*
 * Decompiled with CFR 0.152.
 */
package com.Zrips.CMI.Modules.InteractiveCommand;

import com.Zrips.CMI.CMI;
import com.Zrips.CMI.Containers.CMIInteractType;
import com.Zrips.CMI.Modules.Hooks.CMIHookType;
import com.Zrips.CMI.Modules.InteractiveCommand.CMIInteractiveCommand;
import com.Zrips.CMI.Modules.InteractiveCommand.InteractiveCommandListener;
import java.util.UUID;
import net.Zrips.CMILib.Version.Schedulers.CMIScheduler;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.player.PlayerInteractAtEntityEvent;
import org.bukkit.plugin.java.JavaPlugin;

public class InteractiveCommandListener1_8
implements Listener {
    private CMI plugin;

    public InteractiveCommandListener1_8(CMI cMI) {
        this.plugin = cMI;
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void onEntityDamageByEntityEvent(EntityDamageByEntityEvent entityDamageByEntityEvent) {
        if (!(entityDamageByEntityEvent.getDamager() instanceof Player)) {
            return;
        }
        if (this.processInteraction(entityDamageByEntityEvent.getEntity(), (Player)entityDamageByEntityEvent.getDamager(), CMIInteractType.LeftClick)) {
            entityDamageByEntityEvent.setCancelled(true);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean processInteraction(Entity entity, Player player, CMIInteractType cMIInteractType) {
        Long l;
        UUID uUID = entity.getUniqueId();
        CMIInteractiveCommand cMIInteractiveCommand = this.plugin.getInteractiveCommandManager().getByUUID(uUID);
        if (cMIInteractiveCommand == null) {
            if (!entity.hasMetadata("NPC")) return false;
            if (!CMIHookType.Citizens.isEnabled()) return false;
            Integer n = this.plugin.getCitizensManager().getEntityId(entity);
            if (n == null) {
                return false;
            }
            cMIInteractiveCommand = this.plugin.getInteractiveCommandManager().getByCitizensId(n);
            if (cMIInteractiveCommand == null) {
                return false;
            }
            cMIInteractiveCommand.addUUID(uUID, n);
        }
        if ((l = InteractiveCommandListener.limit.get(player.getUniqueId())) != null && l + 100L > System.currentTimeMillis()) {
            return false;
        }
        InteractiveCommandListener.limit.put(player.getUniqueId(), System.currentTimeMillis());
        player.closeInventory();
        CMIInteractiveCommand cMIInteractiveCommand2 = cMIInteractiveCommand;
        CMIScheduler.runTask((JavaPlugin)this.plugin, () -> {
            player.closeInventory();
            CMIInteractType cMIInteractType2 = cMIInteractType;
            if (cMIInteractType.equals((Object)CMIInteractType.RightClick)) {
                if (player.isSneaking()) {
                    cMIInteractType2 = CMIInteractType.RightShiftClick;
                }
            } else if (player.isSneaking()) {
                cMIInteractType2 = CMIInteractType.LeftShiftClick;
            }
            this.plugin.getSpecializedCommandManager().processCmds("CMIIC" + cMIInteractiveCommand2.getName(), cMIInteractiveCommand2.getCommands(player), player, cMIInteractType2, null);
        });
        return true;
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void onPlayerInteractAtEntityEvent(PlayerInteractAtEntityEvent playerInteractAtEntityEvent) {
        if (this.processInteraction(playerInteractAtEntityEvent.getRightClicked(), playerInteractAtEntityEvent.getPlayer(), CMIInteractType.RightClick)) {
            playerInteractAtEntityEvent.setCancelled(true);
        }
    }
}

