/*
 * Decompiled with CFR 0.152.
 */
package com.Zrips.CMI.Modules.InteractiveCommand;

import com.Zrips.CMI.CMI;
import com.Zrips.CMI.Containers.Snd;
import com.Zrips.CMI.Modules.InteractiveCommand.CMINPC;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.Zrips.CMILib.Colors.CMIChatColor;
import net.Zrips.CMILib.Container.CMILocation;
import net.Zrips.CMILib.Version.Schedulers.CMIScheduler;
import org.bukkit.block.Block;
import org.bukkit.block.Sign;
import org.bukkit.entity.Player;
import org.bukkit.plugin.java.JavaPlugin;

public class CMIInteractiveCommand {
    private String name;
    private boolean publicIc = false;
    private boolean signRequiresPerm = true;
    private boolean cancelInteraction = false;
    private Set<CMILocation> loc = new HashSet<CMILocation>();
    private HashMap<UUID, CMINPC> uuid = new HashMap();
    private Set<CMINPC> citizensCache = new HashSet<CMINPC>();
    private List<String> commands = new ArrayList<String>();
    private List<String> signLines = new ArrayList<String>();

    public CMIInteractiveCommand(String string) {
        this.name = string;
        this.signLines.add(" ");
        this.signLines.add(" ");
        this.signLines.add(" ");
        this.signLines.add(" ");
    }

    public List<String> getCommands(Player player) {
        Snd snd = new Snd();
        snd.setSender(player);
        snd.setTarget(player);
        return CMI.getInstance().getLM().updateSnd(snd, new ArrayList<String>(this.commands));
    }

    public List<String> getCommandsOriginal() {
        return this.commands;
    }

    public List<String> getCommands() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : this.commands) {
            arrayList.add(CMIChatColor.deColorize((String)string));
        }
        return arrayList;
    }

    public void setCommands(List<String> list2) {
        this.commands = new ArrayList<String>(list2);
    }

    public void addCommand(String string) {
        this.commands.add(string);
    }

    public Set<CMILocation> getLocList() {
        return this.loc;
    }

    public List<String> getLocListAsString() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (CMILocation cMILocation : this.loc) {
            arrayList.add(CMI.getInstance().getPlayerManager().convertLocToStringShortBlock(cMILocation));
        }
        return arrayList;
    }

    public void setLoc(List<CMILocation> list2) {
        this.loc.clear();
        this.loc.addAll(list2);
    }

    @Deprecated
    public void addLoc(CMILocation cMILocation) {
        if (cMILocation == null) {
            return;
        }
        this.loc.add(cMILocation);
    }

    public HashMap<UUID, CMINPC> getUUIDMap() {
        return this.uuid;
    }

    public Set<UUID> getUUIDList() {
        HashSet<UUID> hashSet = new HashSet<UUID>();
        for (Map.Entry<UUID, CMINPC> entry : this.uuid.entrySet()) {
            hashSet.add(entry.getKey());
        }
        return hashSet;
    }

    @Deprecated
    public List<Integer> getIDList() {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (Map.Entry<UUID, CMINPC> entry : this.uuid.entrySet()) {
            if (entry.getValue().getId() == null) continue;
            arrayList.add(entry.getValue().getId());
        }
        return arrayList;
    }

    public List<CMINPC> getNPCList() {
        ArrayList<CMINPC> arrayList = new ArrayList<CMINPC>();
        for (Map.Entry<UUID, CMINPC> entry : this.uuid.entrySet()) {
            if (entry.getValue().getId() == null || entry.getValue().getId() < 0) continue;
            arrayList.add(entry.getValue());
        }
        return arrayList;
    }

    public List<String> getUUIDStringList() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (UUID uUID : this.getUUIDList()) {
            arrayList.add(uUID.toString());
        }
        return arrayList;
    }

    public List<String> getUUIDStringListSave() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Map.Entry<UUID, CMINPC> entry : this.uuid.entrySet()) {
            if (entry.getValue().getId() != null && entry.getValue().getId() >= 0) continue;
            arrayList.add(entry.getKey().toString());
        }
        return arrayList;
    }

    public void setUUIDList(HashMap<UUID, CMINPC> hashMap) {
        this.uuid.clear();
        this.uuid.putAll(hashMap);
    }

    public boolean hasUUID(UUID uUID) {
        return this.uuid.containsKey(uUID);
    }

    public void addUUID(UUID uUID, Integer n) {
        this.addUUID(uUID, null, n);
    }

    public void addUUID(UUID uUID, UUID uUID2, Integer n) {
        this.uuid.putIfAbsent(uUID, new CMINPC(uUID).setId(n).setSecondaryUUID(uUID2));
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public boolean isPublic() {
        return this.publicIc;
    }

    public void setPublic(boolean bl) {
        this.publicIc = bl;
    }

    public boolean containsSigntext() {
        for (String string : this.getSignLines()) {
            if (string == null || string.isEmpty() || string.equalsIgnoreCase(" ")) continue;
            return true;
        }
        return false;
    }

    public List<String> getSignLines() {
        while (this.signLines.size() < 4) {
            this.signLines.add(" ");
        }
        while (this.signLines.size() > 4) {
            this.signLines.remove(this.signLines.size() - 1);
        }
        return this.signLines;
    }

    public boolean isSignLinesEmpty() {
        for (String string : this.signLines) {
            if (string == null || string.length() <= 0 || string.equalsIgnoreCase(" ")) continue;
            return false;
        }
        return true;
    }

    public void updateSignText(Block block) {
        CMIScheduler.runTaskLater((JavaPlugin)CMI.getInstance(), () -> {
            if (this.isSignLinesEmpty()) {
                return;
            }
            if (!(block.getState() instanceof Sign)) {
                return;
            }
            Sign sign = (Sign)block.getState();
            int n = 0;
            while (n < 4) {
                if (this.getSignLines().get(n) != null && !this.getSignLines().get(n).isEmpty() && !this.getSignLines().get(n).equals(" ")) {
                    sign.setLine(n, CMIChatColor.translate((String)this.getSignLines().get(n)));
                }
                ++n;
            }
            sign.update();
        }, (long)1L);
    }

    public void setSignLines(List<String> list2) {
        this.signLines = list2;
    }

    public Set<CMINPC> getCitizensCache() {
        return this.citizensCache;
    }

    public void setCitizensCache(Set<CMINPC> set) {
        this.citizensCache = set;
    }

    public void addCitizensCache(CMINPC cMINPC) {
        this.citizensCache.add(cMINPC);
    }

    public CMIInteractiveCommand removeEntity(UUID uUID) {
        if (uUID != null) {
            CMI.getInstance().getInteractiveCommandManager().removeEntity(uUID);
        }
        return this;
    }

    public CMIInteractiveCommand removeLoc(CMILocation cMILocation) {
        if (cMILocation != null) {
            CMI.getInstance().getInteractiveCommandManager().removeLoc(cMILocation);
        }
        return this;
    }

    public boolean isSignRequiresPerm() {
        return this.signRequiresPerm;
    }

    public void setSignRequiresPerm(boolean bl) {
        this.signRequiresPerm = bl;
    }

    public boolean isCancelInteraction() {
        return this.cancelInteraction;
    }

    public void setCancelInteraction(boolean bl) {
        this.cancelInteraction = bl;
    }
}

