/*
 * Decompiled with CFR 0.152.
 */
package com.Zrips.CMI.Modules.Holograms;

import com.Zrips.CMI.CMI;
import com.Zrips.CMI.Containers.CMIUser;
import com.Zrips.CMI.Locale.CMILC;
import com.Zrips.CMI.Modules.Display.CMIBillboard;
import com.Zrips.CMI.Modules.Display.CMIDisplay;
import com.Zrips.CMI.Modules.Display.CMITextAlignment;
import com.Zrips.CMI.Modules.Future.CMIFutureBatcher;
import com.Zrips.CMI.Modules.Holograms.CMIFont;
import com.Zrips.CMI.Modules.Holograms.CMIHologram;
import com.Zrips.CMI.Modules.Holograms.CMIHologramLine;
import com.Zrips.CMI.Modules.Holograms.HologramGUIEditor;
import com.Zrips.CMI.Modules.ModuleHandling.CMIModule;
import com.Zrips.CMI.Modules.Packets.PacketHandler;
import com.Zrips.CMI.Modules.Particl.CMIPEAnimationInterface;
import com.Zrips.CMI.Modules.Permissions.PermissionsManager;
import com.Zrips.CMI.Modules.PlayerOptions.PlayerOption;
import com.Zrips.CMI.Modules.Portals.CMIVector3D;
import com.Zrips.CMI.Modules.Portals.CuboidArea;
import com.Zrips.CMI.Modules.Worlds.CMIWorldListener;
import com.Zrips.CMI.Modules.Worlds.UpdateOnWorldLoad;
import com.Zrips.CMI.commands.list.hologram;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import net.Zrips.CMILib.Colors.CMIChatColor;
import net.Zrips.CMILib.Container.CMILocation;
import net.Zrips.CMILib.Container.CMINumber;
import net.Zrips.CMILib.Effects.CMIEffectManager;
import net.Zrips.CMILib.FileHandler.ConfigReader;
import net.Zrips.CMILib.Version.Schedulers.CMIScheduler;
import net.Zrips.CMILib.Version.Schedulers.CMITask;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.util.Vector;

public class HologramManager {
    private static HashMap<String, CMIHologram> holograms;
    protected static Map<String, Map<CuboidArea.ChunkRef, Set<CMIHologram>>> chunkHoloRange;
    protected static Map<String, Map<CuboidArea.ChunkRef, Set<CMIHologram>>> chunkHoloRangeExtra;
    private static Map<UUID, Set<CMIHologram>> playerNearHoloUpdate;
    private static Map<UUID, Set<CMIHologram>> playerNearHoloExtra;
    private static Map<UUID, CMIFutureBatcher> playerFutureBatcher;
    private static Set<UUID> inPacketListener;
    private ConcurrentHashMap<UUID, CMIAiming> aimingAt = new ConcurrentHashMap();
    private CMIHologramLine prevPage;
    private int prevPageLength = 0;
    private CMIHologramLine nextPage;
    private int nextPageLength = 0;
    private int HoloRangeCheckInterval = 1000;
    private CMITask saveScheduler = null;
    private CMI plugin;
    public static int defaultViewRange;
    public static int defaultUpdateRange;
    public static double defaultUpdateInterval;
    public static double defaultpageChangeInterval;
    public static boolean defaultsPlaceUp;
    private String fileName = "Holograms.yml";

    static {
        playerFutureBatcher = new ConcurrentHashMap<UUID, CMIFutureBatcher>();
        inPacketListener = new HashSet<UUID>();
        defaultViewRange = 8;
        defaultUpdateRange = 8;
        defaultUpdateInterval = 0.0;
        defaultpageChangeInterval = 0.0;
        defaultsPlaceUp = true;
    }

    public void clearCache(UUID uUID) {
        playerNearHoloUpdate.remove(uUID);
        playerNearHoloExtra.remove(uUID);
        inPacketListener.remove(uUID);
        playerFutureBatcher.remove(uUID);
    }

    public void clearCachedData(UUID uUID) {
        Optional.ofNullable(this.getPlayerActiveHolograms(uUID)).ifPresent(set -> set.forEach(cMIHologram -> cMIHologram.removeFromCache(uUID)));
    }

    public HologramManager(CMI cMI) {
        this.plugin = cMI;
        holograms = new HashMap();
        chunkHoloRange = new ConcurrentHashMap<String, Map<CuboidArea.ChunkRef, Set<CMIHologram>>>();
        chunkHoloRangeExtra = new ConcurrentHashMap<String, Map<CuboidArea.ChunkRef, Set<CMIHologram>>>();
        playerNearHoloUpdate = new ConcurrentHashMap<UUID, Set<CMIHologram>>();
        playerNearHoloExtra = new ConcurrentHashMap<UUID, Set<CMIHologram>>();
    }

    public void stop() {
        if (this.saveScheduler != null) {
            this.saveScheduler.cancel();
            this.saveScheduler = null;
            this.saveHolograms();
        }
    }

    public void addHologram(CMIHologram cMIHologram) {
        this.addHologram(cMIHologram, true);
    }

    public void addHologram(CMIHologram cMIHologram, boolean bl) {
        this.addHologram(cMIHologram, bl, true);
    }

    public void addHologram(CMIHologram cMIHologram, boolean bl, boolean bl2) {
        if (!CMIModule.holograms.isEnabled()) {
            return;
        }
        CMIHologram cMIHologram2 = holograms.get(cMIHologram.getName().toLowerCase());
        if (cMIHologram2 != null) {
            cMIHologram2.remove();
        }
        holograms.put(cMIHologram.getName().toLowerCase(), cMIHologram);
        try {
            if (bl2) {
                this.recalculateChunks(cMIHologram);
                this.recalculateChunksExtra(cMIHologram);
            }
            if (bl) {
                this.addPlayersNearHolo(cMIHologram, false);
                this.addPlayersNearHoloExtra(cMIHologram, false);
            }
            cMIHologram.updatePages();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public void recalculateChunks() {
        chunkHoloRange.clear();
        for (Map.Entry<String, CMIHologram> entry : holograms.entrySet()) {
            this.recalculateChunks(entry.getValue());
        }
        chunkHoloRangeExtra.clear();
        for (Map.Entry<String, CMIHologram> entry : holograms.entrySet()) {
            this.recalculateChunksExtra(entry.getValue());
        }
    }

    public void removeChunkRecords(CMIHologram cMIHologram) {
        Map<CuboidArea.ChunkRef, Set<CMIHologram>> map;
        if (cMIHologram.getWorld() == null || cMIHologram.getWorld().getName() == null) {
            return;
        }
        Map<CuboidArea.ChunkRef, Set<CMIHologram>> map2 = chunkHoloRange.get(cMIHologram.getWorld().getName());
        if (map2 != null) {
            for (CuboidArea.ChunkRef chunkRef : cMIHologram.getArea().getChunks()) {
                Set<CMIHologram> set = map2.get(chunkRef);
                if (set == null) continue;
                set.remove(cMIHologram);
                map2.put(chunkRef, set);
            }
        }
        if ((map = chunkHoloRangeExtra.get(cMIHologram.getWorld().getName())) != null) {
            for (CuboidArea.ChunkRef chunkRef : cMIHologram.getAreaExtra().getChunks()) {
                Set<CMIHologram> set = map.get(chunkRef);
                if (set == null) continue;
                set.remove(cMIHologram);
                map.put(chunkRef, set);
                chunkHoloRangeExtra.put(cMIHologram.getWorld().getName(), map);
            }
        }
    }

    public void recalculateChunks(final CMIHologram cMIHologram) {
        if (cMIHologram.getWorld() == null) {
            UpdateOnWorldLoad updateOnWorldLoad = new UpdateOnWorldLoad(){

                @Override
                public void update(World world2) {
                    cMIHologram.getLocation().setWorld(world2);
                }
            };
            CMIWorldListener.delayRecheck(cMIHologram.getWorldName(), updateOnWorldLoad);
            return;
        }
        Map map = chunkHoloRange.computeIfAbsent(cMIHologram.getWorldName(), string -> new HashMap());
        for (CuboidArea.ChunkRef chunkRef2 : cMIHologram.getArea().getChunks()) {
            map.computeIfAbsent(chunkRef2, chunkRef -> new HashSet()).add(cMIHologram);
        }
        chunkHoloRange.put(cMIHologram.getWorldName(), map);
    }

    public void recalculateChunksExtra(final CMIHologram cMIHologram) {
        if (cMIHologram.getWorld() == null) {
            UpdateOnWorldLoad updateOnWorldLoad = new UpdateOnWorldLoad(){

                @Override
                public void update(World world2) {
                    HologramManager.this.recalculateChunksExtra(cMIHologram);
                }
            };
            CMIWorldListener.delayRecheck(cMIHologram.getWorldName(), updateOnWorldLoad);
            return;
        }
        Map map = chunkHoloRange.computeIfAbsent(cMIHologram.getWorldName(), string -> new HashMap());
        for (CuboidArea.ChunkRef chunkRef2 : cMIHologram.getAreaExtra().getChunks()) {
            map.computeIfAbsent(chunkRef2, chunkRef -> new HashSet()).add(cMIHologram);
        }
        chunkHoloRangeExtra.put(cMIHologram.getWorldName(), map);
    }

    public CMIHologram getByName(String string) {
        if (string == null) {
            return null;
        }
        return holograms.get(string.toLowerCase());
    }

    public CMIHologram getByLoc(Location location) {
        if (location == null) {
            return null;
        }
        World world2 = location.getWorld();
        if (world2 == null) {
            return null;
        }
        String string = world2.getName();
        if (string == null) {
            return null;
        }
        CuboidArea.ChunkRef chunkRef = new CuboidArea.ChunkRef(location);
        if (!chunkHoloRange.containsKey(string)) {
            return null;
        }
        Map<CuboidArea.ChunkRef, Set<CMIHologram>> map = chunkHoloRange.get(string);
        if (!map.containsKey(chunkRef)) {
            return null;
        }
        for (CMIHologram cMIHologram : map.get(chunkRef)) {
            if (cMIHologram == null || !cMIHologram.getLocation().toString().equals(location.toString())) continue;
            return cMIHologram;
        }
        return null;
    }

    public CMIHologram getByLocExtra(Location location) {
        if (location == null) {
            return null;
        }
        World world2 = location.getWorld();
        if (world2 == null) {
            return null;
        }
        String string = world2.getName();
        if (string == null) {
            return null;
        }
        CuboidArea.ChunkRef chunkRef = new CuboidArea.ChunkRef(location);
        if (!chunkHoloRangeExtra.containsKey(string)) {
            return null;
        }
        Map<CuboidArea.ChunkRef, Set<CMIHologram>> map = chunkHoloRangeExtra.get(string);
        if (!map.containsKey(chunkRef)) {
            return null;
        }
        for (CMIHologram cMIHologram : map.get(chunkRef)) {
            if (cMIHologram == null || !cMIHologram.getLocation().toString().equals(location.toString())) continue;
            return cMIHologram;
        }
        return null;
    }

    public Set<CMIHologram> getAllInRangeByLoc(Location location) {
        CopyOnWriteArraySet<CMIHologram> copyOnWriteArraySet = new CopyOnWriteArraySet<CMIHologram>();
        if (location == null) {
            return copyOnWriteArraySet;
        }
        World world2 = location.getWorld();
        if (world2 == null) {
            return copyOnWriteArraySet;
        }
        String string = world2.getName();
        if (string == null) {
            return copyOnWriteArraySet;
        }
        CuboidArea.ChunkRef chunkRef = new CuboidArea.ChunkRef(location);
        if (!chunkHoloRange.containsKey(string)) {
            return copyOnWriteArraySet;
        }
        Map<CuboidArea.ChunkRef, Set<CMIHologram>> map = chunkHoloRange.get(string);
        if (!map.containsKey(chunkRef)) {
            return copyOnWriteArraySet;
        }
        for (CMIHologram cMIHologram : new HashSet(map.get(chunkRef))) {
            if (cMIHologram == null || !cMIHologram.getArea().containsLoc(location)) continue;
            copyOnWriteArraySet.add(cMIHologram);
        }
        return copyOnWriteArraySet;
    }

    public Set<CMIHologram> getAllInRangeByLocExtra(Location location) {
        CopyOnWriteArraySet<CMIHologram> copyOnWriteArraySet = new CopyOnWriteArraySet<CMIHologram>();
        if (location == null) {
            return copyOnWriteArraySet;
        }
        World world2 = location.getWorld();
        if (world2 == null) {
            return copyOnWriteArraySet;
        }
        String string = world2.getName();
        if (string == null) {
            return copyOnWriteArraySet;
        }
        CuboidArea.ChunkRef chunkRef = new CuboidArea.ChunkRef(location);
        if (!chunkHoloRangeExtra.containsKey(string)) {
            return copyOnWriteArraySet;
        }
        Map<CuboidArea.ChunkRef, Set<CMIHologram>> map = chunkHoloRangeExtra.get(string);
        if (!map.containsKey(chunkRef)) {
            return copyOnWriteArraySet;
        }
        for (CMIHologram cMIHologram : new HashSet(map.get(chunkRef))) {
            if (cMIHologram == null || !cMIHologram.getAreaExtra().containsLoc(location)) continue;
            copyOnWriteArraySet.add(cMIHologram);
        }
        return copyOnWriteArraySet;
    }

    public void handleHoloUpdates(Player player, Location location) {
        playerFutureBatcher.computeIfAbsent(player.getUniqueId(), uUID -> new CMIFutureBatcher(1)).addBatch(CMIScheduler.runTaskAsynchronously((JavaPlugin)this.plugin, () -> {
            Set<CMIHologram> set = playerNearHoloUpdate.get(player.getUniqueId());
            Set<CMIHologram> set2 = this.getAllInRangeByLoc(location);
            HashSet<CMIHologram> hashSet = new HashSet<CMIHologram>();
            HashSet<CMIHologram> hashSet2 = new HashSet<CMIHologram>();
            if (set != null) {
                for (CMIHologram object2 : set) {
                    if (set2.contains(object2)) continue;
                    hashSet.add(object2);
                }
                for (CMIHologram cMIHologram : set2) {
                    if (set.contains(cMIHologram)) continue;
                    hashSet2.add(cMIHologram);
                }
            } else {
                hashSet2.addAll(set2);
            }
            playerNearHoloUpdate.put(player.getUniqueId(), set2);
            for (CMIHologram cMIHologram : hashSet) {
                Object object = CompletableFuture.runAsync(() -> {
                    cMIHologram.removeLastHoloInRange(player.getUniqueId());
                    this.removeNearHolo(player.getUniqueId(), cMIHologram);
                });
                playerFutureBatcher.get(player.getUniqueId()).addBatch((CompletableFuture<?>)object);
            }
            CMIUser cMIUser = CMIUser.getUser(player);
            if (cMIUser != null) {
                boolean bl = cMIUser.getOptionState(PlayerOption.visibleHolograms);
                for (Object object : hashSet2) {
                    if (((CMIHologram)object).isRequiresPermission() && (!((CMIHologram)object).isRequiresPermission() || !PermissionsManager.CMIPerm.hologram_$1.hasPermission((CommandSender)player, ((CMIHologram)object).getName().toLowerCase())) || !bl && (bl || ((CMIHologram)object).isSaveToFile())) continue;
                    ((CMIHologram)object).addLastHoloInRange(player.getUniqueId());
                    this.addNearHolo(player.getUniqueId(), (CMIHologram)object);
                }
            }
            this.handleHoloRangeUpdates(player, location);
        }));
    }

    public void handleHoloRangeUpdates(Player player, Location location) {
        Set<CMIHologram> set = playerNearHoloExtra.get(player.getUniqueId());
        Set<CMIHologram> set2 = this.getAllInRangeByLocExtra(location);
        HashSet<CMIHologram> hashSet = new HashSet<CMIHologram>();
        HashSet<CMIHologram> hashSet2 = new HashSet<CMIHologram>();
        if (set != null) {
            for (CMIHologram cMIHologram : set) {
                if (set2.contains(cMIHologram)) continue;
                hashSet.add(cMIHologram);
            }
            for (CMIHologram cMIHologram : set2) {
                if (set.contains(cMIHologram)) continue;
                hashSet2.add(cMIHologram);
            }
        } else {
            hashSet2.addAll(set2);
        }
        playerNearHoloExtra.put(player.getUniqueId(), set2);
        for (CMIHologram cMIHologram : hashSet) {
            CompletableFuture<Void> completableFuture = CompletableFuture.runAsync(() -> {
                cMIHologram.removeLastHoloInRangeExtra(player.getUniqueId());
                this.removeNearHoloExtra(player.getUniqueId(), cMIHologram);
            });
            playerFutureBatcher.get(player.getUniqueId()).addBatch(completableFuture);
        }
        boolean bl = CMIUser.getUser(player).getOptionState(PlayerOption.visibleHolograms);
        for (CMIHologram cMIHologram : hashSet2) {
            if (cMIHologram.isRequiresPermission() && (!cMIHologram.isRequiresPermission() || !PermissionsManager.CMIPerm.hologram_$1.hasPermission((CommandSender)player, cMIHologram.getName().toLowerCase())) || !bl && (bl || cMIHologram.isSaveToFile())) continue;
            cMIHologram.addLastHoloInRangeExtra(player.getUniqueId());
            this.addNearHoloExtra(player.getUniqueId(), cMIHologram);
        }
    }

    public void loadConfig() {
        ConfigReader configReader = this.plugin.getConfigManager().getConfig();
        configReader.addComment("Holograms.CheckInterval", new String[]{"Defines in milliseconds how often to check if player entered holograms trigger area", "Bigger numbers can help slightly lower server load", "This is not essential to keep in low numbers"});
        this.HoloRangeCheckInterval = configReader.get("Holograms.CheckInterval", 2000);
        configReader.addComment("Holograms.Defaults.viewRange", new String[]{"Default value for hologram view range", "This defines from how far holograms will appear for the player or when they will disapear"});
        defaultViewRange = CMINumber.clamp((int)configReader.get("Holograms.Defaults.viewRange", 16), (int)1, (int)128);
        configReader.addComment("Holograms.Defaults.updateRange", new String[]{"Default value for hologram update range", "This defines how close player should get for hologram to start updating its text", "Keep it at reasoble numbers as there is no point to update hologram across map"});
        defaultUpdateRange = CMINumber.clamp((int)configReader.get("Holograms.Defaults.updateRange", 8), (int)0, (int)128);
        configReader.addComment("Holograms.Defaults.updateRange", new String[]{"Defines default update interval", "Bigger this number is better performance we will have"});
        defaultUpdateInterval = configReader.get("Holograms.Defaults.updateInterval", Double.valueOf(0.0));
        defaultUpdateInterval = defaultUpdateInterval < 0.0 ? 0.0 : defaultUpdateInterval;
        configReader.addComment("Holograms.Defaults.pageChangeInterval", new String[]{"Defines default page change interval", "When value is set to 0 or lower, pages will not be changed"});
        defaultpageChangeInterval = configReader.get("Holograms.Defaults.pageChangeInterval", Double.valueOf(0.0));
        defaultpageChangeInterval = defaultpageChangeInterval < 0.0 ? 0.0 : defaultpageChangeInterval;
        configReader.addComment("Holograms.Defaults.placeUp", new String[]{"Defines if we should place lines up from starting position or down"});
        defaultsPlaceUp = configReader.get("Holograms.Defaults.placeUp", Boolean.valueOf(true));
        new CMIDisplay(null, null);
    }

    public void reload() {
        this.stop();
        this.load();
    }

    public void load() {
        Long l = System.currentTimeMillis();
        if (!CMIModule.holograms.isEnabled()) {
            return;
        }
        for (CMIHologram object2 : holograms.values()) {
            object2.stop();
            object2.hide();
        }
        PacketHandler.clearFakeEntities();
        holograms.clear();
        chunkHoloRange.clear();
        chunkHoloRangeExtra.clear();
        this.plugin.safeRenameFile(this.fileName.toLowerCase(), "Saves" + File.separator + this.fileName);
        File file = new File(this.plugin.getDataFolder(), "Saves" + File.separator + this.fileName);
        if (!file.exists()) {
            try {
                file.createNewFile();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return;
        }
        try {
            new ConfigReader(file);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        YamlConfiguration yamlConfiguration = null;
        try {
            yamlConfiguration = YamlConfiguration.loadConfiguration((File)file);
        }
        catch (Throwable set) {
            set.printStackTrace();
            return;
        }
        if (yamlConfiguration.getKeys(false).isEmpty()) {
            return;
        }
        Set set = yamlConfiguration.getKeys(false);
        for (String string : set) {
            if (!yamlConfiguration.isString(String.valueOf(string) + ".Loc")) continue;
            try {
                CMILocation throwable = this.plugin.getPlayerManager().convertStringToLocation(yamlConfiguration.getString(String.valueOf(string) + ".Loc"));
                if (throwable == null) continue;
                List<String> list2 = new ArrayList<String>();
                if (yamlConfiguration.isList(String.valueOf(string) + ".Lines")) {
                    list2 = yamlConfiguration.getStringList(String.valueOf(string) + ".Lines");
                }
                CMIHologram cMIHologram = new CMIHologram(string, throwable);
                cMIHologram.makePersistent();
                cMIHologram.setLines(list2);
                if (yamlConfiguration.isBoolean(String.valueOf(string) + ".Enabled")) {
                    if (yamlConfiguration.getBoolean(String.valueOf(string) + ".Enabled")) {
                        cMIHologram.enable();
                    } else {
                        cMIHologram.disable();
                    }
                }
                if (yamlConfiguration.isInt(String.valueOf(string) + ".Interval")) {
                    cMIHologram.setUpdateIntervalSec(yamlConfiguration.getInt(String.valueOf(string) + ".Interval"));
                }
                if (yamlConfiguration.isDouble(String.valueOf(string) + ".Interval")) {
                    cMIHologram.setUpdateIntervalSec(yamlConfiguration.getDouble(String.valueOf(string) + ".Interval"));
                }
                if (yamlConfiguration.isDouble(String.valueOf(string) + ".LOSInterval")) {
                    cMIHologram.setLOSInterval(yamlConfiguration.getDouble(String.valueOf(string) + ".LOSInterval"));
                }
                if (yamlConfiguration.isDouble(String.valueOf(string) + ".PageInterval")) {
                    cMIHologram.setPageChangeIntervalSec(yamlConfiguration.getDouble(String.valueOf(string) + ".PageInterval"));
                }
                if (yamlConfiguration.isString(String.valueOf(string) + ".Group")) {
                    cMIHologram.setGroup(yamlConfiguration.getString(String.valueOf(string) + ".Group"));
                }
                if (yamlConfiguration.isBoolean(String.valueOf(string) + ".NewDisplay")) {
                    cMIHologram.setNewDisplayMethod(yamlConfiguration.getBoolean(String.valueOf(string) + ".NewDisplay"));
                }
                if (yamlConfiguration.isInt(String.valueOf(string) + ".RangeExtra")) {
                    cMIHologram.setShowRange(yamlConfiguration.getInt(String.valueOf(string) + ".RangeExtra"));
                }
                if (yamlConfiguration.isInt(String.valueOf(string) + ".Range")) {
                    cMIHologram.setUpdateRange(yamlConfiguration.getInt(String.valueOf(string) + ".Range"));
                }
                if (yamlConfiguration.isDouble(String.valueOf(string) + ".Spacing")) {
                    cMIHologram.setSpacing(yamlConfiguration.getDouble(String.valueOf(string) + ".Spacing"));
                }
                if (yamlConfiguration.isDouble(String.valueOf(string) + ".SpacingIcon")) {
                    cMIHologram.setIconSpacing(yamlConfiguration.getDouble(String.valueOf(string) + ".SpacingIcon"));
                }
                if (yamlConfiguration.isBoolean(String.valueOf(string) + ".DownOrner")) {
                    cMIHologram.setDownOrder(yamlConfiguration.getBoolean(String.valueOf(string) + ".DownOrner"));
                }
                if (yamlConfiguration.isBoolean(String.valueOf(string) + ".ShowParticles")) {
                    cMIHologram.setShowParticle(yamlConfiguration.getBoolean(String.valueOf(string) + ".ShowParticles"));
                }
                if (yamlConfiguration.isBoolean(String.valueOf(string) + ".HoverParticles.ShowHover")) {
                    cMIHologram.setShowHoverParticle(yamlConfiguration.getBoolean(String.valueOf(string) + ".HoverParticles.ShowHover"));
                }
                if (yamlConfiguration.isBoolean(String.valueOf(string) + ".HoverParticles.Stabilize")) {
                    cMIHologram.setStabilizedHoverParticles(yamlConfiguration.getBoolean(String.valueOf(string) + ".HoverParticles.Stabilize"));
                }
                if (yamlConfiguration.isDouble(String.valueOf(string) + ".HoverParticles.Spacing")) {
                    cMIHologram.setParticleSpacing(yamlConfiguration.getDouble(String.valueOf(string) + ".HoverParticles.Spacing"));
                }
                if (yamlConfiguration.isInt(String.valueOf(string) + ".HoverParticles.Count")) {
                    cMIHologram.setParticleCount(yamlConfiguration.getInt(String.valueOf(string) + ".HoverParticles.Count"));
                }
                if (yamlConfiguration.isDouble(String.valueOf(string) + ".HoverParticles.ExtraHeight")) {
                    cMIHologram.setExtraParticleHeight(yamlConfiguration.getDouble(String.valueOf(string) + ".HoverParticles.ExtraHeight"));
                }
                if (yamlConfiguration.isDouble(String.valueOf(string) + ".HoverParticles.ExtraWidth")) {
                    cMIHologram.setExtraParticleWidth(yamlConfiguration.getDouble(String.valueOf(string) + ".HoverParticles.ExtraWidth"));
                }
                if (yamlConfiguration.isDouble(String.valueOf(string) + ".HoverParticles.OffsetX")) {
                    cMIHologram.setParticleOffsetX(yamlConfiguration.getDouble(String.valueOf(string) + ".HoverParticles.OffsetX"));
                }
                if (yamlConfiguration.isDouble(String.valueOf(string) + ".HoverParticles.OffsetY")) {
                    cMIHologram.setParticleOffsetY(yamlConfiguration.getDouble(String.valueOf(string) + ".HoverParticles.OffsetY"));
                }
                if (yamlConfiguration.isString(String.valueOf(string) + ".HoverParticles.Effect")) {
                    cMIHologram.setHoverEffect(CMIEffectManager.CMIParticle.getCMIParticle((String)yamlConfiguration.getString(String.valueOf(string) + ".HoverParticles.Effect")));
                }
                if (yamlConfiguration.isBoolean(String.valueOf(string) + ".RequiresPermission")) {
                    cMIHologram.setPermissionRequirement(yamlConfiguration.getBoolean(String.valueOf(string) + ".RequiresPermission"));
                }
                if (yamlConfiguration.isBoolean(String.valueOf(string) + ".Interactable")) {
                    cMIHologram.setInteractable(yamlConfiguration.getBoolean(String.valueOf(string) + ".Interactable"));
                }
                if (yamlConfiguration.isBoolean(String.valueOf(string) + ".NewMethod")) {
                    cMIHologram.setNewIneractionMethod(yamlConfiguration.getBoolean(String.valueOf(string) + ".NewMethod"));
                }
                if (yamlConfiguration.isBoolean(String.valueOf(string) + ".ND.AutoPage")) {
                    cMIHologram.setAutoPagination(yamlConfiguration.getBoolean(String.valueOf(string) + ".ND.AutoPage"));
                }
                if (yamlConfiguration.isInt(String.valueOf(string) + ".ND.AutoPageOffset")) {
                    cMIHologram.setAutoPaginationOffset(yamlConfiguration.getInt(String.valueOf(string) + ".ND.AutoPageOffset"));
                }
                if (yamlConfiguration.isString(String.valueOf(string) + ".ND.Bill")) {
                    cMIHologram.setBillboard(CMIBillboard.getByName(yamlConfiguration.getString(String.valueOf(string) + ".ND.Bill")));
                }
                if (yamlConfiguration.isString(String.valueOf(string) + ".ND.IBill")) {
                    cMIHologram.setIconBillboard(CMIBillboard.getByName(yamlConfiguration.getString(String.valueOf(string) + ".ND.IBill")));
                }
                if (yamlConfiguration.isString(String.valueOf(string) + ".ND.Align")) {
                    cMIHologram.setTextAlignment(CMITextAlignment.getByName(yamlConfiguration.getString(String.valueOf(string) + ".ND.Align")));
                }
                if (yamlConfiguration.isInt(String.valueOf(string) + ".ND.TAlpha")) {
                    cMIHologram.setTextAlpha(yamlConfiguration.getInt(String.valueOf(string) + ".ND.TAlpha"));
                }
                if (yamlConfiguration.isInt(String.valueOf(string) + ".ND.BAlpha")) {
                    cMIHologram.setBackgroundAlpha(yamlConfiguration.getInt(String.valueOf(string) + ".ND.BAlpha"));
                }
                if (yamlConfiguration.isBoolean(String.valueOf(string) + ".ND.Shadow")) {
                    cMIHologram.setShadowed(yamlConfiguration.getBoolean(String.valueOf(string) + ".ND.Shadow"));
                }
                if (yamlConfiguration.isBoolean(String.valueOf(string) + ".ND.FadeIn")) {
                    cMIHologram.setFadeInAnimation(yamlConfiguration.getBoolean(String.valueOf(string) + ".ND.FadeIn"));
                }
                if (yamlConfiguration.isInt(String.valueOf(string) + ".ND.Yaw")) {
                    cMIHologram.setYaw(yamlConfiguration.getInt(String.valueOf(string) + ".ND.Yaw"));
                }
                if (yamlConfiguration.isInt(String.valueOf(string) + ".ND.Pitch")) {
                    cMIHologram.setPitch(yamlConfiguration.getInt(String.valueOf(string) + ".ND.Pitch"));
                }
                if (yamlConfiguration.isBoolean(String.valueOf(string) + ".ND.Double")) {
                    cMIHologram.setDoubleSided(yamlConfiguration.getBoolean(String.valueOf(string) + ".ND.Double"));
                }
                if (yamlConfiguration.isString(String.valueOf(string) + ".ND.BColor")) {
                    cMIHologram.setBackgroundColor(CMIChatColor.getColor((String)yamlConfiguration.getString(String.valueOf(string) + ".ND.BColor")));
                }
                if (yamlConfiguration.isDouble(String.valueOf(string) + ".ND.ScaleW")) {
                    cMIHologram.setScaleW(yamlConfiguration.getDouble(String.valueOf(string) + ".ND.ScaleW"));
                }
                if (yamlConfiguration.isDouble(String.valueOf(string) + ".ND.ScaleH")) {
                    cMIHologram.setScaleH(yamlConfiguration.getDouble(String.valueOf(string) + ".ND.ScaleH"));
                }
                if (yamlConfiguration.isInt(String.valueOf(string) + ".ND.SL")) {
                    cMIHologram.setSkyLevel(yamlConfiguration.getInt(String.valueOf(string) + ".ND.SL"));
                }
                if (yamlConfiguration.isInt(String.valueOf(string) + ".ND.BL")) {
                    cMIHologram.setBlockLevel(yamlConfiguration.getInt(String.valueOf(string) + ".ND.BL"));
                }
                if (yamlConfiguration.isDouble(String.valueOf(string) + ".ND.IScale")) {
                    cMIHologram.setIconScale(yamlConfiguration.getDouble(String.valueOf(string) + ".ND.IScale"));
                }
                if (yamlConfiguration.isInt(String.valueOf(string) + ".ND.IPitch")) {
                    cMIHologram.setIconPitch(yamlConfiguration.getInt(String.valueOf(string) + ".ND.IPitch"));
                }
                if (yamlConfiguration.isInt(String.valueOf(string) + ".ND.IYaw")) {
                    cMIHologram.setIconYaw(yamlConfiguration.getInt(String.valueOf(string) + ".ND.IYaw"));
                }
                if (yamlConfiguration.isDouble(String.valueOf(string) + ".ND.IXOff")) {
                    cMIHologram.setIconOffsetX((float)yamlConfiguration.getDouble(String.valueOf(string) + ".ND.IXOff"));
                }
                if (yamlConfiguration.isBoolean(String.valueOf(string) + ".BigButton")) {
                    cMIHologram.setBigButton(yamlConfiguration.getBoolean(String.valueOf(string) + ".BigButton"));
                }
                if (yamlConfiguration.isList(String.valueOf(string) + ".Commands")) {
                    cMIHologram.setCommands(yamlConfiguration.getStringList(String.valueOf(string) + ".Commands"));
                }
                this.addHologram(cMIHologram, false);
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
        this.plugin.loadMessage(holograms.size(), "holograms", System.currentTimeMillis() - l);
        CMIScheduler.runTaskLater((JavaPlugin)this.plugin, () -> {
            for (Player player : Bukkit.getOnlinePlayers()) {
                this.plugin.getHologramManager().handleHoloUpdates(player, player.getLocation());
            }
        }, (long)20L);
    }

    public void save() {
        if (this.saveScheduler != null) {
            return;
        }
        this.saveScheduler = CMIScheduler.runTaskLater((JavaPlugin)this.plugin, () -> {
            this.saveHolograms();
            this.saveScheduler = null;
        }, (long)300L);
    }

    private void saveHolograms() {
        if (!CMIModule.holograms.isEnabled()) {
            return;
        }
        File file = new File(this.plugin.getDataFolder(), "Saves" + File.separator + this.fileName);
        if (!file.exists()) {
            try {
                file.createNewFile();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            return;
        }
        ConfigReader configReader = null;
        try {
            configReader = new ConfigReader(file);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (configReader == null) {
            return;
        }
        for (Map.Entry entry : configReader.getC().getValues(false).entrySet()) {
            configReader.getC().set((String)entry.getKey(), null);
        }
        for (Map.Entry<Object, Object> entry : holograms.entrySet()) {
            CMIHologram cMIHologram = (CMIHologram)entry.getValue();
            if (!cMIHologram.isSaveToFile()) continue;
            String string = cMIHologram.getName().replace(".", "_");
            configReader.get(String.valueOf(string) + ".Loc", this.plugin.getPlayerManager().convertLocToStringShort(cMIHologram.getLocation()));
            configReader.get(String.valueOf(string) + ".Enabled", cMIHologram.isEnabled() ? null : Boolean.valueOf(false));
            if (cMIHologram.getUpdateIntervalSec() > 0.0) {
                configReader.get(String.valueOf(string) + ".Interval", Double.valueOf(cMIHologram.getUpdateIntervalSec()));
            }
            if (cMIHologram.getLOSupdateIntervalSec() > 0.0) {
                configReader.get(String.valueOf(string) + ".LOSInterval", Double.valueOf(cMIHologram.getLOSupdateIntervalSec()));
            }
            configReader.get(String.valueOf(string) + ".ShowParticles", cMIHologram.isShowParticle() ? null : Boolean.valueOf(false));
            if (cMIHologram.getPageChangeIntervalSec() > 0.0) {
                configReader.get(String.valueOf(string) + ".PageInterval", Double.valueOf(cMIHologram.getPageChangeIntervalSec()));
            } else {
                configReader.set(String.valueOf(string) + ".PageInterval", null);
            }
            configReader.get(String.valueOf(string) + ".HoverParticles.ShowHover", cMIHologram.isShowHoverParticle() ? null : Boolean.valueOf(false));
            if (!cMIHologram.getHoverEffect().getParticle().equals((Object)CMIEffectManager.CMIParticle.SMALL_SMOKE)) {
                configReader.get(String.valueOf(string) + ".HoverParticles.Effect", cMIHologram.getHoverEffect().getParticle().toString());
            } else {
                configReader.set(String.valueOf(string) + ".HoverParticles.Effect", null);
            }
            configReader.get(String.valueOf(string) + ".HoverParticles.Spacing", cMIHologram.getParticleSpacing() != 0.0 ? Double.valueOf(cMIHologram.getParticleSpacing()) : null);
            configReader.get(String.valueOf(string) + ".HoverParticles.Count", cMIHologram.getParticleCount() != 1 ? Integer.valueOf(cMIHologram.getParticleCount()) : null);
            configReader.get(String.valueOf(string) + ".HoverParticles.Stabilize", cMIHologram.isStabilizedHoverParticles() ? Boolean.valueOf(cMIHologram.isStabilizedHoverParticles()) : null);
            configReader.get(String.valueOf(string) + ".HoverParticles.ExtraHeight", cMIHologram.getExtraParticleHeight() != 0.0 ? Double.valueOf(cMIHologram.getExtraParticleHeight()) : null);
            configReader.get(String.valueOf(string) + ".HoverParticles.ExtraWidth", cMIHologram.getExtraParticleWidth() != 0.0 ? Double.valueOf(cMIHologram.getExtraParticleWidth()) : null);
            configReader.get(String.valueOf(string) + ".HoverParticles.OffsetX", cMIHologram.getParticleOffsetX() != 0.0 ? Double.valueOf(cMIHologram.getParticleOffsetX()) : null);
            configReader.get(String.valueOf(string) + ".HoverParticles.OffsetY", cMIHologram.getParticleOffsetY() != 0.0 ? Double.valueOf(cMIHologram.getParticleOffsetY()) : null);
            configReader.get(String.valueOf(string) + ".Group", cMIHologram.getGroup());
            configReader.get(String.valueOf(string) + ".Range", cMIHologram.getUpdateRange());
            configReader.get(String.valueOf(string) + ".RangeExtra", cMIHologram.getShowRange());
            configReader.get(String.valueOf(string) + ".Spacing", cMIHologram.getSpacing() != 0.24 ? Double.valueOf((double)((int)(cMIHologram.getSpacing() * 100.0)) / 100.0) : null);
            configReader.get(String.valueOf(string) + ".SpacingIcon", cMIHologram.getIconSpacing() != 0.5 ? Double.valueOf((double)((int)(cMIHologram.getIconSpacing() * 100.0)) / 100.0) : null);
            configReader.get(String.valueOf(string) + ".DownOrner", cMIHologram.isDownOrder().equals(defaultsPlaceUp) ? null : cMIHologram.isDownOrder());
            configReader.get(String.valueOf(string) + ".Interactable", cMIHologram.isInteractable() ? Boolean.valueOf(true) : null);
            configReader.get(String.valueOf(string) + ".NewMethod", cMIHologram.isNewIneractionMethod() ? null : Boolean.valueOf(false));
            configReader.get(String.valueOf(string) + ".NewDisplay", cMIHologram.isNewDisplayMethod() ? Boolean.valueOf(true) : null);
            if (cMIHologram.isNewDisplayMethod()) {
                if (cMIHologram.isAutoPagination()) {
                    configReader.get(String.valueOf(string) + ".ND.AutoPage", Boolean.valueOf(cMIHologram.isAutoPagination()));
                }
                if (cMIHologram.getAutoPaginationOffset() > 0) {
                    configReader.get(String.valueOf(string) + ".ND.AutoPageOffset", cMIHologram.getAutoPaginationOffset());
                }
                configReader.get(String.valueOf(string) + ".ND.Bill", cMIHologram.getBillboard().toString());
                configReader.get(String.valueOf(string) + ".ND.Align", cMIHologram.getTextAlignment().equals((Object)CMITextAlignment.CENTER) ? null : cMIHologram.getTextAlignment().toString());
                configReader.get(String.valueOf(string) + ".ND.TAlpha", cMIHologram.getTextAlpha() != 230 ? Integer.valueOf(cMIHologram.getTextAlpha()) : null);
                if (!cMIHologram.isShadowed()) {
                    configReader.get(String.valueOf(string) + ".ND.Shadow", Boolean.valueOf(cMIHologram.isShadowed()));
                }
                configReader.get(String.valueOf(string) + ".ND.FadeIn", cMIHologram.isFadeInAnimation() ? Boolean.valueOf(cMIHologram.isFadeInAnimation()) : null);
                if (cMIHologram.getYaw() != 0) {
                    configReader.get(String.valueOf(string) + ".ND.Yaw", cMIHologram.getBillboard().equals((Object)CMIBillboard.FIXED) ? Integer.valueOf(cMIHologram.getYaw()) : null);
                }
                if (cMIHologram.getPitch() != 0) {
                    configReader.get(String.valueOf(string) + ".ND.Pitch", cMIHologram.getBillboard().equals((Object)CMIBillboard.FIXED) ? Integer.valueOf(cMIHologram.getPitch()) : null);
                }
                if (cMIHologram.isDoubleSided()) {
                    configReader.get(String.valueOf(string) + ".ND.Double", cMIHologram.getBillboard().equals((Object)CMIBillboard.FIXED) ? Boolean.valueOf(cMIHologram.isDoubleSided()) : null);
                }
                configReader.get(String.valueOf(string) + ".ND.BColor", cMIHologram.getBackgroundColor().equals(CMIChatColor.BLACK) ? null : (cMIHologram.getBackgroundColor().getName() == null ? cMIHologram.getBackgroundColor().getFormatedHex() : "{#" + cMIHologram.getBackgroundColor().getName() + "}"));
                configReader.get(String.valueOf(string) + ".ND.BAlpha", cMIHologram.getBackgroundAlpha() != 125 ? Integer.valueOf(cMIHologram.getBackgroundAlpha()) : null);
                configReader.get(String.valueOf(string) + ".ND.ScaleW", cMIHologram.getScaleW() != 1.0 ? Double.valueOf(cMIHologram.getScaleW()) : null);
                configReader.get(String.valueOf(string) + ".ND.ScaleH", cMIHologram.getScaleH() != 1.0 ? Double.valueOf(cMIHologram.getScaleH()) : null);
                configReader.get(String.valueOf(string) + ".ND.SL", cMIHologram.getSkyLevel() != -1 ? Integer.valueOf(cMIHologram.getSkyLevel()) : null);
                configReader.get(String.valueOf(string) + ".ND.BL", cMIHologram.getBlockLevel() != -1 ? Integer.valueOf(cMIHologram.getBlockLevel()) : null);
                configReader.get(String.valueOf(string) + ".ND.IScale", cMIHologram.getIconScale() != 1.0 ? Double.valueOf(cMIHologram.getIconScale()) : null);
                configReader.get(String.valueOf(string) + ".ND.IPitch", cMIHologram.getIconPitch() != 0 ? Integer.valueOf(cMIHologram.getIconPitch()) : null);
                configReader.get(String.valueOf(string) + ".ND.IYaw", cMIHologram.getIconYaw() != 0 ? Integer.valueOf(cMIHologram.getIconYaw()) : null);
                configReader.get(String.valueOf(string) + ".ND.IXOff", cMIHologram.getIconOffsetX() != 0.0f ? Double.valueOf(cMIHologram.getIconOffsetX()) : null);
            }
            if (!cMIHologram.isRequiresPermission()) {
                configReader.set(String.valueOf(string) + ".RequiresPermission", null);
            } else {
                configReader.get(String.valueOf(string) + ".RequiresPermission", Boolean.valueOf(cMIHologram.isRequiresPermission()));
            }
            if (cMIHologram.isBigButton()) {
                configReader.set(String.valueOf(string) + ".BigButton", null);
            } else {
                configReader.get(String.valueOf(string) + ".BigButton", Boolean.valueOf(cMIHologram.isBigButton()));
            }
            configReader.get(String.valueOf(string) + ".Commands", cMIHologram.getCommands().isEmpty() ? null : cMIHologram.getCommands());
            configReader.get(String.valueOf(string) + ".Lines", cMIHologram.getLines());
        }
        configReader.save();
    }

    public void removeLastHologramInRange(UUID uUID) {
        Set<CMIHologram> set;
        HashMap<String, CMIHologram> hashMap = new HashMap<String, CMIHologram>(holograms);
        for (Map.Entry<String, CMIHologram> entry : hashMap.entrySet()) {
            Set<UUID> set2 = entry.getValue().getLastHoloInRange();
            if (set2 == null) continue;
            entry.getValue().removeFromCache(uUID);
            set2.remove(uUID);
            if (!set2.isEmpty()) continue;
            entry.getValue().stop();
        }
        Set<CMIHologram> set3 = playerNearHoloUpdate.remove(uUID);
        if (set3 != null) {
            for (CMIHologram cMIHologram : set3) {
                cMIHologram.removeFromCache(uUID);
            }
        }
        if ((set = playerNearHoloExtra.remove(uUID)) != null) {
            for (CMIHologram cMIHologram : set) {
                cMIHologram.removeFromCache(uUID);
            }
        }
    }

    public void hideHoloForAllPlayers(CMIHologram cMIHologram) {
        Set<UUID> set = cMIHologram.getLastHoloInRangeExtra();
        if (set == null) {
            return;
        }
        for (UUID uUID : set) {
            cMIHologram.hide(uUID);
        }
        cMIHologram.stop();
    }

    public void resetHoloForAllPlayers(CMIHologram cMIHologram) {
        Set<UUID> set = cMIHologram.getLastHoloInRange();
        if (set == null) {
            return;
        }
        for (UUID uUID : set) {
            cMIHologram.hide(uUID);
        }
        cMIHologram.stop();
        this.addPlayersNearHolo(cMIHologram, true);
    }

    public void addPlayersNearHolo(CMIHologram cMIHologram, boolean bl) {
        for (Player player : Bukkit.getOnlinePlayers()) {
            if (!cMIHologram.getArea().containsLoc(player.getLocation()) || cMIHologram.isRequiresPermission() && !PermissionsManager.CMIPerm.hologram_$1.hasPermission((CommandSender)player, 5000L, cMIHologram.getName().toLowerCase())) continue;
            cMIHologram.addLastHoloInRange(player.getUniqueId());
            this.recheckInteractableHolograms(player);
            if (!bl) continue;
            cMIHologram.update(player);
        }
        cMIHologram.recheckTaskers();
    }

    public void addPlayersNearHoloExtra(CMIHologram cMIHologram, boolean bl) {
        for (Player player : Bukkit.getOnlinePlayers()) {
            if (!cMIHologram.getAreaExtra().containsLoc(player.getLocation()) || cMIHologram.isRequiresPermission() && !PermissionsManager.CMIPerm.hologram_$1.hasPermission((CommandSender)player, 5000L, cMIHologram.getName().toLowerCase())) continue;
            cMIHologram.addLastHoloInRangeExtra(player.getUniqueId());
            if (!bl) continue;
            cMIHologram.update(player);
        }
        cMIHologram.recheckTaskers();
    }

    public HashMap<String, CMIHologram> getHolograms() {
        return holograms;
    }

    public List<CMIHologram> getHologramsByDistance(Location location) {
        Map.Entry<String, CMIHologram> entry2;
        HashMap hashMap = new HashMap();
        ArrayList<CMIHologram> arrayList = new ArrayList<CMIHologram>();
        for (Map.Entry<String, CMIHologram> entry2 : holograms.entrySet()) {
            if (entry2.getValue().getWorld() == null) continue;
            if (!location.getWorld().equals(((CMIHologram)entry2.getValue()).getWorld())) {
                arrayList.add((CMIHologram)entry2.getValue());
                continue;
            }
            if (!((CMIHologram)entry2.getValue()).isSaveToFile() && !((CMIHologram)entry2.getValue()).isShowWhenNotPersistent()) continue;
            hashMap.put(entry2.getValue(), (int)CMI.getInstance().getUtilManager().getDistance(((CMIHologram)entry2.getValue()).getArea().getMiddleLocation(), location));
        }
        hashMap = this.plugin.getSortingManager().sortByValueObject(hashMap);
        entry2 = new ArrayList();
        for (Map.Entry entry3 : hashMap.entrySet()) {
            entry2.add((CMIHologram)entry3.getKey());
        }
        if (!arrayList.isEmpty()) {
            entry2.addAll(arrayList);
        }
        return entry2;
    }

    public void removeHolo(CMIHologram cMIHologram) {
        holograms.remove(cMIHologram.getName().toLowerCase());
        this.hideHoloForAllPlayers(cMIHologram);
        cMIHologram.getLastHoloInRange().clear();
        cMIHologram.getLastHoloInRangeExtra().clear();
        this.removeChunkRecords(cMIHologram);
        for (Map.Entry<UUID, Set<CMIHologram>> entry : playerNearHoloUpdate.entrySet()) {
            entry.getValue().remove(cMIHologram);
        }
        for (Map.Entry<UUID, Set<CMIHologram>> entry : playerNearHoloExtra.entrySet()) {
            entry.getValue().remove(cMIHologram);
        }
        cMIHologram.disable();
        if (cMIHologram.isSaveToFile()) {
            this.save();
        }
    }

    public int getHoloCheckInterval() {
        return this.HoloRangeCheckInterval;
    }

    public boolean isNearHolo(UUID uUID) {
        Set<CMIHologram> set = playerNearHoloUpdate.get(uUID);
        return set != null && !set.isEmpty();
    }

    public boolean rechecInteractableHolograms(UUID uUID) {
        return this.recheckInteractableHolograms(CMIUser.getOnlinePlayer(uUID));
    }

    public boolean recheckInteractableHolograms(Player player) {
        if (player == null) {
            return false;
        }
        Set<CMIHologram> set = playerNearHoloUpdate.get(player.getUniqueId());
        if (set == null || set.isEmpty()) {
            return true;
        }
        boolean bl = false;
        for (CMIHologram cMIHologram : set) {
            if (!cMIHologram.isInteractable()) continue;
            bl = true;
            break;
        }
        if (bl && inPacketListener.contains(player.getUniqueId()) || !bl && !inPacketListener.contains(player.getUniqueId())) {
            return true;
        }
        try {
            if (!bl) {
                CMIScheduler.runTask((JavaPlugin)this.plugin, () -> this.plugin.getPacketInjector().removePlayer(player));
                inPacketListener.remove(player.getUniqueId());
            } else {
                CMIScheduler.runTask((JavaPlugin)this.plugin, () -> this.plugin.getPacketInjector().addPlayer(player));
                inPacketListener.add(player.getUniqueId());
            }
        }
        catch (Error | Exception throwable) {
            // empty catch block
        }
        return true;
    }

    public void addNearHolo(UUID uUID, CMIHologram cMIHologram) {
        Set<CMIHologram> set = playerNearHoloUpdate.get(uUID);
        if (set == null) {
            set = new CopyOnWriteArraySet<CMIHologram>();
        }
        set.add(cMIHologram);
        playerNearHoloUpdate.put(uUID, set);
        this.rechecInteractableHolograms(uUID);
    }

    public void removeNearHolo(UUID uUID, CMIHologram cMIHologram) {
        Set<CMIHologram> set = playerNearHoloUpdate.get(uUID);
        if (set == null) {
            return;
        }
        set.remove(cMIHologram);
        this.recheckInteractableHolograms(CMIUser.getOnlinePlayer(uUID));
        playerNearHoloUpdate.put(uUID, set);
    }

    public void addNearHoloExtra(UUID uUID, CMIHologram cMIHologram) {
        Set<CMIHologram> set = playerNearHoloExtra.get(uUID);
        if (set == null) {
            set = new CopyOnWriteArraySet<CMIHologram>();
        }
        set.add(cMIHologram);
        playerNearHoloExtra.put(uUID, set);
        cMIHologram.update(CMIUser.getOnlinePlayer(uUID));
    }

    public void removeNearHoloExtra(UUID uUID, CMIHologram cMIHologram) {
        Set<CMIHologram> set = playerNearHoloExtra.get(uUID);
        if (set == null) {
            return;
        }
        set.remove(cMIHologram);
        cMIHologram.removeFromCache(uUID);
        playerNearHoloExtra.put(uUID, set);
    }

    public void openGui(Player player, CMIHologram cMIHologram) {
        HologramGUIEditor.openGui(player, cMIHologram);
    }

    public void hideAllHolograms() {
        for (Map.Entry<String, CMIHologram> entry : holograms.entrySet()) {
            this.hideHoloForAllPlayers(entry.getValue());
        }
    }

    public Set<CMIHologram> getPlayerActiveHolograms(UUID uUID) {
        return playerNearHoloUpdate.get(uUID);
    }

    public void addAimAt(UUID uUID, String string, CMIVector3D cMIVector3D) {
        this.aimingAt.put(uUID, new CMIAiming(string, cMIVector3D));
    }

    public void addAimAt(UUID uUID, String string, CMIVector3D cMIVector3D, double d) {
        this.aimingAt.put(uUID, new CMIAiming(string, cMIVector3D, d));
    }

    public CMIAiming getAimAt(UUID uUID) {
        return this.aimingAt.get(uUID);
    }

    public void removeAimAt(UUID uUID) {
        this.aimingAt.remove(uUID);
    }

    public CMIHologramLine getPrevPageSection() {
        if (this.prevPage == null) {
            this.prevPage = new CMIHologramLine(CMILC.getIM(hologram.class, "prevPage", new Object[0]));
            this.setPrevPageLength(CMIFont.getWidth(this.prevPage.getText().replace(" ", "_")));
        }
        return this.prevPage;
    }

    public void setPrevPageSection(CMIHologramLine cMIHologramLine) {
        this.prevPage = cMIHologramLine;
    }

    public CMIHologramLine getNextPageSection() {
        if (this.nextPage == null) {
            this.nextPage = new CMIHologramLine(CMILC.getIM(hologram.class, "nextPage", new Object[0]));
            this.setNextPageLength(CMIFont.getWidth(this.nextPage.getText().replace(" ", "_")));
        }
        return this.nextPage;
    }

    public void setNextPageSection(CMIHologramLine cMIHologramLine) {
        this.nextPage = cMIHologramLine;
    }

    public int getPrevPageLength() {
        return this.prevPageLength;
    }

    public void setPrevPageLength(int n) {
        this.prevPageLength = n;
    }

    public int getNextPageLength() {
        return this.nextPageLength;
    }

    public void setNextPageLength(int n) {
        this.nextPageLength = n;
    }

    public Set<CMIHologram> getHologramsByGroup(String string) {
        if (string == null) {
            return new HashSet<CMIHologram>();
        }
        HashSet<CMIHologram> hashSet = new HashSet<CMIHologram>();
        for (CMIHologram cMIHologram : holograms.values()) {
            if (cMIHologram.getGroup() == null || !cMIHologram.getGroup().equals(string)) continue;
            hashSet.add(cMIHologram);
        }
        return hashSet;
    }

    public Optional<Location> getCenterLocation(Set<CMIHologram> set) {
        ArrayList<CMILocation> arrayList = new ArrayList<CMILocation>();
        for (CMIHologram object2 : set) {
            arrayList.add(object2.getLocation());
        }
        if (arrayList.isEmpty()) {
            return Optional.empty();
        }
        String string = ((Location)arrayList.get(0)).getWorld().getName();
        List<Location> list2 = arrayList.stream().filter(location -> location.getWorld().getName().equals(string)).toList();
        if (list2.isEmpty()) {
            return Optional.empty();
        }
        double d = list2.stream().mapToDouble(Location::getX).average().orElse(0.0);
        double d2 = list2.stream().mapToDouble(Location::getY).average().orElse(0.0);
        double d3 = list2.stream().mapToDouble(Location::getZ).average().orElse(0.0);
        return Optional.of(new Location(((Location)list2.get(0)).getWorld(), d, d2, d3));
    }

    public Location getCenterOfGroup(String string) {
        Set<CMIHologram> set = CMI.getInstance().getHologramManager().getHologramsByGroup(string);
        if (set.isEmpty()) {
            return null;
        }
        Optional<Location> optional = this.getCenterLocation(set);
        if (!optional.isPresent()) {
            return null;
        }
        return optional.get();
    }

    public void relocateHologramGroup(Location location, String string) {
        Set<CMIHologram> set = CMI.getInstance().getHologramManager().getHologramsByGroup(string);
        if (set.isEmpty()) {
            return;
        }
        Optional<Location> optional = this.getCenterLocation(set);
        if (!optional.isPresent()) {
            return;
        }
        Vector vector = optional.get().toVector();
        for (CMIHologram cMIHologram : set) {
            Vector vector2 = cMIHologram.getLocation().toVector().subtract(vector);
            Location location2 = location.clone();
            location2.add(vector2);
            cMIHologram.setLoc(location2);
            CMI.getInstance().getHologramManager().resetHoloForAllPlayers(cMIHologram);
        }
        CMI.getInstance().getHologramManager().save();
    }

    public void shiftHologramGroup(Vector vector, String string) {
        Set<CMIHologram> set = CMI.getInstance().getHologramManager().getHologramsByGroup(string);
        if (set.isEmpty()) {
            return;
        }
        for (CMIHologram cMIHologram : set) {
            cMIHologram.setLoc(cMIHologram.getLocation().add(vector));
            CMI.getInstance().getHologramManager().resetHoloForAllPlayers(cMIHologram);
        }
        CMI.getInstance().getHologramManager().save();
    }

    public void rotateHologramYawGroup(int n, String string, Location location) {
        Set<CMIHologram> set = CMI.getInstance().getHologramManager().getHologramsByGroup(string);
        if (set.isEmpty()) {
            return;
        }
        for (CMIHologram cMIHologram : set) {
            CMILocation cMILocation = cMIHologram.getLocation();
            Vector vector = cMILocation.toVector().subtract(location.toVector());
            if (vector.lengthSquared() == 0.0) {
                cMIHologram.setYaw((cMIHologram.getYaw() + n + 360) % 360);
                CMI.getInstance().getHologramManager().resetHoloForAllPlayers(cMIHologram);
                continue;
            }
            double d = Math.toRadians(n);
            double d2 = Math.cos(d);
            double d3 = Math.sin(d);
            double d4 = vector.getX() * d2 - vector.getZ() * d3;
            double d5 = vector.getX() * d3 + vector.getZ() * d2;
            vector.setX(d4).setZ(d5);
            Location location2 = location.clone().add(vector);
            cMIHologram.setLoc(location2);
            cMIHologram.setYaw((cMIHologram.getYaw() + n + 360) % 360);
            CMI.getInstance().getHologramManager().resetHoloForAllPlayers(cMIHologram);
        }
        CMI.getInstance().getHologramManager().save();
    }

    class CMIAiming {
        private String name;
        private CMIVector3D pos;
        private CMIPEAnimationInterface eff;
        private double localX = 0.0;

        public CMIAiming(String string, CMIVector3D cMIVector3D) {
            this.name = string;
            this.pos = cMIVector3D;
        }

        public CMIAiming(String string, CMIVector3D cMIVector3D, double d) {
            this.name = string;
            this.pos = cMIVector3D;
            this.localX = d;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String string) {
            this.name = string;
        }

        public CMIVector3D getPos() {
            return this.pos;
        }

        public void setPos(CMIVector3D cMIVector3D) {
            this.pos = cMIVector3D;
        }

        public CMIPEAnimationInterface getEff() {
            return this.eff;
        }

        public void setEff(CMIPEAnimationInterface cMIPEAnimationInterface) {
            this.eff = cMIPEAnimationInterface;
        }

        public double getLocalX() {
            return this.localX;
        }
    }
}

