/*
 * Decompiled with CFR 0.152.
 */
package com.Zrips.CMI.Modules.Future;

import java.util.Queue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentLinkedQueue;

public class CMIFutureBatcher {
    private Queue<CompletableFuture<?>> queue = new ConcurrentLinkedQueue();
    private boolean running = false;
    private int delayBetweenBatches = 0;
    private CompletableFuture<Void> queueFuture;

    public CMIFutureBatcher() {
    }

    public CMIFutureBatcher(int n) {
        this.delayBetweenBatches = n;
    }

    public CompletableFuture<?> addBatch(CompletableFuture<?> completableFuture) {
        this.queue.add(completableFuture);
        this.processQueue();
        return completableFuture;
    }

    public void processQueue() {
        if (this.running && !this.queue.isEmpty()) {
            return;
        }
        this.running = true;
        this.queueFuture = CompletableFuture.runAsync(() -> {
            while (!this.queue.isEmpty()) {
                CompletableFuture<?> completableFuture = this.queue.poll();
                if (completableFuture == null) break;
                if (this.delayBetweenBatches > 0) {
                    try {
                        Thread.sleep(this.delayBetweenBatches);
                    }
                    catch (InterruptedException interruptedException) {
                        interruptedException.printStackTrace();
                        Thread.currentThread().interrupt();
                    }
                }
                completableFuture.complete(null);
            }
            this.running = false;
        });
    }

    public int getDelayBetweenBatches() {
        return this.delayBetweenBatches;
    }

    public void setDelayBetweenBatches(int n) {
        this.delayBetweenBatches = n;
    }

    public void cancel() {
        if (this.queueFuture != null) {
            this.queueFuture.cancel(true);
        }
    }

    public int getQueueSize() {
        return this.queue.size();
    }

    public boolean isRunning() {
        return this.running;
    }
}

