/*
 * Decompiled with CFR 0.152.
 */
package com.Zrips.CMI.Modules.EventActions;

import com.Zrips.CMI.CMI;
import com.Zrips.CMI.Containers.CMIUser;
import com.Zrips.CMI.Modules.EventActions.EventActionManager;
import com.Zrips.CMI.Modules.Worlds.CMIWorld;
import com.Zrips.CMI.events.CMIPlayerBanEvent;
import com.Zrips.CMI.events.CMIPvPEndEventAsync;
import com.Zrips.CMI.events.CMIPvPStartEventAsync;
import java.util.HashMap;
import java.util.UUID;
import net.Zrips.CMILib.Version.Schedulers.CMIScheduler;
import net.Zrips.CMILib.Version.Version;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.player.PlayerBedEnterEvent;
import org.bukkit.event.player.PlayerBedLeaveEvent;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerGameModeChangeEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerKickEvent;
import org.bukkit.event.player.PlayerLevelChangeEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerPortalEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.plugin.java.JavaPlugin;

public class EventActionListener
implements Listener {
    private CMI plugin;
    HashMap<UUID, Long> last = new HashMap();

    public EventActionListener(CMI cMI) {
        this.plugin = cMI;
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void PlayerPortalEvent(PlayerPortalEvent playerPortalEvent) {
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void CMIPvPEndEventAsync(CMIPvPEndEventAsync cMIPvPEndEventAsync) {
        if (!EventActionManager.eventAction.pvpend.isEnabled()) {
            return;
        }
        CMIScheduler.runTask((JavaPlugin)this.plugin, () -> this.plugin.getEventActionManager().performCommands(EventActionManager.eventAction.pvpend, cMIPvPEndEventAsync.getPlayer()));
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void CMIPvPStartEventAsync(CMIPvPStartEventAsync cMIPvPStartEventAsync) {
        if (!EventActionManager.eventAction.pvpstart.isEnabled()) {
            return;
        }
        CMIScheduler.runTask((JavaPlugin)this.plugin, () -> this.plugin.getEventActionManager().performCommands(EventActionManager.eventAction.pvpstart, cMIPvPStartEventAsync.getPlayer()));
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void PlayerFirstJoinEvent(PlayerJoinEvent playerJoinEvent) {
        if (!EventActionManager.eventAction.firstJoinServer.isEnabled()) {
            return;
        }
        if (playerJoinEvent.getPlayer().hasPlayedBefore()) {
            return;
        }
        CMIScheduler.runTaskLater((JavaPlugin)this.plugin, () -> this.plugin.getEventActionManager().performCommands(EventActionManager.eventAction.firstJoinServer, playerJoinEvent.getPlayer()), (long)1L);
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void PlayerJoinEvent(PlayerJoinEvent playerJoinEvent) {
        if (!EventActionManager.eventAction.joinServer.isEnabled()) {
            return;
        }
        if (!playerJoinEvent.getPlayer().hasPlayedBefore()) {
            return;
        }
        this.plugin.getEventActionManager().performCommands(EventActionManager.eventAction.joinServer, playerJoinEvent.getPlayer());
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void PlayerDeathEvent(PlayerDeathEvent playerDeathEvent) {
        if (!EventActionManager.eventAction.playerDeath.isEnabled()) {
            return;
        }
        Player player = playerDeathEvent.getEntity().getKiller();
        this.plugin.getEventActionManager().performCommands(EventActionManager.eventAction.playerDeath, playerDeathEvent.getEntity(), player);
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void PlayerKillPlayerEvent(PlayerDeathEvent playerDeathEvent) {
        if (!EventActionManager.eventAction.playerKillPlayer.isEnabled()) {
            return;
        }
        Player player = playerDeathEvent.getEntity().getKiller();
        if (player == null) {
            return;
        }
        this.plugin.getEventActionManager().performCommands(EventActionManager.eventAction.playerKillPlayer, playerDeathEvent.getEntity(), player);
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void PlayerRespawnEvent(PlayerRespawnEvent playerRespawnEvent) {
        if (!EventActionManager.eventAction.playerRespawn.isEnabled()) {
            return;
        }
        if (Version.isCurrentEqualOrHigher((Version)Version.v1_20_R1) && playerRespawnEvent.getRespawnReason() != null && playerRespawnEvent.getRespawnReason().equals((Object)PlayerRespawnEvent.RespawnReason.END_PORTAL)) {
            return;
        }
        CMIScheduler.runTaskLater((JavaPlugin)this.plugin, () -> this.plugin.getEventActionManager().performCommands(EventActionManager.eventAction.playerRespawn, playerRespawnEvent.getPlayer()), (long)1L);
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void PlayerQuitEvent(PlayerQuitEvent playerQuitEvent) {
        if (!EventActionManager.eventAction.quitServer.isEnabled()) {
            return;
        }
        this.plugin.getEventActionManager().performCommands(EventActionManager.eventAction.quitServer, playerQuitEvent.getPlayer());
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void PlayerTeleportEvent(PlayerTeleportEvent playerTeleportEvent) {
        if (!EventActionManager.eventAction.playerPreWorldChange.isEnabled() && !EventActionManager.eventAction.playerTeleport.isEnabled()) {
            return;
        }
        if (playerTeleportEvent.getTo() == null) {
            return;
        }
        if (!playerTeleportEvent.getFrom().getWorld().equals(playerTeleportEvent.getTo().getWorld())) {
            this.plugin.getEventActionManager().performCommands(EventActionManager.eventAction.playerPreWorldChange, playerTeleportEvent.getPlayer());
        }
        this.plugin.getEventActionManager().performCommands(EventActionManager.eventAction.playerTeleport, playerTeleportEvent.getPlayer());
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void PlayerBedEnterEvent(PlayerBedEnterEvent playerBedEnterEvent) {
        if (!EventActionManager.eventAction.bedEnter.isEnabled()) {
            return;
        }
        this.plugin.getEventActionManager().performCommands(EventActionManager.eventAction.bedEnter, playerBedEnterEvent.getPlayer());
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void PlayerBedLeaveEvent(PlayerBedLeaveEvent playerBedLeaveEvent) {
        if (!EventActionManager.eventAction.bedLeave.isEnabled()) {
            return;
        }
        this.plugin.getEventActionManager().performCommands(EventActionManager.eventAction.bedLeave, playerBedLeaveEvent.getPlayer());
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void PlayerVoidFallEvent(PlayerMoveEvent playerMoveEvent) {
        if (!EventActionManager.eventAction.voidFall.isEnabled()) {
            return;
        }
        if (playerMoveEvent.getTo() == null) {
            return;
        }
        if (playerMoveEvent.getTo().getY() >= (double)(CMIWorld.getMinHeight(playerMoveEvent.getPlayer().getWorld()) - 10)) {
            return;
        }
        if (this.last.get(playerMoveEvent.getPlayer().getUniqueId()) == null || this.last.get(playerMoveEvent.getPlayer().getUniqueId()) + 1000L < System.currentTimeMillis()) {
            this.last.put(playerMoveEvent.getPlayer().getUniqueId(), System.currentTimeMillis());
            this.plugin.getEventActionManager().performCommands(EventActionManager.eventAction.voidFall, playerMoveEvent.getPlayer());
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void PlayerChangedWorldEvent(PlayerChangedWorldEvent playerChangedWorldEvent) {
        if (!EventActionManager.eventAction.playerWorldChange.isEnabled()) {
            return;
        }
        this.plugin.getEventActionManager().performCommands(EventActionManager.eventAction.playerWorldChange, playerChangedWorldEvent.getPlayer());
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void PlayerGameModeChangeEvent(PlayerGameModeChangeEvent playerGameModeChangeEvent) {
        if (!EventActionManager.eventAction.playerGameModeChange.isEnabled()) {
            return;
        }
        CMIScheduler.runTaskLater((JavaPlugin)this.plugin, () -> this.plugin.getEventActionManager().performCommands(EventActionManager.eventAction.playerGameModeChange, playerGameModeChangeEvent.getPlayer()), (long)1L);
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void PlayerKickEvent(PlayerKickEvent playerKickEvent) {
        if (!EventActionManager.eventAction.playerKick.isEnabled()) {
            return;
        }
        this.plugin.getEventActionManager().performCommands(EventActionManager.eventAction.playerKick, playerKickEvent.getPlayer());
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void CMIPlayerBanEvent(CMIPlayerBanEvent cMIPlayerBanEvent) {
        if (!EventActionManager.eventAction.playerBan.isEnabled()) {
            return;
        }
        this.plugin.getEventActionManager().performCommands(EventActionManager.eventAction.playerBan, CMIUser.getOnlinePlayer(cMIPlayerBanEvent.getBanned()));
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void PlayerLevelChangeEvent(PlayerLevelChangeEvent playerLevelChangeEvent) {
        if (!EventActionManager.eventAction.playerLevelChange.isEnabled()) {
            return;
        }
        CMIScheduler.runTaskLater((JavaPlugin)this.plugin, () -> this.plugin.getEventActionManager().performCommands(EventActionManager.eventAction.playerLevelChange, playerLevelChangeEvent.getPlayer()), (long)1L);
    }
}

