/*
 * Decompiled with CFR 0.152.
 */
package com.Zrips.CMI.Modules.Economy;

import com.Zrips.CMI.CMI;
import net.Zrips.CMILib.Messages.CMIMessages;
import net.milkbowl.vault.economy.Economy;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.RegisteredServiceProvider;

public class VaultManager {
    private CMI plugin;
    private String version = "";
    private boolean supportsCmi = false;
    private Economy economy = null;

    public VaultManager(CMI cMI) {
        this.plugin = cMI;
    }

    public EconomySetupResponse setupVault() {
        if (this.plugin.getServer().getPluginManager().getPlugin("Vault") == null) {
            return EconomySetupResponse.NoVault;
        }
        RegisteredServiceProvider registeredServiceProvider = this.plugin.getServer().getServicesManager().getRegistration(Economy.class);
        if (registeredServiceProvider == null) {
            CMIMessages.sendMessage((CommandSender)Bukkit.getConsoleSender(), (String)(ChatColor.RED + "[CMI] Vault was found but economy engine is missing. Use one from list provided in https://dev.bukkit.org/bukkit-plugins/vault/"));
            CMIMessages.sendMessage((CommandSender)Bukkit.getConsoleSender(), (String)(ChatColor.RED + "[CMI] Alternatively you can enable CMI economy in config.yml file"));
            return EconomySetupResponse.NoVaultEconomy;
        }
        Plugin plugin = this.plugin.getServer().getPluginManager().getPlugin("Vault");
        this.version = plugin.getDescription().getVersion();
        if (plugin.getDescription().getDescription().contains("CMIEconomy")) {
            this.supportsCmi = true;
        }
        this.economy = (Economy)registeredServiceProvider.getProvider();
        if (this.economy.getName().equalsIgnoreCase("CMIEconomy")) {
            return EconomySetupResponse.CMI;
        }
        return this.economy != null ? EconomySetupResponse.Vault : EconomySetupResponse.NoVaultEconomy;
    }

    public Economy getVaultEconomy() {
        return this.economy;
    }

    public boolean isVaultEnabled() {
        return this.economy != null;
    }

    public String format(Double d) {
        if (d == null) {
            return "0";
        }
        if (this.economy == null) {
            return String.valueOf(d);
        }
        return this.economy.format(d.doubleValue());
    }

    public String getVersion() {
        return this.version;
    }

    public boolean isSupportsCmi() {
        return this.supportsCmi;
    }

    public static enum EconomySetupResponse {
        Vault,
        NoVault,
        NoVaultEconomy,
        CMI;

    }
}

