/*
 * Decompiled with CFR 0.152.
 */
package com.Zrips.CMI.Modules.Economy;

import com.Zrips.CMI.CMI;
import com.Zrips.CMI.Containers.CMIUser;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import net.milkbowl.vault.economy.AbstractEconomy;
import net.milkbowl.vault.economy.Economy;
import net.milkbowl.vault.economy.EconomyResponse;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.server.PluginDisableEvent;
import org.bukkit.event.server.PluginEnableEvent;
import org.bukkit.plugin.Plugin;

public class VaultHandler
extends AbstractEconomy {
    public CMI cmi;
    Plugin plugin;
    private final String name = "CMIEconomy";

    public VaultHandler(CMI cMI) {
        if (this.cmi == null) {
            this.cmi = cMI;
            EconomyServerListener economyServerListener = new EconomyServerListener(this);
            Bukkit.getServer().getPluginManager().registerEvents((Listener)economyServerListener, (Plugin)cMI);
        }
    }

    public VaultHandler(Plugin plugin) {
        Plugin plugin2;
        this.plugin = plugin;
        Bukkit.getServer().getPluginManager().registerEvents((Listener)new EconomyServerListener(this), plugin);
        if (this.cmi == null && (plugin2 = plugin.getServer().getPluginManager().getPlugin("CMI")) != null && plugin2.isEnabled()) {
            this.cmi = (CMI)plugin2;
            CMI.getInstance().consoleMessage(String.format("[%s][Economy] %s hooked.", plugin.getDescription().getName(), "CMIEconomy"));
        }
    }

    public void setCMI(CMI cMI) {
        this.cmi = cMI;
    }

    public boolean isEnabled() {
        return this.cmi != null;
    }

    public String getName() {
        return "CMIEconomy";
    }

    public String TrA(double d) {
        DecimalFormat decimalFormat = CMI.getInstance().getEconomyManager().getMoneyFormat();
        return decimalFormat.format(d);
    }

    public String format(double d) {
        return this.TrA(d);
    }

    public String currencyNameSingular() {
        return "";
    }

    public String currencyNamePlural() {
        return "";
    }

    public double getBalance(String string) {
        CMIUser cMIUser = this.cmi.getPlayerManager().getUser(string, false, true, false, true);
        return VaultHandler.getAccountBalance(cMIUser);
    }

    public double getBalance(OfflinePlayer offlinePlayer) {
        CMIUser cMIUser = this.cmi.getPlayerManager().getUser(offlinePlayer);
        return VaultHandler.getAccountBalance(cMIUser);
    }

    private static double getAccountBalance(CMIUser cMIUser) {
        if (cMIUser == null) {
            return 0.0;
        }
        return cMIUser.getBalance();
    }

    public EconomyResponse withdrawPlayer(String string, double d) {
        CMIUser cMIUser = this.cmi.getPlayerManager().getUser(string, false, true, false, true);
        return VaultHandler.withdraw(cMIUser, d);
    }

    public EconomyResponse withdrawPlayer(OfflinePlayer offlinePlayer, double d) {
        CMIUser cMIUser = this.cmi.getPlayerManager().getUser(offlinePlayer);
        return VaultHandler.withdraw(cMIUser, d);
    }

    private static EconomyResponse withdraw(CMIUser cMIUser, double d) {
        if (cMIUser == null) {
            return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.FAILURE, "Account doesn't exist");
        }
        if (d < 0.0) {
            return new EconomyResponse(0.0, cMIUser.getBalance().doubleValue(), EconomyResponse.ResponseType.FAILURE, "Cannot withdraw negative funds");
        }
        if (cMIUser.hasMoney(d)) {
            Double d2 = cMIUser.getBalance();
            cMIUser.withdraw(d);
            return new EconomyResponse(d, cMIUser.getBalance().doubleValue(), EconomyResponse.ResponseType.SUCCESS, "");
        }
        return new EconomyResponse(0.0, cMIUser.getBalance().doubleValue(), EconomyResponse.ResponseType.FAILURE, "Insufficient funds");
    }

    public EconomyResponse depositPlayer(String string, double d) {
        CMIUser cMIUser = this.cmi.getPlayerManager().getUser(string, false, true, false, true);
        return VaultHandler.deposit(cMIUser, d);
    }

    public EconomyResponse depositPlayer(OfflinePlayer offlinePlayer, double d) {
        CMIUser cMIUser = this.cmi.getPlayerManager().getUser(offlinePlayer);
        return VaultHandler.deposit(cMIUser, d);
    }

    private static EconomyResponse deposit(CMIUser cMIUser, double d) {
        if (cMIUser == null) {
            return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.FAILURE, "Account doesn't exist");
        }
        if (d < 0.0) {
            return new EconomyResponse(0.0, cMIUser.getBalance().doubleValue(), EconomyResponse.ResponseType.FAILURE, "Cannot deposit negative funds");
        }
        Double d2 = cMIUser.getBalance();
        cMIUser.deposit(d);
        return new EconomyResponse(d, cMIUser.getBalance().doubleValue(), EconomyResponse.ResponseType.SUCCESS, "");
    }

    public boolean has(String string, double d) {
        return this.getBalance(string) >= d;
    }

    public boolean has(OfflinePlayer offlinePlayer, double d) {
        return this.getBalance(offlinePlayer) >= d;
    }

    public EconomyResponse createBank(String string, String string2) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "CMI currently don't support bank's");
    }

    public EconomyResponse createBank(String string, OfflinePlayer offlinePlayer) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "CMI currently don't support bank's");
    }

    public EconomyResponse deleteBank(String string) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "CMI currently don't support bank's");
    }

    public EconomyResponse bankHas(String string, double d) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "CMI currently don't support bank's");
    }

    public EconomyResponse bankWithdraw(String string, double d) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "CMI currently don't support bank's");
    }

    public EconomyResponse bankDeposit(String string, double d) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "CMI currently don't support bank's");
    }

    public EconomyResponse isBankOwner(String string, String string2) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "CMI currently don't support bank's");
    }

    public EconomyResponse isBankOwner(String string, OfflinePlayer offlinePlayer) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "CMI currently don't support bank's");
    }

    public EconomyResponse isBankMember(String string, String string2) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "CMI currently don't support bank's");
    }

    public EconomyResponse isBankMember(String string, OfflinePlayer offlinePlayer) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "CMI currently don't support bank's");
    }

    public EconomyResponse bankBalance(String string) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "CMI currently don't support bank's");
    }

    public List<String> getBanks() {
        return new ArrayList<String>();
    }

    public boolean hasBankSupport() {
        return false;
    }

    public boolean hasAccount(String string) {
        return CMI.getInstance().getPlayerManager().getUser(string) != null;
    }

    public boolean hasAccount(OfflinePlayer offlinePlayer) {
        return CMI.getInstance().getPlayerManager().getUser(offlinePlayer) != null;
    }

    public boolean createPlayerAccount(String string) {
        if (this.hasAccount(string)) {
            return true;
        }
        return this.cmi.getPlayerManager().getUser(string, true, false, true, true) != null;
    }

    public boolean createPlayerAccount(OfflinePlayer offlinePlayer) {
        if (this.hasAccount(offlinePlayer)) {
            return true;
        }
        return this.cmi.getPlayerManager().getUser(offlinePlayer) != null;
    }

    public int fractionalDigits() {
        return -1;
    }

    public boolean hasAccount(String string, String string2) {
        return this.hasAccount(string);
    }

    public boolean hasAccount(OfflinePlayer offlinePlayer, String string) {
        return this.hasAccount(offlinePlayer);
    }

    public double getBalance(String string, String string2) {
        return this.getBalance(string);
    }

    public double getBalance(OfflinePlayer offlinePlayer, String string) {
        return this.getBalance(offlinePlayer);
    }

    public boolean has(String string, String string2, double d) {
        return this.has(string, d);
    }

    public boolean has(OfflinePlayer offlinePlayer, String string, double d) {
        return this.has(offlinePlayer, d);
    }

    public EconomyResponse withdrawPlayer(String string, String string2, double d) {
        return this.withdrawPlayer(string, d);
    }

    public EconomyResponse withdrawPlayer(OfflinePlayer offlinePlayer, String string, double d) {
        return this.withdrawPlayer(offlinePlayer, d);
    }

    public EconomyResponse depositPlayer(String string, String string2, double d) {
        return this.depositPlayer(string, d);
    }

    public EconomyResponse depositPlayer(OfflinePlayer offlinePlayer, String string, double d) {
        return this.depositPlayer(offlinePlayer, d);
    }

    public boolean createPlayerAccount(String string, String string2) {
        return this.createPlayerAccount(string);
    }

    public boolean createPlayerAccount(OfflinePlayer offlinePlayer, String string) {
        return this.createPlayerAccount(offlinePlayer);
    }

    public class EconomyServerListener
    implements Listener {
        VaultHandler economy = null;

        public EconomyServerListener(VaultHandler vaultHandler2) {
            this.economy = vaultHandler2;
        }

        @EventHandler(priority=EventPriority.MONITOR)
        public void onPluginEnable(PluginEnableEvent pluginEnableEvent) {
            Plugin plugin;
            if (this.economy.cmi == null && (plugin = pluginEnableEvent.getPlugin()).getDescription().getName().equals("CMI")) {
                CMI cMI = (CMI)plugin;
                if (cMI.getEconomyManager().isEnabled()) {
                    this.economy.cmi = cMI;
                    CMI.getInstance().consoleMessage("&2" + String.format("[%s][Economy] %s hooked.", VaultHandler.this.plugin.getDescription().getName(), this.economy.name));
                } else {
                    VaultHandler.this.plugin.getServer().getServicesManager().unregister(Economy.class, (Object)this.economy);
                    if (CMI.getInstance().getEconomyManager().getVaultManager() != null) {
                        CMI.getInstance().getEconomyManager().getVaultManager().setupVault();
                    }
                }
            }
        }

        @EventHandler(priority=EventPriority.MONITOR)
        public void onPluginDisable(PluginDisableEvent pluginDisableEvent) {
            if (this.economy.cmi != null && pluginDisableEvent.getPlugin().getDescription().getName().equals("CMI")) {
                try {
                    VaultHandler.this.plugin.getServer().getServicesManager().unregister(Economy.class, (Object)this.economy);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.economy.cmi = null;
                try {
                    CMI.getInstance().consoleMessage("&2" + String.format("[%s][Economy] %s unhooked.", VaultHandler.this.plugin.getDescription().getName(), this.economy.name));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }
}

