/*
 * Decompiled with CFR 0.152.
 */
package com.Zrips.CMI.Modules.Economy;

import com.Zrips.CMI.CMI;
import com.Zrips.CMI.Containers.CMIUser;
import com.Zrips.CMI.Modules.Economy.CMIEconomyAcount;
import com.Zrips.CMI.Modules.Economy.EconomyManager;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import net.milkbowl.vault.economy.EconomyResponse;
import org.bukkit.OfflinePlayer;

public class Economy {
    public static CMI plugin;
    private static final String ecoName = "CMIEconomy";

    public Economy(CMI cMI) {
        plugin = cMI;
    }

    public boolean isEnabled() {
        return plugin != null;
    }

    public static String getName() {
        return ecoName;
    }

    private static String TrA(double d) {
        String string = "###,###.###";
        if (plugin != null) {
            d = Math.floor(d * 100.0 + 0.5) / 100.0;
            String string2 = "" + d;
            EconomyManager.WorldGroup worldGroup = plugin.getEconomyManager().getDefaultGroup();
            if (worldGroup.isUseShortNumbers()) {
                string2 = CMIEconomyAcount.format(d, worldGroup.getShortNumbersSuffixes(), null);
                return worldGroup.getPlacing().replace("[money]", string2).replace("[symbol]", worldGroup.getCurrencySymbol());
            }
            try {
                DecimalFormat decimalFormat = CMI.getInstance().getEconomyManager().getMoneyFormat();
                string2 = decimalFormat.format(d);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return CMI.getInstance().getEconomyManager().getDefaultGroup().getPlacing().replace("[money]", string2).replace("[symbol]", plugin.getEconomyManager().getWorldGroup(null).getCurrencySymbol());
        }
        DecimalFormat decimalFormat = new DecimalFormat(string);
        return decimalFormat.format(d);
    }

    public static String format(double d) {
        return Economy.TrA(d);
    }

    public static String currencyNameSingular() {
        return "";
    }

    public static String currencyNamePlural() {
        return "";
    }

    public static double getBalance(String string) {
        if (plugin == null) {
            return 0.0;
        }
        if (plugin.getEconomyManager().isTownyAccount(string)) {
            CMIUser cMIUser = plugin.getPlayerManager().getUser(string, false, true, true, true);
            return Economy.getAccountBalance(cMIUser);
        }
        CMIUser cMIUser = plugin.getPlayerManager().getUser(string, false, true, false, true);
        return Economy.getAccountBalance(cMIUser);
    }

    public static double getBalance(OfflinePlayer offlinePlayer) {
        if (plugin == null) {
            return 0.0;
        }
        CMIUser cMIUser = plugin.getPlayerManager().getUser(offlinePlayer);
        return Economy.getAccountBalance(cMIUser);
    }

    private static double getAccountBalance(CMIUser cMIUser) {
        if (cMIUser == null) {
            return 0.0;
        }
        return cMIUser.getBalance();
    }

    public static EconomyResponse withdrawPlayer(String string, double d) {
        if (plugin == null) {
            return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.FAILURE, "Plugin is not loaded");
        }
        if (plugin.getEconomyManager().isTownyAccount(string)) {
            CMIUser cMIUser = plugin.getPlayerManager().getUser(string, false, true, true, true);
            return Economy.withdraw(cMIUser, d);
        }
        CMIUser cMIUser = plugin.getPlayerManager().getUser(string, false, true, false, true);
        return Economy.withdraw(cMIUser, d);
    }

    public static EconomyResponse withdrawPlayer(OfflinePlayer offlinePlayer, double d) {
        if (plugin == null) {
            return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.FAILURE, "Plugin is not loaded");
        }
        CMIUser cMIUser = plugin.getPlayerManager().getUser(offlinePlayer);
        return Economy.withdraw(cMIUser, d);
    }

    private static EconomyResponse withdraw(CMIUser cMIUser, double d) {
        if (cMIUser == null) {
            return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.FAILURE, "Account doesn't exist");
        }
        if (d < 0.0) {
            return new EconomyResponse(0.0, cMIUser.getBalance().doubleValue(), EconomyResponse.ResponseType.FAILURE, "Cannot withdraw negative funds");
        }
        if (cMIUser.hasMoney(d)) {
            cMIUser.withdraw(d);
            return new EconomyResponse(d, cMIUser.getBalance().doubleValue(), EconomyResponse.ResponseType.SUCCESS, "");
        }
        return new EconomyResponse(0.0, cMIUser.getBalance().doubleValue(), EconomyResponse.ResponseType.FAILURE, "Insufficient funds");
    }

    public static EconomyResponse depositPlayer(String string, double d) {
        if (plugin == null) {
            return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.FAILURE, "Plugin is not loaded");
        }
        if (plugin.getEconomyManager().isTownyAccount(string)) {
            CMIUser cMIUser = plugin.getPlayerManager().getUser(string, false, true, true, true);
            return Economy.deposit(cMIUser, d);
        }
        CMIUser cMIUser = plugin.getPlayerManager().getUser(string, false, true, false, true);
        return Economy.deposit(cMIUser, d);
    }

    public static EconomyResponse depositPlayer(OfflinePlayer offlinePlayer, double d) {
        if (plugin == null) {
            return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.FAILURE, "Plugin is not loaded");
        }
        CMIUser cMIUser = plugin.getPlayerManager().getUser(offlinePlayer);
        return Economy.deposit(cMIUser, d);
    }

    private static EconomyResponse deposit(CMIUser cMIUser, double d) {
        if (cMIUser == null) {
            return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.FAILURE, "Account doesn't exist");
        }
        if (d < 0.0) {
            return new EconomyResponse(0.0, cMIUser.getBalance().doubleValue(), EconomyResponse.ResponseType.FAILURE, "Cannot deposit negative funds");
        }
        Double d2 = cMIUser.getBalance();
        cMIUser.deposit(d);
        return new EconomyResponse(d, cMIUser.getBalance().doubleValue(), EconomyResponse.ResponseType.SUCCESS, "");
    }

    public static boolean has(String string, double d) {
        return Economy.getBalance(string) >= d;
    }

    public static boolean has(OfflinePlayer offlinePlayer, double d) {
        return Economy.getBalance(offlinePlayer) >= d;
    }

    public static EconomyResponse createBank(String string, String string2) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "CMI currently don't support bank's");
    }

    public static EconomyResponse createBank(String string, OfflinePlayer offlinePlayer) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "CMI currently don't support bank's");
    }

    public static EconomyResponse deleteBank(String string) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "CMI currently don't support bank's");
    }

    public static EconomyResponse bankHas(String string, double d) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "CMI currently don't support bank's");
    }

    public static EconomyResponse bankWithdraw(String string, double d) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "CMI currently don't support bank's");
    }

    public static EconomyResponse bankDeposit(String string, double d) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "CMI currently don't support bank's");
    }

    public static EconomyResponse isBankOwner(String string, String string2) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "CMI currently don't support bank's");
    }

    public static EconomyResponse isBankOwner(String string, OfflinePlayer offlinePlayer) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "CMI currently don't support bank's");
    }

    public static EconomyResponse isBankMember(String string, String string2) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "CMI currently don't support bank's");
    }

    public static EconomyResponse isBankMember(String string, OfflinePlayer offlinePlayer) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "CMI currently don't support bank's");
    }

    public static EconomyResponse bankBalance(String string) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "CMI currently don't support bank's");
    }

    public static List<String> getBanks() {
        return new ArrayList<String>();
    }

    public static boolean hasBankSupport() {
        return false;
    }

    public static boolean hasAccount(String string) {
        return plugin.getPlayerManager().getUser(string) != null;
    }

    public static boolean hasAccount(OfflinePlayer offlinePlayer) {
        return plugin.getPlayerManager().getUser(offlinePlayer) != null;
    }

    @Deprecated
    public static boolean createPlayerAccount(String string) {
        if (plugin == null) {
            return false;
        }
        if (Economy.hasAccount(string)) {
            return true;
        }
        CMIUser cMIUser = CMI.getInstance().getPlayerManager().getUser(string, true, false, true, true);
        return cMIUser != null;
    }

    public static boolean createPlayerAccount(OfflinePlayer offlinePlayer) {
        if (plugin == null) {
            return false;
        }
        return plugin.getPlayerManager().getUser(offlinePlayer) != null;
    }

    public static int fractionalDigits() {
        return -1;
    }

    public static boolean hasAccount(String string, String string2) {
        return Economy.hasAccount(string);
    }

    public static boolean hasAccount(OfflinePlayer offlinePlayer, String string) {
        return Economy.hasAccount(offlinePlayer);
    }

    public static double getBalance(String string, String string2) {
        return Economy.getBalance(string);
    }

    public static double getBalance(OfflinePlayer offlinePlayer, String string) {
        return Economy.getBalance(offlinePlayer);
    }

    public static boolean has(String string, String string2, double d) {
        return Economy.has(string, d);
    }

    public static boolean has(OfflinePlayer offlinePlayer, String string, double d) {
        return Economy.has(offlinePlayer, d);
    }

    public static EconomyResponse withdrawPlayer(String string, String string2, double d) {
        return Economy.withdrawPlayer(string, d);
    }

    public static EconomyResponse withdrawPlayer(OfflinePlayer offlinePlayer, String string, double d) {
        return Economy.withdrawPlayer(offlinePlayer, d);
    }

    public static EconomyResponse depositPlayer(String string, String string2, double d) {
        return Economy.depositPlayer(string, d);
    }

    public static EconomyResponse depositPlayer(OfflinePlayer offlinePlayer, String string, double d) {
        return Economy.depositPlayer(offlinePlayer, d);
    }

    public static boolean createPlayerAccount(String string, String string2) {
        return Economy.createPlayerAccount(string);
    }

    public static boolean createPlayerAccount(OfflinePlayer offlinePlayer, String string) {
        return Economy.createPlayerAccount(offlinePlayer);
    }
}

