/*
 * Decompiled with CFR 0.152.
 */
package com.Zrips.CMI.Modules.Economy;

import com.Zrips.CMI.CMI;
import com.Zrips.CMI.Containers.CMIUser;
import com.Zrips.CMI.Modules.Economy.EconomyManager;
import com.Zrips.CMI.events.CMIUserBalanceChangeEvent;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.Zrips.CMILib.Version.Schedulers.CMIScheduler;
import net.milkbowl.vault.economy.EconomyResponse;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.event.Event;
import org.bukkit.plugin.java.JavaPlugin;

public class CMIEconomyAcount {
    private Map<EconomyManager.WorldGroup, Double> balances = null;
    private CMIUser user = null;
    private int balTopPos = 0;
    private double lastKnownBalance = 0.0;

    public CMIEconomyAcount(CMIUser cMIUser) {
        this.user = cMIUser;
        this.balances = Collections.synchronizedMap(new HashMap());
        for (EconomyManager.WorldGroup worldGroup : CMI.getInstance().getEconomyManager().getWorldGroups()) {
            this.balances.put(worldGroup, null);
        }
    }

    public EconomyManager.WorldGroup getCurrentWorldGroup() {
        World world2 = this.user.getWorld();
        return world2 == null ? CMI.getInstance().getEconomyManager().getWorldGroup("CMIGlobal") : CMI.getInstance().getEconomyManager().getWorldGroup(world2.getName());
    }

    public String getCurrentWorldGroupName() {
        World world2 = this.user.getWorld();
        return world2 == null ? "CMIGlobal" : world2.getName();
    }

    public Double setBalance(double d) {
        return this.setBalance(CMI.getInstance().getEconomyManager().getDefaultGroup(), d, true, false);
    }

    public Double setBalance(EconomyManager.WorldGroup worldGroup, double d) {
        return this.setBalance(worldGroup, d, true, false);
    }

    public Double setBalance(EconomyManager.WorldGroup worldGroup, double d, boolean bl) {
        return this.setBalance(worldGroup, d, bl, false);
    }

    public Double setBalance(EconomyManager.WorldGroup worldGroup, double d, boolean bl, boolean bl2) {
        if (CMI.getInstance().isFullyLoaded()) {
            CMIEconomyAcount.fireEvent(this.user, this.balances.get(worldGroup) == null ? worldGroup.getStartingAmount() : this.balances.get(worldGroup), d, bl2 ? "setBalanceReload" : "setBalance", null);
        }
        Double d2 = this.balances.put(worldGroup, d);
        if (bl) {
            this.user.saveIfOffline();
        }
        return d2;
    }

    private static void fireEvent(CMIUser cMIUser, Double d, Double d2, String string, CMIUser cMIUser2) {
        if (!CMI.getInstance().isFullyLoaded()) {
            return;
        }
        CMIScheduler.runTaskAsynchronously((JavaPlugin)CMI.getInstance(), () -> {
            Bukkit.getServer().getPluginManager().callEvent((Event)new CMIUserBalanceChangeEvent(cMIUser, d, d2, string, cMIUser2));
            CMI.getInstance().getEconomyManager().moneyLog(cMIUser, cMIUser2, string != null && string.equalsIgnoreCase("setBalance") ? d : d2 - d, EconomyManager.CMIMoneyLogType.Unknown, string);
        });
    }

    public Double getBalance() {
        return this.getBalance(null);
    }

    private Double getVaultBalance() {
        if (!CMI.getInstance().getEconomyManager().isVaultEnabled()) {
            return 0.0;
        }
        if (CMI.getInstance().getEconomyManager().getVaultManager().getVaultEconomy().getName().equalsIgnoreCase("CMIEconomy")) {
            CMI.getInstance().consoleMessage("&cYou have disabled CMI economy durring server run, this causes issues. Please perform full server restart!");
            return 0.0;
        }
        if (Bukkit.getOfflinePlayer((UUID)this.user.getUniqueId()) == null) {
            return 0.0;
        }
        try {
            if (CMI.isShuttingDown()) {
                return this.lastKnownBalance;
            }
            if (!CMI.getInstance().getEconomyManager().getVaultManager().getVaultEconomy().hasAccount(Bukkit.getOfflinePlayer((UUID)this.user.getUniqueId()))) {
                return 0.0;
            }
            this.lastKnownBalance = CMI.getInstance().getEconomyManager().getVaultManager().getVaultEconomy().getBalance(Bukkit.getOfflinePlayer((UUID)this.user.getUniqueId()));
            return this.lastKnownBalance;
        }
        catch (RuntimeException runtimeException) {
            return 0.0;
        }
    }

    public Double getBalance(String string) {
        if (!CMI.getInstance().getEconomyManager().isEnabled()) {
            return this.getVaultBalance();
        }
        EconomyManager.WorldGroup worldGroup = CMI.getInstance().getEconomyManager().getDefaultGroup();
        Double d = this.balances.get(worldGroup);
        if (d == null) {
            if (this.user.isFakeAccount().booleanValue()) {
                this.balances.put(worldGroup, 0.0);
                return 0.0;
            }
            this.balances.put(worldGroup, worldGroup.getStartingAmount());
            return worldGroup.getStartingAmount();
        }
        return d;
    }

    public String getFormatedBalance() {
        return this.getFormatedBalance(null);
    }

    public String getFormatedBalance(boolean bl) {
        return this.getFormatedBalance(null, bl);
    }

    public String getFormatedBalance(String string) {
        return this.getFormatedBalance(string, false);
    }

    public String getFormatedBalance(String string, boolean bl) {
        if (!CMI.getInstance().getEconomyManager().isEnabled()) {
            if (CMI.getInstance().getEconomyManager().isVaultEnabled()) {
                if (CMI.getInstance().getEconomyManager().getVaultManager().getVaultEconomy().getName().equalsIgnoreCase("CMIEconomy")) {
                    CMI.getInstance().consoleMessage("&cYou have disabled CMI economy durring server run, this causes issues. Please perform full server restart!");
                    return String.valueOf(0.0);
                }
                if (this.user.getPlayer() == null) {
                    return CMI.getInstance().getEconomyManager().getVaultManager().getVaultEconomy().format(0.0);
                }
                try {
                    double d = CMI.getInstance().getEconomyManager().getVaultManager().getVaultEconomy().getBalance((OfflinePlayer)this.user.getPlayer());
                    return CMI.getInstance().getEconomyManager().getVaultManager().getVaultEconomy().format(d);
                }
                catch (Exception exception) {
                    return String.valueOf(0.0);
                }
            }
            return String.valueOf(0.0);
        }
        EconomyManager.WorldGroup worldGroup = CMI.getInstance().getEconomyManager().getDefaultGroup();
        Double d = this.balances.get(worldGroup);
        if (d == null) {
            this.balances.put(worldGroup, worldGroup.getStartingAmount());
            d = worldGroup.getStartingAmount();
        }
        d = Math.floor(d * 10000.0) / 10000.0;
        String string2 = String.valueOf(d);
        if (worldGroup.isUseShortNumbers() || bl) {
            string2 = CMIEconomyAcount.format(d, worldGroup.getShortNumbersSuffixes(), string);
            return worldGroup.getPlacing().replace("[money]", string2).replace("[symbol]", worldGroup.getCurrencySymbol());
        }
        try {
            DecimalFormat decimalFormat = CMI.getInstance().getEconomyManager().getMoneyFormat(string);
            string2 = decimalFormat.format(d);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return worldGroup.getPlacing().replace("[money]", string2).replace("[symbol]", worldGroup.getCurrencySymbol());
    }

    public static String format(double d, HashMap<Double, String> hashMap, String string) {
        Object object;
        int n = 0;
        double d2 = d;
        BigDecimal bigDecimal = BigDecimal.valueOf(d);
        BigDecimal bigDecimal2 = BigDecimal.valueOf(10.0);
        while (bigDecimal.doubleValue() >= 10.0) {
            ++n;
            bigDecimal = bigDecimal.divide(bigDecimal2);
        }
        BigDecimal bigDecimal3 = BigDecimal.valueOf(1.0);
        while (n > 0) {
            bigDecimal3 = bigDecimal3.multiply(bigDecimal2);
            --n;
        }
        while (bigDecimal3.doubleValue() > 1.0) {
            object = hashMap.get(bigDecimal3.doubleValue());
            if (object != null) {
                DecimalFormat decimalFormat = CMI.getInstance().getEconomyManager().getShortMoneyFormat();
                return String.valueOf(decimalFormat.format(bigDecimal.doubleValue())) + (String)object;
            }
            bigDecimal = bigDecimal.multiply(bigDecimal2);
            bigDecimal3 = bigDecimal3.divide(bigDecimal2);
        }
        if (hashMap.get(1.0) == null) {
            object = CMI.getInstance().getEconomyManager().getMoneyFormat(string);
            return ((NumberFormat)object).format(bigDecimal.doubleValue());
        }
        object = CMI.getInstance().getEconomyManager().getMoneyFormat(string);
        return String.valueOf(((NumberFormat)object).format(d2)) + hashMap.get(1.0);
    }

    public Double deposit(double d) {
        return this.deposit(null, d);
    }

    public Double deposit(String string, double d) {
        return this.deposit(string, d, null);
    }

    public Double deposit(String string, double d, CMIUser cMIUser) {
        if (!CMI.getInstance().getEconomyManager().isEnabled()) {
            if (CMI.getInstance().getEconomyManager().isVaultEnabled()) {
                if (this.user.getPlayer() == null) {
                    return 0.0;
                }
                EconomyResponse economyResponse = CMI.getInstance().getEconomyManager().getVaultManager().getVaultEconomy().depositPlayer((OfflinePlayer)this.user.getPlayer(), d);
                return economyResponse.balance;
            }
            return 0.0;
        }
        EconomyManager.WorldGroup worldGroup = CMI.getInstance().getEconomyManager().getDefaultGroup();
        Double d2 = this.balances.get(worldGroup);
        if (d2 == null) {
            d2 = worldGroup.getStartingAmount();
        }
        if (worldGroup.getMaximumAmount() < d2 + d) {
            this.balances.put(worldGroup, worldGroup.getMaximumAmount());
        } else {
            this.balances.put(worldGroup, d2 + d);
        }
        CMIEconomyAcount.fireEvent(this.user, d2, this.getBalance(), "Deposit", cMIUser);
        this.user.addForDelayedSave();
        return this.getBalance();
    }

    public Double withdraw(double d) {
        return this.withdraw(null, d);
    }

    public Double withdraw(String string, double d) {
        return this.withdraw(string, d, null);
    }

    public Double withdraw(String string, double d, CMIUser cMIUser) {
        if (!CMI.getInstance().getEconomyManager().isEnabled()) {
            if (CMI.getInstance().getEconomyManager().isVaultEnabled()) {
                if (this.user.getPlayer() == null) {
                    return 0.0;
                }
                EconomyResponse economyResponse = CMI.getInstance().getEconomyManager().getVaultManager().getVaultEconomy().withdrawPlayer((OfflinePlayer)this.user.getPlayer(), d);
                return economyResponse.balance;
            }
            return 0.0;
        }
        EconomyManager.WorldGroup worldGroup = CMI.getInstance().getEconomyManager().getDefaultGroup();
        Double d2 = this.balances.get(worldGroup);
        if (d2 == null) {
            d2 = worldGroup.getStartingAmount();
        }
        if (worldGroup.getMinimalAmount() > d2 - d) {
            this.balances.put(worldGroup, worldGroup.getMinimalAmount());
        } else {
            this.balances.put(worldGroup, d2 - d);
        }
        CMIEconomyAcount.fireEvent(this.user, d2, this.getBalance(), "Withdraw", cMIUser);
        this.user.addForDelayedSave();
        return this.getBalance();
    }

    public boolean has(double d) {
        return this.has(null, d);
    }

    public boolean has(String string, double d) {
        if (!CMI.getInstance().getEconomyManager().isEnabled()) {
            if (CMI.getInstance().getEconomyManager().isVaultEnabled()) {
                if (this.user.getPlayer() == null) {
                    return false;
                }
                boolean bl = CMI.getInstance().getEconomyManager().getVaultManager().getVaultEconomy().has((OfflinePlayer)this.user.getPlayer(), d);
                return bl;
            }
            return false;
        }
        EconomyManager.WorldGroup worldGroup = CMI.getInstance().getEconomyManager().getDefaultGroup();
        Double d2 = this.balances.get(worldGroup);
        if (d2 == null) {
            d2 = this.balances.put(worldGroup, worldGroup.getStartingAmount());
        }
        return d2 != null && d2 >= d;
    }

    public Map<EconomyManager.WorldGroup, Double> getBalances() {
        return this.balances;
    }

    public HashMap<String, Double> getWorldGroupBalancesRounded() {
        HashMap<String, Double> hashMap = new HashMap<String, Double>();
        for (Map.Entry<EconomyManager.WorldGroup, Double> entry : this.balances.entrySet()) {
            if (entry.getValue() == null) continue;
            hashMap.put(entry.getKey().getName(), entry.getValue());
        }
        return hashMap;
    }

    public HashMap<String, Double> getWorldGroupBalances() {
        HashMap<String, Double> hashMap = new HashMap<String, Double>();
        for (Map.Entry<EconomyManager.WorldGroup, Double> entry : this.balances.entrySet()) {
            hashMap.put(entry.getKey().getName(), entry.getValue());
        }
        return hashMap;
    }

    public int updateBalTopPosition() {
        this.balTopPos = CMI.getInstance().getEconomyManager().getBalTopPlace(this.user.getUniqueId());
        return this.balTopPos;
    }

    public int getBalTopPosition() {
        if (this.balTopPos == 0) {
            this.balTopPos = CMI.getInstance().getEconomyManager().getBalTopPlace(this.user.getUniqueId());
        }
        return this.balTopPos;
    }

    public void setBalTopPosition(int n) {
        this.balTopPos = n;
    }
}

