/*
 * Decompiled with CFR 0.152.
 */
package com.Zrips.CMI.Modules.DynamicSigns;

import com.Zrips.CMI.CMI;
import com.Zrips.CMI.Modules.DynamicSigns.CMISign;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Location;
import org.bukkit.block.Sign;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerTeleportEvent;

public class SignListener
implements Listener {
    private CMI plugin;
    protected Map<UUID, Long> lastUpdateRange;

    public SignListener(CMI cMI) {
        this.plugin = cMI;
        this.lastUpdateRange = new HashMap<UUID, Long>();
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPlayerMoveExtendedRnage(PlayerMoveEvent playerMoveEvent) {
        Player player = playerMoveEvent.getPlayer();
        if (player == null) {
            return;
        }
        Location location = playerMoveEvent.getFrom();
        Location location2 = playerMoveEvent.getTo();
        if (playerMoveEvent.getTo() == null) {
            return;
        }
        if (location.getBlockX() == location2.getBlockX() && location.getBlockY() == location2.getBlockY() && location.getBlockZ() == location2.getBlockZ()) {
            return;
        }
        if (player.hasMetadata("NPC")) {
            return;
        }
        Long l = this.lastUpdateRange.get(player.getUniqueId());
        long l2 = System.currentTimeMillis();
        if (l != null && l2 - l < (long)this.plugin.getSignManager().getSignCheckInterval()) {
            return;
        }
        this.lastUpdateRange.put(player.getUniqueId(), l2);
        this.plugin.getSignManager().handleSignUpdates(player, location2);
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPlayerMoveExtendedRnage(PlayerTeleportEvent playerTeleportEvent) {
        Player player = playerTeleportEvent.getPlayer();
        if (player == null) {
            return;
        }
        Location location = playerTeleportEvent.getFrom();
        Location location2 = playerTeleportEvent.getTo();
        if (location2 == null) {
            return;
        }
        if (location.getBlockX() == location2.getBlockX() && location.getBlockY() == location2.getBlockY() && location.getBlockZ() == location2.getBlockZ()) {
            return;
        }
        if (player.hasMetadata("NPC")) {
            return;
        }
        Long l = this.lastUpdateRange.get(player.getUniqueId());
        long l2 = System.currentTimeMillis();
        if (l != null && l2 - l < 20L) {
            return;
        }
        this.lastUpdateRange.put(player.getUniqueId(), l2);
        this.plugin.getSignManager().handleSignUpdates(player, location2);
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPlayerMoveExtendedRnage(PlayerQuitEvent playerQuitEvent) {
        Player player = playerQuitEvent.getPlayer();
        if (player == null) {
            return;
        }
        this.lastUpdateRange.remove(player.getUniqueId());
        this.plugin.getSignManager().removeNearSign(player.getUniqueId());
        this.plugin.getSignManager().removeLastSignInRange(player.getUniqueId());
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPlayerMoveExtendedRnage(BlockBreakEvent blockBreakEvent) {
        Player player = blockBreakEvent.getPlayer();
        if (player == null) {
            return;
        }
        if (blockBreakEvent.isCancelled()) {
            return;
        }
        if (!(blockBreakEvent.getBlock().getState() instanceof Sign)) {
            return;
        }
        CMISign cMISign = this.plugin.getSignManager().getByLoc(blockBreakEvent.getBlock().getLocation());
        if (cMISign != null) {
            this.plugin.getSignManager().removeSign(cMISign);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPlayerMoveExtendedRnage(PlayerJoinEvent playerJoinEvent) {
        Player player = playerJoinEvent.getPlayer();
        if (player == null) {
            return;
        }
        this.plugin.getSignManager().handleSignUpdates(player, player.getLocation());
    }
}

