/*
 * Decompiled with CFR 0.152.
 */
package com.Zrips.CMI.Modules.Display;

import com.Zrips.CMI.CMI;
import com.Zrips.CMI.Modules.Display.CMIDisplay;
import com.Zrips.CMI.Modules.Display.CMIDisplayType;
import net.Zrips.CMILib.Container.CMINumber;
import net.Zrips.CMILib.Items.CMIItemStack;
import net.Zrips.CMILib.Version.Schedulers.CMIScheduler;
import net.Zrips.CMILib.Version.Version;
import org.bukkit.Location;
import org.bukkit.entity.Display;
import org.bukkit.entity.ItemDisplay;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.util.Transformation;
import org.joml.Quaternionf;
import org.joml.Vector3f;

public class CMIItemDisplay
extends CMIDisplay {
    private ItemDisplay td;

    public CMIItemDisplay(Location location) {
        super(CMIDisplayType.Item, location);
        try {
            this.td = (ItemDisplay)this.display;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        this.setBillboard(Display.Billboard.VERTICAL);
        this.setRange(32);
        this.setWidth(1.0);
        this.setHeight(1.0);
        this.loc = location;
    }

    public ItemStack getItemStack() {
        return this.td.getItemStack();
    }

    public void setItemStack(CMIItemStack cMIItemStack) {
        this.setItemStack(cMIItemStack.getItemStack().clone());
    }

    public void setItemStack(ItemStack itemStack) {
        if (Version.isFolia()) {
            CMIScheduler.runAtLocation((JavaPlugin)CMI.getInstance(), (Location)this.getLocation(), () -> this.td.setItemStack(itemStack));
        } else {
            this.td.setItemStack(itemStack);
        }
    }

    public void setItemDisplayTransform(ItemDisplay.ItemDisplayTransform itemDisplayTransform) {
        if (Version.isFolia()) {
            CMIScheduler.runAtLocation((JavaPlugin)CMI.getInstance(), (Location)this.getLocation(), () -> this.td.setItemDisplayTransform(itemDisplayTransform));
        } else {
            this.td.setItemDisplayTransform(itemDisplayTransform);
        }
    }

    public ItemDisplay.ItemDisplayTransform getItemDisplayTransform() {
        return this.td.getItemDisplayTransform();
    }

    public void setFacing(double d, double d2) {
        if (Version.isFolia()) {
            CMIScheduler.runAtLocation((JavaPlugin)CMI.getInstance(), (Location)this.getLocation(), () -> {
                Transformation transformation = this.td.getTransformation();
                Quaternionf quaternionf = transformation.getLeftRotation();
                if (this.getBillboard().equals((Object)Display.Billboard.FIXED)) {
                    Location location = this.getLocation();
                    location.setYaw((float)d2);
                    this.setLocation(location);
                    quaternionf.rotationX((float)Math.toRadians(d));
                } else {
                    Location location = this.getLocation();
                    location.setPitch((float)d);
                    this.setLocation(location);
                    quaternionf.rotationY((float)Math.toRadians(d2));
                }
                this.td.setTransformation(transformation);
            });
        } else {
            Transformation transformation = this.td.getTransformation();
            Quaternionf quaternionf = transformation.getLeftRotation();
            if (this.getBillboard().equals((Object)Display.Billboard.FIXED)) {
                Location location = this.getLocation();
                location.setYaw((float)d2);
                this.setLocation(location);
                quaternionf.rotationX((float)Math.toRadians(d));
            } else {
                Location location = this.getLocation();
                location.setPitch((float)d);
                this.setLocation(location);
                quaternionf.rotationY((float)Math.toRadians(d2));
            }
            this.td.setTransformation(transformation);
        }
    }

    public void setDepth(double d) {
        if (Version.isFolia()) {
            CMIScheduler.runAtLocation((JavaPlugin)CMI.getInstance(), (Location)this.getLocation(), () -> {
                Transformation transformation = this.td.getTransformation();
                Vector3f vector3f = transformation.getScale();
                vector3f.z = (float)CMINumber.clamp((double)d, (double)0.01, (int)1000);
                this.td.setTransformation(transformation);
            });
        } else {
            Transformation transformation = this.td.getTransformation();
            Vector3f vector3f = transformation.getScale();
            vector3f.z = (float)CMINumber.clamp((double)d, (double)0.01, (int)1000);
            this.td.setTransformation(transformation);
        }
    }

    public void setScale(double d) {
        if (Version.isFolia()) {
            CMIScheduler.runAtLocation((JavaPlugin)CMI.getInstance(), (Location)this.getLocation(), () -> {
                Transformation transformation = this.td.getTransformation();
                Vector3f vector3f = transformation.getScale();
                vector3f.x = (float)CMINumber.clamp((double)d, (double)0.01, (int)1000);
                vector3f.y = (float)CMINumber.clamp((double)d, (double)0.01, (int)1000);
                vector3f.z = (float)CMINumber.clamp((double)d, (double)0.01, (int)1000);
                this.td.setTransformation(transformation);
            });
        } else {
            Transformation transformation = this.td.getTransformation();
            Vector3f vector3f = transformation.getScale();
            vector3f.x = (float)CMINumber.clamp((double)d, (double)0.01, (int)1000);
            vector3f.y = (float)CMINumber.clamp((double)d, (double)0.01, (int)1000);
            vector3f.z = (float)CMINumber.clamp((double)d, (double)0.01, (int)1000);
            this.td.setTransformation(transformation);
        }
    }

    public float getDisplayHeight() {
        return this.td.getDisplayHeight();
    }
}

