/*
 * Decompiled with CFR 0.152.
 */
package com.Zrips.CMI.Modules.DeathMessages;

import com.Zrips.CMI.CMI;
import com.Zrips.CMI.Containers.CMIUser;
import com.Zrips.CMI.Containers.Snd;
import com.Zrips.CMI.Modules.DeathMessages.CMIDeathMsgInfo;
import com.Zrips.CMI.Modules.DeathMessages.CMIDeathType;
import com.Zrips.CMI.Modules.DeathMessages.CMIKillerInfo;
import com.Zrips.CMI.Modules.DeathMessages.damageInformation;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.Zrips.CMILib.Container.CMIText;
import net.Zrips.CMILib.Entities.CMIEntityType;
import net.Zrips.CMILib.Items.CMIItemStack;
import net.Zrips.CMILib.RawMessages.RawMessage;
import net.Zrips.CMILib.Version.Version;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.EnderCrystal;
import org.bukkit.entity.Entity;
import org.bukkit.entity.FallingBlock;
import org.bukkit.entity.LightningStrike;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.TNTPrimed;
import org.bukkit.entity.Trident;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByBlockEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.projectiles.BlockProjectileSource;

public class DeathMessageListener
implements Listener {
    private CMI plugin;
    private static CMIDeathMsgInfo temp = null;
    Pattern pattern = Pattern.compile("(\\[)([^\"^\\[^\\]^ ]+)(\\])");

    public DeathMessageListener(CMI cMI) {
        this.plugin = cMI;
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void playerDamageEvent(EntityDamageEvent entityDamageEvent) {
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void PlayerCombatEvent(EntityDamageEvent entityDamageEvent) {
        if (!this.plugin.getDeathMessageManager().isEnabled()) {
            return;
        }
        if (entityDamageEvent.isCancelled()) {
            return;
        }
        this.processEvent(entityDamageEvent);
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void onQuit(PlayerDeathEvent playerDeathEvent) {
        if (this.plugin.getDeathMessageManager().getAutoHideFrom() < 0) {
            return;
        }
        if (this.plugin.getDeathMessageManager().getAutoHideFrom() >= this.plugin.getUtilManager().getOnlinePlayerCount()) {
            return;
        }
        playerDeathEvent.setDeathMessage("");
    }

    private void processEvent(EntityDamageEvent entityDamageEvent) {
        TNTPrimed tNTPrimed;
        if (!this.plugin.getDeathMessageManager().isEnabled()) {
            return;
        }
        if (entityDamageEvent == null) {
            return;
        }
        if (!(entityDamageEvent.getEntity() instanceof Player)) {
            return;
        }
        Player player = (Player)entityDamageEvent.getEntity();
        CMIUser cMIUser = this.plugin.getPlayerManager().getUser(player);
        if (cMIUser == null) {
            return;
        }
        if (entityDamageEvent.getFinalDamage() <= 0.0) {
            return;
        }
        damageInformation damageInformation2 = new damageInformation();
        EntityDamageEvent.DamageCause damageCause = entityDamageEvent.getCause();
        if (entityDamageEvent.getFinalDamage() == 32767.0) {
            damageCause = EntityDamageEvent.DamageCause.SUICIDE;
        }
        damageInformation2.setCause(damageCause);
        damageInformation2.setTime();
        damageInformation2.setDamage(entityDamageEvent.getFinalDamage());
        if (!(entityDamageEvent instanceof EntityDamageByEntityEvent)) {
            damageInformation2.setEnt(null);
            damageInformation2.setItem(null);
            if (entityDamageEvent instanceof EntityDamageByBlockEvent) {
                EntityDamageByBlockEvent entityDamageByBlockEvent = (EntityDamageByBlockEvent)entityDamageEvent;
                damageInformation2.setBlock(entityDamageByBlockEvent.getDamager());
            }
            cMIUser.addLastDamage(damageInformation2);
            return;
        }
        damageInformation2.setBlock(null);
        EntityDamageByEntityEvent entityDamageByEntityEvent = (EntityDamageByEntityEvent)entityDamageEvent;
        Entity entity = entityDamageByEntityEvent.getDamager();
        boolean bl = false;
        if (!(entity instanceof LivingEntity)) {
            if (entity instanceof TNTPrimed && (tNTPrimed = (TNTPrimed)entity).getSource() != null) {
                entity = tNTPrimed.getSource();
                bl = true;
            }
            if (entity instanceof Projectile) {
                tNTPrimed = (Projectile)entity;
                if (tNTPrimed.getShooter() instanceof Entity) {
                    entity = (Entity)tNTPrimed.getShooter();
                }
                if (Version.isCurrentEqualOrHigher((Version)Version.v1_13_R1) && tNTPrimed instanceof Trident) {
                    bl = true;
                    damageInformation2.setItem(((Trident)tNTPrimed).getItem());
                }
            }
            if (!(entity instanceof LivingEntity)) {
                cMIUser.addLastDamage(damageInformation2);
                damageInformation2.setEnt(entity);
                return;
            }
        }
        damageInformation2.setEnt(entity);
        tNTPrimed = (LivingEntity)entity;
        if (!bl) {
            ItemStack itemStack = tNTPrimed.getEquipment().getItemInHand();
            if (Version.isCurrentEqualOrHigher((Version)Version.v1_13_R1) && itemStack == null || itemStack.getType().equals((Object)Material.AIR)) {
                itemStack = tNTPrimed.getEquipment().getItemInOffHand();
            }
            damageInformation2.setItem(itemStack);
        }
        cMIUser.addLastDamage(damageInformation2);
    }

    private CMIDeathMsgInfo getKillerInfo(CMIUser cMIUser) {
        damageInformation damageInformation2 = cMIUser.getLastDamage(null);
        CMIDeathMsgInfo cMIDeathMsgInfo = new CMIDeathMsgInfo(cMIUser.getUniqueId(), this.getKillerInfo(cMIUser.getPlayer(false), damageInformation2));
        damageInformation damageInformation3 = null;
        if (damageInformation2 != null) {
            damageInformation3 = cMIUser.getLastDamage(damageInformation2);
        }
        cMIDeathMsgInfo.setPreviousDamageInfo(this.getKillerInfo(cMIUser.getPlayer(false), damageInformation3));
        DeathMessageListener.calculateBasePath(cMIDeathMsgInfo);
        return cMIDeathMsgInfo;
    }

    private CMIKillerInfo getKillerInfo(Player player, damageInformation damageInformation2) {
        ItemStack itemStack;
        Block block;
        ArrayList<CMIDeathType> arrayList = new ArrayList<CMIDeathType>();
        CMIKillerInfo cMIKillerInfo = new CMIKillerInfo(damageInformation2);
        boolean bl = false;
        if (damageInformation2 == null) {
            return cMIKillerInfo;
        }
        Entity entity = damageInformation2.getEnt();
        if (entity != null) {
            if (entity instanceof Projectile) {
                block = (Projectile)entity;
                if (block.getShooter() instanceof Entity) {
                    entity = (Entity)block.getShooter();
                } else if (block.getShooter() instanceof BlockProjectileSource) {
                    itemStack = (BlockProjectileSource)block.getShooter();
                    cMIKillerInfo.setType(CMIDeathType.Block);
                    cMIKillerInfo.setKillerBlock(itemStack.getBlock());
                    arrayList.add(CMIDeathType.Block);
                    if (entity.getType().toString().contains("SPLASH")) {
                        arrayList.add(CMIDeathType.SplashPotion);
                    } else {
                        arrayList.add(CMIDeathType.Projectile);
                    }
                    cMIKillerInfo.setKiller(entity);
                    bl = true;
                }
            }
            if (entity instanceof LightningStrike) {
                arrayList.add(CMIDeathType.Custom);
            }
            if (entity != null && arrayList.isEmpty()) {
                if (entity instanceof Player) {
                    if (player != null && entity.getUniqueId().equals(player.getUniqueId())) {
                        damageInformation2.setItem(null);
                        damageInformation2.setCause(EntityDamageEvent.DamageCause.SUICIDE);
                    } else {
                        cMIKillerInfo.setKiller(entity);
                        cMIKillerInfo.setType(CMIDeathType.Player);
                        arrayList.add(CMIDeathType.Player);
                    }
                } else if (entity instanceof FallingBlock) {
                    cMIKillerInfo.setKiller(entity);
                    cMIKillerInfo.setType(CMIDeathType.FallingBlocks);
                    arrayList.add(CMIDeathType.FallingBlocks);
                } else if (entity instanceof Projectile) {
                    cMIKillerInfo.setKiller(entity);
                    if (entity.getType().toString().contains("FIREBALL")) {
                        cMIKillerInfo.setType(CMIDeathType.FireBall);
                        arrayList.add(CMIDeathType.FireBall);
                    } else {
                        cMIKillerInfo.setType(CMIDeathType.Projectile);
                        arrayList.add(CMIDeathType.Projectile);
                    }
                } else if (entity instanceof EnderCrystal) {
                    cMIKillerInfo.setKiller(entity);
                    cMIKillerInfo.setType(CMIDeathType.EndCrystal);
                    arrayList.add(CMIDeathType.Custom);
                    arrayList.add(CMIDeathType.EndCrystal);
                } else {
                    cMIKillerInfo.setKiller(entity);
                    cMIKillerInfo.setType(CMIDeathType.Mob);
                    arrayList.add(CMIDeathType.Mob);
                }
            }
        }
        if ((block = damageInformation2.getBlock()) != null || damageInformation2.getCause() == EntityDamageEvent.DamageCause.LAVA) {
            cMIKillerInfo.setType(CMIDeathType.Block);
            cMIKillerInfo.setKillerBlock(damageInformation2.getBlock());
            arrayList.add(CMIDeathType.Block);
            bl = true;
        }
        if ((itemStack = damageInformation2.getItem()) != null && itemStack.getType() != Material.AIR) {
            cMIKillerInfo.setKillerItem(new CMIItemStack(itemStack));
        } else if (entity != null) {
            boolean cfr_ignored_0 = entity instanceof Projectile;
        }
        EntityDamageEvent.DamageCause damageCause = damageInformation2.getCause();
        if (damageCause != null && !bl) {
            if (arrayList.isEmpty()) {
                arrayList.add(CMIDeathType.Custom);
            }
            if (damageCause == EntityDamageEvent.DamageCause.SUICIDE) {
                arrayList.add(CMIDeathType.Suicide);
            } else if (damageCause == EntityDamageEvent.DamageCause.VOID) {
                arrayList.add(CMIDeathType.Void);
            } else if (damageCause == EntityDamageEvent.DamageCause.BLOCK_EXPLOSION && damageInformation2.getEnt() != null) {
                arrayList.add(CMIDeathType.Tnt);
            }
        }
        cMIKillerInfo.setPath(arrayList);
        return cMIKillerInfo;
    }

    private static void calculateBasePath(CMIDeathMsgInfo cMIDeathMsgInfo) {
        CMIKillerInfo cMIKillerInfo = cMIDeathMsgInfo.getKillerInfo();
        if (cMIKillerInfo.getPath().isEmpty()) {
            return;
        }
        CMIDeathType cMIDeathType = cMIKillerInfo.getPath().get(0);
        String string = cMIDeathType.toString();
        damageInformation damageInformation2 = cMIKillerInfo.getDamage();
        switch (cMIDeathType) {
            case Block: {
                Projectile projectile;
                if (damageInformation2 == null) break;
                Entity entity = damageInformation2.getEnt();
                if (entity instanceof Projectile && (projectile = (Projectile)entity).getShooter() instanceof BlockProjectileSource) {
                    BlockProjectileSource blockProjectileSource = (BlockProjectileSource)projectile.getShooter();
                    string = String.valueOf(string) + "." + CMIText.firstToUpperCase((String)blockProjectileSource.getBlock().getType().toString()).replace(" ", "_");
                }
                if ((projectile = damageInformation2.getBlock()) != null) {
                    string = String.valueOf(string) + "." + CMIText.firstToUpperCase((String)projectile.getType().toString()).replace(" ", "_");
                    break;
                }
                if (damageInformation2.getCause() != EntityDamageEvent.DamageCause.LAVA) break;
                string = String.valueOf(string) + ".Lava";
                break;
            }
            case Custom: {
                if (cMIKillerInfo.getPath().size() > 1) {
                    string = String.valueOf(string) + "." + cMIKillerInfo.getPath().get(1).toString();
                    break;
                }
                if (damageInformation2 == null) break;
                string = String.valueOf(string) + "." + CMIText.firstToUpperCase((String)damageInformation2.getCause().toString()).replace(" ", "_");
                break;
            }
            case FallingBlocks: {
                Entity entity;
                if (damageInformation2 == null || !((entity = damageInformation2.getEnt()) instanceof FallingBlock)) break;
                FallingBlock fallingBlock = (FallingBlock)entity;
                string = String.valueOf(string) + "." + CMIText.firstToUpperCase((String)fallingBlock.getBlockData().getMaterial().toString()).replace(" ", "_");
                break;
            }
            case Mob: {
                Projectile projectile;
                Entity entity;
                if (damageInformation2 == null || (entity = damageInformation2.getEnt()) == null) break;
                if (entity instanceof Projectile && (projectile = (Projectile)entity).getShooter() instanceof Entity) {
                    entity = (Entity)projectile.getShooter();
                }
                if (entity != null) {
                    string = String.valueOf(string) + "." + CMIText.firstToUpperCase((String)CMIEntityType.get((Entity)entity).toString()).replace(" ", "_");
                    break;
                }
                string = String.valueOf(string) + ".General";
                break;
            }
            case Player: {
                break;
            }
            case Projectile: {
                break;
            }
        }
        cMIDeathMsgInfo.setBasePath(string);
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void onPlayerDeathEvent(PlayerDeathEvent playerDeathEvent) {
        Object object;
        if (!this.plugin.getDeathMessageManager().isEnabled()) {
            return;
        }
        if (playerDeathEvent.getDeathMessage() == null || playerDeathEvent.getDeathMessage().isEmpty()) {
            return;
        }
        CMIUser cMIUser = this.plugin.getPlayerManager().getUser(playerDeathEvent.getEntity());
        if (cMIUser == null) {
            return;
        }
        this.processEvent(playerDeathEvent.getEntity().getLastDamageCause());
        CMIDeathMsgInfo cMIDeathMsgInfo = this.getKillerInfo(cMIUser);
        if (cMIDeathMsgInfo.getKillerInfo() != null) {
            if (cMIDeathMsgInfo.getKillerInfo().getType() == CMIDeathType.Projectile) {
                cMIDeathMsgInfo.setPrefixPath(String.valueOf(cMIDeathMsgInfo.getBasePath()) + "." + CMIText.firstToUpperCase((String)cMIDeathMsgInfo.getKillerInfo().getKiller().getType().toString()).replace(" ", "_"));
            } else if (cMIDeathMsgInfo.getKillerInfo().getKillerItem() != null) {
                cMIDeathMsgInfo.setPrefixPath(String.valueOf(cMIDeathMsgInfo.getBasePath()) + ".Item");
            } else if (cMIDeathMsgInfo.getKillerInfo().getDamage() != null && cMIDeathMsgInfo.getKillerInfo().getDamage().getCause() == EntityDamageEvent.DamageCause.FALL) {
                if (playerDeathEvent.getEntity().getFallDistance() > 5.0f) {
                    cMIDeathMsgInfo.setPrefixPath(String.valueOf(cMIDeathMsgInfo.getBasePath()) + ".High.General");
                } else {
                    cMIDeathMsgInfo.setPrefixPath(String.valueOf(cMIDeathMsgInfo.getBasePath()) + ".Low.General");
                }
            } else if (cMIDeathMsgInfo.getKillerInfo() != null && cMIDeathMsgInfo.getKillerInfo().getDamage() != null && cMIDeathMsgInfo.getKillerInfo().getDamage().getCause() == EntityDamageEvent.DamageCause.BLOCK_EXPLOSION && cMIDeathMsgInfo.getKillerInfo().getType() == CMIDeathType.Player) {
                cMIDeathMsgInfo.setPrefixPath(String.valueOf(cMIDeathMsgInfo.getBasePath()) + "." + (Object)((Object)CMIDeathType.Tnt));
            } else {
                cMIDeathMsgInfo.setPrefixPath(String.valueOf(cMIDeathMsgInfo.getBasePath()) + ".General");
            }
        }
        if (cMIDeathMsgInfo.getPreviousDamageInfo() != null && ((CMIKillerInfo)(object = cMIDeathMsgInfo.getPreviousDamageInfo())).getKiller() != null && (((CMIKillerInfo)object).getKiller() instanceof Player && cMIDeathMsgInfo.getKillerInfo().getKiller() != ((CMIKillerInfo)object).getKiller() || !(((CMIKillerInfo)object).getKiller() instanceof Player) && cMIDeathMsgInfo.getKillerInfo().getKiller() != null && cMIDeathMsgInfo.getKillerInfo().getKiller().getType() != ((CMIKillerInfo)object).getKiller().getType() || cMIDeathMsgInfo.getKillerInfo().getKiller() == null)) {
            switch (((CMIKillerInfo)object).getType()) {
                case Block: 
                case Mob: {
                    cMIDeathMsgInfo.setSuffixPath("RunningAway");
                    break;
                }
                case Player: {
                    cMIDeathMsgInfo.setSuffixPath("Escaping");
                    break;
                }
            }
        }
        if ((object = this.plugin.getDeathMessageManager().getDeathMessage(cMIDeathMsgInfo.getPrefixPath())) == null) {
            return;
        }
        String string = "";
        if (cMIDeathMsgInfo.getSuffixPath() != null && !cMIDeathMsgInfo.getPrefixPath().equals(cMIDeathMsgInfo.getSuffixPath())) {
            string = this.plugin.getDeathMessageManager().getDeathMessage(cMIDeathMsgInfo.getSuffixPath());
            string = string.replace("[mobName]", "[prevMobName]");
        }
        cMIDeathMsgInfo.setMessage(String.valueOf(this.plugin.getDeathMessageManager().getPrefix()) + (String)object + string);
        playerDeathEvent.setDeathMessage(cMIDeathMsgInfo.getMessage());
        temp = cMIDeathMsgInfo;
        cMIUser.resetLastDamage();
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onPlayerDeathEventHighest(PlayerDeathEvent playerDeathEvent) {
        if (!this.plugin.getDeathMessageManager().isEnabled()) {
            return;
        }
        if (playerDeathEvent.getDeathMessage() == null || playerDeathEvent.getDeathMessage().isEmpty()) {
            return;
        }
        CMIUser cMIUser = this.plugin.getPlayerManager().getUser(playerDeathEvent.getEntity());
        if (cMIUser == null) {
            return;
        }
        if (temp == null || temp.getUniqueId() != cMIUser.getUniqueId()) {
            temp = null;
            return;
        }
        if (!playerDeathEvent.getDeathMessage().equals(temp.getMessage())) {
            temp.setMessage(playerDeathEvent.getDeathMessage());
        }
        String string = temp.getMessage();
        Matcher matcher = this.pattern.matcher(string);
        ArrayList<String> arrayList = new ArrayList<String>();
        String string2 = string;
        RawMessage rawMessage = new RawMessage();
        while (matcher.find()) {
            try {
                String string3 = matcher.group();
                String[] stringArray = string2.split(Pattern.quote(string3), 2);
                if (!stringArray[0].isEmpty()) {
                    arrayList.add(stringArray[0]);
                    rawMessage.addText(this.plugin.getPlaceholderAPIManager().updatePlaceHolders(playerDeathEvent.getEntity(), stringArray[0]));
                }
                arrayList.add(string3);
                switch (string3.toLowerCase()) {
                    case "[mobname]": {
                        if (temp.getKillerInfo().getType() != CMIDeathType.Mob) break;
                        rawMessage.addText(string3.replace("[mobName]", CMIEntityType.get((Entity)temp.getKillerInfo().getKiller()).getTranslatedName()));
                        break;
                    }
                    case "[prevmobname]": {
                        if (temp.getPreviousDamageInfo() == null || temp.getPreviousDamageInfo().getType() != CMIDeathType.Mob) break;
                        rawMessage.addText(string3.replace("[prevMobName]", CMIEntityType.get((Entity)temp.getPreviousDamageInfo().getKiller()).getTranslatedName()));
                        break;
                    }
                    case "[item]": {
                        if (temp.getKillerInfo().getKillerItem() == null) break;
                        rawMessage.addText(temp.getKillerInfo().getKillerItem().getDisplayName().replace("&", "\uff06").replace("{#", "{\uff06#"));
                        rawMessage.addItem(temp.getKillerInfo().getKillerItem().getItemStack());
                        break;
                    }
                    case "[itemname]": {
                        if (temp.getKillerInfo().getKillerItem() == null) break;
                        rawMessage.addText(temp.getKillerInfo().getKillerItem().getRealName().replace("&", "\uff06").replace("{#", "{\uff06#"));
                        rawMessage.addItem(temp.getKillerInfo().getKillerItem().getItemStack());
                        break;
                    }
                    case "[playerdisplayname]": 
                    case "[playername]": {
                        Snd snd = new Snd();
                        snd.setTarget(playerDeathEvent.getEntity());
                        string3 = this.plugin.getLM().updateSnd(snd, string3);
                        rawMessage.addText(string3);
                        List<String> list2 = this.plugin.getDeathMessageManager().getPlayerHover();
                        if (list2.isEmpty()) break;
                        this.plugin.getPlaceholderAPIManager().updatePlaceHolders(playerDeathEvent.getEntity(), list2);
                        rawMessage.addHover(this.plugin.getPlaceholderAPIManager().updatePlaceHolders(playerDeathEvent.getEntity(), list2));
                        break;
                    }
                    case "[sourcename]": 
                    case "[sourcedisplayname]": {
                        Snd snd = new Snd();
                        if (temp.getKillerInfo().getType() == CMIDeathType.Player) {
                            snd.setSource((Player)temp.getKillerInfo().getKiller());
                        }
                        string3 = this.plugin.getLM().updateSnd(snd, string3);
                        if (temp.getPreviousDamageInfo() != null && temp.getPreviousDamageInfo().getType() == CMIDeathType.Player) {
                            snd.setSource((Player)temp.getPreviousDamageInfo().getKiller());
                        }
                        string3 = this.plugin.getLM().updateSnd(snd, string3);
                        if (temp.getKillerInfo().getType() == CMIDeathType.Mob) {
                            string3 = string3.replace("[sourceDisplayName]", temp.getKillerInfo().getKiller().getCustomName() == null ? CMIEntityType.get((Entity)temp.getKillerInfo().getKiller()).getTranslatedName() : temp.getKillerInfo().getKiller().getCustomName());
                        }
                        rawMessage.addText(string3);
                        List<String> list2 = this.plugin.getDeathMessageManager().getKillerHover();
                        if (list2.isEmpty()) break;
                        this.plugin.getPlaceholderAPIManager().updatePlaceHolders((Player)temp.getKillerInfo().getKiller(), list2);
                        rawMessage.addHover(this.plugin.getPlaceholderAPIManager().updatePlaceHolders((Player)temp.getKillerInfo().getKiller(), list2));
                        break;
                    }
                    default: {
                        rawMessage.addText(string3);
                    }
                }
                if (stringArray.length <= 1) continue;
                string2 = stringArray[1];
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
        if (!string2.isEmpty()) {
            arrayList.add(string2);
            rawMessage.addText(this.plugin.getPlaceholderAPIManager().updatePlaceHolders(playerDeathEvent.getEntity(), string2));
        }
        this.plugin.getDeathMessageManager().broadcastDeathMessage(playerDeathEvent.getEntity(), rawMessage);
        this.plugin.getDiscordSRVManager().sendDiscordDeathMessage(playerDeathEvent.getEntity(), rawMessage.getTextOnly());
        playerDeathEvent.setDeathMessage("");
        temp = null;
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPlayerDeathEventMonitor(PlayerDeathEvent playerDeathEvent) {
    }
}

