/*
 * Decompiled with CFR 0.152.
 */
package com.Zrips.CMI.Modules.ChatFormat;

import com.Zrips.CMI.CMI;
import com.Zrips.CMI.Containers.CMISoundPreset;
import com.Zrips.CMI.Containers.CMIUser;
import com.Zrips.CMI.Containers.Snd;
import com.Zrips.CMI.Locale.CMILC;
import com.Zrips.CMI.Modules.ChatFilter.ChatFilterRule;
import com.Zrips.CMI.Modules.ChatFormat.CMIChatRoom;
import com.Zrips.CMI.Modules.ChatFormat.ChatFormatListener;
import com.Zrips.CMI.Modules.NickName.NickNameListener;
import com.Zrips.CMI.Modules.Permissions.PermissionInfo;
import com.Zrips.CMI.Modules.Permissions.PermissionsManager;
import com.Zrips.CMI.Modules.PlayerOptions.PlayerOption;
import com.Zrips.CMI.events.CMIAfkEnterEvent;
import java.io.File;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.Zrips.CMILib.CMILib;
import net.Zrips.CMILib.Colors.CMIChatColor;
import net.Zrips.CMILib.Container.CMIPlayer;
import net.Zrips.CMILib.FileHandler.ConfigReader;
import net.Zrips.CMILib.Items.CMIItemStack;
import net.Zrips.CMILib.Items.CMIMaterial;
import net.Zrips.CMILib.Messages.CMIMessages;
import net.Zrips.CMILib.RawMessages.RawMessage;
import net.Zrips.CMILib.RawMessages.RawMessageCommand;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class ChatFormatManager {
    private CMI plugin;
    HashMap<Integer, String> groupFormats = new HashMap();
    HashMap<Integer, String> groupMessageFormats = new HashMap();
    private HashMap<String, CMIChatRoom> chatRooms = new HashMap();
    private HashMap<UUID, CMIChatRoom> userChatRoom = new HashMap();
    private Set<UUID> staffChats = new HashSet<UUID>();
    private Long chatMutedUntil = null;
    private String chatMutedReason = null;
    private boolean BungeeMessages = true;
    private boolean BungeePublicMessages = true;
    private boolean BungeeStaffMessages = true;
    private String ChatGeneralFormat = "";
    private String ChatMessageGeneralFormat = "";
    private int ChatGeneralRange = 0;
    private int ChatShoutRange = 0;
    private Integer ChatShoutCost = 0;
    public static int ChatRoomLife = 3600;
    public static String ChatRoomShout = "!";
    public static TreeMap<Integer, Integer> chatDynamicRange = new TreeMap();
    ChatFilterRule rule = new ChatFilterRule();
    ChatFilterRule itemRule = new ChatFilterRule();
    private boolean ChatTranslateLink = true;
    private boolean hoverItems = false;
    private String fileName = "ChatRooms.yml";

    public void clearCache(UUID uUID) {
        this.staffChats.remove(uUID);
        for (Map.Entry<String, CMIChatRoom> entry : new HashMap<String, CMIChatRoom>(this.chatRooms).entrySet()) {
            entry.getValue().cleanOldUsers();
            if (!entry.getValue().getUsers().isEmpty() || entry.getValue().isPersistent()) continue;
            this.chatRooms.remove(entry.getKey());
        }
        this.userChatRoom.remove(uUID);
    }

    public ChatFormatManager(CMI cMI) {
        this.plugin = cMI;
    }

    public void loadConfig(ConfigReader configReader) {
        block24: {
            block23: {
                Object object2;
                configReader.addComment("Chat.TranslateLink", new String[]{"When set to false, web pge links in a chat will not get shortened to default [LINK] format"});
                this.ChatTranslateLink = configReader.get("Chat.TranslateLink", Boolean.valueOf(true));
                configReader.addComment("Chat.LinkRegex", new String[]{"Defines regex when replacing url in chat with short word", "Examples:", "(https?:\\/\\/(?:www\\.|(?!www))[a-zA-Z0-9][a-zA-Z0-9-]+[a-zA-Z0-9]\\.[^\\s]{2,}|www\\.[a-zA-Z0-9][a-zA-Z0-9-]+[a-zA-Z0-9]\\.[^\\s]{2,}|https?:\\/\\/(?:www\\.|(?!www))[a-zA-Z0-9]\\.[^\\s]{2,}|www\\.[a-zA-Z0-9]\\.[^\\s]{2,})", "((http|https|ftp|ftps)\\:\\/\\/)?[a-zA-Z0-9\\-]+\\.[a-zA-Z]{2,3}(\\/\\S*)?", "((http|https|ftp|ftps)\\:\\/\\/)?[a-zA-Z0-9\\-]+\\.[a-zA-Z]{2,3}(\\/\\S*)?([^\\s]+)"});
                String string = configReader.get("Chat.LinkRegex", "(^| )((http|https|ftp|ftps)\\:\\/\\/)?[a-zA-Z0-9\\-]+\\.[a-zA-Z]{2,3}(\\/\\S*)?([^\\s|^\\)]+)");
                this.rule.setPattern(Arrays.asList(string));
                configReader.addComment("Chat.HoverItems.Enabled", new String[]{"When set to true, particular variables in chat will be translated into items player are holding. List of variables belove"});
                this.hoverItems = configReader.get("Chat.HoverItems.Enabled", Boolean.valueOf(configReader.getC().getBoolean("Chat.HoverItems", true)));
                configReader.addComment("Chat.HoverItems.ItemRegex", new String[]{"Defines regex when replacing item line in chat with players item in hand information. Only works when CMI hover over chat format is enabled"});
                List list2 = configReader.get("Chat.HoverItems.ItemRegex", configReader.getC().getList("Chat.ItemRegex", Arrays.asList("(\\[item\\])", "(([&\u00a7]\\S)+)?\\[(([&\u00a7]\\S)+)?i(([&\u00a7]\\S)+)?t(([&\u00a7]\\S)+)?e(([&\u00a7]\\S)+)?m(([&\u00a7]\\S)+)?\\]")));
                this.itemRule.setPattern(list2);
                configReader.addComment("Chat.Bungee.Messages", new String[]{"Attention! This will require you to have CMI Bungee plugin which can be found at zrips.net", "Or direct download https://www.zrips.net/cmi/", "Do you want to enable private messaging over bungeecord", "Bungee cord support needs to be enabled for this to have any effect"});
                this.BungeeMessages = configReader.get("Chat.Bungee.Messages", Boolean.valueOf(configReader.getC().getBoolean("Chat.BungeeMessages", true)));
                configReader.addComment("Chat.Bungee.PublicMessages", new String[]{"Do you want to enable public messaging over bungeecord", "Player needs to have " + PermissionsManager.CMIPerm.bungee_publicmessages_$1.getPermission("[serverName]") + " permission node to be able to send messages to target server"});
                this.BungeePublicMessages = configReader.get("Chat.Bungee.PublicMessages", Boolean.valueOf(configReader.getC().getBoolean("Chat.BungeePublicMessages", true)));
                configReader.addComment("Chat.Bungee.StaffMessages", new String[]{"Do you want to enable staff messaging over bungeecord"});
                this.BungeeStaffMessages = configReader.get("Chat.Bungee.StaffMessages", Boolean.valueOf(configReader.getC().getBoolean("Chat.BungeeStaffMessages", true)));
                configReader.addComment("Chat.GeneralFormat", new String[]{"Used for simple chat messages. Optional variables: {displayName} {world} {prefix} {suffix} {group} {shout} {message} {nicknameprefix}. Supporting PlaceHolderAPI variables like %player_server%", "ATTENTION! Dont use gradient colors for {message} variable, if you want to apply gradient for it, utilize GeneralMessageFormat section"});
                this.ChatGeneralFormat = configReader.get("Chat.GeneralFormat", "{prefix}&f{displayName}&7: &r{message}");
                if (!CMIChatColor.processGradient((String)this.ChatGeneralFormat).contains("{message}")) {
                    CMIMessages.consoleMessage((String)"&4Incorrect Chat.GeneralFormat format! &2You cant use gradient here for {message}, check  &7GeneralMessageFormat &2section");
                }
                configReader.addComment("Chat.GeneralMessageFormat", new String[]{"Will define message format itself, this allows to have gradients in messages", "It NEEDS to contain {message} otherwise we will ignore this setup", "For 1.16+ servers you can use color gradients like '{#b3a28f>}{message}{#d7b8e6<}'", "You can have more than 2 colors in gradient. To define it repeat {message} variable. For example '{#b3a28f>}{message}{#5c6999<>}{message}{#d7b8e6<}'", "Use %cmi_user_chatcolor% to add players choosen chat color"});
                this.ChatMessageGeneralFormat = configReader.get("Chat.GeneralMessageFormat", "{message}");
                if (!this.ChatMessageGeneralFormat.contains("{message}")) {
                    this.ChatMessageGeneralFormat = "{message}";
                }
                configReader.addComment("Chat.Ranged.General", new String[]{"Defines range of regular messages to travel", "Set to -1 to disable range restriction"});
                this.ChatGeneralRange = configReader.get("Chat.Ranged.General", configReader.getC().getInt("Chat.GeneralRange", -1));
                configReader.addComment("Chat.Ranged.Shout", new String[]{"Defines range of shout messages to travel", "Shout messages should start with ! and player should have " + PermissionsManager.CMIPerm.chat_shout.getPermissionForShow() + " permission", "GeneralRange should be enabled", "set to 0 to shout across all worlds, -1 to disable"});
                this.ChatShoutRange = configReader.get("Chat.Ranged.Shout", configReader.getC().getInt("Chat.ShoutRange", 200));
                configReader.addComment("Chat.Ranged.ShoutCost", new String[]{"Defines cost for each shout message"});
                this.ChatShoutCost = configReader.get("Chat.Ranged.ShoutCost", configReader.getC().getInt("Chat.ShoutCost", 0));
                configReader.addComment("Chat.Ranged.Dynamic", new String[]{"Enables use of dynamic message range dependent on online player amount"});
                Boolean bl = configReader.get("Chat.Ranged.Dynamic.Use", Boolean.valueOf(false));
                configReader.addComment("Chat.Ranged.Dynamic", new String[]{"List of message range limits", "Player count fallowed by range", "Player amount defines from how many we should use this range"});
                List list3 = configReader.get("Chat.Ranged.Dynamic.Limits", Arrays.asList("1-0", "10-1000", "20-500", "30-400", "40-300", "50-200"));
                chatDynamicRange.clear();
                if (bl.booleanValue()) {
                    for (Object object2 : list3) {
                        if (!((String)object2).contains("-")) continue;
                        String[] stringArray = ((String)object2).split("-", 2);
                        try {
                            chatDynamicRange.put(Integer.parseInt(stringArray[0]), Integer.parseInt(stringArray[1]));
                        }
                        catch (Throwable throwable) {
                            CMIMessages.consoleMessage((String)("&cFailed to parse " + (String)object2 + " for dynamic chat ranges"));
                        }
                    }
                }
                configReader.addComment("Chat.ChatRoomShout", new String[]{"Prefix used to indicate that message should be sent to public chat instead of current players chat room", "Set it to empty field if you want this feature to be disabled"});
                ChatRoomShout = configReader.get("Chat.ChatRoomShout", "!");
                configReader.addComment("Chat.ChatRoomLife", new String[]{"Time in seconds you want to keep chat rooms alive before removing them", "This only applies to empty rooms after last user leaves it"});
                ChatRoomLife = configReader.get("Chat.ChatRoomLife", 3600);
                configReader.addComment("Chat.ClickSuggestions", new String[]{"Defines suggested commands when you click on public, private and similar messages. [playerName], [playerDisplayName] and [playerNickName]  can be used to include players name"});
                Object object3 = chatClickAction.values();
                int n = ((chatClickAction[])object3).length;
                int n2 = 0;
                while (n2 < n) {
                    object2 = object3[n2];
                    ((chatClickAction)((Object)object2)).setSuggestion(configReader.get("Chat.ClickSuggestions." + ((Enum)object2).name(), ((chatClickAction)((Object)object2)).getSuggestion(null, null, null)));
                    ++n2;
                }
                configReader.addComment("Chat.ClickCommands", new String[]{"Defines command (one command per type) to be performed by player when clicked on players name", "When this is defined then ClickSuggestions will be changed to shift+left click action for suggested command", "Command is performed as player, if you want to perform it from console then add asConsole! variable at the start of it"});
                object3 = chatClickAction.values();
                n = ((chatClickAction[])object3).length;
                n2 = 0;
                while (n2 < n) {
                    object2 = object3[n2];
                    ((chatClickAction)((Object)object2)).setCommand(configReader.get("Chat.ClickCommands." + ((Enum)object2).name(), ""));
                    ++n2;
                }
                configReader.addComment("Chat.GroupFormat", new String[]{"Use numeric increments to separate groups from each other. If player has more than one, then line with higher number will be used", "Add as many lines as you need too", "cmi.chatgroup.[id] permnission node to use", "Permission example: cmi.chatgroup.2", "", "ATTENTION! Dont use gradient colors for {message} variable, if you want to apply gradient for it, utilize GroupMessageFormat section"});
                if (!configReader.getC().isConfigurationSection("Chat.GroupFormat")) {
                    this.groupFormats.put(1, configReader.get("Chat.GroupFormat.1", "{prefix}&f{displayName}&f: &r{message}"));
                    this.groupFormats.put(2, configReader.get("Chat.GroupFormat.2", "{prefix}&f{displayName}&7: &r{message}"));
                    this.groupFormats.put(3, configReader.get("Chat.GroupFormat.3", "{prefix}&f{displayName}&8: &r{message}"));
                } else {
                    try {
                        if (!configReader.getC().isConfigurationSection("Chat.GroupFormat")) break block23;
                        for (Object object2 : configReader.getC().getConfigurationSection("Chat.GroupFormat").getKeys(false)) {
                            Integer n3 = null;
                            try {
                                n3 = Integer.parseInt((String)object2);
                            }
                            catch (Exception exception) {
                                continue;
                            }
                            object3 = configReader.get("Chat.GroupFormat." + (String)object2, "{prefix}&f{displayName}&f: &r{message}");
                            if (!CMIChatColor.processGradient((String)object3).contains("{message}")) {
                                CMIMessages.consoleMessage((String)("&4Incorrect Chat.GroupFormat." + (String)object2 + " format! &2You cant use gradient here for {message}, check &7Chat.GroupMessageFormat &2section"));
                            }
                            this.groupFormats.put(n3, (String)object3);
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            configReader.addComment("Chat.GroupMessageFormat", new String[]{"Use numeric increments to separate groups from each other. If player has more than one, then line with higher number will be used", "Add as many lines as you need too", "cmi.chatmessagegroup.[id] permnission node to use", "Permission example: cmi.chatmessagegroup.2"});
            if (!configReader.getC().isConfigurationSection("Chat.GroupMessageFormat")) {
                this.groupMessageFormats.put(1, configReader.get("Chat.GroupMessageFormat.1", "{message}"));
                this.groupMessageFormats.put(2, configReader.get("Chat.GroupMessageFormat.2", "{message}"));
                this.groupMessageFormats.put(3, configReader.get("Chat.GroupMessageFormat.3", "{message}"));
            } else {
                try {
                    if (!configReader.getC().isConfigurationSection("Chat.GroupMessageFormat")) break block24;
                    for (Object object2 : configReader.getC().getConfigurationSection("Chat.GroupMessageFormat").getKeys(false)) {
                        Integer n = null;
                        try {
                            n = Integer.parseInt((String)object2);
                        }
                        catch (Exception exception) {
                            continue;
                        }
                        this.groupMessageFormats.put(n, configReader.get("Chat.GroupMessageFormat." + (String)object2, "{message}"));
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    private String getChatGeneralFormat() {
        return this.ChatGeneralFormat;
    }

    public String getNickNamePrefix(CMIUser cMIUser) {
        String string;
        String string2 = string = cMIUser.getNickName() == null ? "" : CMI.getInstance().getNickNameManager().getNickNamePrefix();
        if (!CMI.getInstance().getNickNameManager().isPrefixWhenDifferent().booleanValue()) {
            return string;
        }
        if (cMIUser.getNickName() != null && cMIUser.getName(false) != null && CMIChatColor.stripColor((String)cMIUser.getNickName()).equalsIgnoreCase(cMIUser.getName())) {
            string = "";
        }
        return string;
    }

    public String getGroupFormat(Player player) {
        String string = this.getChatGeneralFormat();
        if (player == null) {
            return string;
        }
        PermissionInfo permissionInfo = this.plugin.getPermissionsManager().getPermissionInfo(player, PermissionsManager.CMIPerm.chatgroup_$1, (Long)1000L);
        if (permissionInfo != null && permissionInfo.getMaxValue() != null && this.groupFormats.containsKey(permissionInfo.getMaxValue().intValue())) {
            string = this.groupFormats.get(permissionInfo.getMaxValue().intValue());
        }
        return string;
    }

    public String getGroupMessageFormat(Player player) {
        String string = this.ChatMessageGeneralFormat;
        if (player == null) {
            return string;
        }
        PermissionInfo permissionInfo = this.plugin.getPermissionsManager().getPermissionInfo(player, PermissionsManager.CMIPerm.chatmessagegroup_$1, (Long)1000L);
        if (permissionInfo != null && permissionInfo.getMaxValue() != null && this.groupMessageFormats.containsKey(permissionInfo.getMaxValue().intValue())) {
            string = this.groupMessageFormats.get(permissionInfo.getMaxValue().intValue());
        }
        return string;
    }

    public Long getChatMutedUntil() {
        return this.chatMutedUntil;
    }

    public void setChatMutedUntil(Long l) {
        this.chatMutedUntil = l;
    }

    public void broadcastBungeeMessage(String string, String string2) {
        HashSet<Player> hashSet = new HashSet<Player>();
        CMIUser cMIUser = this.plugin.getPlayerManager().getUser(string);
        for (Player player : Bukkit.getOnlinePlayers()) {
            if (cMIUser != null && CMIUser.getUser(player).isIgnoring(cMIUser.getUniqueId())) continue;
            hashSet.add(player);
        }
        if (this.plugin.getTagManager().isChatTagEnabled()) {
            string2 = this.plugin.getTagManager().tag(cMIUser, string2, "", true);
        }
        if (string2.startsWith("[") && string2.endsWith("]")) {
            Player player;
            if (string2.length() <= 2) {
                return;
            }
            player = new RawMessage();
            player.setCombined(string2);
            player.show(hashSet, false);
        } else {
            for (Player player : hashSet) {
                player.sendMessage(string2);
            }
        }
    }

    public void sendMessage(String string, String string2, String string3) {
        CMIUser cMIUser;
        ConsoleCommandSender consoleCommandSender = null;
        if (string.equalsIgnoreCase("console")) {
            consoleCommandSender = Bukkit.getConsoleSender();
        } else {
            cMIUser = this.plugin.getPlayerManager().getUser(string);
            if (cMIUser != null) {
                consoleCommandSender = cMIUser.getPlayer(false);
            }
        }
        if (consoleCommandSender == null) {
            consoleCommandSender = CMIPlayer.getByName((String)string);
        }
        cMIUser = this.plugin.getPlayerManager().getUser(string2);
        Player player = null;
        player = cMIUser != null ? cMIUser.getPlayer(false) : CMIUser.getOnlinePlayer(string2);
        this.sendMessage((CommandSender)consoleCommandSender, string, player, string2, string3, true);
    }

    public void sendMessage(CommandSender commandSender, Player player, String string) {
        this.sendMessage(commandSender, commandSender != null ? commandSender.getName() : null, player, player != null ? player.getName() : null, string, true);
    }

    public void sendMessage(CommandSender commandSender, Player player, String string, boolean bl) {
        this.sendMessage(commandSender, commandSender != null ? commandSender.getName() : null, player, player != null ? player.getName() : null, string, bl);
    }

    public void sendMessage(CommandSender commandSender, String string, Player player, String string2, String string3) {
        this.sendMessage(commandSender, string, player, string2, string3, true);
    }

    public void sendMessage(CommandSender commandSender, String string, Player player, String string2, String string3, boolean bl) {
        String string4;
        Object object;
        Object object2;
        CMIUser cMIUser = this.plugin.getPlayerManager().getUser(player);
        if (cMIUser == null) {
            cMIUser = this.plugin.getPlayerManager().getUser(string2);
        }
        String string5 = "Console";
        if (player != null) {
            string5 = player.getName();
        } else if (string2 != null) {
            string5 = string2;
        }
        Snd snd = new Snd().setSender(commandSender).setTarget(cMIUser).setTargetName(string2);
        if (player != null) {
            snd.setTarget(player);
        }
        if (cMIUser != null && cMIUser.isAfk()) {
            if (cMIUser.isOnline() && cMIUser.hasSetPermission(PermissionsManager.CMIPerm.command_afk_staffinform)) {
                object2 = CMILC.afk_MayNotRespondStaff.getLocale(snd);
                object2 = this.plugin.getPlaceholderAPIManager().updatePlaceHolders(cMIUser.getPlayer(false), (String)object2);
                CMILC.sendMessage(commandSender, (String)object2);
            } else {
                object2 = CMILC.afk_MayNotRespond.getLocale(snd);
                object2 = this.plugin.getPlaceholderAPIManager().updatePlaceHolders(cMIUser.getPlayer(false), (String)object2);
                CMILC.sendMessage(commandSender, (String)object2);
            }
        }
        object2 = null;
        if (commandSender instanceof Player) {
            object2 = this.plugin.getPlayerManager().getUser((Player)commandSender);
        }
        if (object2 == null && string != null) {
            object2 = this.plugin.getPlayerManager().getUser(string);
        }
        if (object2 != null && cMIUser != null) {
            if (cMIUser.isIgnoring(((CMIUser)object2).getUniqueId()) && !PermissionsManager.CMIPerm.command_ignore_bypass.hasPermission(commandSender)) {
                CMILC.info("ignore", commandSender, "ignoringYou", snd);
                return;
            }
            if (cMIUser.isSilenceMode() && !PermissionsManager.CMIPerm.command_silence_bypass.hasPermission(commandSender)) {
                CMILC.info("silence", commandSender, "inMode", snd);
                return;
            }
        }
        snd.setSender(commandSender).setTarget(player).setSenderName(string).setTargetName(string2);
        if (string5.equalsIgnoreCase("Console")) {
            snd.setTarget(Bukkit.getConsoleSender());
            snd.setTargetName(string5);
        }
        boolean bl2 = commandSender instanceof Player;
        if (player != null && bl) {
            if (!(commandSender instanceof Player)) {
                string3 = this.plugin.getPlaceholderAPIManager().updatePlaceHolders(player, string3);
            }
            if (string3.startsWith("!") && PermissionsManager.CMIPerm.command_msg_clean.hasPermission(commandSender)) {
                string3 = CMIChatColor.translate((String)string3);
                if ((string3 = string3.replace("\uff06", "&")).startsWith("!-")) {
                    string3 = "!" + string3.substring(2);
                    if (PermissionsManager.CMIPerm.command_msg_noreply.hasPermission(commandSender)) {
                        bl2 = false;
                    }
                }
                object = string3.substring(1, string3.length());
                if (commandSender != null && !(commandSender instanceof Player)) {
                    player.sendMessage((String)object);
                } else {
                    player.sendMessage(string3.substring(1, string3.length()).replace("\n", "\\n"));
                }
            } else if (commandSender != null && commandSender instanceof Player && this.plugin.getChatManager().isChatClickHoverMessages()) {
                object = new RawMessage();
                string4 = CMILC.Chat_privateHover.getLocale(new Object[0]);
                string4 = this.plugin.getPlaceholderAPIManager().updatePlaceHolders((Player)commandSender, string4);
                CMIUser cMIUser2 = this.plugin.getPlayerManager().getUser((Player)commandSender);
                if (cMIUser2 == null) {
                    return;
                }
                string3 = string3.replace("\n", "");
                object.setDontBreakLine(false);
                if (this.containsUrl(string3)) {
                    object.addText(this.plugin.getPlaceholderAPIManager().updatePlaceHolders((Player)commandSender, CMILC.getIM("msg", "TargetMsg", snd, "[message]", ""))).addHover(string4);
                    chatClickAction.privmsg.updateClickAction((RawMessage)object, cMIUser2);
                    this.convertHoverOver((RawMessage)object, string3, commandSender instanceof Player ? (Player)commandSender : null);
                } else if (!(commandSender instanceof Player)) {
                    object.addText(this.plugin.getPlaceholderAPIManager().updatePlaceHolders((Player)commandSender, CMILC.getIM("msg", "TargetMsg", snd, "[message]", string3))).addHover(string4);
                    chatClickAction.privmsg.updateClickAction((RawMessage)object, cMIUser2);
                } else {
                    object.addText(CMILC.getIM("msg", "TargetMsg", snd, "[message]", string3)).addHover(string4);
                    chatClickAction.privmsg.updateClickAction((RawMessage)object, cMIUser2);
                }
                object.show(player);
            } else {
                object = CMILC.getIM("msg", "TargetMsg", snd, "[message]", string3).replace("\uff06", "&");
                if (commandSender != null && !(commandSender instanceof Player)) {
                    player.sendMessage((String)object);
                } else {
                    player.sendMessage(((String)object).replace("\n", "\\n"));
                }
            }
            if (cMIUser != null && cMIUser.getOptionState(PlayerOption.pmSound).booleanValue()) {
                CMISoundPreset.PrivateMessage.play(player);
            }
        } else {
            snd.setTarget(Bukkit.getConsoleSender());
            CMIMessages.sendMessage((CommandSender)Bukkit.getConsoleSender(), (String)CMILC.getIM("msg", "TargetMsg", snd, "[message]", string3).replace("\uff06", "&"));
        }
        if (commandSender instanceof Player && this.plugin.getChatManager().isChatClickHoverMessages()) {
            object = new RawMessage();
            string4 = CMILC.Chat_privateHover.getLocale(new Object[0]);
            string4 = this.plugin.getPlaceholderAPIManager().updatePlaceHolders((Player)commandSender, string4);
            string3 = string3.replace("\n", "");
            object.setDontBreakLine(false);
            if (this.containsUrl(string3)) {
                object.addText(this.plugin.getPlaceholderAPIManager().updatePlaceHolders(player, CMILC.getIM("msg", "SenderMsg", snd, "[message]", ""))).addHover(string4);
                chatClickAction.privmsg.updateClickAction((RawMessage)object, cMIUser == null ? string5 : cMIUser.getName(), cMIUser == null ? string5 : cMIUser.getCleanDisplayName(), cMIUser == null ? string5 : cMIUser.getNickName());
                this.convertHoverOver((RawMessage)object, string3, (Player)commandSender);
            } else if (!(commandSender instanceof Player)) {
                object.addText(this.plugin.getPlaceholderAPIManager().updatePlaceHolders(player, CMILC.getIM("msg", "SenderMsg", snd, "[message]", string3))).addHover(string4);
                chatClickAction.privmsg.updateClickAction((RawMessage)object, cMIUser == null ? string5 : cMIUser.getName(), cMIUser == null ? string5 : cMIUser.getCleanDisplayName(), cMIUser == null ? string5 : cMIUser.getNickName());
            } else {
                object.addText(CMILC.getIM("msg", "SenderMsg", snd, "[message]", string3)).addHover(string4);
                chatClickAction.privmsg.updateClickAction((RawMessage)object, cMIUser == null ? string5 : cMIUser.getName(), cMIUser == null ? string5 : cMIUser.getCleanDisplayName(), cMIUser == null ? string5 : cMIUser.getNickName());
            }
            object.show(commandSender);
        } else if (commandSender != null) {
            object = CMILC.getIM("msg", "SenderMsg", snd, "[message]", string3).replace("\uff06", "&");
            if (!(commandSender instanceof Player)) {
                commandSender.sendMessage((String)object);
            } else {
                commandSender.sendMessage(((String)object).replace("\n", "\\n"));
            }
        }
        if (commandSender == null || commandSender instanceof Player && !PermissionsManager.CMIPerm.command_socialspy_hide.hasPermission(commandSender)) {
            this.plugin.getPlayerManager().sendMessageToSpies(commandSender, string, player, string3);
        }
        if (bl2 || commandSender == null) {
            if (commandSender != null) {
                this.plugin.getUtilManager().addMessageReplyTo(string5, commandSender.getName());
            } else if (string != null) {
                this.plugin.getUtilManager().addMessageReplyTo(string5, string);
            }
        }
        if (commandSender instanceof Player && this.plugin.getAfkManager().isDisableOnPrivateChat()) {
            this.plugin.getPlayerManager().getUser((Player)commandSender).setAfk(false, CMIAfkEnterEvent.AfkType.manual);
        }
    }

    public String updateUrl(String string) {
        if (!this.containsUrl(string)) {
            return string;
        }
        Matcher matcher = this.rule.getMatcher(string);
        while (matcher != null && matcher.find()) {
            String string2 = matcher.group(0);
            String string3 = string2.replace("&", "\uff06");
            string = string.replace(string2, string3);
        }
        return string;
    }

    public boolean containsUrl(String string) {
        Matcher matcher = this.rule.getMatcher(string);
        boolean bl = false;
        if (matcher != null) {
            bl = matcher.find();
        }
        Matcher matcher2 = this.itemRule.getMatcher(string);
        boolean bl2 = false;
        if (matcher2 != null) {
            bl2 = matcher2.find();
        }
        return bl || bl2;
    }

    public RawMessage convertHoverOver(RawMessage rawMessage, String string, Player player) {
        return this.convertHoverOver(rawMessage, string, player, false);
    }

    public RawMessage convertHoverOver(RawMessage rawMessage, String string, Player player, boolean bl) {
        String[] stringArray;
        String string2 = string;
        Matcher matcher = this.rule.getMatcher(string);
        Matcher matcher2 = this.itemRule.getMatcher(string);
        String string3 = null;
        if (matcher != null && matcher.find()) {
            string3 = matcher.group();
        }
        String string4 = null;
        if (matcher2 != null && matcher2.find()) {
            string4 = matcher2.group();
        }
        Boolean bl2 = null;
        int n = 0;
        if (string3 != null) {
            if (string3.startsWith(" ")) {
                string3 = string3.substring(1, string3.length());
            }
            stringArray = string.split(Pattern.quote(string3), 2);
            bl2 = true;
            n = stringArray[0].length();
        }
        if (string4 != null) {
            stringArray = string.split(string4, 2);
            if (stringArray.length == 1) {
                bl2 = false;
            } else if (stringArray[0].length() < n) {
                bl2 = false;
            } else if (bl2 != null) {
                bl2 = true;
            }
        }
        if (string3 != null && bl2 != null && bl2.booleanValue()) {
            stringArray = string3;
            Object object = stringArray;
            String[] stringArray2 = string.split(Pattern.quote((String)stringArray));
            string = stringArray2.length > 1 ? stringArray2[1] : "";
            if (stringArray2.length > 0) {
                rawMessage.addText(ChatFormatListener.processGradientChat(player, stringArray2[0]));
            }
            rawMessage.freezeFormat();
            rawMessage.addText(CMILC.Chat_link.getLocale(new Object[0]).isEmpty() || !this.ChatTranslateLink ? Matcher.quoteReplacement((String)stringArray) : CMILC.Chat_link.getLocale(new Object[0])).addHover((String)object).addUrl((String)object);
            rawMessage.unFreezeFormat();
        } else if (this.hoverItems && string4 != null) {
            stringArray = null;
            try {
                if (player != null) {
                    stringArray = this.plugin.getPlayerManager().getUser(player).getItemInHand();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (stringArray != null && !CMIMaterial.isAir((Material)stringArray.getType())) {
                String string5 = string4;
                String[] stringArray3 = string.split(Pattern.quote(string5), 2);
                string = stringArray3.length > 1 ? stringArray3[1] : "";
                if (stringArray3.length > 0) {
                    rawMessage.addText(ChatFormatListener.processGradientChat(player, stringArray3[0]));
                }
                stringArray = stringArray.clone();
                CMIItemStack cMIItemStack = CMILib.getInstance().getItemManager().getItem((ItemStack)stringArray);
                String string6 = "";
                if (stringArray.getType().equals((Object)Material.AIR)) {
                    string5 = CMILC.Chat_itemEmpty.getLocale(new Object[0]);
                } else {
                    if (cMIItemStack.getAmount() > 1) {
                        string6 = CMILC.Chat_itemAmount.getLocale("[amount]", cMIItemStack.getAmount());
                    }
                    string5 = CMILC.Chat_item.getLocale("[itemName]", cMIItemStack.getRealName(), "[amount]", string6);
                }
                string5 = CMI.getInstance().getPlaceholderAPIManager().updatePlaceHolders(player, string5);
                if (string5 != null) {
                    string5 = string5.replace("&", "\uff06");
                }
                if (!bl) {
                    rawMessage.freezeFormat();
                    rawMessage.addItem(string5, (ItemStack)stringArray, null, null, null);
                    rawMessage.unFreezeFormat();
                    bl = true;
                } else {
                    rawMessage.addText(string4);
                }
            }
        }
        if (!string2.equals(string)) {
            this.convertHoverOver(rawMessage, string, player, bl);
        } else {
            rawMessage.addText(ChatFormatListener.processGradientChat(player, string));
        }
        return rawMessage;
    }

    public StringBuilder convertHoverItem(StringBuilder stringBuilder, String string, Player player, boolean bl) {
        String string2 = string;
        Matcher matcher = this.itemRule.getMatcher(string);
        String string3 = null;
        if (matcher != null && matcher.find()) {
            string3 = matcher.group();
        }
        if (this.hoverItems && string3 != null) {
            ItemStack itemStack = null;
            try {
                if (player != null) {
                    itemStack = this.plugin.getPlayerManager().getUser(player).getItemInHand();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (itemStack != null && !CMIMaterial.isAir((Material)itemStack.getType())) {
                String string4 = string3;
                String[] stringArray = string.split(Pattern.quote(string4), 2);
                string = stringArray.length > 1 ? stringArray[1] : "";
                if (stringArray.length > 0) {
                    stringBuilder.append(ChatFormatListener.processGradientChat(player, stringArray[0]));
                }
                itemStack = itemStack.clone();
                CMIItemStack cMIItemStack = CMILib.getInstance().getItemManager().getItem(itemStack);
                String string5 = "";
                if (itemStack.getType().equals((Object)Material.AIR)) {
                    string4 = CMILC.Chat_itemEmpty.getLocale(new Object[0]);
                } else {
                    if (cMIItemStack.getAmount() > 1) {
                        string5 = CMILC.Chat_itemAmount.getLocale("[amount]", cMIItemStack.getAmount());
                    }
                    string4 = CMILC.Chat_item.getLocale("[itemName]", cMIItemStack.getRealName(), "[amount]", string5);
                }
                string4 = CMI.getInstance().getPlaceholderAPIManager().updatePlaceHolders(player, string4);
                if (string4 != null) {
                    string4 = string4.replace("&", "\uff06");
                }
                if (!bl) {
                    stringBuilder.append(string4);
                    bl = true;
                } else {
                    stringBuilder.append(string3);
                }
            }
        }
        if (!string2.equals(string)) {
            this.convertHoverItem(stringBuilder, string, player, bl);
        } else {
            stringBuilder.append(NickNameListener.processGradientChat(player, string));
        }
        return stringBuilder;
    }

    public boolean isBungeeMessages() {
        return this.BungeeMessages;
    }

    public void setChatGeneralRange(int n) {
        this.ChatGeneralRange = n;
    }

    public int getChatShoutRange() {
        return this.ChatShoutRange;
    }

    public void setChatShoutRange(int n) {
        this.ChatShoutRange = n;
    }

    public Integer getChatShoutCost() {
        return this.ChatShoutCost;
    }

    public void setChatShoutCost(int n) {
        this.ChatShoutCost = n;
    }

    public Set<UUID> getStaffChats() {
        return this.staffChats;
    }

    public boolean isBungeePublicMessages() {
        return this.BungeePublicMessages;
    }

    public boolean isBungeeStaffMessages() {
        return this.BungeeStaffMessages;
    }

    public HashMap<String, CMIChatRoom> getChatRooms() {
        Iterator<Map.Entry<String, CMIChatRoom>> iterator = this.chatRooms.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, CMIChatRoom> entry = iterator.next();
            CMIChatRoom cMIChatRoom = entry.getValue();
            if (cMIChatRoom.isPersistent() || !cMIChatRoom.getUsers().isEmpty() || cMIChatRoom.getKeepAliveUntil() == 0L || cMIChatRoom.getKeepAliveUntil() > System.currentTimeMillis()) continue;
            iterator.remove();
        }
        return this.chatRooms;
    }

    public CMIChatRoom getChatRoom(String string) {
        if (string == null) {
            return null;
        }
        return this.getChatRooms().get(string.toLowerCase());
    }

    public boolean joinChatRoom(CMIUser cMIUser, String string) {
        CMIChatRoom cMIChatRoom = this.getChatRooms().get(string.toLowerCase());
        if (cMIChatRoom == null) {
            return false;
        }
        cMIChatRoom.addUser(cMIUser);
        cMIChatRoom.removeWatcher(cMIUser);
        this.setChatRoom(cMIUser, cMIChatRoom);
        return true;
    }

    @Deprecated
    public boolean createChatRoom(CMIUser cMIUser, String string, boolean bl) {
        return this.createChatRoom(cMIUser, string, bl, false, false);
    }

    public boolean createChatRoom(CMIUser cMIUser, String string, boolean bl, boolean bl2, boolean bl3) {
        CMIChatRoom cMIChatRoom = this.getChatRooms().get(string.toLowerCase());
        if (cMIChatRoom != null) {
            return false;
        }
        cMIChatRoom = new CMIChatRoom(string);
        cMIChatRoom.setOwner(cMIUser.getUniqueId());
        cMIChatRoom.setPrivate(bl);
        cMIChatRoom.setLocked(bl2);
        cMIChatRoom.setPersistent(bl3);
        this.chatRooms.put(string.toLowerCase(), cMIChatRoom);
        this.setChatRoom(cMIUser, cMIChatRoom);
        cMIChatRoom.addUser(cMIUser);
        if (bl3) {
            this.save();
        }
        return true;
    }

    public void load() {
        long l = System.currentTimeMillis();
        this.plugin.safeRenameFile("chatRooms.yml", "Saves" + File.separator + this.fileName);
        ConfigReader configReader = null;
        try {
            configReader = new ConfigReader((Plugin)CMI.getInstance(), "Saves" + File.separator + this.fileName);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (configReader == null) {
            return;
        }
        Set set = configReader.getC().getKeys(false);
        for (String string : set) {
            CMIChatRoom cMIChatRoom = new CMIChatRoom(string);
            cMIChatRoom.setPersistent(true);
            if (configReader.getC().isString(String.valueOf(string) + ".owner")) {
                cMIChatRoom.setOwner(UUID.fromString(configReader.getC().getString(String.valueOf(string) + ".owner")));
            }
            if (configReader.getC().isBoolean(String.valueOf(string) + ".locked")) {
                cMIChatRoom.setLocked(configReader.getC().getBoolean(String.valueOf(string) + ".locked"));
            }
            if (configReader.getC().isBoolean(String.valueOf(string) + ".private")) {
                cMIChatRoom.setPrivate(configReader.getC().getBoolean(String.valueOf(string) + ".private"));
            }
            if (configReader.getC().isList(String.valueOf(string) + ".invitations")) {
                for (Object e : configReader.getC().getList(String.valueOf(string) + ".invitations")) {
                    cMIChatRoom.addInvitation((UUID)e);
                }
            }
            this.chatRooms.put(string.toLowerCase(), cMIChatRoom);
        }
        if (!this.chatRooms.isEmpty()) {
            this.plugin.loadMessage(this.chatRooms.size(), "chat rooms", System.currentTimeMillis() - l);
        }
    }

    public void save() {
        ConfigReader configReader = null;
        try {
            configReader = new ConfigReader((Plugin)CMI.getInstance(), "Saves" + File.separator + this.fileName);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (configReader == null) {
            return;
        }
        for (CMIChatRoom cMIChatRoom : this.chatRooms.values()) {
            if (!cMIChatRoom.isPersistent()) continue;
            configReader.get(String.valueOf(cMIChatRoom.getChatName()) + ".owner", cMIChatRoom.getOwner().toString());
            if (cMIChatRoom.isLocked()) {
                configReader.get(String.valueOf(cMIChatRoom.getChatName()) + ".locked", Boolean.valueOf(cMIChatRoom.isLocked()));
            }
            if (cMIChatRoom.isPrivate()) {
                configReader.get(String.valueOf(cMIChatRoom.getChatName()) + ".private", Boolean.valueOf(cMIChatRoom.isPrivate()));
            }
            if (cMIChatRoom.getInvitations() == null || cMIChatRoom.getInvitations().isEmpty()) continue;
            configReader.get(String.valueOf(cMIChatRoom.getChatName()) + ".invitations", cMIChatRoom.getInvitations());
        }
        configReader.save();
    }

    public CMIChatRoom getChatRoom(UUID uUID) {
        return this.userChatRoom.get(uUID);
    }

    public boolean leaveChatRoom(UUID uUID) {
        if (this.getChatRoom(uUID) == null) {
            return false;
        }
        return this.getChatRoom(uUID).removeUser(CMIUser.getUser(uUID));
    }

    public void setChatRoom(CMIUser cMIUser, CMIChatRoom cMIChatRoom) {
        if (cMIChatRoom != null && !cMIChatRoom.getUsers().contains(cMIUser)) {
            cMIChatRoom.getUsers().add(cMIUser);
        }
        this.userChatRoom.put(cMIUser.getUniqueId(), cMIChatRoom);
    }

    public void leaveChatRoom(CMIUser cMIUser) {
        this.leaveChatRoom(cMIUser.getUniqueId());
    }

    public String getChatMutedReason() {
        return this.chatMutedReason;
    }

    public void setChatMutedReason(String string) {
        if (string == null || string.isEmpty()) {
            string = null;
        } else {
            this.chatMutedReason = string;
        }
    }

    public int getChatGeneralRange() {
        return this.getChatGeneralRange(null);
    }

    public int getChatGeneralRange(World world2) {
        if (chatDynamicRange.isEmpty()) {
            return this.ChatGeneralRange;
        }
        int n = this.plugin.getUtilManager().getOnlinePlayerCount(null);
        int n2 = -2;
        Integer n3 = chatDynamicRange.get(n);
        if (n3 != null) {
            return n3;
        }
        for (Map.Entry<Integer, Integer> entry : chatDynamicRange.entrySet()) {
            if (n2 != -2 && entry.getKey() > n) break;
            n2 = entry.getValue();
        }
        if (n2 == -2) {
            return this.ChatGeneralRange;
        }
        chatDynamicRange.put(n, n2);
        return n2;
    }

    public static enum chatClickAction {
        pubmsg,
        privmsg,
        staffmsg,
        helpop,
        chatroom,
        discord;

        private String sug = "/msg [playerNickName] ";
        private String cmd = "";
        private boolean specialized = false;

        public void updateClickAction(RawMessage rawMessage, CMIUser cMIUser) {
            if (!this.cmd.isEmpty()) {
                if (!this.sug.isEmpty()) {
                    rawMessage.addInsertion(this.getSuggestion(cMIUser));
                }
                if (this.specialized) {
                    final List<String> list2 = Arrays.asList(this.getCommand(cMIUser));
                    RawMessageCommand rawMessageCommand = new RawMessageCommand(){

                        public void run(CommandSender commandSender) {
                            CMI.getInstance().getSpecializedCommandManager().processCmds((List<String>)list2, (Player)commandSender);
                        }
                    };
                    rawMessageCommand.setKeep(true);
                    rawMessage.addCommand(rawMessageCommand);
                } else {
                    rawMessage.addCommand(this.getCommand(cMIUser));
                }
            } else if (!this.sug.isEmpty()) {
                rawMessage.addSuggestion(this.getSuggestion(cMIUser));
            }
        }

        public void updateClickAction(RawMessage rawMessage, String string, String string2, String string3) {
            if (!this.cmd.isEmpty()) {
                if (!this.sug.isEmpty()) {
                    rawMessage.addInsertion(this.getSuggestion(string, string2, string3));
                }
                if (this.specialized) {
                    final List<String> list2 = Arrays.asList(this.getCommand(string, string2, string3));
                    RawMessageCommand rawMessageCommand = new RawMessageCommand(){

                        public void run(CommandSender commandSender) {
                            CMI.getInstance().getSpecializedCommandManager().processCmds((List<String>)list2, (Player)commandSender);
                        }
                    };
                    rawMessageCommand.setKeep(true);
                    rawMessage.addCommand(rawMessageCommand);
                } else {
                    rawMessage.addCommand(this.getCommand(string, string2, string3));
                }
            } else if (!this.sug.isEmpty()) {
                rawMessage.addSuggestion(this.getSuggestion(string, string2, string3));
            }
        }

        public String getSuggestion(CMIUser cMIUser) {
            if (cMIUser == null) {
                return this.sug;
            }
            return this.getSuggestion(cMIUser.getName(false), cMIUser.getDisplayName(false), cMIUser.getNickName());
        }

        public String getSuggestion(String string, String string2, String string3) {
            return chatClickAction.process(string, string2, string3, this.sug);
        }

        public void setSuggestion(String string) {
            this.sug = string;
        }

        public String getCommand() {
            return this.cmd;
        }

        public void setCommand(String string) {
            this.cmd = string;
            this.specialized = CMI.getInstance().getSpecializedCommandManager().isSpecializedCommand(string);
        }

        public String getCommand(CMIUser cMIUser) {
            if (cMIUser == null) {
                return this.sug;
            }
            return this.getCommand(cMIUser.getName(false), cMIUser.getDisplayName(false), cMIUser.getNickName());
        }

        private static String process(String string, String string2, String string3, String string4) {
            String string5 = string4;
            if (string != null) {
                string5 = string5.replace("[playerName]", CMIChatColor.stripColor((String)string));
            }
            if (string2 != null) {
                string5 = string5.replace("[playerDisplayName]", CMIChatColor.stripColor((String)string2));
            } else if (string != null) {
                string5 = string5.replace("[playerDisplayName]", CMIChatColor.stripColor((String)string));
            }
            if (string3 != null) {
                string5 = string5.replace("[playerNickName]", CMIChatColor.stripColor((String)string3));
            } else if (string != null) {
                string5 = string5.replace("[playerNickName]", CMIChatColor.stripColor((String)string));
            }
            return string5;
        }

        public String getCommand(String string, String string2, String string3) {
            if (this.cmd.isEmpty()) {
                return this.cmd;
            }
            return chatClickAction.process(string, string2, string3, this.cmd);
        }
    }
}

