/*
 * Decompiled with CFR 0.152.
 */
package com.Zrips.CMI.Modules.ChatFilter;

import com.Zrips.CMI.CMI;
import com.Zrips.CMI.Containers.Snd;
import com.Zrips.CMI.Locale.CMILC;
import com.Zrips.CMI.Modules.ChatFilter.ChatFilterRule;
import com.Zrips.CMI.Modules.Permissions.PermissionsManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.Zrips.CMILib.Chat.ChatFilterBlockType;
import net.Zrips.CMILib.Colors.CMIChatColor;
import net.Zrips.CMILib.Version.Schedulers.CMIScheduler;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.java.JavaPlugin;

public class RuleResponse {
    private String message;
    private String updatedMessage;
    private HashMap<String, ChatFilterRule> rules = new HashMap();
    private List<String> bypass = new ArrayList<String>();

    public RuleResponse(String string) {
        this.message = string;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String string) {
        this.message = string;
    }

    public HashMap<String, ChatFilterRule> getRules() {
        return this.rules;
    }

    public String getRulesNamesAsString() {
        String string = "";
        for (Map.Entry<String, ChatFilterRule> entry : this.rules.entrySet()) {
            if (!string.isEmpty()) {
                string = String.valueOf(string) + ", ";
            }
            string = String.valueOf(string) + entry.getKey();
        }
        return string;
    }

    public void addRule(ChatFilterRule chatFilterRule) {
        if (chatFilterRule != null && !this.rules.containsKey(chatFilterRule.getRuleName())) {
            this.rules.put(chatFilterRule.getRuleName(), chatFilterRule);
        }
    }

    public ChatFilterBlockType getMaxFilterBlockType() {
        ChatFilterBlockType chatFilterBlockType = ChatFilterBlockType.None;
        for (Map.Entry<String, ChatFilterRule> entry : this.rules.entrySet()) {
            if (this.isBypass(entry.getValue().getGroup()) || entry.getValue().getBlockType().getId() >= chatFilterBlockType.getId()) continue;
            chatFilterBlockType = entry.getValue().getBlockType();
        }
        return chatFilterBlockType;
    }

    public boolean isInformConsole() {
        boolean bl = false;
        for (Map.Entry<String, ChatFilterRule> entry : this.rules.entrySet()) {
            if (this.isBypass(entry.getValue().getGroup()) || !entry.getValue().isInformConsole()) continue;
            bl = true;
        }
        return bl;
    }

    public boolean isBypass(String string) {
        return this.bypass.contains(string.toLowerCase());
    }

    public void addBypass(String string) {
        if (!this.bypass.contains(string.toLowerCase())) {
            this.bypass.add(string.toLowerCase());
        }
    }

    public String getUpdatedMessage() {
        if (this.updatedMessage == null) {
            return this.message;
        }
        return this.updatedMessage;
    }

    public void setUpdatedMessage(String string) {
        this.updatedMessage = string;
    }

    public void informStaff(Player player) {
        for (Player player2 : Bukkit.getOnlinePlayers()) {
            if (!PermissionsManager.CMIPerm.chatfilter_inform.hasPermission((CommandSender)player2, 10000L, new String[0])) continue;
            for (Map.Entry<String, ChatFilterRule> entry : this.getRules().entrySet()) {
                ChatFilterRule chatFilterRule;
                if (this.isBypass(entry.getValue().getGroup()) || (chatFilterRule = entry.getValue()).getMessageToStaff() == null || chatFilterRule.getMessageToStaff().isEmpty()) continue;
                player2.sendMessage(CMIChatColor.translate((String)CMI.getInstance().getLM().updateSnd(new Snd().setSender(player2).setTarget(player), chatFilterRule.getMessageToStaff())).replace("[message]", this.getMessage()));
            }
        }
        if (this.isInformConsole()) {
            CMI.getInstance().consoleMessage(CMILC.info_spamConsoleInform.getLocale("[playerName]", player.getName(), "[rules]", this.getRulesNamesAsString(), "[message]", this.getMessage()));
        }
    }

    public void performCommands(Player player) {
        CMIScheduler.runTaskLater((JavaPlugin)CMI.getInstance(), () -> {
            Snd snd = new Snd().setSender(player).setTarget(player);
            for (Map.Entry<String, ChatFilterRule> entry : this.getRules().entrySet()) {
                for (String string : entry.getValue().getCommands()) {
                    if (this.isBypass(entry.getValue().getGroup())) continue;
                    String string2 = CMI.getInstance().getLM().updateSnd(snd, string);
                    string2 = string2.replace("[message]", this.getMessage());
                    string2 = string2.replace("[updatedmessage]", this.getUpdatedMessage());
                    CMI.getInstance().getSpecializedCommandManager().executeCmd(string2, null);
                }
            }
        }, (long)1L);
    }
}

