/*
 * Decompiled with CFR 0.152.
 */
package com.Zrips.CMI.Modules.ChatFilter;

import com.Zrips.CMI.CMI;
import com.Zrips.CMI.Containers.Snd;
import com.Zrips.CMI.Locale.CMILC;
import com.Zrips.CMI.Modules.ChatFilter.RuleResponse;
import com.Zrips.CMI.events.CMIPlayerChatFilterCapsEvent;
import com.Zrips.CMI.events.CMIPlayerChatFilterEvent;
import net.Zrips.CMILib.Container.CMIText;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.event.block.SignChangeEvent;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.plugin.Plugin;

public class ChatFilterListener
implements Listener {
    private CMI plugin;

    public ChatFilterListener(CMI cMI) {
        this.plugin = cMI;
        cMI.getServer().getPluginManager().registerEvent(AsyncPlayerChatEvent.class, (Listener)this, cMI.getChatFilterManager().getCapsCheckPriority().getPriority(), (listener, event) -> this.capsFilter((AsyncPlayerChatEvent)event), (Plugin)cMI, true);
        cMI.getServer().getPluginManager().registerEvent(AsyncPlayerChatEvent.class, (Listener)this, cMI.getChatFilterManager().getFilterCheckPriority().getPriority(), (listener, event) -> this.AsyncPlayerChatEvent((AsyncPlayerChatEvent)event), (Plugin)cMI, true);
        cMI.getServer().getPluginManager().registerEvent(PlayerCommandPreprocessEvent.class, (Listener)this, cMI.getChatFilterManager().getCommandSpamPriority().getPriority(), (listener, event) -> this.spamCommandFilter((PlayerCommandPreprocessEvent)event), (Plugin)cMI, true);
        cMI.getServer().getPluginManager().registerEvent(AsyncPlayerChatEvent.class, (Listener)this, cMI.getChatFilterManager().getChatSpamPriority().getPriority(), (listener, event) -> this.spamFilter((AsyncPlayerChatEvent)event), (Plugin)cMI, true);
        cMI.getServer().getPluginManager().registerEvent(SignChangeEvent.class, (Listener)this, cMI.getChatFilterManager().getSignAdvertisementPriority().getPriority(), (listener, event) -> this.onSignChangeEventAdvertisement((SignChangeEvent)event), (Plugin)cMI, true);
    }

    private void capsFilter(AsyncPlayerChatEvent asyncPlayerChatEvent) {
        if (asyncPlayerChatEvent.isCancelled() || asyncPlayerChatEvent.getRecipients().isEmpty()) {
            return;
        }
        if (this.plugin.getChatFilterManager().checkCaps(asyncPlayerChatEvent.getPlayer(), asyncPlayerChatEvent.getMessage())) {
            return;
        }
        CMIPlayerChatFilterCapsEvent cMIPlayerChatFilterCapsEvent = new CMIPlayerChatFilterCapsEvent(asyncPlayerChatEvent.getPlayer(), asyncPlayerChatEvent.getMessage());
        if (cMIPlayerChatFilterCapsEvent.isCancelled()) {
            return;
        }
        String string = asyncPlayerChatEvent.getMessage();
        if (this.plugin.getChatFilterManager().isCapToLowerCase()) {
            asyncPlayerChatEvent.setMessage(CMIText.firstToUpperCase((String)string));
        }
        if (this.plugin.getChatFilterManager().isCancelCapEvent()) {
            asyncPlayerChatEvent.getRecipients().clear();
        }
    }

    private void AsyncPlayerChatEvent(AsyncPlayerChatEvent asyncPlayerChatEvent) {
        if (asyncPlayerChatEvent.isCancelled()) {
            return;
        }
        RuleResponse ruleResponse = this.plugin.getChatFilterManager().getCorrectMessage(asyncPlayerChatEvent.getPlayer(), asyncPlayerChatEvent.getMessage());
        if (ruleResponse.getRules().isEmpty()) {
            return;
        }
        CMIPlayerChatFilterEvent cMIPlayerChatFilterEvent = new CMIPlayerChatFilterEvent(asyncPlayerChatEvent.getPlayer(), ruleResponse);
        if (cMIPlayerChatFilterEvent.isCancelled()) {
            return;
        }
        ruleResponse.informStaff(asyncPlayerChatEvent.getPlayer());
        ruleResponse.performCommands(asyncPlayerChatEvent.getPlayer());
        switch (ruleResponse.getMaxFilterBlockType()) {
            case None: {
                break;
            }
            case All: {
                asyncPlayerChatEvent.setCancelled(true);
                asyncPlayerChatEvent.getRecipients().clear();
                return;
            }
            case Others: {
                Player player = asyncPlayerChatEvent.getPlayer();
                asyncPlayerChatEvent.getRecipients().clear();
                asyncPlayerChatEvent.getRecipients().add(player);
                break;
            }
        }
        asyncPlayerChatEvent.setMessage(ruleResponse.getUpdatedMessage());
    }

    private void spamFilter(AsyncPlayerChatEvent asyncPlayerChatEvent) {
        if (asyncPlayerChatEvent.isCancelled()) {
            return;
        }
        Player player = asyncPlayerChatEvent.getPlayer();
        if (!this.plugin.getChatFilterManager().isSpam(player, asyncPlayerChatEvent.getMessage())) {
            return;
        }
        CMILC.info_noSpam.sendMessage(player, new Snd().setSender(player).setTarget(player));
        asyncPlayerChatEvent.setCancelled(true);
    }

    private void spamCommandFilter(PlayerCommandPreprocessEvent playerCommandPreprocessEvent) {
        if (playerCommandPreprocessEvent.isCancelled()) {
            return;
        }
        Player player = playerCommandPreprocessEvent.getPlayer();
        if (!this.plugin.getChatFilterManager().isSpamedCommand(player, playerCommandPreprocessEvent.getMessage())) {
            return;
        }
        CMILC.info_noCmdSpam.sendMessage(player, new Snd().setSender(player).setTarget(player));
        playerCommandPreprocessEvent.setCancelled(true);
    }

    private void onSignChangeEventAdvertisement(SignChangeEvent signChangeEvent) {
        if (signChangeEvent.isCancelled()) {
            return;
        }
        Player player = signChangeEvent.getPlayer();
        if (player == null) {
            return;
        }
        String[] stringArray = signChangeEvent.getLines();
        StringBuilder stringBuilder = new StringBuilder();
        int n = 0;
        while (n < stringArray.length) {
            if (!stringBuilder.toString().isEmpty()) {
                stringBuilder.append("%break%");
            }
            stringBuilder.append(stringArray[n]);
            ++n;
        }
        this.plugin.getPlayerManager().sendMessageToSignSpies(player, stringBuilder.toString(), signChangeEvent.getBlock().getLocation());
    }
}

