/*
 * Decompiled with CFR 0.152.
 */
package com.Zrips.CMI.Modules.Chat;

import com.Zrips.CMI.CMI;
import com.Zrips.CMI.Modules.Chat.CMIChatBubble;
import net.Zrips.CMILib.Colors.CMIChatColor;
import net.Zrips.CMILib.Version.Schedulers.CMIScheduler;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class ChatBubbleListener
implements Listener {
    private static CMI plugin;

    public ChatBubbleListener(CMI cMI) {
        plugin = cMI;
        plugin.getServer().getPluginManager().registerEvent(PlayerTeleportEvent.class, (Listener)this, EventPriority.MONITOR, (listener, event) -> ChatBubbleListener.onPlayerTeleport((PlayerTeleportEvent)event), (Plugin)plugin, true);
        plugin.getServer().getPluginManager().registerEvent(AsyncPlayerChatEvent.class, (Listener)this, plugin.getChatBubbleManager().getPriority().getPriority(), (listener, event) -> {
            AsyncPlayerChatEvent asyncPlayerChatEvent = (AsyncPlayerChatEvent)event;
            plugin.getChatBubbleManager().showBubble(asyncPlayerChatEvent.getPlayer(), String.valueOf(CMIChatColor.translate((String)CMIChatColor.getLastColors((String)asyncPlayerChatEvent.getFormat()))) + asyncPlayerChatEvent.getMessage(), asyncPlayerChatEvent.getRecipients());
        }, (Plugin)plugin, true);
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void AsyncPlayerChatEvent(AsyncPlayerChatEvent asyncPlayerChatEvent) {
        if (asyncPlayerChatEvent.isCancelled()) {
            return;
        }
    }

    private static void onPlayerTeleport(PlayerTeleportEvent playerTeleportEvent) {
        Player player = playerTeleportEvent.getPlayer();
        if (player == null) {
            return;
        }
        CMIChatBubble cMIChatBubble = plugin.getChatBubbleManager().getBubble(player.getUniqueId());
        if (cMIChatBubble == null) {
            return;
        }
        if (playerTeleportEvent.getTo() == null) {
            cMIChatBubble.delete();
            return;
        }
        if (!playerTeleportEvent.getFrom().getWorld().equals(playerTeleportEvent.getTo().getWorld())) {
            cMIChatBubble.delete();
            return;
        }
        plugin.getTeleportHandler().teleportEntity(cMIChatBubble.getDisplay().getDisplayEntity(), playerTeleportEvent.getTo(), PlayerTeleportEvent.TeleportCause.PLUGIN).thenApply(bl -> {
            if (!bl.booleanValue()) {
                if (!cMIChatBubble.getDisplay().getDisplayEntity().isDead()) {
                    CMIScheduler.runAtLocation((JavaPlugin)plugin, (Location)cMIChatBubble.getDisplay().getDisplayEntity().getLocation(), cMIChatBubble::delete);
                }
                return null;
            }
            if (!player.isOnline()) {
                return null;
            }
            player.addPassenger(cMIChatBubble.getDisplay().getDisplayEntity());
            return null;
        });
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPlayerQuitEvent(PlayerQuitEvent playerQuitEvent) {
        Player player = playerQuitEvent.getPlayer();
        if (player == null) {
            return;
        }
        plugin.getChatBubbleManager().clearCache(player.getUniqueId());
    }
}

