/*
 * Decompiled with CFR 0.152.
 */
package com.Zrips.CMI.Modules.Chat;

import com.Zrips.CMI.CMI;
import com.Zrips.CMI.Containers.CMIUser;
import com.Zrips.CMI.Modules.Display.CMITextDisplay;
import com.Zrips.CMI.Modules.Holograms.Animations.CMIHologramAnimationType;
import com.Zrips.CMI.Modules.Holograms.Animations.CMIHologramFadeInAnimation;
import com.Zrips.CMI.Modules.Holograms.Animations.CMIHologramValueChanger;
import com.Zrips.CMI.Modules.PlayerOptions.PlayerOption;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import net.Zrips.CMILib.Container.CMINumber;
import net.Zrips.CMILib.Version.Schedulers.CMIScheduler;
import net.Zrips.CMILib.Version.Schedulers.CMITask;
import net.Zrips.CMILib.Version.Schedulers.CMITaskResult;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.entity.Display;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.util.Transformation;
import org.joml.Vector3f;

public class CMIChatBubble {
    private CMITextDisplay tDisplay;
    private Player player;
    private Location originPoint;
    private String text;
    private long startTime;
    private long endTime;
    private Set<Player> receivers;
    private CMITask schedId = null;
    private CompletableFuture<CMITaskResult> initTask = null;
    CMIHologramFadeInAnimation faneId = null;

    public CMIChatBubble(Player player, String string, Set<Player> set) {
        this.player = player;
        this.text = string;
        this.receivers = new HashSet<Player>(set);
        this.receivers.remove(player);
        this.originPoint = this.generateLoc();
        this.startTime = System.currentTimeMillis();
        this.endTime = (long)((double)this.startTime + CMI.getInstance().getChatBubbleManager().getShowFor(string) * 1000.0);
        Color color = CMI.getInstance().getChatBubbleManager().getBackgroundColor();
        this.faneId = new CMIHologramFadeInAnimation(new CMIHologramValueChanger(0.0, CMI.getInstance().getChatBubbleManager().getScale(), CMIHologramValueChanger.increment(0.0, CMI.getInstance().getChatBubbleManager().getScale(), 20, 0.2)), new CMIHologramValueChanger(0.0, CMINumber.clamp((double)((float)color.getAlpha() / 255.0f), (double)0.0, (int)1), CMIHologramValueChanger.increment(0.0, CMINumber.clamp((double)((double)color.getAlpha() / 255.0), (double)0.0, (int)1), 20, 0.2)), new CMIHologramValueChanger(0.0, 1.0, CMIHologramValueChanger.increment(0.0, 1.0, 20, 0.2)));
        this.initialRecheckReceivers();
        this.initTask = CMIScheduler.runAtEntity((JavaPlugin)CMI.getInstance(), (Entity)player, this::generateDisplay);
    }

    public void show() {
        this.tasker();
    }

    private void tasker() {
        if (this.schedId != null) {
            this.schedId.cancel();
            this.schedId = null;
        }
        this.initTask.thenAccept(cMITaskResult -> {
            CompletionStage completionStage = CMIScheduler.runAtLocation((JavaPlugin)CMI.getInstance(), (Location)this.generateLoc(), this::spawnIn).thenAccept(void_ -> {
                this.tDisplay.addAsPassenger(this.receivers, (Entity)this.player);
                this.schedId = CMIScheduler.runTimerAsync((JavaPlugin)CMI.getInstance(), () -> {
                    if (this.endTime < System.currentTimeMillis() || this.receivers.isEmpty() || !this.originPoint.getWorld().equals(this.player.getWorld())) {
                        this.remove();
                        if (this.schedId != null) {
                            this.schedId.cancel();
                        }
                        this.schedId = null;
                        return;
                    }
                    this.faneId.update();
                    if (this.tDisplay == null) {
                        return;
                    }
                    if (!this.faneId.get(CMIHologramAnimationType.Opacity).finished() || !this.faneId.get(CMIHologramAnimationType.Scale).finished()) {
                        this.updateLooks();
                        for (Player player : this.receivers) {
                            this.tDisplay.update(player, false);
                        }
                    }
                }, (long)1L, (long)1L);
            });
        });
    }

    public CompletableFuture<Void> delete() {
        if (this.schedId != null) {
            this.schedId.cancel();
            this.schedId = null;
        }
        return this.remove();
    }

    private CompletableFuture<Void> remove() {
        if (this.tDisplay == null) {
            return CompletableFuture.completedFuture(null);
        }
        this.receivers.forEach(player -> this.tDisplay.destroy((Player)player));
        return CMIScheduler.runAtLocation((JavaPlugin)CMI.getInstance(), (Location)this.tDisplay.getLocation(), () -> {
            this.tDisplay.getDisplayEntity().leaveVehicle();
            this.tDisplay.getDisplayEntity().remove();
        });
    }

    private Location generateLoc() {
        Location location = this.player.getLocation().clone().add(0.0, 1.8, 0.0);
        location.setPitch(0.0f);
        location.setYaw(0.0f);
        return location;
    }

    private void spawnIn() {
        for (Player player : this.receivers) {
            this.tDisplay.show(player);
        }
    }

    private void initialRecheckReceivers() {
        Iterator<Player> iterator = this.receivers.iterator();
        while (iterator.hasNext()) {
            Player player = iterator.next();
            if (!CMI.getInstance().getChatBubbleManager().inRange(player.getLocation(), this.player.getLocation())) {
                if (this.tDisplay != null) {
                    this.tDisplay.destroy(player);
                }
                iterator.remove();
                continue;
            }
            if (!player.canSee(this.player)) {
                if (this.tDisplay != null) {
                    this.tDisplay.destroy(player);
                }
                iterator.remove();
                continue;
            }
            if (CMIUser.getUser(player).getOptionState(PlayerOption.chatbubble).booleanValue()) continue;
            if (this.tDisplay != null) {
                this.tDisplay.destroy(player);
            }
            iterator.remove();
        }
    }

    private void updateLooks() {
        if (this.tDisplay == null) {
            return;
        }
        this.tDisplay.setWidth(this.faneId.getCurrent(CMIHologramAnimationType.Scale));
        this.tDisplay.setHeight(this.faneId.getCurrent(CMIHologramAnimationType.Scale));
        if (CMI.getInstance().getChatBubbleManager().getBackgroundColor() != null) {
            Color color = CMI.getInstance().getChatBubbleManager().getBackgroundColor();
            color = Color.fromARGB((int)CMINumber.clamp((int)((int)(this.faneId.getCurrent(CMIHologramAnimationType.Opacity) * 255.0)), (int)0, (int)255), (int)color.getRed(), (int)color.getGreen(), (int)color.getBlue());
            this.tDisplay.setBackgroundColor(color);
        }
        this.tDisplay.setTextOpacity((byte)CMINumber.clamp((int)((int)(this.faneId.getCurrent(CMIHologramAnimationType.TextOpacity) * 255.0)), (int)0, (int)255));
    }

    private void generateDisplay() {
        this.tDisplay = new CMITextDisplay(this.originPoint);
        this.tDisplay.setText(" " + this.text + " ");
        this.tDisplay.setLineWidth(CMI.getInstance().getChatBubbleManager().getLineWidth());
        this.tDisplay.setBillboard(Display.Billboard.VERTICAL);
        this.tDisplay.setRange(32);
        this.updateLooks();
        this.tDisplay.setShadowed(CMI.getInstance().getChatBubbleManager().isShadow());
        Transformation transformation = this.tDisplay.getTransformation();
        Vector3f vector3f = transformation.getTranslation();
        vector3f.add(0.0f, (float)(CMI.getInstance().getChatBubbleManager().getOffset() - (double)1.7f), 0.0f);
        this.tDisplay.getTransformation(transformation);
    }

    public CMITextDisplay getDisplay() {
        return this.tDisplay;
    }
}

