/*
 * Decompiled with CFR 0.152.
 */
package com.Zrips.CMI.Modules.ArmorEffects;

import com.Zrips.CMI.CMI;
import com.Zrips.CMI.Containers.CMIUser;
import com.Zrips.CMI.utils.CMIEncoder;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import net.Zrips.CMILib.Container.CMINumber;
import net.Zrips.CMILib.NBT.CMINBT;
import net.Zrips.CMILib.Version.Schedulers.CMIScheduler;
import net.Zrips.CMILib.Version.Schedulers.CMITask;
import net.Zrips.CMILib.Version.Version;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class ArmorEffectManager {
    private CMI plugin;
    public static final String NBTName = "CMIArmorEffects";
    private Set<UUID> players = new HashSet<UUID>();
    private CMITask saveId = null;

    public ArmorEffectManager(CMI cMI) {
        this.plugin = cMI;
    }

    public void removePlayer(UUID uUID) {
        this.players.remove(uUID);
        if (this.players.isEmpty()) {
            this.onDisable();
        }
    }

    public void addPlayer(UUID uUID) {
        this.players.add(uUID);
    }

    public void onDisable() {
        if (this.saveId != null) {
            this.saveId.cancel();
            this.saveId = null;
        }
    }

    public void tasker() {
        if (this.saveId != null) {
            return;
        }
        this.saveId = CMIScheduler.scheduleSyncRepeatingTask((JavaPlugin)this.plugin, () -> {
            if (this.players.isEmpty()) {
                this.onDisable();
                return;
            }
            Iterator<UUID> iterator = this.players.iterator();
            while (iterator.hasNext()) {
                UUID uUID = iterator.next();
                Player player = CMIUser.getOnlinePlayer(uUID);
                if (player == null || !player.isOnline()) {
                    iterator.remove();
                    continue;
                }
                if (this.checkPlayerArmor(player)) continue;
                iterator.remove();
            }
        }, (long)280L, (long)280L);
    }

    public boolean checkPlayerArmor(Player player) {
        HashMap<PotionEffectType, PotionEffect> hashMap = new HashMap<PotionEffectType, PotionEffect>();
        ItemStack[] itemStackArray = player.getInventory().getArmorContents();
        int n = itemStackArray.length;
        int n2 = 0;
        while (n2 < n) {
            List<String> list2;
            CMINBT cMINBT;
            ItemStack itemStack = itemStackArray[n2];
            if (itemStack != null && (cMINBT = new CMINBT(itemStack)).hasNBT(NBTName) && (list2 = cMINBT.getList(NBTName)) != null && (list2 = CMIEncoder.decodeList(list2)) != null) {
                for (String string : list2) {
                    PotionEffect potionEffect;
                    PotionEffect potionEffect2 = this.plugin.getUtilManager().deserializePotionEffect(string);
                    if (potionEffect2 == null || potionEffect2.getType().equals(PotionEffectType.NIGHT_VISION) && (potionEffect2 = this.plugin.getUtilManager().deserializePotionEffect(string, 30)) == null || (potionEffect = (PotionEffect)hashMap.get(potionEffect2.getType())) != null && potionEffect.getAmplifier() > potionEffect2.getAmplifier()) continue;
                    hashMap.put(potionEffect2.getType(), potionEffect2);
                }
            }
            ++n2;
        }
        for (ItemStack itemStack : hashMap.values()) {
            if (itemStack == null) continue;
            PotionEffect potionEffect = ArmorEffectManager.getPotionEffect(player, itemStack.getType());
            if (potionEffect != null) {
                if ((!potionEffect.getType().equals(PotionEffectType.NIGHT_VISION) || potionEffect.getDuration() - 20 > itemStack.getDuration()) && potionEffect.getDuration() - 12 > itemStack.getDuration()) continue;
                if (potionEffect.getType().equals(PotionEffectType.HEALTH_BOOST)) {
                    if (Version.isCurrentLower((Version)Version.v1_20_R1)) {
                        double d = player.getHealth();
                        player.removePotionEffect(itemStack.getType());
                        player.addPotionEffect((PotionEffect)itemStack);
                        player.setHealth(CMINumber.clamp((double)d, (double)1.0, (double)player.getMaxHealth()));
                        continue;
                    }
                    player.addPotionEffect((PotionEffect)itemStack);
                    continue;
                }
                if (Version.isCurrentLower((Version)Version.v1_20_R1)) {
                    player.removePotionEffect(itemStack.getType());
                }
                player.addPotionEffect((PotionEffect)itemStack);
                if (!player.isFlying() || !itemStack.getType().getName().equals("LEVITATION")) continue;
                player.setFlying(false);
                continue;
            }
            player.addPotionEffect((PotionEffect)itemStack);
            if (!player.isFlying() || !itemStack.getType().getName().equals("LEVITATION")) continue;
            player.setFlying(false);
        }
        return !hashMap.isEmpty();
    }

    public static PotionEffect getPotionEffect(Player player, PotionEffectType potionEffectType) {
        if (Version.isCurrentEqualOrHigher((Version)Version.v1_20_R1)) {
            return player.getPotionEffect(potionEffectType);
        }
        for (PotionEffect potionEffect : player.getActivePotionEffects()) {
            if (potionEffect.getType() != potionEffectType) continue;
            return potionEffect;
        }
        return null;
    }
}

