/*
 * Decompiled with CFR 0.152.
 */
package com.Zrips.CMI.Modules.ArmorEffects;

import com.Zrips.CMI.CMI;
import com.Zrips.CMI.Modules.ArmorEffects.ArmorEffectManager;
import com.Zrips.CMI.events.CMIArmorChangeEvent;
import com.Zrips.CMI.utils.CMIEncoder;
import java.util.HashMap;
import java.util.List;
import net.Zrips.CMILib.Items.ArmorTypes;
import net.Zrips.CMILib.NBT.CMINBT;
import net.Zrips.CMILib.Version.Schedulers.CMIScheduler;
import net.Zrips.CMILib.Version.Version;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class ArmorEffectListener
implements Listener {
    private CMI plugin;

    public ArmorEffectListener(CMI cMI) {
        this.plugin = cMI;
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onBlockInteract(CMIArmorChangeEvent cMIArmorChangeEvent) {
        if (cMIArmorChangeEvent.isCancelled()) {
            return;
        }
        Player player = cMIArmorChangeEvent.getPlayer();
        this.modifyOldEffect(player, cMIArmorChangeEvent.getOldArmorPiece());
        CMIScheduler.runTask((JavaPlugin)this.plugin, () -> this.applyNewEffect(player, cMIArmorChangeEvent.getType()));
    }

    private static ItemStack[] getArmorContents(Player player) {
        if (Version.isCurrentEqualOrHigher((Version)Version.v1_9_R1)) {
            return player.getInventory().getArmorContents();
        }
        ItemStack[] itemStackArray = new ItemStack[]{player.getInventory().getHelmet(), player.getInventory().getChestplate(), player.getInventory().getLeggings(), player.getInventory().getBoots()};
        return itemStackArray;
    }

    private void modifyOldEffect(Player player, ItemStack itemStack) {
        CMINBT cMINBT;
        if (itemStack == null) {
            return;
        }
        CMINBT cMINBT2 = new CMINBT(itemStack);
        if (!cMINBT2.hasNBT("CMIArmorEffects")) {
            return;
        }
        List<String> list2 = cMINBT2.getList("CMIArmorEffects");
        if (list2 == null) {
            return;
        }
        if ((list2 = CMIEncoder.decodeList(list2)) == null) {
            return;
        }
        HashMap<PotionEffectType, PotionEffect> hashMap = new HashMap<PotionEffectType, PotionEffect>();
        PotionEffect potionEffect = ArmorEffectListener.getArmorContents(player);
        int n = ((ItemStack[])potionEffect).length;
        int n2 = 0;
        while (n2 < n) {
            List<String> list3;
            ItemStack object = potionEffect[n2];
            if (object != null && !object.equals((Object)itemStack) && (cMINBT = new CMINBT(object)).hasNBT("CMIArmorEffects") && (list3 = cMINBT.getList("CMIArmorEffects")) != null && (list3 = CMIEncoder.decodeList(list3)) != null) {
                for (String string : list3) {
                    PotionEffect potionEffect2;
                    PotionEffect potionEffect3 = this.plugin.getUtilManager().deserializePotionEffect(string);
                    if (potionEffect3 == null || potionEffect3.getType().equals(PotionEffectType.NIGHT_VISION) && (potionEffect3 = this.plugin.getUtilManager().deserializePotionEffect(string, 30)) == null || (potionEffect2 = (PotionEffect)hashMap.get(potionEffect3.getType())) != null && potionEffect2.getAmplifier() > potionEffect3.getAmplifier()) continue;
                    hashMap.put(potionEffect3.getType(), potionEffect3);
                }
            }
            ++n2;
        }
        for (String string : list2) {
            PotionEffect potionEffect4 = this.plugin.getUtilManager().deserializePotionEffect(string);
            if (potionEffect4 == null || potionEffect4.getType().equals(PotionEffectType.NIGHT_VISION) && (potionEffect4 = this.plugin.getUtilManager().deserializePotionEffect(string, 30)) == null || (potionEffect = ArmorEffectManager.getPotionEffect(player, potionEffect4.getType())) == null) continue;
            if (potionEffect.getDuration() <= potionEffect4.getDuration() * 2) {
                if (hashMap.containsKey(potionEffect4.getType())) {
                    cMINBT = (PotionEffect)hashMap.get(potionEffect4.getType());
                    if (cMINBT.getAmplifier() > potionEffect4.getAmplifier()) continue;
                    player.removePotionEffect(potionEffect4.getType());
                    player.addPotionEffect((PotionEffect)cMINBT);
                    continue;
                }
                player.removePotionEffect(potionEffect4.getType());
                continue;
            }
            cMINBT = new PotionEffect(potionEffect.getType(), potionEffect.getDuration() - potionEffect4.getDuration(), potionEffect4.getAmplifier(), true, potionEffect4.hasParticles());
            player.removePotionEffect(potionEffect4.getType());
            player.addPotionEffect((PotionEffect)cMINBT);
        }
    }

    private void applyNewEffect(Player player, ArmorTypes armorTypes) {
        ItemStack itemStack = player.getInventory().getItem(44 - armorTypes.getSlot());
        if (itemStack == null) {
            return;
        }
        CMINBT cMINBT = new CMINBT(itemStack);
        if (!cMINBT.hasNBT("CMIArmorEffects")) {
            return;
        }
        List<String> list2 = cMINBT.getList("CMIArmorEffects");
        if (list2 == null) {
            return;
        }
        if ((list2 = CMIEncoder.decodeList(list2)) == null) {
            return;
        }
        for (String string : list2) {
            PotionEffect potionEffect = this.plugin.getUtilManager().deserializePotionEffect(string);
            if (potionEffect == null || potionEffect.getType().equals(PotionEffectType.NIGHT_VISION) && (potionEffect = this.plugin.getUtilManager().deserializePotionEffect(string, 30)) == null) continue;
            PotionEffect potionEffect2 = ArmorEffectManager.getPotionEffect(player, potionEffect.getType());
            if (potionEffect2 != null && potionEffect2.getAmplifier() < potionEffect.getAmplifier()) {
                player.removePotionEffect(potionEffect.getType());
            }
            player.addPotionEffect(potionEffect);
        }
        this.plugin.getArmorEffectManager().addPlayer(player.getUniqueId());
        this.plugin.getArmorEffectManager().tasker();
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPlayerLoginNameCheck(PlayerJoinEvent playerJoinEvent) {
        CMIScheduler.runTaskLater((JavaPlugin)this.plugin, () -> {
            if (playerJoinEvent.getPlayer().isOnline() && this.plugin.getArmorEffectManager().checkPlayerArmor(playerJoinEvent.getPlayer())) {
                this.plugin.getArmorEffectManager().addPlayer(playerJoinEvent.getPlayer().getUniqueId());
            }
        }, (long)20L);
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPlayerQuit(PlayerQuitEvent playerQuitEvent) {
        this.plugin.getArmorEffectManager().removePlayer(playerQuitEvent.getPlayer().getUniqueId());
    }
}

