/*
 * Decompiled with CFR 0.152.
 */
package com.Zrips.CMI.Modules.Anvil;

import com.Zrips.CMI.CMI;
import com.Zrips.CMI.Reflections;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import net.Zrips.CMILib.CMILib;
import net.Zrips.CMILib.Colors.CMIChatColor;
import net.Zrips.CMILib.RawMessages.RawMessage;
import net.Zrips.CMILib.Version.Version;
import net.minecraft.core.BlockPosition;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.protocol.game.PacketPlayOutOpenWindow;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.player.PlayerInventory;
import net.minecraft.world.inventory.ContainerAccess;
import net.minecraft.world.inventory.ContainerAnvil;
import net.minecraft.world.inventory.Containers;
import net.minecraft.world.level.World;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.PrepareAnvilEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;

public class CMIAnvilGUI {
    private boolean colorrename = false;
    private Player player;
    private String title = "Repair & Name";
    private String defaulttext = "";
    private Inventory inventory;
    private HashMap<AnvilSlot, ItemStack> items = new HashMap();
    private Listener listener;
    private AnvilClickEventHandler handler;
    private static Class<?> BlockPosition;
    private static Class<?> PacketPlayOutOpenWindow;
    private static Class<?> ContainerAnvil;
    private static Class<?> ChatMessage;
    private static Class<?> EntityHuman;
    private static Class<?> ContainerAccess;
    private static Class<?> Containers;
    private static Class<?> Container;
    private static boolean useNewVersion;

    static {
        useNewVersion = true;
        CMIAnvilGUI.loadClasses();
    }

    private static void loadClasses() {
        if (Version.isCurrentEqualOrHigher((Version)Version.v1_17_R1)) {
            try {
                Container = Class.forName("net.minecraft.world.inventory.Container");
            }
            catch (Throwable throwable) {
                useNewVersion = false;
            }
        } else {
            try {
                Class.forName("net.minecraft.server." + Version.getCurrent().toString() + ".ContainerAccess");
                useNewVersion = true;
            }
            catch (Error | Exception throwable) {
                useNewVersion = false;
            }
            Reflections reflections = CMI.getInstance().getReflectionManager();
            BlockPosition = reflections.getMinecraftClass("BlockPosition");
            PacketPlayOutOpenWindow = reflections.getMinecraftClass("PacketPlayOutOpenWindow");
            ContainerAnvil = reflections.getMinecraftClass("ContainerAnvil");
            ChatMessage = reflections.getMinecraftClass("ChatMessage");
            EntityHuman = reflections.getMinecraftClass("EntityHuman");
            if (useNewVersion) {
                ContainerAccess = reflections.getMinecraftClass("ContainerAccess");
                Containers = reflections.getMinecraftClass("Containers");
            }
        }
    }

    public boolean getColorRename() {
        return this.colorrename;
    }

    public void setColorRename(boolean bl) {
        this.colorrename = bl;
    }

    public Player getPlayer() {
        return this.player;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String string) {
        this.title = string;
    }

    public String getDefaultText() {
        return this.defaulttext;
    }

    public void setDefaultText(String string) {
        this.defaulttext = string;
    }

    public ItemStack getSlot(AnvilSlot anvilSlot) {
        return this.items.get((Object)anvilSlot);
    }

    public void setSlot(AnvilSlot anvilSlot, ItemStack itemStack) {
        this.items.put(anvilSlot, itemStack);
    }

    public String getSlotName(AnvilSlot anvilSlot) {
        ItemStack itemStack = this.getSlot(anvilSlot);
        if (itemStack != null && itemStack.hasItemMeta()) {
            ItemMeta itemMeta = itemStack.getItemMeta();
            return itemMeta.hasDisplayName() ? itemMeta.getDisplayName() : "";
        }
        return "";
    }

    public void setSlotName(AnvilSlot anvilSlot, String string) {
        ItemStack itemStack = this.getSlot(anvilSlot);
        if (itemStack != null) {
            ItemMeta itemMeta = itemStack.getItemMeta();
            itemMeta.setDisplayName(string != null ? CMIChatColor.translate((String)string) : null);
            itemStack.setItemMeta(itemMeta);
            this.setSlot(anvilSlot, itemStack);
        }
    }

    public CMIAnvilGUI(Player player, AnvilClickEventHandler anvilClickEventHandler) {
        this.player = player;
        this.handler = anvilClickEventHandler;
        this.listener = null;
        this.listener = Version.isCurrentEqualOrLower((Version)Version.v1_8_R3) ? new Listener(){

            @EventHandler
            public void ICE(InventoryClickEvent inventoryClickEvent) {
                Object object;
                if (!inventoryClickEvent.getInventory().equals(CMIAnvilGUI.this.inventory)) {
                    return;
                }
                if (inventoryClickEvent.getClick() != ClickType.LEFT && inventoryClickEvent.getClick() != ClickType.RIGHT) {
                    return;
                }
                ItemStack itemStack = inventoryClickEvent.getCurrentItem();
                int n = inventoryClickEvent.getRawSlot();
                String string = null;
                if (itemStack != null && itemStack.hasItemMeta() && (object = itemStack.getItemMeta()).hasDisplayName()) {
                    string = object.getDisplayName();
                }
                object = new AnvilClickEvent(AnvilSlot.bySlot(n), itemStack, string);
                CMIAnvilGUI.this.handler.onAnvilClick((AnvilClickEvent)object);
            }

            @EventHandler
            public void ICE(InventoryCloseEvent inventoryCloseEvent) {
                if (!inventoryCloseEvent.getInventory().equals(CMIAnvilGUI.this.inventory)) {
                    return;
                }
                CMIAnvilGUI.this.handler.onAnvilClose(inventoryCloseEvent);
                if (CMIAnvilGUI.this.inventory.getItem(0) != null) {
                    CMIAnvilGUI.this.player.getInventory().addItem(new ItemStack[]{CMIAnvilGUI.this.inventory.getItem(0)});
                }
                if (CMIAnvilGUI.this.inventory.getItem(1) != null) {
                    CMIAnvilGUI.this.player.getInventory().addItem(new ItemStack[]{CMIAnvilGUI.this.inventory.getItem(1)});
                }
                CMIAnvilGUI.this.inventory.clear();
                HandlerList.unregisterAll((Listener)CMIAnvilGUI.this.listener);
            }

            @EventHandler
            public void PQE(PlayerQuitEvent playerQuitEvent) {
                if (!playerQuitEvent.getPlayer().equals(CMIAnvilGUI.this.player)) {
                    return;
                }
                HandlerList.unregisterAll((Listener)CMIAnvilGUI.this.listener);
            }
        } : new Listener(){

            @EventHandler
            public void ICE(InventoryClickEvent inventoryClickEvent) {
                Object object;
                if (!inventoryClickEvent.getInventory().equals(CMIAnvilGUI.this.inventory)) {
                    return;
                }
                if (inventoryClickEvent.getClick() != ClickType.LEFT && inventoryClickEvent.getClick() != ClickType.RIGHT) {
                    return;
                }
                ItemStack itemStack = inventoryClickEvent.getCurrentItem();
                int n = inventoryClickEvent.getRawSlot();
                String string = null;
                if (itemStack != null && itemStack.hasItemMeta() && (object = itemStack.getItemMeta()).hasDisplayName()) {
                    string = object.getDisplayName();
                }
                object = new AnvilClickEvent(AnvilSlot.bySlot(n), itemStack, string);
                CMIAnvilGUI.this.handler.onAnvilClick((AnvilClickEvent)object);
            }

            @EventHandler
            public void PAE(PrepareAnvilEvent prepareAnvilEvent) {
                if (!prepareAnvilEvent.getInventory().equals(CMIAnvilGUI.this.inventory)) {
                    return;
                }
                ItemStack itemStack = prepareAnvilEvent.getResult();
                if (CMIAnvilGUI.this.colorrename && itemStack != null && itemStack.hasItemMeta()) {
                    ItemMeta itemMeta = itemStack.getItemMeta();
                    if (itemMeta.hasDisplayName()) {
                        itemMeta.setDisplayName(CMIChatColor.translate((String)itemMeta.getDisplayName()));
                    }
                    itemStack.setItemMeta(itemMeta);
                    prepareAnvilEvent.setResult(itemStack);
                }
            }

            @EventHandler
            public void ICE(InventoryCloseEvent inventoryCloseEvent) {
                if (!inventoryCloseEvent.getInventory().equals(CMIAnvilGUI.this.inventory)) {
                    return;
                }
                CMIAnvilGUI.this.handler.onAnvilClose(inventoryCloseEvent);
                if (CMIAnvilGUI.this.inventory.getItem(0) != null) {
                    CMIAnvilGUI.this.player.getInventory().addItem(new ItemStack[]{CMIAnvilGUI.this.inventory.getItem(0)});
                }
                if (CMIAnvilGUI.this.inventory.getItem(1) != null) {
                    CMIAnvilGUI.this.player.getInventory().addItem(new ItemStack[]{CMIAnvilGUI.this.inventory.getItem(1)});
                }
                CMIAnvilGUI.this.inventory.clear();
                HandlerList.unregisterAll((Listener)CMIAnvilGUI.this.listener);
            }

            @EventHandler
            public void PQE(PlayerQuitEvent playerQuitEvent) {
                if (!playerQuitEvent.getPlayer().equals(CMIAnvilGUI.this.player)) {
                    return;
                }
                HandlerList.unregisterAll((Listener)CMIAnvilGUI.this.listener);
            }
        };
        Bukkit.getPluginManager().registerEvents(this.listener, (Plugin)CMI.getInstance());
    }

    public void open() {
        this.open(this.title);
    }

    public Field getField(Class<?> clazz, String string) {
        Field field = clazz.getDeclaredField(string);
        field.setAccessible(true);
        return field;
    }

    public void open(String string) {
        net.Zrips.CMILib.Reflections reflections = CMILib.getInstance().getReflectionManager();
        try {
            Object object = reflections.getPlayerHandle(this.player);
            if (Version.isCurrentEqualOrHigher((Version)Version.v1_18_R1)) {
                if (Version.isPaperBranch()) {
                    CMI.getInstance().getReflectionManager().openAnvil(this.player);
                    return;
                }
            } else if (Version.isCurrentEqualOrHigher((Version)Version.v1_17_R1)) {
                if (Version.isPaperBranch()) {
                    CMI.getInstance().getReflectionManager().openAnvil(this.player);
                    return;
                }
                EntityPlayer entityPlayer = (EntityPlayer)object;
                BlockPosition blockPosition = new BlockPosition(0, 0, 0);
                Class<?> clazz = Class.forName("net.minecraft.world.inventory.ContainerAccess");
                Object object2 = entityPlayer.getClass().getField("t").get(entityPlayer);
                ContainerAccess containerAccess = (ContainerAccess)clazz.getMethod("at", World.class, blockPosition.getClass()).invoke(clazz, object2, blockPosition);
                EntityHuman entityHuman = (EntityHuman)EntityHuman.class.cast(CMILib.getInstance().getReflectionManager().getPlayerHandle(this.player));
                Object object3 = entityHuman.getClass().getMethod("getInventory", new Class[0]).invoke((Object)entityHuman, new Object[0]);
                ContainerAnvil containerAnvil = new ContainerAnvil(9, (PlayerInventory)object3, containerAccess);
                Field field = containerAnvil.getClass().getField("checkReachable");
                field.setAccessible(true);
                field.set(containerAnvil, false);
                Object object4 = containerAnvil.getClass().getMethod("getBukkitView", new Class[0]).invoke((Object)containerAnvil, new Object[0]);
                this.inventory = (Inventory)object4.getClass().getMethod("getTopInventory", new Class[0]).invoke(object4, new Object[0]);
                for (AnvilSlot anvilSlot : this.items.keySet()) {
                    this.inventory.setItem(anvilSlot.getSlot(), this.items.get((Object)anvilSlot));
                }
                entityHuman.getClass().getField("bV").set(entityHuman, Container.cast(containerAnvil));
                int n = entityPlayer.nextContainerCounter();
                Field field2 = entityHuman.getClass().getField("bV").get(entityHuman).getClass().getField("j");
                field2.setAccessible(true);
                field2.set(entityHuman.getClass().getField("bV").get(entityHuman), n);
                RawMessage rawMessage = new RawMessage();
                rawMessage.addText(this.title);
                PacketPlayOutOpenWindow packetPlayOutOpenWindow = new PacketPlayOutOpenWindow(n, net.minecraft.world.inventory.Containers.h, (IChatBaseComponent)CMILib.getInstance().getReflectionManager().textToIChatBaseComponent(rawMessage.getRaw()));
                CMILib.getInstance().getReflectionManager().sendPlayerPacket(this.player, (Object)packetPlayOutOpenWindow);
            } else {
                Constructor<?> constructor = ChatMessage.getConstructor(String.class, Object[].class);
                if (useNewVersion) {
                    Method method = reflections.getMethod("at", ContainerAccess, new Class[]{reflections.getMinecraftClass("World"), BlockPosition});
                    Object obj = ContainerAnvil.getConstructor(Integer.TYPE, reflections.getMinecraftClass("PlayerInventory"), ContainerAccess).newInstance(9, reflections.getPlayerField(this.player, "inventory"), method.invoke(ContainerAccess, reflections.getPlayerField(this.player, "world"), BlockPosition.getConstructor(Integer.TYPE, Integer.TYPE, Integer.TYPE).newInstance(0, 0, 0)));
                    this.getField(reflections.getMinecraftClass("Container"), "checkReachable").set(obj, false);
                    this.inventory = (Inventory)reflections.invokeMethod("getTopInventory", reflections.invokeMethod("getBukkitView", obj));
                    for (AnvilSlot anvilSlot : this.items.keySet()) {
                        this.inventory.setItem(anvilSlot.getSlot(), this.items.get((Object)anvilSlot));
                    }
                    int n = (Integer)reflections.invokeMethod("nextContainerCounter", object);
                    Object object5 = reflections.getPlayerField(this.player, "playerConnection");
                    Object obj2 = PacketPlayOutOpenWindow.getConstructor(Integer.TYPE, Containers, reflections.getMinecraftClass("IChatBaseComponent")).newInstance(n, this.getField(Containers, "ANVIL").get(Containers), constructor.newInstance(CMIChatColor.translate((String)string), new Object[0]));
                    Method method2 = reflections.getMethod("sendPacket", object5.getClass(), new Class[]{PacketPlayOutOpenWindow});
                    method2.invoke(object5, obj2);
                    Field field = this.getField(EntityHuman, "activeContainer");
                    if (field != null) {
                        field.set(object, obj);
                        this.getField(reflections.getMinecraftClass("Container"), "windowId").set(field.get(object), n);
                        reflections.getMethod("addSlotListener", field.get(object).getClass(), new Class[]{object.getClass()}).invoke(field.get(object), object);
                        Object t = reflections.getMinecraftClass("Container").cast(field.get(object));
                        t.getClass().getMethod("setTitle", reflections.getMinecraftClass("IChatBaseComponent")).invoke(t, CMILib.getInstance().getReflectionManager().textToIChatBaseComponent("{\"text\": \"" + CMIChatColor.translate((String)this.title) + "\"}"));
                    }
                } else {
                    Object obj = ContainerAnvil.getConstructor(reflections.getMinecraftClass("PlayerInventory"), reflections.getMinecraftClass("World"), BlockPosition, EntityHuman).newInstance(reflections.getPlayerField(this.player, "inventory"), reflections.getPlayerField(this.player, "world"), BlockPosition.getConstructor(Integer.TYPE, Integer.TYPE, Integer.TYPE).newInstance(0, 0, 0), object);
                    this.getField(reflections.getMinecraftClass("Container"), "checkReachable").set(obj, false);
                    this.inventory = (Inventory)reflections.invokeMethod("getTopInventory", reflections.invokeMethod("getBukkitView", obj));
                    for (AnvilSlot anvilSlot : this.items.keySet()) {
                        this.inventory.setItem(anvilSlot.getSlot(), this.items.get((Object)anvilSlot));
                    }
                    int n = (Integer)reflections.invokeMethod("nextContainerCounter", object);
                    Object object6 = reflections.getPlayerField(this.player, "playerConnection");
                    Object obj3 = PacketPlayOutOpenWindow.getConstructor(Integer.TYPE, String.class, reflections.getMinecraftClass("IChatBaseComponent"), Integer.TYPE).newInstance(n, "minecraft:anvil", constructor.newInstance(CMIChatColor.translate((String)string), new Object[0]), 0);
                    Method method = reflections.getMethod("sendPacket", object6.getClass(), new Class[]{PacketPlayOutOpenWindow});
                    method.invoke(object6, obj3);
                    Field field = this.getField(EntityHuman, "activeContainer");
                    if (field != null) {
                        field.set(object, obj);
                        this.getField(reflections.getMinecraftClass("Container"), "windowId").set(field.get(object), n);
                        try {
                            reflections.getMethod("addSlotListener", field.get(object).getClass(), new Class[]{object.getClass()}).invoke(field.get(object), object);
                        }
                        catch (Throwable throwable) {}
                    }
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public class AnvilClickEvent {
        private AnvilSlot slot;
        private ItemStack item;
        private String text;

        public AnvilClickEvent(AnvilSlot anvilSlot, ItemStack itemStack, String string) {
            this.slot = anvilSlot;
            this.item = itemStack;
            this.text = string;
        }

        public AnvilSlot getSlot() {
            return this.slot;
        }

        public ItemStack getItemStack() {
            return this.item;
        }

        public void setItemStack(ItemStack itemStack) {
            this.item = itemStack;
            CMIAnvilGUI.this.inventory.setItem(this.slot.getSlot(), this.item);
        }

        public boolean hasText() {
            return this.text != null;
        }

        public String getText() {
            return this.text != null ? this.text : CMIAnvilGUI.this.defaulttext;
        }
    }

    public static interface AnvilClickEventHandler {
        public void onAnvilClick(AnvilClickEvent var1);

        public void onAnvilClose(InventoryCloseEvent var1);
    }

    public static enum AnvilSlot {
        INPUT_LEFT(0),
        INPUT_RIGHT(1),
        OUTPUT(2);

        private int slot;

        private AnvilSlot(int n2) {
            this.slot = n2;
        }

        public int getSlot() {
            return this.slot;
        }

        public static AnvilSlot bySlot(int n) {
            AnvilSlot[] anvilSlotArray = AnvilSlot.values();
            int n2 = anvilSlotArray.length;
            int n3 = 0;
            while (n3 < n2) {
                AnvilSlot anvilSlot = anvilSlotArray[n3];
                if (anvilSlot.getSlot() == n) {
                    return anvilSlot;
                }
                ++n3;
            }
            return null;
        }
    }
}

