/*
 * Decompiled with CFR 0.152.
 */
package com.Zrips.CMI.Modules.Animations;

import com.Zrips.CMI.CMI;
import com.Zrips.CMI.Containers.CMIPlayerInventory;
import com.Zrips.CMI.Containers.CMIUser;
import com.Zrips.CMI.Locale.CMILC;
import com.Zrips.CMI.Modules.Animations.LeatherAnimation;
import com.Zrips.CMI.Modules.Chat.CMIChatBubble;
import com.Zrips.CMI.Modules.Worlds.CMIBiome;
import com.Zrips.CMI.events.CMIPlayerSitEvent;
import java.awt.Color;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import net.Zrips.CMILib.Container.CMIBlock;
import net.Zrips.CMILib.Container.CMINumber;
import net.Zrips.CMILib.FileHandler.ConfigReader;
import net.Zrips.CMILib.Items.CMIMaterial;
import net.Zrips.CMILib.Items.SlabType;
import net.Zrips.CMILib.NBT.CMINBT;
import net.Zrips.CMILib.Version.Schedulers.CMIScheduler;
import net.Zrips.CMILib.Version.Schedulers.CMITask;
import net.Zrips.CMILib.Version.Version;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.attribute.Attribute;
import org.bukkit.block.Biome;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.entity.Slime;
import org.bukkit.entity.Steerable;
import org.bukkit.event.Event;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.LeatherArmorMeta;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.util.Vector;

public class AnimationManager {
    private CMI plugin;
    CMITask task = null;
    public static final String CMIArmorStandForSit = "CMIArmorStandForSit";
    public static final String CMIRainbowArmor = "CMIRainbowArmor";
    public static final String CMISoulBound = "CMISoulBound";
    public static final String CMIFakeSlime = "CMIFakeSlime";
    HashMap<UUID, Long> doubleClick = new HashMap();
    HashMap<UUID, LeatherAnimation> leatherArmor = new HashMap();
    HashMap<UUID, Chair> playerSittingMap = new HashMap();
    HashMap<String, UUID> chairLoc = new HashMap();
    private HashMap<UUID, UUID> riding = new HashMap();
    private ConcurrentHashMap<UUID, Location> ridingNonSteerable = new ConcurrentHashMap();
    private HashMap<UUID, UUID> beingRidden = new HashMap();
    private boolean SitOnStairs = true;
    private boolean StairsAsChairs = true;
    private boolean SlabsAsChairs = true;
    private boolean CarpetsAsChairs = true;
    private boolean RemoveFromChairOnDamage = true;
    private boolean DoubleClick = true;
    private int DoubleClickDelay = 200;
    private int chairRange = 200;
    List<CMIPlayerInventory.CMIInventorySlot> armorTypes = new ArrayList<CMIPlayerInventory.CMIInventorySlot>(Arrays.asList(CMIPlayerInventory.CMIInventorySlot.Helmet, CMIPlayerInventory.CMIInventorySlot.ChestPlate, CMIPlayerInventory.CMIInventorySlot.Pants, CMIPlayerInventory.CMIInventorySlot.Boots));
    private CMITask autoTimerBukkitId = null;
    private Runnable autoTimer = new Runnable(){

        @Override
        public void run() {
            try {
                AnimationManager.this.checkLeatherArmors();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    };
    private static Method method = null;
    private static Field field = null;
    CMITask ridingTask = null;

    public AnimationManager(CMI cMI) {
        this.plugin = cMI;
    }

    public void clearCache(UUID uUID) {
        Chair chair;
        this.doubleClick.remove(uUID);
        this.leatherArmor.remove(uUID);
        UUID uUID2 = this.riding.remove(uUID);
        if (uUID2 != null) {
            this.beingRidden.remove(uUID2);
        }
        if ((chair = this.playerSittingMap.remove(uUID)) != null && chair.getChairLoc() != null) {
            this.chairLoc.remove(this.plugin.getUtilManager().convertLocToStringShort(chair.getChairLoc()));
        }
    }

    public void addLeatherArmor(Player player) {
        CMIUser cMIUser = this.plugin.getPlayerManager().getUser(player);
        if (cMIUser == null) {
            return;
        }
        LeatherAnimation leatherAnimation = this.leatherArmor.remove(player.getUniqueId());
        if (leatherAnimation == null) {
            leatherAnimation = new LeatherAnimation();
        }
        leatherAnimation.getMap().clear();
        for (CMIPlayerInventory.CMIInventorySlot cMIInventorySlot : this.armorTypes) {
            String string;
            Integer n;
            ItemStack itemStack = cMIUser.getInventory().getItem(cMIInventorySlot);
            if (itemStack == null || !CMIMaterial.isLeatherArmor((Material)itemStack.getType()) || (n = new CMINBT(itemStack).getInt(CMIRainbowArmor)) == null || (string = new CMINBT(itemStack).getString(CMISoulBound)) != null && !string.equals(player.getUniqueId().toString())) continue;
            leatherAnimation.setAnimation(cMIInventorySlot, LeatherAnimationType.getById(n));
        }
        if (!leatherAnimation.getMap().isEmpty()) {
            this.leatherArmor.put(player.getUniqueId(), leatherAnimation);
        }
        if (this.autoTimerBukkitId == null) {
            this.autoTimerBukkitId = CMIScheduler.scheduleSyncRepeatingTask((JavaPlugin)this.plugin, (Runnable)this.autoTimer, (long)4L, (long)4L);
        }
        if (this.leatherArmor.isEmpty()) {
            this.stopLeatherUpdate();
        }
    }

    public void stopLeatherUpdate() {
        if (this.autoTimerBukkitId != null) {
            this.autoTimerBukkitId.cancel();
            this.autoTimerBukkitId = null;
        }
    }

    private void checkLeatherArmors() {
        for (Map.Entry<UUID, LeatherAnimation> entry : new HashMap<UUID, LeatherAnimation>(this.leatherArmor).entrySet()) {
            CMIUser cMIUser = this.plugin.getPlayerManager().getUser(entry.getKey());
            if (!cMIUser.isOnline()) {
                this.leatherArmor.remove(entry.getKey());
                continue;
            }
            CMIScheduler.runTaskAsynchronously((JavaPlugin)this.plugin, () -> {
                HashMap<LeatherAnimationType, ArrayList<CMIPlayerInventory.CMIInventorySlot>> hashMap = new HashMap<LeatherAnimationType, ArrayList<CMIPlayerInventory.CMIInventorySlot>>();
                for (CMIPlayerInventory.CMIInventorySlot object : this.armorTypes) {
                    ArrayList<CMIPlayerInventory.CMIInventorySlot> arrayList = (ArrayList<CMIPlayerInventory.CMIInventorySlot>)hashMap.get((Object)((LeatherAnimation)entry.getValue()).getAnimation(object));
                    if (arrayList == null) {
                        arrayList = new ArrayList<CMIPlayerInventory.CMIInventorySlot>();
                    }
                    arrayList.add(object);
                    hashMap.put(((LeatherAnimation)entry.getValue()).getAnimation(object), arrayList);
                }
                for (Map.Entry entry2 : hashMap.entrySet()) {
                    AnimationManager.setColor(cMIUser, (LeatherAnimationType)((Object)((Object)entry2.getKey())), (List)entry2.getValue(), (LeatherAnimation)entry.getValue());
                }
            });
        }
    }

    private static double getMaxHealth(Player player) {
        if (Version.isCurrentEqualOrHigher((Version)Version.v1_9_R1)) {
            return player.getAttribute(Attribute.GENERIC_MAX_HEALTH).getBaseValue();
        }
        return player.getMaxHealth();
    }

    private static void setColor(CMIUser cMIUser, LeatherAnimationType leatherAnimationType, List<CMIPlayerInventory.CMIInventorySlot> list2, LeatherAnimation leatherAnimation) {
        if (leatherAnimationType == null) {
            return;
        }
        switch (leatherAnimationType) {
            case Health: {
                int n = (int)(cMIUser.getPlayer().getHealth() / AnimationManager.getMaxHealth(cMIUser.getPlayer()) * 100.0);
                n = CMINumber.clamp((int)n, (int)0, (int)100);
                int n2 = 255 * (100 - n) / 100;
                int n3 = 255 * n / 100;
                org.bukkit.Color color = org.bukkit.Color.fromRGB((int)CMINumber.clamp((int)n2, (int)0, (int)255), (int)CMINumber.clamp((int)n3, (int)0, (int)255), (int)0);
                for (CMIPlayerInventory.CMIInventorySlot cMIInventorySlot : list2) {
                    ItemStack itemStack = cMIUser.getInventory().getItem(cMIInventorySlot);
                    if (itemStack == null || !(itemStack.getItemMeta() instanceof LeatherArmorMeta)) continue;
                    LeatherArmorMeta leatherArmorMeta = (LeatherArmorMeta)itemStack.getItemMeta();
                    leatherArmorMeta.setColor(color);
                    itemStack.setItemMeta((ItemMeta)leatherArmorMeta);
                }
                break;
            }
            case Biome: {
                Biome biome = cMIUser.getPlayer().getLocation().getBlock().getBiome();
                CMIBiome cMIBiome = CMIBiome.getById(biome.ordinal());
                if (cMIBiome == null) break;
                Color color = cMIBiome.getColor();
                org.bukkit.Color color2 = org.bukkit.Color.fromRGB((int)color.getRed(), (int)color.getGreen(), (int)color.getBlue());
                for (CMIPlayerInventory.CMIInventorySlot cMIInventorySlot : list2) {
                    ItemStack itemStack = cMIUser.getInventory().getItem(cMIInventorySlot);
                    if (itemStack == null || !itemStack.hasItemMeta() || !(itemStack.getItemMeta() instanceof LeatherArmorMeta)) continue;
                    LeatherArmorMeta leatherArmorMeta = (LeatherArmorMeta)itemStack.getItemMeta();
                    leatherArmorMeta.setColor(color2);
                    itemStack.setItemMeta((ItemMeta)leatherArmorMeta);
                }
                break;
            }
            case Day: {
                byte by = cMIUser.getPlayer().getLocation().getBlock().getLightLevel();
                int n = by * 255 / 15;
                org.bukkit.Color color = org.bukkit.Color.fromRGB((int)n, (int)n, (int)n);
                for (CMIPlayerInventory.CMIInventorySlot cMIInventorySlot : list2) {
                    ItemStack itemStack = cMIUser.getInventory().getItem(cMIInventorySlot);
                    if (itemStack == null || !(itemStack.getItemMeta() instanceof LeatherArmorMeta)) continue;
                    LeatherArmorMeta leatherArmorMeta = (LeatherArmorMeta)itemStack.getItemMeta();
                    leatherArmorMeta.setColor(color);
                    itemStack.setItemMeta((ItemMeta)leatherArmorMeta);
                }
                break;
            }
            case Rainbow: {
                Serializable serializable;
                Float f = leatherAnimation.getColorValue();
                Float f2 = leatherAnimation.getSaturationValue();
                Float f3 = Float.valueOf(2.0f);
                if (f2 == null) {
                    serializable = new Random(System.nanoTime());
                    f2 = Float.valueOf((float)((Random)serializable).nextDouble());
                }
                if ((f2 = leatherAnimation.isSascending() ? Float.valueOf(f2.floatValue() + 0.001f * f3.floatValue()) : Float.valueOf(f2.floatValue() - 0.001f * f3.floatValue())).floatValue() >= 1.0f) {
                    leatherAnimation.setSascending(false);
                    f2 = Float.valueOf(f2.floatValue() - 0.001f * f3.floatValue());
                }
                if ((double)f2.floatValue() <= 0.5) {
                    f2 = Float.valueOf(0.5f);
                    leatherAnimation.setSascending(true);
                    f2 = Float.valueOf(f2.floatValue() + 0.001f * f3.floatValue());
                }
                if (f == null) {
                    serializable = new Random(System.nanoTime());
                    f = Float.valueOf((float)((Random)serializable).nextDouble());
                }
                if ((f = leatherAnimation.isAscending() ? Float.valueOf(f.floatValue() + 0.0075f * f3.floatValue()) : Float.valueOf(f.floatValue() - 0.0075f * f3.floatValue())).floatValue() >= 1.0f) {
                    leatherAnimation.setAscending(false);
                    f = Float.valueOf(f.floatValue() - 0.0075f * f3.floatValue());
                }
                if (f.floatValue() <= 0.0f) {
                    f = Float.valueOf(0.0f);
                    leatherAnimation.setAscending(true);
                    f = Float.valueOf(f.floatValue() + 0.0075f * f3.floatValue());
                }
                leatherAnimation.setColorValue(f);
                leatherAnimation.setSaturationValue(f2);
                serializable = Color.getHSBColor(f.floatValue(), f2.floatValue(), f2.floatValue());
                org.bukkit.Color color = org.bukkit.Color.fromRGB((int)((Color)serializable).getRed(), (int)((Color)serializable).getGreen(), (int)((Color)serializable).getBlue());
                for (CMIPlayerInventory.CMIInventorySlot cMIInventorySlot : list2) {
                    ItemStack itemStack = cMIUser.getInventory().getItem(cMIInventorySlot);
                    if (itemStack == null || !(itemStack.getItemMeta() instanceof LeatherArmorMeta)) continue;
                    LeatherArmorMeta leatherArmorMeta = (LeatherArmorMeta)itemStack.getItemMeta();
                    leatherArmorMeta.setColor(color);
                    itemStack.setItemMeta((ItemMeta)leatherArmorMeta);
                }
                break;
            }
        }
    }

    public static int getIntFromColor(int n, int n2, int n3) {
        n = n << 16 & 0xFF0000;
        n2 = n2 << 8 & 0xFF00;
        return 0xFF000000 | n | n2 | (n3 &= 0xFF);
    }

    public boolean isDoubleClickWait(Player player) {
        if (!this.DoubleClick) {
            return false;
        }
        Long l = this.doubleClick.get(player.getUniqueId());
        if (l == null) {
            this.doubleClick.put(player.getUniqueId(), System.currentTimeMillis());
            return true;
        }
        if (System.currentTimeMillis() - l > (long)this.DoubleClickDelay) {
            this.doubleClick.put(player.getUniqueId(), System.currentTimeMillis());
            return true;
        }
        return false;
    }

    public void loadConfig() {
        ConfigReader configReader = this.plugin.getConfigManager().getConfig();
        configReader.addComment("Animations.SitOnStairs", new String[]{"Enable sitting on stair block by clicking on them with empty hand or by looking and using command", "Requires cmi.command.sit.stairs"});
        this.SitOnStairs = configReader.get("Animations.SitOnStairs", Boolean.valueOf(true));
        this.StairsAsChairs = configReader.get("Animations.StairsAsChairs", Boolean.valueOf(true));
        this.SlabsAsChairs = configReader.get("Animations.SlabsAsChairs", Boolean.valueOf(true));
        this.CarpetsAsChairs = configReader.get("Animations.CarpetsAsChairs", Boolean.valueOf(false));
        this.RemoveFromChairOnDamage = configReader.get("Animations.RemoveFromChairOnDamage", Boolean.valueOf(true));
        configReader.addComment("Animations.DoubleClick", new String[]{"Player will sit on chair only after rapid double click"});
        this.DoubleClick = configReader.get("Animations.DoubleClick", Boolean.valueOf(false));
        configReader.addComment("Animations.DoubleClickDelay", new String[]{"Delay in milliseconds between clicks to sit on chair when double click is enabled"});
        this.DoubleClickDelay = configReader.get("Animations.DoubleClickDelay", 200);
        configReader.addComment("Animations.ChairRange", new String[]{"Range in blocks from player to look up for valid chair block"});
        this.chairRange = configReader.get("Animations.ChairRange", 4);
    }

    public boolean isValidChairBlock(Block block) {
        block24: {
            SlabType slabType;
            CMIMaterial cMIMaterial = CMIMaterial.get((Block)block);
            if (!(cMIMaterial.isSlab() || cMIMaterial.isCarpet() || cMIMaterial.isStairs())) {
                return false;
            }
            if (cMIMaterial.isStairs() && !this.plugin.getAnimationManager().isStairsAsChairs()) {
                return false;
            }
            if (cMIMaterial.isSlab() && !this.plugin.getAnimationManager().isSlabsAsChairs()) {
                return false;
            }
            if (cMIMaterial.isCarpet() && !this.CarpetsAsChairs) {
                return false;
            }
            if (CMIMaterial.isSlab((Material)block.getType())) {
                slabType = CMIMaterial.getSlabType((Block)block);
                switch (slabType) {
                    case BOTTOM: {
                        break;
                    }
                    case TOP: 
                    case DOUBLE: 
                    case NOTSLAB: {
                        return false;
                    }
                }
            }
            if (!this.plugin.getTeleportHandler().isEmpty(CMIMaterial.get((Block)block.getLocation().clone().add(0.0, 1.0, 0.0).getBlock()), false)) {
                return false;
            }
            slabType = new CMIBlock(block);
            CMIBlock.Bisect bisect = slabType.getBisect();
            if (bisect != null && bisect == CMIBlock.Bisect.TOP) {
                return false;
            }
            BlockFace blockFace = slabType.getFacing();
            if (blockFace == null || !CMIMaterial.isStairs((Material)block.getType())) break block24;
            switch (blockFace.toString()) {
                case "EAST": 
                case "WEST": 
                case "NORTH": 
                case "SOUTH": {
                    return true;
                }
            }
            return false;
        }
        return true;
    }

    public void sit(Player player) {
        this.sit(player, false);
    }

    public void sit(Player player, boolean bl) {
        this.sit(player, player.getLocation(), bl);
    }

    public void sit(Player player, Location location, boolean bl) {
        Location location2 = location.clone();
        location2.add(0.0, -1.0, 0.0);
        if (Version.isCurrentEqualOrHigher((Version)Version.v1_20_R1)) {
            location2.add(0.0, -0.2, 0.0);
        }
        Chair chair = new Chair().setArmorStandLoc(location2.clone().add(0.0, -0.7, 0.0)).setChairLoc(location);
        chair.setPersistent(bl);
        if (this.sit(player, chair)) {
            this.chairLoc.put(this.plugin.getUtilManager().convertLocToStringShort(location), player.getUniqueId());
        }
    }

    public boolean isSomeOneSittingHere(Block block) {
        UUID uUID = this.chairLoc.get(this.plugin.getUtilManager().convertLocToStringShort(block.getLocation().clone()));
        return uUID != null;
    }

    private static Vector getStairLedgeDirection(Block block) {
        CMIBlock cMIBlock = new CMIBlock(block);
        BlockFace blockFace = cMIBlock.getFacing();
        if (blockFace == null) {
            return new Vector();
        }
        CMIMaterial cMIMaterial = CMIMaterial.get((Block)block);
        double d = 0.0;
        double d2 = 0.0;
        if (cMIMaterial.isStairs()) {
            if (Version.isCurrentEqualOrHigher((Version)Version.v1_13_R1)) {
                CMIBlock.StairShape stairShape = cMIBlock.getStairShape();
                BlockFace blockFace2 = cMIBlock.getFacing();
                block0 : switch (blockFace2) {
                    case EAST: {
                        d += 0.25;
                        d2 += 0.5;
                        switch (stairShape) {
                            case INNER_LEFT: 
                            case OUTER_LEFT: {
                                d2 += 0.3;
                                break block0;
                            }
                            case INNER_RIGHT: 
                            case OUTER_RIGHT: {
                                d2 += -0.3;
                                break block0;
                            }
                            case STRAIGHT: {
                                break block0;
                            }
                        }
                        break;
                    }
                    case NORTH: {
                        d += 0.5;
                        d2 += 0.75;
                        switch (stairShape) {
                            case INNER_LEFT: 
                            case OUTER_LEFT: {
                                d += 0.3;
                                break block0;
                            }
                            case INNER_RIGHT: 
                            case OUTER_RIGHT: {
                                d += -0.3;
                                break block0;
                            }
                            case STRAIGHT: {
                                break block0;
                            }
                        }
                        break;
                    }
                    case SOUTH: {
                        d += 0.5;
                        d2 += 0.25;
                        switch (stairShape) {
                            case INNER_LEFT: 
                            case OUTER_LEFT: {
                                d += -0.3;
                                break block0;
                            }
                            case INNER_RIGHT: 
                            case OUTER_RIGHT: {
                                d += 0.3;
                                break block0;
                            }
                            case STRAIGHT: {
                                break block0;
                            }
                        }
                        break;
                    }
                    case WEST: {
                        d += 0.75;
                        d2 += 0.5;
                        switch (stairShape) {
                            case INNER_LEFT: 
                            case OUTER_LEFT: {
                                d2 += -0.3;
                                break block0;
                            }
                            case INNER_RIGHT: 
                            case OUTER_RIGHT: {
                                d2 += 0.3;
                                break block0;
                            }
                            case STRAIGHT: {
                                break block0;
                            }
                        }
                        break;
                    }
                }
            } else {
                block26 : switch (block.getData()) {
                    case 0: 
                    case 1: 
                    case 2: 
                    case 3: {
                        switch (cMIBlock.getDirection()) {
                            case upEast: {
                                d += 0.75;
                                d2 += 0.5;
                                break block26;
                            }
                            case upNorth: {
                                d += 0.5;
                                d2 += 0.25;
                                break block26;
                            }
                            case upSouth: {
                                d += 0.5;
                                d2 += 0.75;
                                break block26;
                            }
                            case upWest: {
                                d += 0.25;
                                d2 += 0.5;
                                break block26;
                            }
                        }
                    }
                }
            }
        }
        return new Vector(d, 0.0, d2);
    }

    public void sit(Player player, Block block) {
        this.sit(player, block, false);
    }

    public void sit(Player player, Block block, boolean bl) {
        Object object;
        Location location = block.getLocation().clone();
        CMIMaterial cMIMaterial = CMIMaterial.get((Block)block);
        if (cMIMaterial.isStairs()) {
            object = AnimationManager.getStairLedgeDirection(block);
            location.add(object.getX(), -1.2, object.getZ());
        }
        if (cMIMaterial.isSlab()) {
            location.add(0.5, -1.2, 0.5);
        }
        if (cMIMaterial.isCarpet()) {
            location.add(0.5, -1.6, 0.5);
        }
        if (Version.isCurrentEqualOrHigher((Version)Version.v1_20_R1)) {
            location.add(0.0, -0.2, 0.0);
        }
        object = new Chair();
        ((Chair)object).setChairLoc(block.getLocation()).setArmorStandLoc(location);
        ((Chair)object).setPersistent(bl);
        if (this.sit(player, (Chair)object)) {
            this.chairLoc.put(this.plugin.getUtilManager().convertLocToStringShort(block.getLocation()), player.getUniqueId());
        }
    }

    public boolean isSitting(Player player) {
        if (player == null) {
            return false;
        }
        if (this.playerSittingMap.isEmpty()) {
            return false;
        }
        return this.playerSittingMap.containsKey(player.getUniqueId());
    }

    public Entity getChair(Player player) {
        if (this.playerSittingMap.isEmpty()) {
            return null;
        }
        Chair chair = this.playerSittingMap.get(player.getUniqueId());
        return chair == null ? null : chair.getEnt();
    }

    public void sitOnPlayer(Player player, Player player2) {
        Chair chair = new Chair().setChairLoc(player2.getLocation()).setArmorStandLoc(player2.getLocation());
        ArmorStand armorStand = null;
        Location location = chair.getArmorStandLoc();
        armorStand = (ArmorStand)location.getWorld().spawn(location, ArmorStand.class);
        armorStand.setBasePlate(false);
        armorStand.setVisible(false);
        armorStand.setGravity(false);
        armorStand.setSmall(true);
        armorStand.setCustomName(CMIArmorStandForSit);
        try {
            armorStand.setMetadata(CMIArmorStandForSit, (MetadataValue)new FixedMetadataValue((Plugin)this.plugin, (Object)true));
        }
        catch (Exception exception) {
            // empty catch block
        }
        armorStand.setCustomNameVisible(false);
        armorStand.getLocation().setDirection(location.getDirection());
        armorStand.addPotionEffect(new PotionEffect(PotionEffectType.ABSORPTION, 99999999, 2, false, false));
        if (Version.isCurrentLower((Version)Version.v1_11_R1)) {
            armorStand.setPassenger((Entity)player);
        } else {
            armorStand.addPassenger((Entity)player);
        }
        if (Version.isCurrentLower((Version)Version.v1_11_R1)) {
            player2.setPassenger((Entity)armorStand);
        } else {
            player2.addPassenger((Entity)armorStand);
        }
        chair.setEnt((Entity)armorStand);
        this.playerSittingMap.put(player.getUniqueId(), chair);
        this.updateSitTask();
    }

    private boolean sit(Player player, Chair chair) {
        if (player.isSneaking()) {
            return false;
        }
        if (this.plugin.getPlayerManager().getUser(player).isCuffed()) {
            return false;
        }
        CMIPlayerSitEvent cMIPlayerSitEvent = new CMIPlayerSitEvent(player, chair);
        CMI.getInstance().getServer().getPluginManager().callEvent((Event)cMIPlayerSitEvent);
        if (cMIPlayerSitEvent.isCancelled()) {
            return false;
        }
        Location location = chair.getArmorStandLoc().clone();
        location.add(0.0, 1.7, 0.0);
        location.setYaw(player.getLocation().getYaw());
        location.setPitch(player.getLocation().getPitch());
        this.plugin.getTeleportHandler().teleportPlayer(player, location, false).thenAccept(cMITeleportFeedback -> {
            Location location = chair.getArmorStandLoc();
            CMIScheduler.runAtLocation((JavaPlugin)this.plugin, (Location)location, () -> {
                ArmorStand armorStand2 = null;
                if (Version.isCurrentEqualOrHigher((Version)Version.v1_12_R1)) {
                    try {
                        armorStand2 = (ArmorStand)location.getWorld().spawn(location, ArmorStand.class, armorStand -> {
                            armorStand.setVisible(false);
                            armorStand.setGravity(false);
                        });
                    }
                    catch (Throwable throwable) {
                        armorStand2 = (ArmorStand)location.getWorld().spawn(location, ArmorStand.class);
                        armorStand2.setVisible(false);
                        armorStand2.setGravity(false);
                    }
                } else {
                    armorStand2 = (ArmorStand)location.getWorld().spawn(location, ArmorStand.class);
                    armorStand2.setVisible(false);
                    armorStand2.setGravity(false);
                }
                armorStand2.setBasePlate(false);
                armorStand2.setCustomName(CMIArmorStandForSit);
                armorStand2.setCustomNameVisible(false);
                armorStand2.getLocation().setDirection(location.getDirection());
                armorStand2.addPotionEffect(new PotionEffect(PotionEffectType.ABSORPTION, 99999999, 2, false, false));
                chair.setEnt((Entity)armorStand2);
                if (Version.isCurrentLower((Version)Version.v1_11_R1)) {
                    armorStand2.setPassenger((Entity)player);
                } else {
                    armorStand2.addPassenger((Entity)player);
                }
                this.playerSittingMap.put(player.getUniqueId(), chair);
                this.updateSitTask();
            });
        });
        return true;
    }

    @Deprecated
    public void removePlayer(UUID uUID) {
        Player player = CMIUser.getOnlinePlayer(uUID);
        if (player != null) {
            this.removePlayer(player);
        }
    }

    @Deprecated
    public void removePlayer(Player player) {
        this.removePlayer(player, true);
    }

    @Deprecated
    public void removePlayer(Player player, boolean bl) {
        this.removePlayerFromChair(player, bl, false);
    }

    public void removePlayerFromChair(UUID uUID) {
        Player player = CMIUser.getOnlinePlayer(uUID);
        if (player != null) {
            this.removePlayerFromChair(player);
        }
    }

    public void removePlayerFromChair(Player player) {
        this.removePlayerFromChair(player, true);
    }

    public void removePlayerFromChair(Player player, boolean bl) {
        this.removePlayerFromChair(player, bl, false);
    }

    public void removePlayerFromChair(Player player, boolean bl, boolean bl2) {
        this.removePlayerFromChair(player, bl, bl2, true);
    }

    public void removePlayerFromChair(Player player, boolean bl, boolean bl2, boolean bl3) {
        Entity entity;
        Chair chair = this.playerSittingMap.remove(player.getUniqueId());
        this.updateSitTask();
        if (chair == null) {
            return;
        }
        if (chair.getChairLoc() != null) {
            this.chairLoc.remove(this.plugin.getUtilManager().convertLocToStringShort(chair.getChairLoc()));
        }
        if ((entity = chair.getEnt()) == null) {
            return;
        }
        entity.remove();
        CMILC.info("sit", player, "onStandUp", new Object[0]);
        if (!bl3) {
            return;
        }
        if (bl) {
            CMIScheduler.runTask((JavaPlugin)this.plugin, () -> this.tpPlayer(player, chair, bl2));
        } else {
            this.tpPlayer(player, chair, bl2);
        }
    }

    private void tpPlayer(Player player, Chair chair, boolean bl) {
        if (!player.isOnline()) {
            return;
        }
        Location location = chair.getArmorStandLoc().clone().add(0.0, 1.95, 0.0);
        location.setPitch(player.getLocation().getPitch());
        location.setYaw(player.getLocation().getYaw());
        CMIScheduler.runAtLocation((JavaPlugin)this.plugin, (Location)location, () -> {
            if (CMIMaterial.isStairs((Material)chair.getChairLoc().getBlock().getType())) {
                Vector vector = AnimationManager.getStairLedgeDirection(chair.getChairLoc().getBlock());
                double d = (double)((int)(vector.getX() * 10.0)) / 10.0;
                double d2 = (double)((int)(vector.getZ() * 10.0)) / 10.0;
                if (d >= 0.7) {
                    d = 0.8;
                }
                if (d2 >= 0.7) {
                    d2 = 0.8;
                }
                location.setX((double)location.getBlockX() + d);
                location.setY(location.getY() + 0.0);
                location.setZ((double)location.getBlockZ() + d2);
            }
            if (bl) {
                location.setX((double)location.getBlockX() + 0.5);
                location.setZ((double)location.getBlockZ() + 0.5);
            }
            this.plugin.getTeleportHandler().teleportPlayer(player, location, PlayerTeleportEvent.TeleportCause.PLUGIN, false);
        });
    }

    private void updateSitTask() {
        if (this.task == null && !this.playerSittingMap.isEmpty()) {
            this.task = CMIScheduler.runTimerAsync((JavaPlugin)this.plugin, () -> {
                HashMap<UUID, Chair> hashMap = new HashMap<UUID, Chair>(this.playerSittingMap);
                for (Map.Entry<UUID, Chair> entry : hashMap.entrySet()) {
                    if (!(entry.getValue().getEnt() instanceof ArmorStand)) continue;
                    Chair chair = entry.getValue();
                    if (!chair.isPersistent() && chair.getLastCheck() + 3000L < System.currentTimeMillis()) {
                        if (this.plugin.getUtilManager().getDistance(chair.getEnt().getLocation(), chair.getArmorStandLoc()) > 0.6) {
                            CMIScheduler.runTask((JavaPlugin)this.plugin, () -> this.removePlayerFromChair((UUID)entry.getKey()));
                            return;
                        }
                        chair.setLastCheck(System.currentTimeMillis());
                    }
                    ArmorStand armorStand = (ArmorStand)entry.getValue().getEnt();
                    CMIScheduler.runAtEntity((JavaPlugin)this.plugin, (Entity)chair.getEnt(), () -> {
                        try {
                            armorStand.setRotation(armorStand.getPassenger().getLocation().getYaw(), armorStand.getLocation().getPitch());
                        }
                        catch (Throwable throwable) {
                            try {
                                if (method == null) {
                                    method = armorStand.getClass().getMethod("getHandle", new Class[0]);
                                }
                                Object object = method.invoke((Object)armorStand, new Object[0]);
                                if (field == null) {
                                    field = Version.isCurrentLower((Version)Version.v1_17_R1) ? object.getClass().getField("yaw") : (Version.isCurrentEqualOrHigher((Version)Version.v1_19_R1) ? object.getClass().getField("aX") : (Version.isCurrentEqualOrHigher((Version)Version.v1_18_R1) ? object.getClass().getField("aA") : object.getClass().getField("ay")));
                                }
                                if (armorStand.getPassenger() == null) {
                                    return;
                                }
                                field.set(object, Float.valueOf(armorStand.getPassenger().getLocation().getYaw()));
                            }
                            catch (Throwable throwable2) {
                                // empty catch block
                            }
                        }
                    });
                }
            }, (long)0L, (long)1L);
            return;
        }
        if (this.task != null && this.playerSittingMap.isEmpty()) {
            this.task.cancel();
            this.task = null;
            return;
        }
    }

    public boolean isSitOnStairs() {
        return this.SitOnStairs;
    }

    public void setSitOnStairs(boolean bl) {
        this.SitOnStairs = bl;
    }

    public boolean isSlabsAsChairs() {
        return this.SlabsAsChairs;
    }

    public boolean isStairsAsChairs() {
        return this.StairsAsChairs;
    }

    public UUID removeRiding(UUID uUID) {
        UUID uUID2 = this.riding.remove(uUID);
        this.ridingNonSteerable.remove(uUID);
        if (uUID2 != null) {
            this.beingRidden.remove(uUID2);
        }
        return uUID2;
    }

    public CompletableFuture<List<Entity>> removePassengers(Player player, String string) {
        Object object2;
        ArrayList<CompletableFuture<Void>> arrayList = new ArrayList<CompletableFuture<Void>>();
        ArrayList<Object> arrayList2 = new ArrayList<Object>();
        if (Version.isCurrentLower((Version)Version.v1_11_R1)) {
            if (player.getPassenger() != null) {
                object2 = player.getPassenger();
                if (object2 instanceof Slime && object2.getCustomName() != null && object2.getCustomName().equalsIgnoreCase(CMIFakeSlime)) {
                    if (object2.getPassenger() != null) {
                        arrayList2.add(object2.getPassenger());
                    }
                    object2.leaveVehicle();
                    object2.remove();
                } else {
                    arrayList2.add(player.getPassenger());
                    player.getPassenger().leaveVehicle();
                }
            }
        } else {
            for (Object object2 : player.getPassengers()) {
                if (object2 == null) continue;
                if (object2 instanceof Slime && object2.getCustomName() != null && object2.getCustomName().equalsIgnoreCase(CMIFakeSlime)) {
                    if (object2.getPassenger() != null) {
                        arrayList2.add(object2.getPassenger());
                    }
                    arrayList.add(CMIScheduler.runAtLocation((JavaPlugin)this.plugin, (Location)object2.getLocation(), () -> AnimationManager.lambda$9((Entity)object2)));
                    continue;
                }
                if (!Version.isCurrentEqualOrHigher((Version)Version.v1_21_R1) || !object2.getType().equals((Object)EntityType.TEXT_DISPLAY)) {
                    arrayList2.add(object2);
                }
                arrayList.add(CMIScheduler.runAtLocation((JavaPlugin)this.plugin, (Location)object2.getLocation(), () -> ((Entity)object2).leaveVehicle()));
            }
            if (string != null && player.isInsideVehicle()) {
                arrayList2.add(player);
                player.leaveVehicle();
            }
        }
        if ((object2 = this.plugin.getChatBubbleManager().getBubble(player.getUniqueId())) != null) {
            arrayList.add(((CMIChatBubble)object2).delete());
        }
        return CompletableFuture.allOf(arrayList.toArray(new CompletableFuture[0])).thenApply(void_ -> arrayList2);
    }

    public boolean isRiding(UUID uUID) {
        return this.riding.containsKey(uUID);
    }

    public HashMap<UUID, UUID> getRidingList() {
        return this.riding;
    }

    public boolean isBeingRiden(UUID uUID) {
        return this.beingRidden.containsKey(uUID);
    }

    public boolean isRidingNonSteerable(UUID uUID) {
        return this.ridingNonSteerable.containsKey(uUID);
    }

    public UUID getBeingRiden(UUID uUID) {
        return this.beingRidden.get(uUID);
    }

    @Deprecated
    public void addRiding(UUID uUID, UUID uUID2) {
        this.riding.put(uUID, uUID2);
        this.beingRidden.put(uUID2, uUID);
    }

    public void addRiding(Player player, Entity entity) {
        if (Version.isCurrentEqualOrHigher((Version)Version.v1_16_R1) && !(entity instanceof Steerable)) {
            this.ridingNonSteerable.put(player.getUniqueId(), player.getLocation());
            this.runRidingTasker();
        }
        this.riding.put(player.getUniqueId(), entity.getUniqueId());
        this.beingRidden.put(entity.getUniqueId(), player.getUniqueId());
    }

    private void runRidingTasker() {
        if (this.ridingTask != null) {
            return;
        }
        this.ridingTask = CMIScheduler.scheduleSyncRepeatingTask((JavaPlugin)this.plugin, () -> {
            if (this.ridingNonSteerable.isEmpty()) {
                this.ridingTask.cancel();
                this.ridingTask = null;
                return;
            }
            for (Map.Entry<UUID, Location> entry : this.ridingNonSteerable.entrySet()) {
                Location location = entry.getValue();
                Player player = CMIUser.getOnlinePlayer(entry.getKey());
                if (player == null) {
                    this.removeRiding(entry.getKey());
                    continue;
                }
                Location location2 = player.getLocation();
                if (location.toVector().equals((Object)location2.toVector())) continue;
                this.ridingNonSteerable.put(entry.getKey(), location2);
                PlayerMoveEvent playerMoveEvent = new PlayerMoveEvent(player, location, location2);
                Bukkit.getServer().getPluginManager().callEvent((Event)playerMoveEvent);
            }
        }, (long)5L, (long)5L);
    }

    public boolean isDoubleClick() {
        return this.DoubleClick;
    }

    public int getChairRange() {
        return this.chairRange;
    }

    public boolean isRemoveFromChairOnDamage() {
        return this.RemoveFromChairOnDamage;
    }

    private static /* synthetic */ void lambda$9(Entity entity) {
        entity.leaveVehicle();
        entity.remove();
    }

    public class Chair {
        private Entity ent = null;
        private Location ChairBlockLoc = null;
        private Location armorStandLoc = null;
        private long lastCheck = 0L;
        private boolean persistent = false;

        public Entity getEnt() {
            return this.ent;
        }

        public Chair setEnt(Entity entity) {
            this.ent = entity;
            return this;
        }

        public Location getChairLoc() {
            return this.ChairBlockLoc;
        }

        public Chair setChairLoc(Location location) {
            this.ChairBlockLoc = location;
            return this;
        }

        public Location getArmorStandLoc() {
            return this.armorStandLoc;
        }

        public Chair setArmorStandLoc(Location location) {
            this.armorStandLoc = location;
            return this;
        }

        public long getLastCheck() {
            return this.lastCheck;
        }

        public void setLastCheck(long l) {
            this.lastCheck = l;
        }

        public boolean isPersistent() {
            return this.persistent;
        }

        public void setPersistent(boolean bl) {
            this.persistent = bl;
        }
    }

    public static enum LeatherAnimationType {
        Rainbow(1),
        Health(2),
        Biome(3),
        Day(4);

        private Integer id;

        private LeatherAnimationType(Integer n2) {
            this.id = n2;
        }

        public Integer getId() {
            return this.id;
        }

        public void setId(Integer n) {
            this.id = n;
        }

        public static LeatherAnimationType getById(int n) {
            LeatherAnimationType[] leatherAnimationTypeArray = LeatherAnimationType.values();
            int n2 = leatherAnimationTypeArray.length;
            int n3 = 0;
            while (n3 < n2) {
                LeatherAnimationType leatherAnimationType = leatherAnimationTypeArray[n3];
                if (leatherAnimationType.getId() == n) {
                    return leatherAnimationType;
                }
                ++n3;
            }
            return null;
        }

        public static LeatherAnimationType getByName(String string) {
            LeatherAnimationType[] leatherAnimationTypeArray = LeatherAnimationType.values();
            int n = leatherAnimationTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                LeatherAnimationType leatherAnimationType = leatherAnimationTypeArray[n2];
                if (leatherAnimationType.name().equalsIgnoreCase(string)) {
                    return leatherAnimationType;
                }
                ++n2;
            }
            return null;
        }
    }
}

