/*
 * Decompiled with CFR 0.152.
 */
package com.Zrips.CMI.Modules.Alias;

import com.Zrips.CMI.CMI;
import com.Zrips.CMI.Containers.CommandAlias;
import com.Zrips.CMI.Containers.CommandAliasType;
import com.Zrips.CMI.Modules.Alias.Allias;
import com.Zrips.CMI.Modules.ModuleHandling.CMIModule;
import com.Zrips.CMI.Modules.Permissions.PermissionsManager;
import com.Zrips.CMI.commands.CAnnotation;
import com.Zrips.CMI.commands.CMICommand;
import com.Zrips.CMI.commands.CommandsHandler;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.Zrips.CMILib.Colors.CMIChatColor;
import net.Zrips.CMILib.Container.CMIList;
import net.Zrips.CMILib.FileHandler.ConfigReader;
import net.Zrips.CMILib.Messages.CMIMessages;
import net.Zrips.CMILib.Version.Schedulers.CMIScheduler;
import org.bukkit.Bukkit;
import org.bukkit.command.PluginCommand;
import org.bukkit.command.TabCompleter;
import org.bukkit.plugin.java.JavaPlugin;

public class AliasManager {
    private CMI plugin;
    public LinkedHashMap<String, CommandAlias> defaultAliases = new LinkedHashMap();
    public LinkedHashMap<String, CommandAlias> customAliases = new LinkedHashMap();
    public LinkedHashMap<String, CommandAlias> alternativeAliases = new LinkedHashMap();
    public HashMap<String, CommandAlias> fromAliases = new HashMap();
    private static final int MAX_CACHE_SIZE = 100;
    private static Map<String, CommandAlias> cache = Collections.synchronizedMap(new LinkedHashMap<String, CommandAlias>(100, 0.75f, true){

        @Override
        protected boolean removeEldestEntry(Map.Entry<String, CommandAlias> entry) {
            return this.size() > 100;
        }
    });
    private static Map<String, List<CommandAlias>> cacheListed = Collections.synchronizedMap(new LinkedHashMap<String, List<CommandAlias>>(100, 0.75f, true){

        @Override
        protected boolean removeEldestEntry(Map.Entry<String, List<CommandAlias>> entry) {
            return this.size() > 100;
        }
    });
    public static Pattern patern = Pattern.compile("( |^|:|:\\/|\\S)(\\$(\\d{1,2})(-?))");
    List<String> CommentList = new ArrayList<String>(Arrays.asList("", "Edit custom variables in game if possible", "Some extra variables can be used, like [playerName] will insert senders name automatically", "All global variables should work, you can find full list in locale file", "You can add delay between commands by inserting line like", "delay! 5", "This will delay next commands by defines time in seconds", "If command is shortened and you need to provide some changing variables like target player name you need to define what and where it should be placed", "Example: /cmi heal Zrips ", "Can be shortened with custom alias to something like /h zrips by using alias command like", "cmi heal $1", "If you need to add more than one variable, use $1- format. Number represents variable place when used in alias command", "Example: cmi tppos $1-", "In case you want to print out help page if player enters wrong subcommand, use ? in alias", "Example: ca ?", "In this case if player performs /ca wrongsub or /ca anotherwrong", "Commands under this alias will get executed. Exelent way to show help page and correct usage if needed"));
    List<String> temp = new ArrayList<String>();
    private String fileName = "Alias.yml";

    public AliasManager(CMI cMI) {
        this.plugin = cMI;
    }

    private static CommandAlias getFirst(String string, CommandAlias commandAlias, String string2) {
        if (string.equalsIgnoreCase(string2)) {
            return commandAlias;
        }
        if (string.startsWith(String.valueOf(string2) + " ") && commandAlias.containsDynamicVariables()) {
            return commandAlias;
        }
        if (string.equalsIgnoreCase(string2)) {
            return commandAlias;
        }
        if (commandAlias.getAlias().equalsIgnoreCase(string) && !commandAlias.containsDynamicVariables()) {
            return commandAlias;
        }
        if (string2.startsWith(String.valueOf(string) + " ") && commandAlias.containsDynamicVariables()) {
            return commandAlias;
        }
        if (string.contains(" ") && string2.contains(" ") && string.startsWith(String.valueOf(string2) + " ")) {
            return commandAlias;
        }
        return null;
    }

    private static CommandAlias getSecond(String string, CommandAlias commandAlias, CommandAlias commandAlias2, CommandAlias commandAlias3, String string2) {
        if (string.equalsIgnoreCase(string2)) {
            return commandAlias3;
        }
        if (commandAlias3.getAlias().equalsIgnoreCase(string)) {
            return commandAlias3;
        }
        if (string.startsWith(String.valueOf(string2) + " ") && !commandAlias3.containsDynamicVariables()) {
            return commandAlias3;
        }
        return null;
    }

    public void clearCache() {
        cache.clear();
        cacheListed.clear();
    }

    public CommandAlias getAliasForCommand(String string) {
        if (cache.containsKey(string = string.toLowerCase())) {
            return cache.get(string);
        }
        Object object = null;
        CommandAlias commandAlias = null;
        HashMap<String, CommandAlias> hashMap = this.getAll();
        for (Map.Entry<String, CommandAlias> entry : hashMap.entrySet()) {
            if (!entry.getValue().getState()) continue;
            String string2 = entry.getKey().toLowerCase();
            if (object == null) {
                object = AliasManager.getFirst(string, entry.getValue(), string2);
            }
            if (commandAlias == null) {
                commandAlias = AliasManager.getSecond(string, commandAlias, (CommandAlias)object, entry.getValue(), string2);
            }
            if (object != null && commandAlias != null) break;
        }
        if (object != null && commandAlias != null && !object.equals(commandAlias)) {
            if (commandAlias.getAlias().equalsIgnoreCase(string)) {
                cache.put(string, (CommandAlias)object);
                return commandAlias;
            }
            if (((CommandAlias)object).getAlias().length() > commandAlias.getAlias().length()) {
                cache.put(string, (CommandAlias)object);
                return object;
            }
            cache.put(string, commandAlias);
            return commandAlias;
        }
        if (object == null) {
            Map.Entry<String, CommandAlias> entry;
            entry = null;
            for (Map.Entry entry2 : hashMap.entrySet()) {
                String string3;
                if (!((CommandAlias)entry2.getValue()).getState() || !(string3 = ((String)entry2.getKey()).toLowerCase()).endsWith("?")) continue;
                if (string3.length() > 1) {
                    string3 = string3.substring(0, string3.length() - 2);
                }
                if (string.equalsIgnoreCase(string3)) {
                    entry = (CommandAlias)entry2.getValue();
                    break;
                }
                if (!string.startsWith(String.valueOf(string3) + " ")) continue;
                entry = (CommandAlias)entry2.getValue();
                break;
            }
            if (entry != null) {
                cache.put(string, (CommandAlias)((Object)entry));
                return entry;
            }
        }
        if (object == null && commandAlias != null) {
            cache.put(string, commandAlias);
            return commandAlias;
        }
        cache.put(string, (CommandAlias)object);
        return object;
    }

    public List<CommandAlias> getAliasStartingWith(String string) {
        return this.getAliasStartingWith(string, null);
    }

    public List<CommandAlias> getAliasStartingWith(String string, CommandAliasType commandAliasType) {
        if (cacheListed.containsKey(string = string.toLowerCase())) {
            return cacheListed.get(string);
        }
        ArrayList<CommandAlias> arrayList = new ArrayList<CommandAlias>();
        for (Map.Entry<String, CommandAlias> entry : this.getAll().entrySet()) {
            String string2;
            if (!entry.getValue().getState() || commandAliasType != null && !commandAliasType.equals((Object)entry.getValue().getType()) || !(string2 = entry.getKey().toLowerCase()).startsWith(string)) continue;
            arrayList.add(entry.getValue());
        }
        for (Map.Entry<String, CommandAlias> entry : this.getAll().entrySet()) {
            if (!entry.getValue().getState() || commandAliasType != null && !commandAliasType.equals((Object)entry.getValue().getType()) || !entry.getValue().getAlias().equalsIgnoreCase(string)) continue;
            arrayList.add(entry.getValue());
        }
        cacheListed.put(string, arrayList);
        return arrayList;
    }

    private void register(CommandAlias commandAlias) {
        if (!commandAlias.getState()) {
            return;
        }
        try {
            if (commandAlias.getAlias().contains(" ") && commandAlias.getAlias().split(" ")[1].length() > 1 && !commandAlias.getAlias().split(" ")[1].startsWith("[")) {
                return;
            }
        }
        catch (Throwable throwable) {
            CMIMessages.consoleMessage((String)("Issue with custom alias formatting for: " + commandAlias.getAlias()));
            throwable.printStackTrace();
        }
        Allias allias = new Allias(commandAlias.getAliasBaseCommand(), commandAlias);
        if (commandAlias.getType() == CommandAliasType.base || commandAlias.isRequiresPerm()) {
            if (commandAlias.isRequiresPerm() && commandAlias.getType() == CommandAliasType.custom) {
                allias.register(PermissionsManager.CMIPerm.customalias_$1.getPermission(commandAlias.getAliasAsOneWordNS()));
            } else {
                allias.register(PermissionsManager.CMIPerm.command_$1.getPermission(commandAlias.getCmiCommandName()));
            }
        } else {
            allias.register();
        }
        PluginCommand pluginCommand = Bukkit.getPluginCommand((String)commandAlias.getAliasBaseCommand().toLowerCase());
        if (pluginCommand != null) {
            CMIScheduler.runTaskLater((JavaPlugin)this.plugin, () -> {
                if (commandAlias.getCmiCommandName() == null) {
                    return;
                }
                if (this.plugin.getTab() != null && this.plugin.isEnabled()) {
                    pluginCommand.setTabCompleter((TabCompleter)this.plugin.getTab());
                }
            }, (long)200L);
        }
    }

    public void addDefault(CommandAlias commandAlias) {
        this.defaultAliases.put(commandAlias.getAlias(), commandAlias);
        this.fromAliases.put(commandAlias.getCleanCommand(), commandAlias);
        this.register(commandAlias);
    }

    public void addCustom(CommandAlias commandAlias) {
        for (String string : commandAlias.getCommands()) {
            if (!string.equalsIgnoreCase(commandAlias.getAlias())) continue;
            CMI.getInstance().consoleMessage("&cYou cant have custom alias (" + commandAlias.getAlias() + ") performing (" + string + ") command! This will create infinite loop! Alias will be ignored to avoid major issues");
            return;
        }
        this.customAliases.put(commandAlias.getAlias(), commandAlias);
        this.fromAliases.put(commandAlias.getCleanCommand(), commandAlias);
        this.clearCache();
        this.register(commandAlias);
    }

    public void removeCustom(String string) {
        CommandAlias commandAlias = (CommandAlias)this.customAliases.remove(string);
        if (commandAlias != null) {
            this.fromAliases.remove(commandAlias.getCleanCommand());
        }
        this.clearCache();
    }

    public void removeCustom(CommandAlias commandAlias) {
        this.customAliases.remove(commandAlias.getAlias());
        this.fromAliases.remove(commandAlias.getCleanCommand());
        this.clearCache();
    }

    public LinkedHashMap<String, CommandAlias> getCustom() {
        return this.customAliases;
    }

    public LinkedHashMap<String, CommandAlias> getDefaultAlias() {
        return this.defaultAliases;
    }

    public HashMap<String, CommandAlias> getAll() {
        HashMap<String, CommandAlias> hashMap = new HashMap<String, CommandAlias>();
        hashMap.putAll(this.defaultAliases);
        hashMap.putAll(this.customAliases);
        return hashMap;
    }

    public HashMap<String, CommandAlias> getFrom() {
        return this.fromAliases;
    }

    private List<String> convertCustom() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Map.Entry<String, CommandAlias> entry : this.customAliases.entrySet()) {
            arrayList.add(String.valueOf(entry.getValue().getCommand()) + "-" + entry.getKey());
        }
        return arrayList;
    }

    public void save() {
        this.plugin.getConfigManager().ChangeConfig("CustomAlias.List", this.convertCustom());
    }

    public List<String> updateCommands(CommandAlias commandAlias, List<String> list2, List<String> list3) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (commandAlias != null && !list2.isEmpty() && list2.get(0).isEmpty()) {
            arrayList.add(list2.remove(0));
            arrayList.add(commandAlias.getAlias());
            arrayList.addAll(list2);
            list2 = arrayList;
        } else {
            if (commandAlias != null) {
                arrayList.add(commandAlias.getAlias());
            } else {
                arrayList.add("");
            }
            arrayList.addAll(list2);
            list2 = arrayList;
        }
        int n = 0;
        while (n < list3.size()) {
            String string = list3.get(n);
            ArrayList<String> arrayList2 = new ArrayList<String>();
            if (string.contains(" ")) {
                arrayList2.addAll(Arrays.asList(string.split(" ")));
            } else {
                arrayList2.add(string);
            }
            int n2 = 0;
            while (n2 < arrayList2.size()) {
                String string2 = (String)arrayList2.get(n2);
                string2 = CMIChatColor.stripColor((String)string2);
                Matcher matcher = patern.matcher(string2);
                while (matcher.find()) {
                    String string3 = matcher.group(2);
                    Integer n3 = null;
                    boolean bl = matcher.group(4) != null && !matcher.group(4).isEmpty();
                    try {
                        n3 = Integer.parseInt(matcher.group(3));
                    }
                    catch (Exception exception) {
                        continue;
                    }
                    n3 = n3 + 1;
                    String string4 = null;
                    if (n3 <= 10 && n3 < list2.size()) {
                        if (!bl) {
                            string4 = list2.get(n3);
                        } else {
                            string4 = "";
                            int n4 = n3;
                            while (n4 < list2.size()) {
                                if (!string4.isEmpty()) {
                                    string4 = String.valueOf(string4) + " ";
                                }
                                string4 = String.valueOf(string4) + list2.get(n4);
                                ++n4;
                            }
                        }
                    }
                    if ((string = string.replaceFirst(Pattern.quote(string3), string4 != null ? Matcher.quoteReplacement(string4) : "")).endsWith(" ")) {
                        string = string.substring(0, string.length() - 1);
                    }
                    list3.set(n, string);
                }
                ++n2;
            }
            ++n;
        }
        this.clearCache();
        return list3;
    }

    public void fullLoad() {
        this.load();
        this.loadRegularAlias();
        this.clearCache();
    }

    public void load() {
        Long l = System.currentTimeMillis();
        File file = new File(this.plugin.getDataFolder(), "CustomAlias");
        if (!file.isDirectory()) {
            file.mkdir();
        }
        File file2 = new File(this.plugin.getDataFolder(), "CustomAlias.yml");
        ConfigReader configReader = null;
        try {
            configReader = new ConfigReader(file2);
            if (file2.isFile()) {
                configReader.saveToBackup(false);
            }
            file2.renameTo(new File(this.plugin.getDataFolder(), "CustomAlias" + File.separator + "CustomAlias.yml"));
            if (new File(this.plugin.getDataFolder(), "CustomAlias" + File.separator + "CustomAlias.yml").isFile()) {
                file2.delete();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.customAliases.clear();
        if (file.listFiles().length == 0) {
            File file3 = new File(this.plugin.getDataFolder(), "CustomAlias" + File.separator + "CustomAlias.yml");
            ConfigReader configReader2 = null;
            try {
                configReader2 = new ConfigReader(file3);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            if (configReader2 == null) {
                return;
            }
            configReader2.getC().options().copyDefaults(true);
            configReader2.header(this.CommentList);
            configReader2.save();
            return;
        }
        this.customAliases.clear();
        int n = 0;
        File[] fileArray = file.listFiles();
        int n2 = fileArray.length;
        int n3 = 0;
        while (n3 < n2) {
            block24: {
                File file4 = fileArray[n3];
                if (file4.getName().endsWith(".yml")) {
                    configReader = null;
                    try {
                        configReader = new ConfigReader(file4);
                    }
                    catch (Exception exception) {
                        CMIMessages.consoleMessage((String)("Can't read " + file4.getName() + " file in CustomAlias directory"));
                        break block24;
                    }
                    String string = file4.getName();
                    if (string.endsWith(".yml")) {
                        string = string.substring(0, string.length() - ".yml".length());
                    }
                    configReader.getC().options().copyDefaults(true);
                    configReader.header(this.CommentList);
                    if (configReader.getC().isConfigurationSection("CustomAlias")) {
                        Set set = configReader.getC().getConfigurationSection("CustomAlias").getKeys(false);
                        for (String string2 : set) {
                            ArrayList<String> arrayList = new ArrayList();
                            List<String> list2 = new ArrayList<String>();
                            boolean bl = false;
                            boolean bl2 = false;
                            boolean bl3 = true;
                            if (configReader.getC().isList("CustomAlias." + string2 + ".Cmds")) {
                                arrayList = configReader.get("CustomAlias." + string2 + ".Cmds", Arrays.asList(""));
                                if (configReader.getC().isBoolean("CustomAlias." + string2 + ".Perm")) {
                                    bl = configReader.get("CustomAlias." + string2 + ".Perm", Boolean.valueOf(false));
                                }
                                if (configReader.getC().isBoolean("CustomAlias." + string2 + ".AddTabs")) {
                                    bl2 = configReader.get("CustomAlias." + string2 + ".AddTabs", Boolean.valueOf(false));
                                }
                                if (configReader.getC().isBoolean("CustomAlias." + string2 + ".Tab")) {
                                    bl3 = configReader.get("CustomAlias." + string2 + ".Tab", Boolean.valueOf(true));
                                }
                                if (configReader.getC().isList("CustomAlias." + string2 + ".CustomTabs")) {
                                    list2 = configReader.get("CustomAlias." + string2 + ".CustomTabs", new ArrayList());
                                }
                            } else {
                                arrayList = configReader.get("CustomAlias." + string2, Arrays.asList(""));
                            }
                            if (!this.temp.contains(string2)) {
                                this.temp.add(string2);
                            }
                            CommandAlias commandAlias = new CommandAlias(string2, string, arrayList, true);
                            commandAlias.setRequiresPerm(bl);
                            commandAlias.setTabComplete(bl3);
                            commandAlias.setAddTabs(bl2);
                            if (!list2.isEmpty()) {
                                commandAlias.setCustomTab(list2);
                            }
                            this.addCustom(commandAlias);
                            ++n;
                        }
                    }
                }
            }
            ++n3;
        }
        this.plugin.loadMessage(n, "custom alias", System.currentTimeMillis() - l);
    }

    public void loadRegularAlias() {
        this.temp.clear();
        Long l = System.currentTimeMillis();
        this.plugin.safeRenameFile(this.fileName, "Settings" + File.separator + this.fileName);
        File file = new File(this.plugin.getDataFolder(), "Settings" + File.separator + "Alias.yml");
        ConfigReader configReader = null;
        try {
            configReader = new ConfigReader(file);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        LinkedHashMap<String, CommandAlias> linkedHashMap = new LinkedHashMap<String, CommandAlias>(this.defaultAliases);
        this.defaultAliases.clear();
        if (configReader == null) {
            return;
        }
        configReader.getC().options().copyDefaults(true);
        configReader.header(Arrays.asList("", "All aliases to used with this plugin. In example original command for going back to spawn is /cmi spawn", "By enabling appropriate alias you can use /spawn to get back to set spawn point", "if it interferes with another plugin, just disable it here and reload plugin with /cmi reload", "Comment shows command to be performed by using alias defined one line belove it", "True/false defines if alias is enabled or disabled", "", "ATENTION! If you want to have custom alias and not only presets, use ingame command /cmi aliaseditor for this", "This file will not accept new custom alias, for that we do have separate file"));
        int n = 0;
        CMI.getInstance().getCommandManager().clearDisabledBase();
        for (Map.Entry<String, CMICommand> entry : this.plugin.getCommandManager().getCommands().entrySet()) {
            Object object;
            Object object2;
            CMICommand cMICommand = entry.getValue();
            if (cMICommand.getAnottation().hidden()) continue;
            String string = cMICommand.getName();
            CAnnotation cAnnotation = cMICommand.getAnottation();
            boolean bl = cAnnotation.alias();
            configReader.addComment("Alias./" + string, new String[]{" ", "/" + CommandsHandler.getLabel() + " " + string + " $1-"});
            if (!this.temp.contains(string)) {
                this.temp.add(string);
            }
            if (configReader.getC().isBoolean("Alias./" + string)) {
                bl = configReader.getC().getBoolean("Alias./" + string, bl);
            }
            Boolean bl2 = configReader.get("Alias./" + string + ".Enabled", Boolean.valueOf(bl));
            Boolean bl3 = configReader.get("Alias./" + string + ".Tab", Boolean.valueOf(true));
            String[] stringArray = cMICommand.getAnottation().modules();
            int n2 = stringArray.length;
            int n3 = 0;
            while (n3 < n2) {
                object2 = stringArray[n3];
                if (!CMIModule.isEnabled((String)object2)) {
                    bl2 = false;
                    break;
                }
                ++n3;
            }
            object2 = false;
            if (configReader.getC().isBoolean("Alias./" + string + ".BaseDisabled")) {
                object2 = configReader.get("Alias./" + string + ".BaseDisabled", Boolean.valueOf(false));
            }
            if (bl2.booleanValue()) {
                object = new CommandAlias(string, Arrays.asList(String.valueOf(CommandsHandler.getLabel()) + " " + string + " $1-"), bl2, CommandAliasType.base, entry.getKey());
                ((CommandAlias)object).setDisableBase((Boolean)object2);
                this.plugin.getCommandManager().setBaseCommandState(string, !((Boolean)object2).booleanValue());
                ((CommandAlias)object).setTabComplete(bl3);
                this.addDefault((CommandAlias)object);
            } else {
                object = linkedHashMap.get(string);
                if (object != null && ((CommandAlias)object).getType() == CommandAliasType.base && ((CommandAlias)object).getCmiCommandName().equals(entry.getKey())) {
                    ((CommandAlias)object).setCommands(Arrays.asList(String.valueOf(CommandsHandler.getLabel()) + " " + string + " $1-"));
                    ((CommandAlias)object).setState(bl2);
                    ((CommandAlias)object).setTabComplete(bl3);
                    this.plugin.getCommandManager().setBaseCommandState(string, !((Boolean)object2).booleanValue());
                    ((CommandAlias)object).setDisableBase((Boolean)object2);
                    this.addDefault((CommandAlias)object);
                }
            }
            object = cAnnotation.customAlias();
            String[] stringArray2 = object;
            int n4 = ((String[])object).length;
            int n5 = 0;
            while (n5 < n4) {
                Object object3;
                String string2;
                String string3 = stringArray2[n5];
                String string4 = string;
                boolean bl4 = string3.startsWith("!");
                String string5 = string2 = string3.startsWith("!") ? string3.substring(1) : string3;
                if (string2.startsWith("+")) {
                    string2 = string2.substring(1);
                    string4 = String.valueOf(string) + " " + string2.split(":")[0];
                    string2 = string2.split(":")[1];
                }
                if (configReader.getC().isBoolean("Alias./" + string2)) {
                    bl4 = configReader.getC().getBoolean("Alias./" + string2, bl4);
                }
                bl2 = configReader.get("Alias./" + string2 + ".Enabled", Boolean.valueOf(bl4));
                bl3 = configReader.get("Alias./" + string2 + ".Tab", Boolean.valueOf(true));
                ++n;
                if (!this.temp.contains(string2)) {
                    this.temp.add(string2);
                }
                String[] stringArray3 = cMICommand.getAnottation().modules();
                int n6 = stringArray3.length;
                int n7 = 0;
                while (n7 < n6) {
                    object3 = stringArray3[n7];
                    if (!CMIModule.isEnabled((String)object3)) {
                        bl2 = false;
                        break;
                    }
                    ++n7;
                }
                if (bl2.booleanValue()) {
                    object3 = new CommandAlias(string2, Arrays.asList(String.valueOf(CommandsHandler.getLabel()) + " " + string4 + " $1-"), bl2, CommandAliasType.subbase, entry.getKey());
                    ((CommandAlias)object3).setRequiresPerm(true);
                    ((CommandAlias)object3).setTabComplete(bl3);
                    this.addDefault((CommandAlias)object3);
                } else {
                    object3 = linkedHashMap.get(string2);
                    if (object3 != null && ((CommandAlias)object3).getType() == CommandAliasType.subbase && ((CommandAlias)object3).getCmiCommandName().equals(entry.getKey())) {
                        ((CommandAlias)object3).setState(bl2);
                        ((CommandAlias)object3).setTabComplete(bl3);
                        this.addDefault((CommandAlias)object3);
                    }
                }
                if (!string.equalsIgnoreCase(string4)) {
                    configReader.addComment("Alias./" + string2, new String[]{"/" + CommandsHandler.getLabel() + " " + string4 + " $1-"});
                }
                ++n5;
            }
        }
        configReader.save();
        this.plugin.loadMessage(n, "regular alias", System.currentTimeMillis() - l);
    }

    public void saveNew() {
        HashSet<String> hashSet = new HashSet<String>();
        for (Map.Entry<String, CommandAlias> object : this.customAliases.entrySet()) {
            hashSet.add(object.getValue().getFileName());
        }
        for (String string : hashSet) {
            this.saveNew(string);
        }
    }

    public void saveNew(String string) {
        if (string.endsWith(".yml")) {
            string = string.substring(0, string.length() - ".yml".length());
        }
        File file = new File(this.plugin.getDataFolder(), "CustomAlias" + File.separator + string + ".yml");
        ConfigReader configReader = null;
        try {
            configReader = new ConfigReader(file);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (configReader == null) {
            return;
        }
        configReader.getC().set("CustomAlias", null);
        configReader.getC().options().copyDefaults(true);
        if (!string.equalsIgnoreCase("CustomAlias")) {
            if (configReader.getC().options().header() != null) {
                configReader.header(CMIList.stringToList((String)configReader.getC().options().header(), (String)"\n"));
            }
        } else {
            configReader.header(this.CommentList);
        }
        for (Map.Entry<String, CommandAlias> entry : this.customAliases.entrySet()) {
            if (!entry.getValue().getFileName().equals(string)) continue;
            configReader.get("CustomAlias." + entry.getKey() + ".Cmds", entry.getValue().getCommands());
            if (entry.getValue().isRequiresPerm()) {
                configReader.get("CustomAlias." + entry.getKey() + ".Perm", Boolean.valueOf(entry.getValue().isRequiresPerm()));
            }
            if (entry.getValue().isAddTabs()) {
                configReader.get("CustomAlias." + entry.getKey() + ".AddTabs", Boolean.valueOf(entry.getValue().isAddTabs()));
            }
            if (!entry.getValue().isTabComplete()) {
                configReader.get("CustomAlias." + entry.getKey() + ".Tab", Boolean.valueOf(entry.getValue().isTabComplete()));
            }
            if (entry.getValue().getCustomTabRawList() == null || entry.getValue().getCustomTabRawList().isEmpty()) continue;
            configReader.get("CustomAlias." + entry.getKey() + ".CustomTabs", entry.getValue().getCustomTabRawList());
        }
        configReader.save();
    }
}

