/*
 * Decompiled with CFR 0.152.
 */
package com.Zrips.CMI.Modules.Afk;

import com.Zrips.CMI.CMI;
import com.Zrips.CMI.Containers.CMIDirection;
import com.Zrips.CMI.Containers.CMIHitBox;
import com.Zrips.CMI.Containers.CMIUser;
import com.Zrips.CMI.Containers.CommandAlias;
import com.Zrips.CMI.Modules.Afk.checkInfo;
import com.Zrips.CMI.Modules.Permissions.PermissionsManager;
import com.Zrips.CMI.commands.list.util;
import com.Zrips.CMI.events.CMIAfkEnterEvent;
import com.Zrips.CMI.events.CMIAfkKickEvent;
import com.Zrips.CMI.events.CMIAfkLeaveEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import net.Zrips.CMILib.Container.CMIVectorInt3D;
import net.Zrips.CMILib.Items.CMIMaterial;
import net.Zrips.CMILib.Messages.CMIMessages;
import net.Zrips.CMILib.Version.Schedulers.CMIScheduler;
import net.Zrips.CMILib.Version.Version;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.ExperienceOrb;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityTargetLivingEntityEvent;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerFishEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerItemHeldEvent;
import org.bukkit.event.player.PlayerLoginEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerPickupItemEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.event.player.PlayerToggleSneakEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.java.JavaPlugin;

public class AfkListener
implements Listener {
    private CMI plugin;
    HashMap<UUID, previousLoc> antiJump = new HashMap();
    static HashMap<UUID, checkInfo> pitchChange = new HashMap();
    HashMap<UUID, Long> antiPush = new HashMap();

    public AfkListener(CMI cMI) {
        this.plugin = cMI;
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPlayerCommand(PlayerCommandPreprocessEvent playerCommandPreprocessEvent) {
        if (playerCommandPreprocessEvent.isCancelled()) {
            return;
        }
        Player player = playerCommandPreprocessEvent.getPlayer();
        if (player == null) {
            return;
        }
        if (player.hasMetadata("NPC")) {
            return;
        }
        boolean bl = this.plugin.getPlayerManager().getUser(player).isAfk();
        if (this.plugin.getAfkManager().isDisableOnCommand()) {
            CMIScheduler.runTask((JavaPlugin)this.plugin, () -> {
                CMIUser cMIUser = this.plugin.getPlayerManager().getUser(player);
                if (cMIUser == null) {
                    return;
                }
                if (bl && cMIUser.isAfk()) {
                    cMIUser.setAfk(false, CMIAfkEnterEvent.AfkType.auto);
                }
                this.plugin.getAfkManager().updateUser(cMIUser);
            });
        }
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void CreatureSpawnEvent(CreatureSpawnEvent creatureSpawnEvent) {
        if (!this.plugin.getAfkManager().isPreventMobSpawning()) {
            return;
        }
        if ((creatureSpawnEvent.getSpawnReason().equals((Object)CreatureSpawnEvent.SpawnReason.SPAWNER) && this.plugin.getAfkManager().isPreventMobSpawningSpawners() || (creatureSpawnEvent.getSpawnReason().equals((Object)CreatureSpawnEvent.SpawnReason.NATURAL) || creatureSpawnEvent.getSpawnReason().equals((Object)CreatureSpawnEvent.SpawnReason.EGG)) && this.plugin.getAfkManager().isPreventMobSpawningNatural() || creatureSpawnEvent.getSpawnReason().equals((Object)CreatureSpawnEvent.SpawnReason.VILLAGE_DEFENSE) && this.plugin.getAfkManager().isPreventMobVillageDefence()) && !this.plugin.getAfkManager().nearActivePlayer(creatureSpawnEvent.getLocation(), creatureSpawnEvent.getSpawnReason())) {
            creatureSpawnEvent.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPlayerAliasCommand(PlayerCommandPreprocessEvent playerCommandPreprocessEvent) {
        Player player = playerCommandPreprocessEvent.getPlayer();
        if (player == null) {
            return;
        }
        if (player.hasMetadata("NPC")) {
            return;
        }
        String string = playerCommandPreprocessEvent.getMessage().startsWith("/") ? playerCommandPreprocessEvent.getMessage().substring(1) : playerCommandPreprocessEvent.getMessage();
        CommandAlias commandAlias = CMI.getInstance().getAliasManager().getAliasForCommand(string);
        if (commandAlias == null || commandAlias.getAlias() == null || string == null) {
            return;
        }
        boolean bl = this.plugin.getPlayerManager().getUser(player).isAfk();
        if (this.plugin.getAfkManager().isDisableOnCommand()) {
            CMIScheduler.runTask((JavaPlugin)this.plugin, () -> {
                CMIUser cMIUser = this.plugin.getPlayerManager().getUser(player);
                if (cMIUser == null) {
                    return;
                }
                if (bl && cMIUser.isAfk()) {
                    cMIUser.setAfk(false, CMIAfkEnterEvent.AfkType.auto);
                }
                this.plugin.getAfkManager().updateUser(cMIUser);
            });
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPlayerTeleportEvent(PlayerTeleportEvent playerTeleportEvent) {
        Player player = playerTeleportEvent.getPlayer();
        if (player == null) {
            return;
        }
        Location location = playerTeleportEvent.getFrom();
        Location location2 = playerTeleportEvent.getTo();
        if (location2 == null) {
            return;
        }
        if (location.getWorld() == location2.getWorld() && location.getBlockX() == location2.getBlockX() && location.getBlockY() == location2.getBlockY() && location.getBlockZ() == location2.getBlockZ()) {
            return;
        }
        if (player.hasMetadata("NPC")) {
            return;
        }
        CMIUser cMIUser = this.plugin.getPlayerManager().getUser(playerTeleportEvent.getPlayer());
        if (cMIUser == null) {
            return;
        }
        if (location.getWorld() == location2.getWorld() && AfkListener.isSameDirection(cMIUser)) {
            return;
        }
        if (this.plugin.getAfkManager().isDisableOnMove()) {
            cMIUser.setAfk(false, CMIAfkEnterEvent.AfkType.auto);
        }
        CMIScheduler.runTask((JavaPlugin)this.plugin, () -> this.plugin.getAfkManager().updateUser(cMIUser));
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void onFishingRodUseOnPlayer(PlayerFishEvent playerFishEvent) {
        if (!this.plugin.getAfkManager().isPreventHook()) {
            return;
        }
        if (playerFishEvent.getCaught() == null) {
            return;
        }
        if (!(playerFishEvent.getCaught() instanceof Player)) {
            return;
        }
        Player player = (Player)playerFishEvent.getCaught();
        CMIUser cMIUser = CMIUser.getUser(player);
        if (cMIUser == null || !cMIUser.isAfk()) {
            return;
        }
        playerFishEvent.setCancelled(true);
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPlayerMove(PlayerMoveEvent playerMoveEvent) {
        Object object;
        Object object2;
        Player player = playerMoveEvent.getPlayer();
        if (player == null) {
            return;
        }
        Location location = playerMoveEvent.getFrom();
        Location location2 = playerMoveEvent.getTo();
        if (playerMoveEvent.getTo() == null) {
            return;
        }
        if (location.getBlockX() == location2.getBlockX() && location.getBlockY() == location2.getBlockY() && location.getBlockZ() == location2.getBlockZ() && location2.getPitch() == location.getPitch()) {
            return;
        }
        if (player.hasMetadata("NPC")) {
            return;
        }
        if (this.plugin.getAfkManager().isPreventJumping() && location.getBlockY() != location2.getBlockY()) {
            object2 = this.antiJump.get(player.getUniqueId());
            if (object2 == null) {
                object2 = new previousLoc();
            }
            if ((object = ((previousLoc)object2).addLoc(location2)) != null) {
                if (object.getBlockY() == location2.getBlockY()) {
                    ((previousLoc)object2).addJumpCount();
                } else {
                    ((previousLoc)object2).setJumpCount(0);
                }
                if (object.getBlockX() != location2.getBlockX() || object.getBlockZ() != location2.getBlockZ()) {
                    ((previousLoc)object2).setJumpCount(0);
                }
                if (((previousLoc)object2).getJumpCount() > 10) {
                    return;
                }
            }
            this.antiJump.put(player.getUniqueId(), (previousLoc)object2);
        }
        if ((object2 = this.plugin.getPlayerManager().getUser(playerMoveEvent.getPlayer())) == null) {
            return;
        }
        if (this.plugin.getAfkManager().isPreventPushing() && ((CMIUser)object2).isAfk() && location.getBlockY() == location2.getBlockY() && ((CMIUser)object2).isCollidable()) {
            Object object32;
            object = this.antiPush.get(player.getUniqueId());
            if (object != null && (Long)object > System.currentTimeMillis() && location2.getPitch() == location.getPitch()) {
                this.antiPush.put(player.getUniqueId(), System.currentTimeMillis() + 1000L);
                playerMoveEvent.setCancelled(true);
                return;
            }
            double d = Double.MAX_VALUE;
            Object object4 = null;
            for (Object object32 : location.getWorld().getNearbyEntities(location, 20.0, 20.0, 20.0)) {
                double d2;
                if (object32.getUniqueId().equals(player.getUniqueId()) || !((d2 = location.distance(object32.getLocation())) < d)) continue;
                d = d2;
                object4 = object32;
            }
            object32 = new CMIHitBox((Entity)player);
            if (((CMIHitBox)object32).collides((Entity)object4) && location2.getPitch() == location.getPitch()) {
                this.antiPush.put(player.getUniqueId(), System.currentTimeMillis() + 1000L);
                playerMoveEvent.setCancelled(true);
                return;
            }
        }
        if (AfkListener.isSameDirection((CMIUser)object2)) {
            return;
        }
        if (((CMIUser)object2).isAfk() && ((CMIUser)object2).getAfkInfo().getAfkFrom() != 0L && location.getBlockX() == location2.getBlockX() && location.getBlockY() == location2.getBlockY() && location.getBlockZ() == location2.getBlockZ() && ((CMIUser)object2).getAfkInfo().getAfkFrom() < System.currentTimeMillis() && ((CMIUser)object2).getAfkInfo().getAfkFrom() + 2500L > System.currentTimeMillis()) {
            return;
        }
        if (((CMIUser)object2).isAfk() && !playerMoveEvent.getPlayer().isOnGround() && !playerMoveEvent.getPlayer().isFlying() && location.getBlockX() == location2.getBlockX() && location.getY() > location2.getY() && location.getBlockZ() == location2.getBlockZ() && location2.getPitch() == location.getPitch()) {
            return;
        }
        if (((CMIUser)object2).isAfk() && !this.plugin.getAfkManager().isDisableOnLookAround()) {
            object = new CMIVectorInt3D(playerMoveEvent.getPlayer().getLocation());
            if (((CMIUser)object2).getAfkInfo().getAfkAt() != null && object.getX() == ((CMIUser)object2).getAfkInfo().getAfkAt().getX() && object.getY() == ((CMIUser)object2).getAfkInfo().getAfkAt().getY() && object.getZ() == ((CMIUser)object2).getAfkInfo().getAfkAt().getZ()) {
                return;
            }
        }
        if (this.plugin.getAfkManager().isDisableOnMove() || this.plugin.getAfkManager().isDisableOnLookAround()) {
            ((CMIUser)object2).setAfk(false, CMIAfkEnterEvent.AfkType.auto);
        }
        this.plugin.getAfkManager().updateUser((CMIUser)object2);
    }

    public static boolean isSameDirection(CMIUser cMIUser) {
        if (!CMI.getInstance().getAfkManager().isAntiAfkMachines()) {
            return false;
        }
        checkInfo checkInfo2 = pitchChange.get(cMIUser.getUniqueId());
        if (!cMIUser.isOnline() || cMIUser.getPlayer() == null) {
            return false;
        }
        Location location = cMIUser.getLocation();
        boolean bl = false;
        if (checkInfo2 == null) {
            checkInfo2 = new checkInfo(location);
            pitchChange.put(cMIUser.getUniqueId(), checkInfo2);
            bl = true;
        }
        if (checkInfo2.timeToCheck()) {
            checkInfo2.updateTime();
            if (checkInfo2.isSameDirection(location)) {
                block9: {
                    block10: {
                        if (bl || Version.isFolia()) break block9;
                        Material material = cMIUser.getPlayer().getEyeLocation().getBlock().getType();
                        Material material2 = cMIUser.getPlayer().getLocation().getBlock().getType();
                        if (!(Math.abs((double)CMIDirection.getAngle(location, checkInfo2.getLocation()) - checkInfo2.getPrevAngle()) > 90.0) || cMIUser.getPlayer().getVehicle() != null || (material.equals((Object)Material.WATER) || material2.equals((Object)Material.WATER)) && !material.equals((Object)Material.WATER) && !material2.equals((Object)Material.WATER)) break block9;
                        if (!material.equals((Object)Material.WATER) || material2.equals((Object)Material.WATER)) break block10;
                        return true;
                    }
                    checkInfo2.setPrevAngle(CMIDirection.getAngle(location, checkInfo2.getLocation()));
                    checkInfo2.updateLocation(location);
                    return false;
                }
                try {
                    checkInfo2.setPrevAngle(CMIDirection.getAngle(location, checkInfo2.getLocation()));
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
                checkInfo2.updateLocation(location);
                return true;
            }
            checkInfo2.updateLocation(location);
            return false;
        }
        return true;
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void PlayerPickupItemEvent(PlayerPickupItemEvent playerPickupItemEvent) {
        if (!this.plugin.getAfkManager().isDisableItemPickup()) {
            return;
        }
        CMIUser cMIUser = this.plugin.getPlayerManager().getUser(playerPickupItemEvent.getPlayer());
        if (cMIUser == null) {
            return;
        }
        if (cMIUser.isAfk()) {
            playerPickupItemEvent.setCancelled(true);
            playerPickupItemEvent.getItem().setPickupDelay(playerPickupItemEvent.getItem().getPickupDelay() < 20 ? 20 : playerPickupItemEvent.getItem().getPickupDelay());
        }
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void onFishingRodUse(PlayerFishEvent playerFishEvent) {
        if (!this.plugin.getAfkManager().isDisableOnFishing()) {
            return;
        }
        CMIUser cMIUser = this.plugin.getPlayerManager().getUser(playerFishEvent.getPlayer());
        if (cMIUser == null) {
            return;
        }
        if (playerFishEvent.getState() != PlayerFishEvent.State.CAUGHT_FISH && playerFishEvent.getState() != PlayerFishEvent.State.CAUGHT_ENTITY) {
            return;
        }
        cMIUser.setAfk(false, CMIAfkEnterEvent.AfkType.auto);
        this.plugin.getAfkManager().updateUser(cMIUser);
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void PlayerItemHeldEvent(PlayerItemHeldEvent playerItemHeldEvent) {
        if (!this.plugin.getAfkManager().isDisableOnInteract()) {
            return;
        }
        CMIUser cMIUser = this.plugin.getPlayerManager().getUser(playerItemHeldEvent.getPlayer());
        if (cMIUser == null) {
            return;
        }
        if (AfkListener.isSameDirection(cMIUser)) {
            return;
        }
        cMIUser.setAfk(false, CMIAfkEnterEvent.AfkType.auto);
        this.plugin.getAfkManager().updateUser(cMIUser);
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void PlayerInteractEvent(PlayerInteractEvent playerInteractEvent) {
        Block block;
        CMIMaterial cMIMaterial;
        try {
            if (Version.isCurrentHigher((Version)Version.v1_8_R3) && playerInteractEvent.getHand() != EquipmentSlot.HAND) {
                return;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!this.plugin.getAfkManager().isDisableOnInteract()) {
            return;
        }
        CMIUser cMIUser = this.plugin.getPlayerManager().getUser(playerInteractEvent.getPlayer());
        if (cMIUser == null) {
            return;
        }
        if (this.plugin.getAfkManager().isSmartInteractCheck() && (cMIMaterial = CMIMaterial.get((Block)(block = playerInteractEvent.getClickedBlock()))) != null) {
            switch (cMIMaterial) {
                case JUKEBOX: 
                case LAVA: 
                case LEVER: 
                case NOTE_BLOCK: 
                case WATER: {
                    return;
                }
            }
            if (cMIMaterial.isButton() || cMIMaterial.isGate() || cMIMaterial.isDoor()) {
                return;
            }
            ItemStack itemStack = cMIUser.getItemInHand();
            cMIMaterial = CMIMaterial.get((ItemStack)itemStack);
            if (cMIMaterial.equals((Object)CMIMaterial.FISHING_ROD) || cMIMaterial.isDye()) {
                return;
            }
            itemStack = cMIUser.getItemInOffHand();
            cMIMaterial = CMIMaterial.get((ItemStack)itemStack);
            if (cMIMaterial.equals((Object)CMIMaterial.FISHING_ROD) || cMIMaterial.isDye()) {
                return;
            }
        }
        if (AfkListener.isSameDirection(cMIUser)) {
            return;
        }
        cMIUser.setAfk(false, CMIAfkEnterEvent.AfkType.auto);
        this.plugin.getAfkManager().updateUser(cMIUser);
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void InventoryClickEvent(InventoryClickEvent inventoryClickEvent) {
        if (!this.plugin.getAfkManager().isDisableOnInventoryClick()) {
            return;
        }
        CMIUser cMIUser = this.plugin.getPlayerManager().getUser((Player)inventoryClickEvent.getWhoClicked());
        if (cMIUser == null) {
            return;
        }
        cMIUser.setAfk(false, CMIAfkEnterEvent.AfkType.auto);
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void PlayerToggleSneakEvent(PlayerToggleSneakEvent playerToggleSneakEvent) {
        if (!this.plugin.getAfkManager().isDisableOnMove()) {
            return;
        }
        CMIUser cMIUser = this.plugin.getPlayerManager().getUser(playerToggleSneakEvent.getPlayer());
        if (cMIUser == null) {
            return;
        }
        CMIVectorInt3D cMIVectorInt3D = new CMIVectorInt3D(playerToggleSneakEvent.getPlayer().getLocation());
        if (cMIUser.isAfk() && cMIUser.getAfkInfo().getAfkAt() != null && cMIVectorInt3D.getX() == cMIUser.getAfkInfo().getAfkAt().getX() && cMIVectorInt3D.getY() == cMIUser.getAfkInfo().getAfkAt().getY() && cMIVectorInt3D.getZ() == cMIUser.getAfkInfo().getAfkAt().getZ()) {
            return;
        }
        cMIUser.setAfk(false, CMIAfkEnterEvent.AfkType.auto);
        this.plugin.getAfkManager().updateUser(cMIUser);
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void EntityDamageEvent(EntityDamageEvent entityDamageEvent) {
        if (!this.plugin.getAfkManager().isPreventDamage()) {
            return;
        }
        if (!(entityDamageEvent.getEntity() instanceof Player)) {
            return;
        }
        CMIUser cMIUser = this.plugin.getPlayerManager().getUser((Player)entityDamageEvent.getEntity());
        if (cMIUser == null) {
            return;
        }
        if (cMIUser.isAfk()) {
            if (util.imortaldebug) {
                CMIMessages.consoleMessage((String)"Afk EntityDamageEvent->EntityDamageEvent");
            }
            entityDamageEvent.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onAsyncPlayerChatEvent(AsyncPlayerChatEvent asyncPlayerChatEvent) {
        if (!this.plugin.getAfkManager().isDisableOnPublicChat()) {
            return;
        }
        CMIUser cMIUser = this.plugin.getPlayerManager().getUser(asyncPlayerChatEvent.getPlayer());
        if (cMIUser == null) {
            return;
        }
        if (Version.isPaper()) {
            CMIScheduler.runTask((JavaPlugin)this.plugin, () -> {
                cMIUser.setAfk(false, CMIAfkEnterEvent.AfkType.auto);
                this.plugin.getAfkManager().updateUser(cMIUser);
            });
        } else {
            cMIUser.setAfk(false, CMIAfkEnterEvent.AfkType.auto);
            this.plugin.getAfkManager().updateUser(cMIUser);
        }
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void CMIAfkEnterEvent(CMIAfkEnterEvent cMIAfkEnterEvent) {
        CMIUser cMIUser;
        Player player = cMIAfkEnterEvent.getPlayer();
        if (player == null) {
            return;
        }
        if (!PermissionsManager.CMIPerm.command_afk_auto.hasPermission((CommandSender)player) && cMIAfkEnterEvent.getType().equals((Object)CMIAfkEnterEvent.AfkType.auto)) {
            cMIAfkEnterEvent.setCancelled(true);
        }
        if ((cMIUser = this.plugin.getPlayerManager().getUser(cMIAfkEnterEvent.getPlayer())) == null) {
            return;
        }
        this.plugin.getPlayTimeRewardManager().updateAfkAction(cMIUser);
        AfkListener.isSameDirection(cMIUser);
        if (this.plugin.getAfkManager().isStopPlayTime()) {
            this.plugin.getAfkManager().AddToAfkTimePreventer(cMIUser);
        }
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void CMIAfkKickEvent(CMIAfkKickEvent cMIAfkKickEvent) {
        Player player = cMIAfkKickEvent.getPlayer();
        if (player == null) {
            return;
        }
        if (!PermissionsManager.CMIPerm.command_afk_auto.hasPermission((CommandSender)player)) {
            cMIAfkKickEvent.setCancelled(true);
        }
        if (PermissionsManager.CMIPerm.command_afk_kickbypass.hasPermission((CommandSender)player)) {
            cMIAfkKickEvent.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void CMIAfkLeaveEvent(CMIAfkLeaveEvent cMIAfkLeaveEvent) {
        CMIUser cMIUser = this.plugin.getPlayerManager().getUser(cMIAfkLeaveEvent.getPlayer());
        if (cMIUser == null) {
            return;
        }
        this.plugin.getPlayTimeRewardManager().removeFromAfkAction(cMIUser);
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void PlayerLoginEvent(PlayerLoginEvent playerLoginEvent) {
        Player player = playerLoginEvent.getPlayer();
        if (player == null) {
            return;
        }
        CMIUser cMIUser = this.plugin.getPlayerManager().getUser(playerLoginEvent.getPlayer());
        if (cMIUser == null) {
            return;
        }
        this.plugin.getPlayTimeRewardManager().removeFromAfkAction(cMIUser);
        CMIScheduler.runTaskLater((JavaPlugin)this.plugin, () -> this.plugin.getAfkManager().updateUser(cMIUser), (long)60L);
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void PlayerQuitEvent(PlayerQuitEvent playerQuitEvent) {
        Player player = playerQuitEvent.getPlayer();
        if (player == null) {
            return;
        }
        CMIUser cMIUser = this.plugin.getPlayerManager().getUser(playerQuitEvent.getPlayer());
        if (cMIUser == null) {
            return;
        }
        this.plugin.getPlayTimeRewardManager().removeFromAfkAction(cMIUser);
        CMIScheduler.runTask((JavaPlugin)this.plugin, () -> {
            cMIUser.setAfk(false, CMIAfkEnterEvent.AfkType.auto);
            this.plugin.getAfkManager().removeUser(cMIUser);
            this.antiJump.remove(cMIUser.getUniqueId());
            pitchChange.remove(cMIUser.getUniqueId());
        });
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void EntityTargetLivingEntityEvent(EntityTargetLivingEntityEvent entityTargetLivingEntityEvent) {
        if (entityTargetLivingEntityEvent.isCancelled()) {
            return;
        }
        if (!this.plugin.getAfkManager().isDisableExpPickup()) {
            return;
        }
        if (entityTargetLivingEntityEvent.getEntity().getType() != EntityType.EXPERIENCE_ORB) {
            return;
        }
        if (entityTargetLivingEntityEvent.getTarget() == null) {
            return;
        }
        if (entityTargetLivingEntityEvent.getTarget().getType() != EntityType.PLAYER) {
            return;
        }
        CMIUser cMIUser = this.plugin.getPlayerManager().getUser((Player)entityTargetLivingEntityEvent.getTarget());
        if (cMIUser == null) {
            return;
        }
        if (cMIUser.isAfk()) {
            ExperienceOrb experienceOrb = (ExperienceOrb)entityTargetLivingEntityEvent.getEntity();
            experienceOrb.setExperience(0);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onItemDrop(PlayerDropItemEvent playerDropItemEvent) {
        if (playerDropItemEvent.isCancelled()) {
            return;
        }
        if (!this.plugin.getAfkManager().isDisableOnItemDrop()) {
            return;
        }
        CMIUser cMIUser = this.plugin.getPlayerManager().getUser(playerDropItemEvent.getPlayer());
        if (cMIUser == null) {
            return;
        }
        if (!cMIUser.isAfk()) {
            return;
        }
        cMIUser.setAfk(false, CMIAfkEnterEvent.AfkType.auto);
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onBlockBreakEvent(BlockBreakEvent blockBreakEvent) {
        if (blockBreakEvent.isCancelled()) {
            return;
        }
        CMIUser cMIUser = this.plugin.getPlayerManager().getUser(blockBreakEvent.getPlayer());
        if (cMIUser == null) {
            return;
        }
        if (!cMIUser.isAfk()) {
            return;
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPlayerRespawnEvent(PlayerRespawnEvent playerRespawnEvent) {
        CMIUser cMIUser = this.plugin.getPlayerManager().getUser(playerRespawnEvent.getPlayer());
        if (cMIUser == null) {
            return;
        }
        if (!cMIUser.isAfk()) {
            return;
        }
        this.plugin.getAfkManager().updateUser(cMIUser);
        cMIUser.setAfk(false, CMIAfkEnterEvent.AfkType.auto);
    }

    private class previousLoc {
        List<Location> locs = new ArrayList<Location>();
        private int jumpCount = 0;

        private previousLoc() {
        }

        public Location addLoc(Location location) {
            this.locs.add(location);
            if (this.locs.size() > 2) {
                return this.locs.remove(0);
            }
            return null;
        }

        public int getJumpCount() {
            return this.jumpCount;
        }

        public void setJumpCount(int n) {
            this.jumpCount = n;
        }

        public void addJumpCount() {
            ++this.jumpCount;
        }
    }
}

