/*
 * Decompiled with CFR 0.152.
 */
package com.Zrips.CMI.Containers;

import com.Zrips.CMI.CMI;
import com.Zrips.CMI.Containers.CMISunMover;
import com.Zrips.CMI.Containers.CMIUser;
import com.Zrips.CMI.Locale.CMILC;
import com.Zrips.CMI.Modules.Permissions.PermissionsManager;
import com.Zrips.CMI.utils.TimeManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import net.Zrips.CMILib.Container.CMIList;
import net.Zrips.CMILib.FileHandler.ConfigReader;
import net.Zrips.CMILib.Messages.CMIMessages;
import net.Zrips.CMILib.Version.Schedulers.CMIScheduler;
import net.Zrips.CMILib.Version.Schedulers.CMITask;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.java.JavaPlugin;

public class SleepStats {
    private World world;
    private int speed;
    private double sleeping;
    private double total;
    private double percent;
    private int online;
    CMITask task = null;
    public static List<String> timeSpeedUpWorlds = new ArrayList<String>();
    private static boolean SleepingPercentage;
    public static boolean SleepingExcludeAfk;
    public static boolean SleepingSpeedup;
    public static boolean SleepingOnlyDurringNight;
    public static boolean SleepingInform;
    private static int SleepingBaseSpeed;
    private static int SleepingMinBeforeSpeeding;
    private static int SleepingMinSpeed;
    public static int SleepingInformDelay;
    public static int SleepingNightStartsAt;
    public static String SleepingSpeedupInfoType;
    public static HashMap<UUID, Long> informMap;

    static {
        informMap = new HashMap();
    }

    public static void loadConfig() {
        ConfigReader configReader = CMI.getInstance().getConfigManager().getConfig();
        configReader.addComment("Sleeping.Speedup.Enabled", new String[]{"When set to true, players can speedup night by sleeping in bed", "This will allow to speed up night in percentage depending how many players are sleeping in beds in that world"});
        SleepingSpeedup = configReader.get("Sleeping.Speedup.Enabled", Boolean.valueOf(true));
        configReader.addComment("Sleeping.Speedup.Worlds", new String[]{"List of worlds where this should be applied.", "Keep in mind that time speed up only works on a normal type world and by default you will have only one", "Set this list to [] if you want to include all possible worlds"});
        timeSpeedUpWorlds = configReader.get("Sleeping.Speedup.Worlds", new ArrayList());
        CMIList.toLowerCase(timeSpeedUpWorlds);
        configReader.addComment("Sleeping.Speedup.OnlyDurringNight", new String[]{"When this set to true time will be speed up only between 12542 and 24000 ticks of the day", "When having this set to false players can speed up day durring storms or other events"});
        SleepingOnlyDurringNight = configReader.get("Sleeping.Speedup.OnlyDurringNight", Boolean.valueOf(true));
        configReader.addComment("Sleeping.Speedup.NightStartsAt", new String[]{"Time when night starts", "This is in ticks, so 12542 will be 18:32:00"});
        SleepingNightStartsAt = configReader.get("Sleeping.Speedup.NightStartsAt", 12542);
        configReader.addComment("Sleeping.Speedup.InfoType", new String[]{"Type of speedup information, can be: none, title, bossbar"});
        SleepingSpeedupInfoType = configReader.get("Sleeping.Speedup.InfoType", "title");
        configReader.addComment("Sleeping.Speedup.ExcludeAfk", new String[]{"When set to true, players who are in afk mode will be excluded from speed calculations"});
        SleepingExcludeAfk = configReader.get("Sleeping.Speedup.ExcludeAfk", Boolean.valueOf(true));
        configReader.addComment("Sleeping.Speedup.BaseSpeed", new String[]{"Defines speed to go throw night, bigger numbers will make it go faster and less players you will need to go throw night", "100 will result in 100 times faster time"});
        SleepingBaseSpeed = configReader.get("Sleeping.Speedup.BaseSpeed", 100);
        configReader.addComment("Sleeping.Speedup.MinSpeed", new String[]{"Defines minimal speed to go throw night, this is in case there are more players than base speed and calculation return default speed"});
        SleepingMinSpeed = configReader.get("Sleeping.Speedup.MinSpeed", 5);
        configReader.addComment("Sleeping.Speedup.MinBeforeSpeeding", new String[]{"Minimal amount of players sleeping in beds before speeding it up", "Can be defined in 2 formats. When using clean number like 3, then 3 players will have to be sleeping before speedup kicks in", "If amount is defined with % like 50% then half of server population will have to be sleeping before speedup kicks in"});
        String string = configReader.get("Sleeping.Speedup.MinBeforeSpeeding", "50%");
        if (string.contains("%")) {
            try {
                SleepingMinBeforeSpeeding = Integer.parseInt(string.replace("%", ""));
                SleepingPercentage = true;
            }
            catch (Exception exception) {
                SleepingMinBeforeSpeeding = 1;
                SleepingPercentage = false;
            }
        } else {
            SleepingPercentage = false;
            try {
                SleepingMinBeforeSpeeding = Integer.parseInt(string);
            }
            catch (Exception exception) {
                SleepingMinBeforeSpeeding = 1;
            }
        }
        configReader.addComment("Sleeping.Speedup.Inform", new String[]{"When set to true online players will be informed about missing sleeping people count"});
        SleepingInform = configReader.get("Sleeping.Speedup.Inform", Boolean.valueOf(true));
        configReader.addComment("Sleeping.Speedup.InformDelay", new String[]{"Time in seconds between information messages can be shown when player starts or stops sleeping"});
        SleepingInformDelay = configReader.get("Sleeping.Speedup.InformDelay", 30);
    }

    public SleepStats(World world2) {
        this.world = world2;
        this.sleeping = 0.0;
        this.total = 0.0;
        this.online = 0;
        for (Player player : Bukkit.getOnlinePlayers()) {
            CMIUser cMIUser = CMI.getInstance().getPlayerManager().getUser(player);
            if (!player.getWorld().equals(world2) || PermissionsManager.CMIPerm.sleepignore.hasSetPermission((CommandSender)player, new String[0])) continue;
            boolean bl = cMIUser.isAfk();
            if (!cMIUser.isVanished() && bl && !SleepingExcludeAfk) {
                ++this.online;
            }
            if (!bl && !cMIUser.isVanished() || bl && !SleepingExcludeAfk && !cMIUser.isVanished()) {
                this.total += 1.0;
            }
            if (!player.isSleeping() || cMIUser.isVanished() || bl && (!bl || SleepingExcludeAfk)) continue;
            this.sleeping += 1.0;
        }
        this.percent = this.sleeping / this.total;
        this.speed = (int)((double)SleepingBaseSpeed * this.percent);
        if (this.speed < SleepingMinSpeed) {
            this.speed = SleepingMinSpeed;
        }
    }

    public World getWorld() {
        return this.world;
    }

    public void setWorld(World world2) {
        this.world = world2;
    }

    public int getSpeed() {
        return this.speed;
    }

    public void setSpeed(int n) {
        this.speed = n;
    }

    public double getSleeping() {
        return this.sleeping;
    }

    public int needToBeSleeping() {
        int n = SleepingMinBeforeSpeeding;
        if (SleepingPercentage) {
            double d = (double)n / 100.0;
            int n2 = (int)Math.ceil(this.getTotal() * d);
            return n2;
        }
        return n;
    }

    public void setSleeping(double d) {
        this.sleeping = d;
        this.percent = d / this.total;
        this.speed = (int)((double)SleepingBaseSpeed * this.percent);
        if (this.speed < SleepingMinSpeed) {
            this.speed = SleepingMinSpeed;
        }
    }

    public double getTotal() {
        return this.total;
    }

    public void setTotal(double d) {
        this.total = d;
    }

    public double getPercent() {
        return this.percent;
    }

    public void setPercent(double d) {
        this.percent = d;
    }

    public int getOnline() {
        return this.online;
    }

    public int getWorldOnline() {
        int n = 0;
        for (Player player : Bukkit.getOnlinePlayers()) {
            if (!player.getWorld().equals(this.world)) continue;
            ++n;
        }
        return n;
    }

    public void setOnline(int n) {
        this.online = n;
    }

    public void onBedEnter(Player player) {
        if (SleepingOnlyDurringNight && player.getWorld().getTime() <= (long)SleepingNightStartsAt) {
            return;
        }
        CMIScheduler.runTask((JavaPlugin)CMI.getInstance(), () -> {
            if (!PermissionsManager.CMIPerm.sleepignore.hasSetPermission((CommandSender)player, new String[0])) {
                this.setSleeping(this.getSleeping() + 1.0);
            }
            if (this.getSleeping() >= (double)this.getWorldOnline()) {
                if (!player.getWorld().getGameRuleValue("doDaylightCycle").equalsIgnoreCase("true")) {
                    CMISunMover cMISunMover = TimeManager.movingmap.getOrDefault(player.getWorld(), new CMISunMover());
                    cMISunMover.setMoving(player.getWorld().getGameRuleValue("doDaylightCycle"));
                    TimeManager.movingmap.put(player.getWorld(), cMISunMover);
                    player.getWorld().setGameRuleValue("doDaylightCycle", "true");
                }
                CMI.getInstance().getTimeManager().cancelSunMove(player.getWorld(), false);
                for (CMISunMover cMISunMover : Bukkit.getOnlinePlayers()) {
                    if (!cMISunMover.getWorld().equals(player.getWorld())) continue;
                    CMILC.info_skippingNight.sendMessage(cMISunMover, new Object[0]);
                }
                return;
            }
            if ((double)this.needToBeSleeping() > this.getSleeping()) {
                Long l = informMap.get(player.getUniqueId());
                if (SleepingInform && (l == null || l + (long)(1000 * SleepingInformDelay) < System.currentTimeMillis())) {
                    CMIMessages.broadcastMessage((CommandSender)Bukkit.getConsoleSender(), (String)CMILC.info_sleepersRequired.getLocale("[required]", this.needToBeSleeping(), "[sleeping]", (int)this.getSleeping()), (boolean)false);
                    informMap.put(player.getUniqueId(), System.currentTimeMillis());
                }
                CMI.getInstance().getTimeManager().cancelSunMove(player.getWorld());
                return;
            }
            if (this.getSleeping() > 0.0) {
                if (player.getWorld().getGameRuleValue("doDaylightCycle").equals("true")) {
                    CMI.getInstance().getTimeManager().moveSun(player.getWorld(), this.getSpeed(), 1, 23450, true);
                } else {
                    CMI.getInstance().getTimeManager().moveSun(player.getWorld(), this.getSpeed(), 1, 23550, true);
                }
            }
        });
    }

    public void onBedLeave(Player player) {
        this.setSleeping(this.getSleeping() - 1.0);
        CMIScheduler.runTask((JavaPlugin)CMI.getInstance(), () -> {
            if (this.getSleeping() <= (double)this.getWorldOnline() && TimeManager.movingmap.containsKey(player.getWorld())) {
                player.getWorld().setGameRuleValue("doDaylightCycle", TimeManager.movingmap.get(player.getWorld()).getMoving());
            }
            if (this.getSleeping() <= 1.0) {
                CMI.getInstance().getTimeManager().cancelSunMove(player.getWorld());
                return;
            }
            if ((double)this.needToBeSleeping() > this.getSleeping()) {
                Long l;
                if (this.getSleeping() > 0.0 && SleepingInform && ((l = informMap.get(player.getUniqueId())) == null || l + (long)(1000 * SleepingInformDelay) < System.currentTimeMillis())) {
                    CMIMessages.broadcastMessage((CommandSender)player, (String)CMILC.info_sleepersRequired.getLocale("[required]", this.needToBeSleeping(), "[sleeping]", (int)this.getSleeping()), (boolean)false);
                    informMap.put(player.getUniqueId(), System.currentTimeMillis());
                }
                CMI.getInstance().getTimeManager().cancelSunMove(player.getWorld());
                return;
            }
            if (player.getWorld().getTime() > 10000L) {
                CMI.getInstance().getTimeManager().moveSun(player.getWorld(), this.getSpeed(), 1, 23500, true);
            }
        });
    }
}

