/*
 * Decompiled with CFR 0.152.
 */
package com.Zrips.CMI.Containers;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CMIJson {
    private CMIJson() {
        throw new IllegalStateException("Utility class");
    }

    public static <K, V> String serialize(HashMap<K, V> hashMap) {
        try {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("{");
            for (Map.Entry<K, V> entry : hashMap.entrySet()) {
                stringBuilder.append(CMIJson.serializeObject(entry.getKey())).append(":").append(CMIJson.serializeObject(entry.getValue())).append(",");
            }
            if (stringBuilder.length() > 1) {
                stringBuilder.setLength(stringBuilder.length() - 1);
            }
            stringBuilder.append("}");
            return stringBuilder.toString();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return null;
        }
    }

    public static HashMap<String, Object> deserialize(String string) {
        String[] stringArray;
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        string = string.substring(1, string.length() - 1);
        String[] stringArray2 = stringArray = CMIJson.splitJsonEntries(string);
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String string2 = stringArray2[n2];
            String[] stringArray3 = string2.split(":", 2);
            if (stringArray3.length == 2) {
                String string3 = CMIJson.deserializeObject(stringArray3[0]).toString();
                Object object = CMIJson.deserializeObject(stringArray3[1]);
                hashMap.put(string3, object);
            }
            ++n2;
        }
        return hashMap;
    }

    private static String serializeObject(Object object) {
        if (object == null) {
            return "\"null\"";
        }
        if (object instanceof String) {
            return "\"" + CMIJson.escapeJson(object.toString()) + "\"";
        }
        if (object instanceof Boolean) {
            return "\"" + ((Boolean)object != false ? "1b" : "0b") + "\"";
        }
        if (object instanceof Integer || object instanceof Long || object instanceof Double) {
            return "\"" + object.toString() + "\"";
        }
        if (object instanceof List) {
            return CMIJson.serializeList((List)object);
        }
        if (object instanceof HashMap) {
            return CMIJson.serialize((HashMap)object);
        }
        return "\"" + object.toString() + "\"";
    }

    private static String escapeJson(String string) {
        return string.replace("\\", "\\\\").replace("\"", "\\\"").replace("\b", "\\b").replace("\f", "\\f").replace("\n", "\\n").replace("\r", "\\r").replace("\t", "\\t");
    }

    private static String unescapeJson(String string) {
        return string.replace("\\\"", "\"").replace("\\\\", "\\").replace("\\b", "\b").replace("\\f", "\f").replace("\\n", "\n").replace("\\r", "\r").replace("\\t", "\t");
    }

    public static String serializeList(List<?> list2) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[");
        for (Object obj : list2) {
            stringBuilder.append(CMIJson.serializeObject(obj)).append(",");
        }
        if (stringBuilder.length() > 1) {
            stringBuilder.setLength(stringBuilder.length() - 1);
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    private static Object deserializeObject(String string) {
        if ((string = string.trim()).startsWith("\"") && string.endsWith("\"")) {
            string = string.substring(1, string.length() - 1);
        }
        if ("null".equals(string)) {
            return null;
        }
        if (string.equals("true") || string.equals("false")) {
            return Boolean.parseBoolean(string);
        }
        if (string.equals("1b")) {
            return true;
        }
        if (string.equals("0b")) {
            return false;
        }
        if (string.startsWith("[") && string.endsWith("]")) {
            return CMIJson.deserializeList(string);
        }
        if (string.startsWith("{") && string.endsWith("}")) {
            return CMIJson.deserialize(string);
        }
        try {
            return Long.parseLong(string);
        }
        catch (NumberFormatException numberFormatException) {
            try {
                return Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException2) {
                try {
                    return Double.parseDouble(string);
                }
                catch (NumberFormatException numberFormatException3) {
                    if (string.startsWith("\"") && string.endsWith("\"")) {
                        return CMIJson.unescapeJson(string.substring(1, string.length() - 1));
                    }
                    return CMIJson.unescapeJson(string);
                }
            }
        }
    }

    public static List<Object> deserializeList(String string) {
        String[] stringArray;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        string = string.substring(1, string.length() - 1);
        String[] stringArray2 = stringArray = CMIJson.splitJsonEntries(string);
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String string2 = stringArray2[n2];
            arrayList.add(CMIJson.deserializeObject(string2));
            ++n2;
        }
        return arrayList;
    }

    private static String[] splitJsonEntries(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        while (n4 < string.length()) {
            char c = string.charAt(n4);
            if (c == '{') {
                ++n;
            }
            if (c == '}') {
                --n;
            }
            if (c == '[') {
                ++n2;
            }
            if (c == ']') {
                --n2;
            }
            if (c == ',' && n == 0 && n2 == 0) {
                arrayList.add(string.substring(n3, n4).trim());
                n3 = n4 + 1;
            }
            ++n4;
        }
        if (n3 < string.length()) {
            arrayList.add(string.substring(n3).trim());
        }
        return arrayList.toArray(new String[0]);
    }
}

