/*
 * Decompiled with CFR 0.152.
 */
package com.Zrips.CMI.Containers;

import net.Zrips.CMILib.CMILib;
import org.bukkit.Location;
import org.bukkit.util.Vector;

public enum CMIDirection {
    N("North", 0, 0, -1),
    NE("North_East", 45, 1, -1),
    E("East", 90, 1, 0),
    SE("South_East", 135, 1, 1),
    S("South", 180, 0, 1),
    SW("South_West", 225, -1, 1),
    W("West", 270, -1, 0),
    NW("North_West", 315, -1, 1);

    private int angle;
    private String name;
    private int x = 0;
    private int z = 0;

    private CMIDirection(String string2, int n2, int n3, int n4) {
        this.name = string2;
        this.angle = n2;
        this.x = n3;
        this.z = n4;
    }

    private CMIDirection(String string2, int n2) {
        this.name = string2;
        this.angle = n2;
    }

    public static CMIDirection getFromAngle(double d) {
        CMIDirection[] cMIDirectionArray = CMIDirection.values();
        int n = cMIDirectionArray.length;
        int n2 = 0;
        while (n2 < n) {
            CMIDirection cMIDirection = cMIDirectionArray[n2];
            double d2 = (double)cMIDirection.getAngle() - d;
            double d3 = d2 = d2 < 0.0 ? -d2 : d2;
            if (d2 <= 22.5) {
                return cMIDirection;
            }
            ++n2;
        }
        return N;
    }

    public int getAngle() {
        return this.angle;
    }

    public String getName() {
        return this.name;
    }

    public static Location rotateOnAxisDistance(Location location, double d, double d2, double d3) {
        return location.clone().add(CMIDirection.rotateOnAxisDistanceVector(location, d, d2, d3));
    }

    public static Vector rotateOnAxisDistanceVector(Location location, double d, double d2, double d3) {
        double d4 = (double)location.getYaw() / 180.0 * Math.PI;
        double d5 = (double)location.getPitch() / 180.0 * Math.PI;
        double d6 = Math.toRadians(d2);
        Vector vector = new Vector(Math.sin(d6) * d * Math.cos(Math.PI / 180 * d3), Math.cos(d6) * d, Math.sin(d6) * d * Math.sin(Math.PI / 180 * d3));
        double d7 = Math.cos(d5) * vector.getY() - Math.sin(d5) * vector.getZ();
        double d8 = Math.sin(d5) * vector.getY() + Math.cos(d5) * vector.getZ();
        vector.setY(d7).setZ(d8);
        double d9 = Math.cos(-d4) * vector.getX() + Math.sin(-d4) * vector.getZ();
        double d10 = -Math.sin(-d4) * vector.getX() + Math.cos(-d4) * vector.getZ();
        vector.setX(d9).setZ(d10);
        return vector;
    }

    public static float getAngle(Location location, Location location2) {
        Vector vector = location.toVector().subtract(location2.toVector());
        Location location3 = location.clone();
        location3.setDirection(vector);
        return (location3.getYaw() + 540.0f) % 360.0f;
    }

    public static float getAngle(float f) {
        return (f + 540.0f) % 360.0f;
    }

    public static CMIDirection getFromLocations(Location location, Location location2) {
        return CMIDirection.getFromAngle(CMIDirection.getAngle(location, location2));
    }

    public String getTranslatedName() {
        return CMILib.getInstance().getLM().getMessage("direction." + this.toString().toLowerCase(), new Object[0]);
    }

    public int getX() {
        return this.x;
    }

    public int getZ() {
        return this.z;
    }

    public CMIDirection rotate90ClockWise() {
        int n = this.getAngle() + 90;
        n = n > 360 ? 360 - n : n;
        return CMIDirection.getFromAngle(n);
    }

    public CMIDirection rotate90CounterClockWise() {
        int n = this.getAngle() - 90;
        n = n < 0 ? 360 + n : n;
        return CMIDirection.getFromAngle(n);
    }
}

