/*
 * Decompiled with CFR 0.152.
 */
package com.Zrips.CMI.Containers;

import com.Zrips.CMI.Containers.CMIHitBox;
import com.Zrips.CMI.Containers.CMIRay;
import org.bukkit.Location;
import org.bukkit.util.Vector;

public class CMICollision {
    private Vector min;
    private Vector max;

    public CMICollision(CMIHitBox cMIHitBox) {
        this(cMIHitBox.getMin(), cMIHitBox.getMax());
    }

    public CMICollision(Vector vector, Vector vector2) {
        this(vector.getX(), vector.getY(), vector.getZ(), vector2.getX(), vector2.getY(), vector2.getZ());
    }

    public CMICollision(double d, double d2, double d3, double d4, double d5, double d6) {
        this.min = new Vector(Math.min(d, d4), Math.min(d2, d5), Math.min(d3, d6));
        this.max = new Vector(Math.max(d, d4), Math.max(d2, d5), Math.max(d3, d6));
    }

    public Vector getMin() {
        return this.min;
    }

    public Vector getMax() {
        return this.max;
    }

    public double min(int n) {
        switch (n) {
            case 0: {
                return this.min.getX();
            }
            case 1: {
                return this.min.getY();
            }
            case 2: {
                return this.min.getZ();
            }
        }
        return 0.0;
    }

    public double max(int n) {
        switch (n) {
            case 0: {
                return this.max.getX();
            }
            case 1: {
                return this.max.getY();
            }
            case 2: {
                return this.max.getZ();
            }
        }
        return 0.0;
    }

    public boolean collides(CMIRay cMIRay, double d, double d2) {
        int n = 0;
        while (n < 3) {
            double d3 = 1.0 / cMIRay.direction(n);
            double d4 = (this.min(n) - cMIRay.origin(n)) * d3;
            double d5 = (this.max(n) - cMIRay.origin(n)) * d3;
            if (d3 < 0.0) {
                double d6 = d4;
                d4 = d5;
                d5 = d6;
            }
            d = d4 > d ? d4 : d;
            double d7 = d2 = d5 < d2 ? d5 : d2;
            if (d2 <= d) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public double collidesNearest(CMIRay cMIRay, double d, double d2) {
        int n = 0;
        while (n < 3) {
            double d3 = 1.0 / cMIRay.direction(n);
            double d4 = (this.min(n) - cMIRay.origin(n)) * d3;
            double d5 = (this.max(n) - cMIRay.origin(n)) * d3;
            if (d3 < 0.0) {
                double d6 = d4;
                d4 = d5;
                d5 = d6;
            }
            d = d4 > d ? d4 : d;
            double d7 = d2 = d5 < d2 ? d5 : d2;
            if (d2 <= d) {
                return -1.0;
            }
            ++n;
        }
        return d;
    }

    public boolean contains(Location location) {
        if (location.getX() > this.max.getX()) {
            return false;
        }
        if (location.getY() > this.max.getY()) {
            return false;
        }
        if (location.getZ() > this.max.getZ()) {
            return false;
        }
        if (location.getX() < this.min.getX()) {
            return false;
        }
        if (location.getY() < this.min.getY()) {
            return false;
        }
        return !(location.getZ() < this.min.getZ());
    }
}

