/*
 * Decompiled with CFR 0.152.
 */
package com.Zrips.CMI.AllListeners;

import com.Zrips.CMI.CMI;
import com.Zrips.CMI.Containers.CMIUser;
import com.Zrips.CMI.Locale.CMILC;
import com.Zrips.CMI.Modules.Permissions.PermissionsManager;
import com.Zrips.CMI.commands.list.cuff;
import com.Zrips.CMI.commands.list.util;
import net.Zrips.CMILib.Messages.CMIMessages;
import net.Zrips.CMILib.TitleMessages.CMITitleMessage;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.ProjectileLaunchEvent;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerQuitEvent;

public class UserCuffedEvents
implements Listener {
    private CMI plugin;

    public UserCuffedEvents(CMI cMI) {
        this.plugin = cMI;
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void chat(AsyncPlayerChatEvent asyncPlayerChatEvent) {
        Player player = asyncPlayerChatEvent.getPlayer();
        if (!this.plugin.getConfigManager().CuffMute) {
            return;
        }
        if (!this.plugin.getPlayerManager().isCuffed(player)) {
            return;
        }
        CMILC.info(cuff.class, (CommandSender)player, "noChat", new Object[0]);
        asyncPlayerChatEvent.setCancelled(true);
        asyncPlayerChatEvent.getRecipients().clear();
        asyncPlayerChatEvent.setMessage("");
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPlayerQuit(PlayerQuitEvent playerQuitEvent) {
        Player player = playerQuitEvent.getPlayer();
        if (!this.plugin.getPlayerManager().isCuffed(player)) {
            return;
        }
        this.plugin.getPlayerManager().removeCuffed(player);
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onPlayerInteract(PlayerInteractEvent playerInteractEvent) {
        Player player = playerInteractEvent.getPlayer();
        if (!this.plugin.getPlayerManager().isCuffed(player)) {
            return;
        }
        playerInteractEvent.setCancelled(true);
        CMITitleMessage.send((Player)player, (Object)CMILC.getIM(cuff.class, "cuffedInfo", new Object[0]), null);
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onPlayerInteract(InventoryClickEvent inventoryClickEvent) {
        if (!(inventoryClickEvent.getWhoClicked() instanceof Player)) {
            return;
        }
        Player player = (Player)inventoryClickEvent.getWhoClicked();
        if (!this.plugin.getPlayerManager().isCuffed(player)) {
            return;
        }
        inventoryClickEvent.setCancelled(true);
        CMITitleMessage.send((Player)player, (Object)CMILC.getIM(cuff.class, "cuffedInfo", new Object[0]), null);
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onPlayerDropItemEvent(PlayerDropItemEvent playerDropItemEvent) {
        Player player = playerDropItemEvent.getPlayer();
        if (!this.plugin.getPlayerManager().isCuffed(player)) {
            return;
        }
        playerDropItemEvent.setCancelled(true);
        CMITitleMessage.send((Player)player, (Object)CMILC.getIM(cuff.class, "cuffedInfo", new Object[0]), null);
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onProjectileLaunchEvent(ProjectileLaunchEvent projectileLaunchEvent) {
        if (!(projectileLaunchEvent.getEntity().getShooter() instanceof Player)) {
            return;
        }
        Player player = (Player)projectileLaunchEvent.getEntity().getShooter();
        if (!this.plugin.getPlayerManager().isCuffed(player)) {
            return;
        }
        projectileLaunchEvent.setCancelled(true);
        CMITitleMessage.send((Player)player, (Object)CMILC.getIM(cuff.class, "cuffedInfo", new Object[0]), null);
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onHit(EntityDamageByEntityEvent entityDamageByEntityEvent) {
        if (!(entityDamageByEntityEvent.getDamager() instanceof Player)) {
            return;
        }
        Player player = (Player)entityDamageByEntityEvent.getDamager();
        if (!this.plugin.getPlayerManager().isCuffed(player)) {
            return;
        }
        if (util.imortaldebug) {
            CMIMessages.consoleMessage((String)"onHit->EntityDamageByEntityEvent");
        }
        entityDamageByEntityEvent.setCancelled(true);
        CMITitleMessage.send((Player)player, (Object)CMILC.getIM(cuff.class, "cuffedInfo", new Object[0]), null);
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onPlayerDamage(EntityDamageEvent entityDamageEvent) {
        if (!(entityDamageEvent.getEntity() instanceof Player)) {
            return;
        }
        Player player = (Player)entityDamageEvent.getEntity();
        if (!this.plugin.getPlayerManager().isCuffed(player)) {
            return;
        }
        if (EntityDamageEvent.DamageCause.STARVATION.equals((Object)entityDamageEvent.getCause())) {
            player.setFoodLevel(20);
        }
        if (util.imortaldebug) {
            CMIMessages.consoleMessage((String)"Cuffed onPlayerDamage->EntityDamageEvent");
        }
        entityDamageEvent.setCancelled(true);
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onPlayerMove(PlayerMoveEvent playerMoveEvent) {
        Player player = playerMoveEvent.getPlayer();
        if (!this.plugin.getPlayerManager().isCuffed(player)) {
            return;
        }
        Location location = playerMoveEvent.getFrom();
        Location location2 = playerMoveEvent.getTo();
        if (playerMoveEvent.getTo() == null) {
            return;
        }
        if (location.getBlockY() < location2.getBlockY() && player.isFlying()) {
            playerMoveEvent.setCancelled(true);
        }
        if (location.getWorld() != location2.getWorld() || location.getBlockX() != location2.getBlockX() || location.getBlockZ() != location2.getBlockZ()) {
            CMITitleMessage.send((Player)player, (Object)CMILC.getIM(cuff.class, "cuffedInfo", new Object[0]), null);
            playerMoveEvent.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onPlayerMove(PlayerCommandPreprocessEvent playerCommandPreprocessEvent) {
        Player player = playerCommandPreprocessEvent.getPlayer();
        if (!this.plugin.getPlayerManager().isCuffed(player)) {
            return;
        }
        if (PermissionsManager.CMIPerm.command_cuff_bypass.hasPermission((CommandSender)player)) {
            return;
        }
        String string = playerCommandPreprocessEvent.getMessage();
        String string2 = string.startsWith("/") ? string.substring(1) : string;
        String string3 = string2.toLowerCase();
        boolean bl = false;
        for (String string4 : this.plugin.getConfigManager().CuffAllowed) {
            if (!string3.equalsIgnoreCase(string4.toLowerCase()) && !string3.startsWith(String.valueOf(string4.toLowerCase()) + " ")) continue;
            bl = true;
        }
        if (!bl) {
            playerCommandPreprocessEvent.setCancelled(true);
            playerCommandPreprocessEvent.setMessage("/");
            player.sendMessage(CMILC.getIM(cuff.class, "noCommand", new Object[0]));
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPlayerLogin(PlayerJoinEvent playerJoinEvent) {
        Player player = playerJoinEvent.getPlayer();
        CMIUser cMIUser = this.plugin.getPlayerManager().getUser(player);
        if (cMIUser == null) {
            return;
        }
        if (cMIUser.isCuffed()) {
            this.plugin.getPlayerManager().addCuffed(player.getUniqueId());
        }
    }
}

