/*
 * Decompiled with CFR 0.152.
 */
package com.Zrips.CMI.AllListeners;

import com.Zrips.CMI.CMI;
import com.Zrips.CMI.Containers.CMIUser;
import com.Zrips.CMI.Modules.Permissions.PermissionsManager;
import net.Zrips.CMILib.Entities.CMIEntityType;
import net.Zrips.CMILib.Version.Version;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Minecart;
import org.bukkit.entity.Player;
import org.bukkit.entity.Vehicle;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerInteractAtEntityEvent;
import org.bukkit.event.vehicle.VehicleDestroyEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;

public class PlayerListeners1_8
implements Listener {
    private CMI plugin;

    public PlayerListeners1_8(CMI cMI) {
        this.plugin = cMI;
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void PlayerInteractMinecart(PlayerInteractAtEntityEvent playerInteractAtEntityEvent) {
        if (playerInteractAtEntityEvent.isCancelled()) {
            return;
        }
        Entity entity = playerInteractAtEntityEvent.getRightClicked();
        if (entity == null) {
            return;
        }
        try {
            if (Version.isCurrentHigher((Version)Version.v1_8_R3) && playerInteractAtEntityEvent.getHand() != EquipmentSlot.HAND) {
                return;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!entity.getType().equals((Object)EntityType.MINECART)) {
            return;
        }
        Player player = playerInteractAtEntityEvent.getPlayer();
        if (!player.isSneaking()) {
            return;
        }
        CMIUser cMIUser = this.plugin.getPlayerManager().getUser(player);
        if (cMIUser == null) {
            return;
        }
        ItemStack itemStack = cMIUser.getItemInHand();
        if (itemStack == null || itemStack.getType().equals((Object)Material.AIR)) {
            return;
        }
        Minecart minecart = (Minecart)entity;
        try {
            if (minecart.getPassenger() != null) {
                return;
            }
        }
        catch (Exception | NoSuchMethodError throwable) {
            throwable.printStackTrace();
            return;
        }
        Location location = minecart.getLocation();
        Entity entity2 = null;
        switch (itemStack.getType()) {
            case CHEST: 
            case FURNACE: 
            case HOPPER: 
            case TNT: {
                if (PermissionsManager.CMIPerm.minecart_change_$1.hasPermission((CommandSender)player, true, itemStack.getType().name().toLowerCase())) break;
                return;
            }
        }
        VehicleDestroyEvent vehicleDestroyEvent = new VehicleDestroyEvent((Vehicle)minecart, (Entity)player);
        Bukkit.getPluginManager().callEvent((Event)vehicleDestroyEvent);
        if (vehicleDestroyEvent.isCancelled()) {
            return;
        }
        switch (itemStack.getType()) {
            case CHEST: {
                minecart.remove();
                cMIUser.getInventory().removeItemFromMainHand(new ItemStack(Material.CHEST));
                entity2 = location.getWorld().spawnEntity(location.clone(), CMIEntityType.CHEST_MINECART.getType());
                break;
            }
            case FURNACE: {
                minecart.remove();
                cMIUser.getInventory().removeItemFromMainHand(new ItemStack(Material.FURNACE));
                entity2 = location.getWorld().spawnEntity(location.clone(), CMIEntityType.FURNACE_MINECART.getType());
                break;
            }
            case TNT: {
                minecart.remove();
                cMIUser.getInventory().removeItemFromMainHand(new ItemStack(Material.TNT));
                entity2 = location.getWorld().spawnEntity(location.clone(), CMIEntityType.TNT_MINECART.getType());
                break;
            }
            case HOPPER: {
                minecart.remove();
                cMIUser.getInventory().removeItemFromMainHand(new ItemStack(Material.HOPPER));
                entity2 = location.getWorld().spawnEntity(location.clone(), CMIEntityType.HOPPER_MINECART.getType());
            }
        }
        if (entity2 == null) {
            return;
        }
        entity2.teleport(location);
        entity2.setCustomName(minecart.getCustomName());
        entity2.setCustomNameVisible(minecart.isCustomNameVisible());
        try {
            entity2.setGlowing(minecart.isGlowing());
        }
        catch (Exception | NoSuchMethodError throwable) {
            // empty catch block
        }
        try {
            entity2.setGravity(minecart.hasGravity());
        }
        catch (Exception | NoSuchMethodError throwable) {
            // empty catch block
        }
        entity2.setVelocity(minecart.getVelocity());
        entity2.setTicksLived(minecart.getTicksLived());
        entity2.setFireTicks(minecart.getFireTicks());
    }
}

