/*
 * Decompiled with CFR 0.152.
 */
package com.Zrips.CMI.AllListeners;

import com.Zrips.CMI.CMI;
import com.Zrips.CMI.Config;
import com.Zrips.CMI.Containers.CMIBanEntry;
import com.Zrips.CMI.Containers.CMIColorTypes;
import com.Zrips.CMI.Containers.CMIEvent;
import com.Zrips.CMI.Containers.CMITextCleaner;
import com.Zrips.CMI.Containers.CMIUser;
import com.Zrips.CMI.Containers.SleepStats;
import com.Zrips.CMI.Containers.Snd;
import com.Zrips.CMI.Locale.CMILC;
import com.Zrips.CMI.Modules.Permissions.PermissionsManager;
import com.Zrips.CMI.Modules.Teleportations.CMITeleportFeedback;
import com.Zrips.CMI.PlayerManager;
import com.Zrips.CMI.commands.list.donate;
import com.Zrips.CMI.commands.list.hat;
import com.Zrips.CMI.commands.list.maintenance;
import com.Zrips.CMI.commands.list.sc;
import com.Zrips.CMI.commands.list.util;
import com.Zrips.CMI.events.CMIArmorChangeEvent;
import com.Zrips.CMI.utils.DateFormat;
import com.Zrips.CMI.utils.SpawnUtil;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import net.Zrips.CMILib.BossBar.BossBarInfo;
import net.Zrips.CMILib.Colors.CMIChatColor;
import net.Zrips.CMILib.Container.CMILocation;
import net.Zrips.CMILib.Entities.CMIEntityType;
import net.Zrips.CMILib.Items.ArmorTypes;
import net.Zrips.CMILib.Items.CMIMaterial;
import net.Zrips.CMILib.Locale.LC;
import net.Zrips.CMILib.Messages.CMIMessages;
import net.Zrips.CMILib.NBT.CMINBT;
import net.Zrips.CMILib.Version.Schedulers.CMIScheduler;
import net.Zrips.CMILib.Version.Version;
import org.bukkit.BanEntry;
import org.bukkit.BanList;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Beehive;
import org.bukkit.block.Block;
import org.bukkit.block.Sign;
import org.bukkit.block.Skull;
import org.bukkit.block.sign.Side;
import org.bukkit.boss.BarColor;
import org.bukkit.boss.BarStyle;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Animals;
import org.bukkit.entity.Boat;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.ExperienceOrb;
import org.bukkit.entity.Golem;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Monster;
import org.bukkit.entity.Player;
import org.bukkit.entity.Villager;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.block.SignChangeEvent;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.entity.EntityPortalEnterEvent;
import org.bukkit.event.entity.FoodLevelChangeEvent;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.entity.PotionSplashEvent;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerEditBookEvent;
import org.bukkit.event.player.PlayerFishEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerLoginEvent;
import org.bukkit.event.player.PlayerPickupItemEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.event.player.PlayerToggleSprintEvent;
import org.bukkit.event.server.ServerCommandEvent;
import org.bukkit.event.vehicle.VehicleEnterEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BookMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.util.Vector;

public class PlayerListeners
implements Listener {
    private CMI plugin;
    HashMap<UUID, HungerCache> hungerMap = new HashMap();
    public static HashMap<UUID, String[]> scMap = new HashMap();

    public PlayerListeners(CMI cMI) {
        this.plugin = cMI;
    }

    private static boolean isMonster(Entity entity) {
        return entity instanceof Monster;
    }

    private static boolean isAnimal(Entity entity) {
        return entity instanceof Animals;
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void PlayerPickupItemEvent(PlayerPickupItemEvent playerPickupItemEvent) {
        if (!playerPickupItemEvent.getItem().hasMetadata("CMIShoot")) {
            return;
        }
        List list2 = playerPickupItemEvent.getItem().getMetadata("CMIShoot");
        if (list2 == null || list2.isEmpty()) {
            return;
        }
        playerPickupItemEvent.setCancelled(true);
        playerPickupItemEvent.getItem().remove();
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void onRespawn(PlayerRespawnEvent playerRespawnEvent) {
        if (this.plugin.getHomeManager().getRespawnImmortality() > 0 && this.plugin.getHomeManager().getRespawnImmortality() <= 60) {
            CMIScheduler.runTaskLater((JavaPlugin)this.plugin, () -> {
                if (playerRespawnEvent.getPlayer().isOnline()) {
                    playerRespawnEvent.getPlayer().setNoDamageTicks(this.plugin.getHomeManager().getRespawnImmortality() * 20);
                }
            }, (long)20L);
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onRespawnSetLocation(PlayerRespawnEvent playerRespawnEvent) {
        Location location = this.plugin.getHomeManager().getReSpawnLocation(playerRespawnEvent.getPlayer(), playerRespawnEvent.getRespawnLocation());
        if (location == null || location.getWorld() == null) {
            return;
        }
        playerRespawnEvent.setRespawnLocation(location);
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void PlayerDeathEvent(PlayerDeathEvent playerDeathEvent) {
        Player player = playerDeathEvent.getEntity();
        if (PermissionsManager.CMIPerm.keepinventory.hasSetPermission((CommandSender)player, new String[0])) {
            playerDeathEvent.setKeepInventory(true);
            if (Version.isCurrentEqualOrHigher((Version)Version.v1_14_R1)) {
                playerDeathEvent.getDrops().clear();
            }
        }
        if (PermissionsManager.CMIPerm.keepexp.hasSetPermission((CommandSender)player, new String[0])) {
            playerDeathEvent.setKeepLevel(true);
            playerDeathEvent.setDroppedExp(0);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void PlayerDeathEventHunger(PlayerDeathEvent playerDeathEvent) {
        Player player = playerDeathEvent.getEntity();
        this.hungerMap.put(player.getUniqueId(), new HungerCache(player.getFoodLevel(), player.getSaturation()));
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void PlayerRespawnEventHunger(PlayerRespawnEvent playerRespawnEvent) {
        Player player = playerRespawnEvent.getPlayer();
        HungerCache hungerCache = this.hungerMap.remove(player.getUniqueId());
        if (hungerCache == null) {
            return;
        }
        if (!PermissionsManager.CMIPerm.hunger_keepafterdeath.hasSetPermission((CommandSender)player, new String[0])) {
            return;
        }
        CMIScheduler.runTaskLater((JavaPlugin)this.plugin, () -> {
            if (!player.isOnline()) {
                return;
            }
            player.setFoodLevel(hungerCache.getHunger());
            player.setSaturation(hungerCache.getSaturation());
        }, (long)5L);
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void onFishingRodUse(PlayerFishEvent playerFishEvent) {
        Player player = playerFishEvent.getPlayer();
        if (!this.plugin.getConfigManager().isPreventHook()) {
            return;
        }
        if (playerFishEvent.getCaught() == null) {
            return;
        }
        if (!(playerFishEvent.getCaught() instanceof LivingEntity)) {
            return;
        }
        playerFishEvent.setCancelled(true);
        int n = player.getInventory().getHeldItemSlot();
        int n2 = n >= 8 ? 0 : n + 1;
        player.getInventory().setHeldItemSlot(n2);
        CMIScheduler.runTaskLater((JavaPlugin)this.plugin, () -> player.getInventory().setHeldItemSlot(n), (long)1L);
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void VehicleEnterEvent(VehicleEnterEvent vehicleEnterEvent) {
        if (!(vehicleEnterEvent.getVehicle() instanceof Boat)) {
            return;
        }
        if (this.plugin.getConfigManager().isPreventEntityBoatEnterMonsters() && PlayerListeners.isMonster(vehicleEnterEvent.getEntered())) {
            vehicleEnterEvent.setCancelled(true);
        }
        if (this.plugin.getConfigManager().isPreventEntityBoatEnterAnimals() && PlayerListeners.isAnimal(vehicleEnterEvent.getEntered())) {
            vehicleEnterEvent.setCancelled(true);
        }
        if (this.plugin.getConfigManager().isPreventEntityBoatEnterVillagers() && vehicleEnterEvent.getEntered() instanceof Villager) {
            vehicleEnterEvent.setCancelled(true);
        }
    }

    @EventHandler
    public void onInteract(PlayerInteractEvent playerInteractEvent) {
        if (playerInteractEvent.getAction() != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        Block block = playerInteractEvent.getClickedBlock();
        try {
            if (!CMIMaterial.isBed((Material)block.getType())) {
                return;
            }
        }
        catch (Exception exception) {
            return;
        }
        World.Environment environment = block.getLocation().getWorld().getEnvironment();
        if (environment == World.Environment.NORMAL) {
            return;
        }
        if (!this.plugin.getConfigManager().isPreventBedExplosionNether() && block.getLocation().getWorld().getEnvironment() == World.Environment.NETHER) {
            return;
        }
        if (!this.plugin.getConfigManager().isPreventBedExplosionTheEnd() && block.getLocation().getWorld().getEnvironment() == World.Environment.THE_END) {
            return;
        }
        playerInteractEvent.setCancelled(true);
    }

    @EventHandler
    public void onInteractHead(PlayerInteractEvent playerInteractEvent) {
        Object object;
        CMIUser cMIUser;
        String string;
        block22: {
            Object object2;
            String string2;
            block21: {
                CMIMaterial cMIMaterial;
                if (playerInteractEvent.getAction() != Action.RIGHT_CLICK_BLOCK) {
                    return;
                }
                if (!Config.ShowSkullOwner) {
                    return;
                }
                try {
                    if (Version.isCurrentHigher((Version)Version.v1_8_R3) && playerInteractEvent.getHand() != EquipmentSlot.HAND) {
                        return;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                Block block = playerInteractEvent.getClickedBlock();
                try {
                    cMIMaterial = CMIMaterial.get((Block)block);
                    if (!cMIMaterial.isPlayerHead()) {
                        return;
                    }
                }
                catch (Throwable throwable) {
                    return;
                }
                cMIMaterial = (Skull)block.getState();
                string = cMIMaterial.getOwner();
                string2 = null;
                if (Version.isCurrentEqualOrHigher((Version)Version.v1_9_R1) && (string == null || string.isEmpty())) {
                    try {
                        cMIUser = new CMINBT(block);
                        object = cMIUser.getList("SkullOwner.Properties.textures");
                        if (object == null) break block21;
                        string2 = ((String)object.get(0)).split("Value:\"", 2)[1].split("\"", 2)[0];
                        object2 = null;
                        try {
                            byte[] byArray = Base64.getDecoder().decode(string2);
                            object2 = new String(byArray);
                        }
                        catch (Throwable throwable) {
                            byte[] byArray = Base64.getMimeDecoder().decode(string2);
                            object2 = new String(byArray);
                        }
                        if (((String)object2).contains("profileName\" : \"")) {
                            string = ((String)object2).split("profileName\" : \"", 2)[1].split("\"", 2)[0];
                        }
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            }
            cMIUser = this.plugin.getPlayerManager().getUser(string);
            if ((string == null || string.isEmpty()) && string2 != null) {
                try {
                    object = CMIEntityType.getByTexture(string2);
                    if (object == null) break block22;
                    object2 = null;
                    try {
                        object2 = object.getHeadInfo(string2);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    string = object2 != null && object2.getCustomName() != null ? object2.getCustomName() : object.getName();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
        if (string == null) {
            string = LC.info_unknown.getLocale(new Object[0]);
        }
        object = new Snd();
        ((Snd)object).setTarget(cMIUser);
        if (cMIUser == null) {
            ((Snd)object).setTargetName(string);
        }
        CMILC.sendMessage(playerInteractEvent.getPlayer(), LC.info_skullOwner.getLocale(new Object[]{object}));
    }

    @EventHandler
    public void onInteractBeeHive(PlayerInteractEvent playerInteractEvent) {
        int n;
        if (playerInteractEvent.getAction() != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        if (Version.isCurrentLower((Version)Version.v1_15_R1)) {
            return;
        }
        if (!Config.ShowBeeHive) {
            return;
        }
        try {
            if (Version.isCurrentHigher((Version)Version.v1_8_R3) && playerInteractEvent.getHand() != EquipmentSlot.HAND) {
                return;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        Block block = playerInteractEvent.getClickedBlock();
        try {
            CMIMaterial cMIMaterial = CMIMaterial.get((Block)block);
            if (cMIMaterial != CMIMaterial.BEE_NEST && cMIMaterial != CMIMaterial.BEEHIVE) {
                return;
            }
        }
        catch (Throwable throwable) {
            return;
        }
        int n2 = 5;
        int n3 = 3;
        if (Version.isCurrentEqualOrHigher((Version)Version.v1_16_R1) && block.getState() instanceof Beehive) {
            Beehive beehive = (Beehive)block.getState();
            n3 = beehive.getMaxEntities();
        }
        if ((n = this.plugin.getReflectionManager().getHoneyLevel(block)) < 0) {
            return;
        }
        CMILC.info_beeinfo.sendMessage(playerInteractEvent.getPlayer(), "[level]", n, "[maxlevel]", n2, "[maxcount]", n3, "[count]", this.plugin.getReflectionManager().getBeesInside(block));
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void armorChangeEvent(CMIArmorChangeEvent cMIArmorChangeEvent) {
        if (cMIArmorChangeEvent.getNewArmorPiece() == null || CMIMaterial.isAir((Material)cMIArmorChangeEvent.getNewArmorPiece().getType())) {
            return;
        }
        if (!cMIArmorChangeEvent.getType().equals((Object)ArmorTypes.HELMET)) {
            return;
        }
        ItemStack itemStack = cMIArmorChangeEvent.getNewArmorPiece();
        Boolean bl = hat.checkHatItem(cMIArmorChangeEvent.getPlayer(), itemStack);
        if (bl != null && !bl.booleanValue()) {
            cMIArmorChangeEvent.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void hatPlacement(InventoryClickEvent inventoryClickEvent) {
        if (inventoryClickEvent.isCancelled()) {
            return;
        }
        InventoryView inventoryView = inventoryClickEvent.getWhoClicked().getOpenInventory();
        if (inventoryView == null) {
            return;
        }
        Inventory inventory = inventoryView.getTopInventory();
        if (inventory == null) {
            return;
        }
        if (inventoryView.getType() != InventoryType.CRAFTING) {
            return;
        }
        if (inventoryClickEvent.getSlot() != 39) {
            return;
        }
        Player player = (Player)inventoryClickEvent.getWhoClicked();
        CMIMaterial cMIMaterial = CMIMaterial.get((Material)inventoryClickEvent.getCursor().getType());
        if (cMIMaterial.isHelmet()) {
            return;
        }
        if (!PermissionsManager.CMIPerm.inventoryhat.hasPermission((CommandSender)player)) {
            if (inventoryClickEvent.getCursor() == null || CMIMaterial.isAir((Material)inventoryClickEvent.getCursor().getType())) {
                return;
            }
            if (!hat.isHelmet(inventoryClickEvent.getCursor())) {
                inventoryClickEvent.setCancelled(true);
            }
            return;
        }
        if (inventoryClickEvent.getClick() != ClickType.LEFT) {
            return;
        }
        if (inventoryClickEvent.isShiftClick()) {
            return;
        }
        ItemStack itemStack = player.getInventory().getHelmet();
        ItemStack itemStack2 = player.getItemOnCursor();
        CMIArmorChangeEvent cMIArmorChangeEvent = new CMIArmorChangeEvent(player, CMIArmorChangeEvent.EquipMethod.SHIFT_CLICK, ArmorTypes.HELMET, itemStack, itemStack2);
        Bukkit.getServer().getPluginManager().callEvent((Event)cMIArmorChangeEvent);
        if (!cMIArmorChangeEvent.isCancelled()) {
            player.getInventory().setHelmet(itemStack2);
            player.setItemOnCursor(itemStack);
        }
        inventoryClickEvent.setCancelled(true);
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void PlayerEditBookEvent(PlayerEditBookEvent playerEditBookEvent) {
        ArrayList<String> arrayList;
        if (playerEditBookEvent.isCancelled()) {
            return;
        }
        BookMeta bookMeta = playerEditBookEvent.getNewBookMeta();
        if (Config.BooksAddDate && bookMeta.getAuthor() != null) {
            arrayList = bookMeta.getLore();
            if (arrayList == null) {
                arrayList = new ArrayList<String>();
            }
            arrayList.add(CMILC.info_bookDate.getLocale("[date]", DateFormat.MiliToDate(System.currentTimeMillis())));
            bookMeta.setLore(arrayList);
        }
        if (Version.isCurrentLower((Version)Version.v1_15_R1) || Version.isCurrentEqualOrHigher((Version)Version.v1_16_R1)) {
            arrayList = playerEditBookEvent.getPlayer();
            int n = 0;
            while (n < bookMeta.getPages().size()) {
                String string = bookMeta.getPage(n + 1);
                string = string.replace("\u00a70\n", "\n");
                string = CMITextCleaner.cleanFromColorCodes(arrayList, string, CMIColorTypes.books, true);
                string = string.replace("\uff06", "&");
                bookMeta.setPage(n + 1, string);
                ++n;
            }
        }
        playerEditBookEvent.setNewBookMeta(bookMeta);
    }

    @EventHandler(priority=EventPriority.LOW)
    public void EntityDeathEvent(EntityDeathEvent entityDeathEvent) {
        try {
            if (!this.plugin.getConfigManager().isPreventIronGolemRoses()) {
                return;
            }
            if (!(entityDeathEvent.getEntity() instanceof Golem)) {
                return;
            }
            ArrayList arrayList = new ArrayList(entityDeathEvent.getDrops());
            for (ItemStack itemStack : arrayList) {
                if (!CMIMaterial.POPPY.equals(itemStack.getType()) && !CMIMaterial.ROSE_RED.equals(itemStack.getType())) continue;
                entityDeathEvent.getDrops().remove(itemStack);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void onCommand(ServerCommandEvent serverCommandEvent) {
        if (!this.plugin.getConfigManager().isMulticraftDisableList()) {
            return;
        }
        if (!serverCommandEvent.getCommand().equalsIgnoreCase("list") && !serverCommandEvent.getCommand().equalsIgnoreCase("cmi list")) {
            return;
        }
        try {
            serverCommandEvent.setCancelled(true);
        }
        catch (NoSuchMethodError noSuchMethodError) {
            // empty catch block
        }
        System.out.print(" ");
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void EntityPortalEnterEvent(EntityPortalEnterEvent entityPortalEnterEvent) {
        if (entityPortalEnterEvent.getEntityType() != EntityType.EXPERIENCE_ORB) {
            return;
        }
        if (!this.plugin.getConfigManager().isPreventExpPortals()) {
            return;
        }
        ExperienceOrb experienceOrb = (ExperienceOrb)entityPortalEnterEvent.getEntity();
        experienceOrb.setExperience(0);
    }

    @EventHandler(priority=EventPriority.LOW)
    public void onTeleport(PlayerTeleportEvent playerTeleportEvent) {
        Player player = playerTeleportEvent.getPlayer();
        if (!playerTeleportEvent.getCause().name().equalsIgnoreCase("CHORUS_FRUIT")) {
            return;
        }
        if (PermissionsManager.CMIPerm.chorusteleport.hasPermission((CommandSender)player)) {
            return;
        }
        playerTeleportEvent.setCancelled(true);
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void onPlayerLoginLimit(PlayerLoginEvent playerLoginEvent) {
        int n = Bukkit.getMaxPlayers();
        int n2 = this.plugin.getUtilManager().getOnlinePlayerCount();
        if (playerLoginEvent.getResult().equals((Object)PlayerLoginEvent.Result.KICK_FULL) && n2 >= n && PermissionsManager.CMIPerm.fullserver_bypass.hasPermission((CommandSender)playerLoginEvent.getPlayer())) {
            playerLoginEvent.allow();
            try {
                playerLoginEvent.setResult(PlayerLoginEvent.Result.ALLOWED);
            }
            catch (Error | Exception throwable) {
                // empty catch block
            }
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onPlayerLoginFakeUser(PlayerLoginEvent playerLoginEvent) {
        if (playerLoginEvent.getPlayer().getName().equalsIgnoreCase(this.plugin.getPlayerManager().getFakeUserName()) || playerLoginEvent.getPlayer().getName().equalsIgnoreCase(this.plugin.getPlayerManager().getFakeUserName().replace("-", "")) || playerLoginEvent.getPlayer().getUniqueId().equals(this.plugin.getPlayerManager().getFakeUserUUID()) || playerLoginEvent.getPlayer().getUniqueId().equals(PlayerManager.oldFakeUserUUID)) {
            playerLoginEvent.disallow(PlayerLoginEvent.Result.KICK_OTHER, "Sneaky one, change NickName or suffer my wrath!");
            return;
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onPlayerLogin(PlayerLoginEvent playerLoginEvent) {
        String string;
        if (this.plugin.getConfigManager().isMaintenance()) {
            if (!PermissionsManager.CMIPerm.command_maintenance_bypass.hasPermission((CommandSender)playerLoginEvent.getPlayer())) {
                string = this.plugin.getConfigManager().getMaintenanceMessage() == null ? CMILC.getIM(maintenance.class, "feedback", new Object[0]) : this.plugin.getConfigManager().getMaintenanceMessage();
                string = this.plugin.getPlaceholderAPIManager().updatePlaceHolders(playerLoginEvent.getPlayer(), string);
                playerLoginEvent.disallow(PlayerLoginEvent.Result.KICK_OTHER, CMIChatColor.translate((String)string));
            } else {
                CMIScheduler.runTaskLater((JavaPlugin)this.plugin, () -> {
                    if (!playerLoginEvent.getPlayer().isOnline()) {
                        return;
                    }
                    if (!Config.maintenanceBossbar.booleanValue()) {
                        return;
                    }
                    String string = this.plugin.getConfigManager().getMaintenanceMessage() == null ? CMILC.info_maintenance.getLocale(new Object[0]) : this.plugin.getConfigManager().getMaintenanceMessage();
                    string = this.plugin.getPlaceholderAPIManager().updatePlaceHolders(playerLoginEvent.getPlayer(), string);
                    if (!Version.isCurrentEqualOrHigher((Version)Version.v1_9_R1)) {
                        return;
                    }
                    try {
                        CMIUser cMIUser = this.plugin.getPlayerManager().getUser(playerLoginEvent.getPlayer());
                        BossBarInfo bossBarInfo = cMIUser.getBossBar("CMIMaintenance");
                        if (bossBarInfo == null) {
                            bossBarInfo = new BossBarInfo(cMIUser.getPlayer(), "CMIMaintenance");
                        }
                        bossBarInfo.setKeepForTicks(Integer.valueOf(-1));
                        bossBarInfo.setColor(BarColor.BLUE);
                        bossBarInfo.setTitleOfBar(string);
                        bossBarInfo.setStyle(BarStyle.SOLID);
                        cMIUser.addBossBar(bossBarInfo);
                    }
                    catch (Error | Exception throwable) {
                        // empty catch block
                    }
                }, (long)40L);
            }
        }
        if (playerLoginEvent.getResult() == PlayerLoginEvent.Result.KICK_BANNED && this.plugin.getConfigManager().isOverrideLoginMessage()) {
            string = Bukkit.getBanList((BanList.Type)BanList.Type.IP).getBanEntry(playerLoginEvent.getAddress().getHostAddress());
            if (string != null) {
                playerLoginEvent.setKickMessage(CMIBanEntry.getIpBanMessage((BanEntry)string));
            } else {
                string = Bukkit.getBanList((BanList.Type)BanList.Type.NAME).getBanEntry(playerLoginEvent.getPlayer().getName());
                if (string != null) {
                    playerLoginEvent.setKickMessage(CMIBanEntry.getBanMessage((BanEntry)string));
                }
            }
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onPlayerFirstJoin(PlayerJoinEvent playerJoinEvent) {
        Player player = playerJoinEvent.getPlayer();
        if (player.hasPlayedBefore()) {
            return;
        }
        if (this.plugin.getConfigManager().getFirstSpawnPoint() == null) {
            return;
        }
        if (this.plugin.getUtilManager().isNPC(player)) {
            return;
        }
        this.plugin.getTeleportHandler().teleportPlayer(player, this.plugin.getConfigManager().getFirstSpawnPoint());
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onJoinInSpawn(PlayerJoinEvent playerJoinEvent) {
        Player player = playerJoinEvent.getPlayer();
        if (!player.hasPlayedBefore()) {
            return;
        }
        if (!SpawnUtil.isSpawnSpawnOnJoin()) {
            return;
        }
        if (this.plugin.getUtilManager().isNPC(player)) {
            return;
        }
        if (PermissionsManager.CMIPerm.spawnonjoin_bypass.hasSetPermission((CommandSender)player, new String[0])) {
            return;
        }
        if (SpawnUtil.isIgnoresSpawnWorld(player.getWorld().getName())) {
            return;
        }
        CMILocation cMILocation = SpawnUtil.getSpawnPoint(player);
        if (cMILocation == null) {
            return;
        }
        this.plugin.getTeleportHandler().teleportPlayer(player, (Location)cMILocation);
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void PlayerQuitEvent(PlayerQuitEvent playerQuitEvent) {
        CMIScheduler.runTask((JavaPlugin)this.plugin, () -> {
            Player player = playerQuitEvent.getPlayer();
            SleepStats.informMap.remove(player.getUniqueId());
            CMIUser cMIUser = this.plugin.getPlayerManager().getUser(player);
            if (cMIUser == null) {
                return;
            }
            if (cMIUser.getTfly() == -1L && cMIUser.getFlightCharge().getSafeCharge() == 0.0) {
                cMIUser.setFlying(false);
                cMIUser.setAllowFlight(false);
            } else if (cMIUser.getTfly() > System.currentTimeMillis()) {
                cMIUser.setFlying(true);
            }
            cMIUser.setWasFlying(player.isFlying());
            cMIUser.setHadAllowFlight(player.getAllowFlight());
            cMIUser.cacheClear();
        });
    }

    @EventHandler(priority=EventPriority.LOW)
    public void PlayerQuitEventPermissioCache(PlayerQuitEvent playerQuitEvent) {
        CMIScheduler.runTask((JavaPlugin)this.plugin, () -> {
            Player player = playerQuitEvent.getPlayer();
            this.plugin.getPermissionsManager().removeFromCache(player);
            if (player.getVehicle() != null && player.getVehicle().getType().equals((Object)EntityType.PLAYER)) {
                player.leaveVehicle();
            }
        });
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void onPlayerJoinSafe(PlayerJoinEvent playerJoinEvent) {
        boolean bl;
        Player player = playerJoinEvent.getPlayer();
        CMIUser cMIUser = this.plugin.getPlayerManager().getUser(player);
        if (cMIUser == null) {
            return;
        }
        try {
            if (this.plugin.getPlayerManager().getFakeOperatorRaw() != null) {
                playerJoinEvent.getPlayer().hidePlayer((Plugin)this.plugin, this.plugin.getPlayerManager().getFakeOperatorRaw());
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (Config.ImmortalityOnJoin > 0 && Config.ImmortalityOnJoin <= 60) {
            player.setNoDamageTicks(Config.ImmortalityOnJoin * 20);
        }
        if ((bl = PermissionsManager.CMIPerm.command_$1.hasPermission((CommandSender)player, "fly")) && cMIUser.hadAllowFlight() || cMIUser.wasFlying() && cMIUser.hadAllowFlight()) {
            player.setAllowFlight(true);
        }
        if (!PermissionsManager.CMIPerm.command_fly_safelogin.hasPermission((CommandSender)player)) {
            return;
        }
        if (cMIUser.wasFlying() && (bl || cMIUser.getTfly() > System.currentTimeMillis()) || !player.isOnGround() && bl) {
            CompletableFuture<CMITeleportFeedback> completableFuture = this.plugin.getTeleportHandler().getSafeLocation(player, player.getLocation(), 0, 6, false);
            completableFuture.thenAccept(cMITeleportFeedback -> {
                if (!player.isOnline()) {
                    return;
                }
                if (cMITeleportFeedback.getLocation().distance(player.getLocation()) < 4.0) {
                    return;
                }
                if (player.isOnGround()) {
                    return;
                }
                if (player.getVehicle() != null) {
                    return;
                }
                player.setVelocity(new Vector());
                player.setAllowFlight(true);
                player.setFlying(true);
            });
            return;
        }
    }

    @EventHandler
    public void onSignInteract(PlayerInteractEvent playerInteractEvent) {
        if (playerInteractEvent.isCancelled()) {
            return;
        }
        if (scMap.isEmpty()) {
            return;
        }
        if (playerInteractEvent.getAction().equals((Object)Action.PHYSICAL)) {
            return;
        }
        Player player = playerInteractEvent.getPlayer();
        if (!scMap.containsKey(player.getUniqueId())) {
            return;
        }
        playerInteractEvent.setCancelled(true);
        String[] stringArray = scMap.get(player.getUniqueId());
        if (player.isSneaking()) {
            return;
        }
        Block block = playerInteractEvent.getClickedBlock();
        if (!(block.getState() instanceof Sign)) {
            scMap.remove(player.getUniqueId());
            CMILC.info(sc.class, (CommandSender)player, "canceled", new Object[0]);
            return;
        }
        Sign sign = (Sign)block.getState();
        BlockPlaceEvent blockPlaceEvent = CMIEvent.placeSignEvent(block, sign, player);
        Bukkit.getServer().getPluginManager().callEvent((Event)blockPlaceEvent);
        if (!blockPlaceEvent.isCancelled()) {
            if (Version.isCurrentEqualOrHigher((Version)Version.v1_20_R1)) {
                String[] stringArray2 = new String[4];
                int n = 0;
                while (n < 4) {
                    stringArray2[n] = stringArray[n];
                    ++n;
                }
                SignChangeEvent signChangeEvent = new SignChangeEvent(block, player, (String[])stringArray2.clone(), Side.FRONT);
                Bukkit.getServer().getPluginManager().callEvent((Event)signChangeEvent);
                if (signChangeEvent.isCancelled()) {
                    return;
                }
                int n2 = 0;
                while (n2 < 4) {
                    sign.getSide(Side.FRONT).setLine(n2, stringArray2[n2]);
                    ++n2;
                }
                n2 = 0;
                while (n2 < 4) {
                    stringArray2[n2] = stringArray[n2 + 4];
                    ++n2;
                }
                n2 = 0;
                while (n2 < 4) {
                    sign.getSide(Side.BACK).setLine(n2, stringArray2[n2]);
                    ++n2;
                }
            } else {
                SignChangeEvent signChangeEvent = new SignChangeEvent(block, player, (String[])stringArray.clone());
                Bukkit.getServer().getPluginManager().callEvent((Event)signChangeEvent);
                if (signChangeEvent.isCancelled()) {
                    return;
                }
                stringArray = signChangeEvent.getLines();
                int n = 0;
                while (n < 4) {
                    sign.setLine(n, stringArray[n]);
                    ++n;
                }
            }
            sign.update();
            CMILC.info(sc.class, (CommandSender)player, "updated", new Object[0]);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onChatIgnore(AsyncPlayerChatEvent asyncPlayerChatEvent) {
        if (asyncPlayerChatEvent.isCancelled()) {
            return;
        }
        if (!this.plugin.getChatManager().isChatIgnorePublicMessage()) {
            return;
        }
        ArrayList<Player> arrayList = new ArrayList<Player>();
        UUID uUID = asyncPlayerChatEvent.getPlayer().getUniqueId();
        if (PermissionsManager.CMIPerm.command_ignore_bypass.hasPermission((CommandSender)asyncPlayerChatEvent.getPlayer())) {
            return;
        }
        for (Player player : asyncPlayerChatEvent.getRecipients()) {
            CMIUser cMIUser;
            if (uUID.equals(player.getUniqueId()) || (cMIUser = this.plugin.getPlayerManager().getUser(player)) == null || !cMIUser.isIgnoring(uUID)) continue;
            arrayList.add(player);
        }
        asyncPlayerChatEvent.getRecipients().removeAll(arrayList);
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onChat(AsyncPlayerChatEvent asyncPlayerChatEvent) {
        if (asyncPlayerChatEvent.isCancelled()) {
            return;
        }
        CMIUser cMIUser = this.plugin.getPlayerManager().getUser(asyncPlayerChatEvent.getPlayer());
        if (cMIUser == null) {
            return;
        }
        ArrayList<Player> arrayList = new ArrayList<Player>();
        if (cMIUser.isSilenceMode()) {
            asyncPlayerChatEvent.getRecipients().clear();
            asyncPlayerChatEvent.getRecipients().add(asyncPlayerChatEvent.getPlayer());
            asyncPlayerChatEvent.setFormat(ChatColor.RED + "[!]" + asyncPlayerChatEvent.getFormat());
            return;
        }
        if (!PermissionsManager.CMIPerm.command_silence_bypass.hasPermission((CommandSender)asyncPlayerChatEvent.getPlayer())) {
            for (Player player : asyncPlayerChatEvent.getRecipients()) {
                cMIUser = this.plugin.getPlayerManager().getUser(player);
                if (cMIUser == null || !cMIUser.isSilenceMode()) continue;
                arrayList.add(player);
            }
        }
        asyncPlayerChatEvent.getRecipients().removeAll(arrayList);
    }

    @EventHandler
    public void FoodLevelChangeEvent(FoodLevelChangeEvent foodLevelChangeEvent) {
        HumanEntity humanEntity = foodLevelChangeEvent.getEntity();
        if (!(humanEntity instanceof Player)) {
            return;
        }
        Player player = (Player)humanEntity;
        CMIUser cMIUser = this.plugin.getPlayerManager().getUser(player);
        if (cMIUser == null) {
            return;
        }
        int n = foodLevelChangeEvent.getFoodLevel() - player.getFoodLevel();
        if (n > 0) {
            return;
        }
        if (!cMIUser.isGod()) {
            return;
        }
        if (Version.isCurrentEqualOrLower((Version)Version.v1_16_R3)) {
            int n2 = player.getFoodLevel();
            CMIScheduler.runTaskLater((JavaPlugin)this.plugin, () -> player.setFoodLevel(n2), (long)0L);
        }
        foodLevelChangeEvent.setCancelled(true);
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void CreatureSpawnEvent(CreatureSpawnEvent creatureSpawnEvent) {
        CreatureSpawnEvent.SpawnReason spawnReason = creatureSpawnEvent.getSpawnReason();
        if (this.plugin.getConfigManager().isBlockedSpawnReason(creatureSpawnEvent.getEntity().getWorld().getName(), spawnReason)) {
            creatureSpawnEvent.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void onPotionSplashEvent(PotionSplashEvent potionSplashEvent) {
        for (LivingEntity livingEntity : potionSplashEvent.getAffectedEntities()) {
            if (!(livingEntity instanceof Player)) continue;
            CMIUser cMIUser = this.plugin.getPlayerManager().getUser((Player)livingEntity);
            if (cMIUser == null) {
                return;
            }
            if (!cMIUser.isGod()) continue;
            potionSplashEvent.setIntensity(livingEntity, 0.0);
        }
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void onEntityDamage(EntityDamageEvent entityDamageEvent) {
        Entity entity = entityDamageEvent.getEntity();
        if (!(entity instanceof Player)) {
            return;
        }
        CMIUser cMIUser = this.plugin.getPlayerManager().getUser((Player)entity);
        if (cMIUser == null) {
            return;
        }
        if (!cMIUser.isGod()) {
            return;
        }
        Player player = cMIUser.getPlayer();
        if (util.imortaldebug) {
            CMIMessages.consoleMessage((String)"PlayerListener onEntityDamage->EntityDamageEvent");
        }
        player.setFireTicks(0);
        player.setRemainingAir(player.getMaximumAir());
        entityDamageEvent.setCancelled(true);
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onPlayerDropItemEvent(PlayerDropItemEvent playerDropItemEvent) {
        Player player = playerDropItemEvent.getPlayer();
        Long l = donate.donateLock.get(player.getUniqueId());
        if (l == null || l + 500L < System.currentTimeMillis()) {
            return;
        }
        playerDropItemEvent.setCancelled(true);
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void onPlayerDropItemEvent(PlayerToggleSprintEvent playerToggleSprintEvent) {
    }

    class HungerCache {
        private int hunger = 20;
        private float saturation = 5.0f;

        public HungerCache(int n, float f) {
            this.hunger = n;
            this.saturation = f;
        }

        public int getHunger() {
            return this.hunger;
        }

        public void setHunger(int n) {
            this.hunger = n;
        }

        public float getSaturation() {
            return this.saturation;
        }

        public void setSaturation(float f) {
            this.saturation = f;
        }
    }
}

