/*
 * Decompiled with CFR 0.152.
 */
package com.Zrips.CMI.AllListeners;

import com.Zrips.CMI.CMI;
import com.Zrips.CMI.Containers.CMIUser;
import com.Zrips.CMI.Locale.CMILC;
import com.Zrips.CMI.Modules.Permissions.PermissionsManager;
import com.Zrips.CMI.Modules.PlayerOptions.PlayerOption;
import java.util.HashMap;
import java.util.UUID;
import net.Zrips.CMILib.CMILib;
import net.Zrips.CMILib.Container.CMINumber;
import net.Zrips.CMILib.Items.CMIItemStack;
import org.bukkit.command.CommandSender;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerItemDamageEvent;

public class PlayerItemDamageListener
implements Listener {
    private CMI plugin;
    HashMap<UUID, Long> informed = new HashMap();

    public PlayerItemDamageListener(CMI cMI) {
        this.plugin = cMI;
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void itemDurabilityLoss(PlayerItemDamageEvent playerItemDamageEvent) {
        if (playerItemDamageEvent.isCancelled() || playerItemDamageEvent.getDamage() == 0) {
            return;
        }
        if (!this.plugin.getConfigManager().isToolDurabilityLossUse()) {
            return;
        }
        CMIItemStack cMIItemStack = CMILib.getInstance().getItemManager().getItem(playerItemDamageEvent.getItem());
        if (cMIItemStack == null || !cMIItemStack.isTool()) {
            return;
        }
        int n = cMIItemStack.getDurability() + playerItemDamageEvent.getDamage();
        short s = cMIItemStack.getMaxDurability();
        if (s - n <= 0) {
            return;
        }
        double d = 100.0 - (double)n * 100.0 / (double)s;
        if (d > (double)this.plugin.getConfigManager().getToolDurabilityLossPercentage()) {
            return;
        }
        Long l = this.informed.get(playerItemDamageEvent.getPlayer().getUniqueId());
        if (l != null && System.currentTimeMillis() - l <= 1000L) {
            return;
        }
        this.informed.put(playerItemDamageEvent.getPlayer().getUniqueId(), System.currentTimeMillis());
        CMIUser cMIUser = CMIUser.getUser(playerItemDamageEvent.getPlayer());
        if (cMIUser == null) {
            return;
        }
        if (!cMIUser.getOptionState(PlayerOption.InformDurability).booleanValue() || !PermissionsManager.CMIPerm.informDurability.hasPermission((CommandSender)playerItemDamageEvent.getPlayer())) {
            return;
        }
        CMILC.info_ItemWillBreak.sendMessage(playerItemDamageEvent.getPlayer(), "[itemName]", cMIItemStack.getDisplayName(), "[current]", CMINumber.clamp((int)(s - n), (int)1, (int)s), "[max]", cMIItemStack.getMaxDurability());
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void armorDurabilityLoss(PlayerItemDamageEvent playerItemDamageEvent) {
        if (playerItemDamageEvent.isCancelled() || playerItemDamageEvent.getDamage() == 0) {
            return;
        }
        if (!this.plugin.getConfigManager().isArmorDurabilityLossUse()) {
            return;
        }
        CMIItemStack cMIItemStack = CMILib.getInstance().getItemManager().getItem(playerItemDamageEvent.getItem());
        if (cMIItemStack == null || !cMIItemStack.isArmor()) {
            return;
        }
        int n = cMIItemStack.getDurability() + playerItemDamageEvent.getDamage();
        short s = cMIItemStack.getMaxDurability();
        if (s - n <= 0) {
            return;
        }
        double d = 100.0 - (double)n * 100.0 / (double)s;
        if (d > (double)this.plugin.getConfigManager().getArmorDurabilityLossPercentage()) {
            return;
        }
        Long l = this.informed.get(playerItemDamageEvent.getPlayer().getUniqueId());
        if (l != null && System.currentTimeMillis() - l <= 1000L) {
            return;
        }
        this.informed.put(playerItemDamageEvent.getPlayer().getUniqueId(), System.currentTimeMillis());
        CMIUser cMIUser = CMIUser.getUser(playerItemDamageEvent.getPlayer());
        if (cMIUser == null) {
            return;
        }
        if (!cMIUser.getOptionState(PlayerOption.InformDurability).booleanValue() || !PermissionsManager.CMIPerm.informDurability.hasPermission((CommandSender)playerItemDamageEvent.getPlayer())) {
            return;
        }
        CMILC.info_ArmorWillBreak.sendMessage(playerItemDamageEvent.getPlayer(), "[itemName]", cMIItemStack.getDisplayName(), "[current]", s - n, "[max]", cMIItemStack.getMaxDurability());
    }
}

