/*
 * Decompiled with CFR 0.152.
 */
package com.Zrips.CMI.AllListeners;

import com.Zrips.CMI.AllListeners.UserEvents;
import com.Zrips.CMI.CMI;
import com.Zrips.CMI.Containers.CMISoundPreset;
import com.Zrips.CMI.Locale.CMILC;
import com.Zrips.CMI.Modules.Particl.CMIPEAnimationInterface;
import com.Zrips.CMI.Modules.Particl.ParticleManager;
import com.Zrips.CMI.Modules.Permissions.PermissionsManager;
import com.Zrips.CMI.Modules.Teleportations.CMITeleportCondition;
import com.Zrips.CMI.Modules.Teleportations.CMITeleportFeedback;
import com.Zrips.CMI.Modules.Teleportations.CMITeleportType;
import java.awt.Color;
import java.util.HashMap;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import net.Zrips.CMILib.Colors.CMIChatColor;
import net.Zrips.CMILib.Colors.CMIColors;
import net.Zrips.CMILib.Container.CMIBlock;
import net.Zrips.CMILib.Container.CMIWorld;
import net.Zrips.CMILib.Items.CMIMaterial;
import net.Zrips.CMILib.Locale.LC;
import net.Zrips.CMILib.Version.Schedulers.CMIScheduler;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.Sign;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.SignChangeEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.plugin.java.JavaPlugin;

public class ElevatorListener
implements Listener {
    private CMI plugin;
    HashMap<UUID, Long> elevatorUsage = new HashMap();

    public ElevatorListener(CMI cMI) {
        this.plugin = cMI;
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onSignChangeEventElevator(SignChangeEvent signChangeEvent) {
        if (signChangeEvent.isCancelled()) {
            return;
        }
        Player player = signChangeEvent.getPlayer();
        if (player == null) {
            return;
        }
        CMIScheduler.runAtLocation((JavaPlugin)this.plugin, (Location)signChangeEvent.getBlock().getLocation(), () -> {
            if (!(signChangeEvent.getBlock().getState() instanceof Sign)) {
                return;
            }
            Sign sign = (Sign)signChangeEvent.getBlock().getState();
            String string = CMIChatColor.stripColor((String)sign.getLine(0));
            if (!this.plugin.getConfigManager().getElevatorIndicators().contains(string.toLowerCase())) {
                return;
            }
            if (PermissionsManager.CMIPerm.elevator_create.hasPermission((CommandSender)signChangeEvent.getPlayer(), true, new String[0])) {
                CMILC.info_Elevator_created.sendMessage(signChangeEvent.getPlayer(), new Object[0]);
                return;
            }
            sign.setLine(0, CMIChatColor.translate((String)("*&m" + string + "&r*")));
            sign.update();
        });
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void PlayerInteractEvent(PlayerInteractEvent playerInteractEvent) {
        if (playerInteractEvent.isCancelled()) {
            return;
        }
        Block block = playerInteractEvent.getClickedBlock();
        if (block == null) {
            return;
        }
        if (!(block.getState() instanceof Sign)) {
            return;
        }
        if (!playerInteractEvent.getAction().equals((Object)Action.RIGHT_CLICK_BLOCK)) {
            return;
        }
        Sign sign = (Sign)block.getState();
        String string = CMIChatColor.stripColor((String)sign.getLine(0));
        if (!this.plugin.getConfigManager().getElevatorIndicators().contains(string.toLowerCase())) {
            return;
        }
        if (!PermissionsManager.CMIPerm.elevator_use.hasPermission((CommandSender)playerInteractEvent.getPlayer(), true, new String[0])) {
            return;
        }
        Boolean bl = !playerInteractEvent.getPlayer().isSneaking();
        CompletableFuture<CMITeleportFeedback> completableFuture = this.findTeleportLocation(playerInteractEvent.getPlayer(), sign.getLocation(), bl);
        completableFuture.thenAccept(cMITeleportFeedback2 -> {
            if (cMITeleportFeedback2 == null || !cMITeleportFeedback2.getCondition().equals((Object)CMITeleportCondition.Good)) {
                LC.info_nolocation.sendMessage((Object)playerInteractEvent.getPlayer(), new Object[0]);
                return;
            }
            Long l = this.elevatorUsage.get(playerInteractEvent.getPlayer().getUniqueId());
            if (l != null && l > System.currentTimeMillis()) {
                playerInteractEvent.setCancelled(true);
                return;
            }
            this.elevatorUsage.put(playerInteractEvent.getPlayer().getUniqueId(), System.currentTimeMillis() + 500L);
            Location location = cMITeleportFeedback2.getLocation().clone();
            Location location2 = playerInteractEvent.getPlayer().getLocation().clone();
            location.setPitch(location2.getPitch());
            location.setYaw(location2.getYaw());
            UserEvents.addBackLocationExclusion(playerInteractEvent.getPlayer().getUniqueId());
            this.plugin.getTeleportHandler().teleportPlayer(playerInteractEvent.getPlayer(), location, CMITeleportType.Elevator).thenAccept(cMITeleportFeedback -> {
                if (!cMITeleportFeedback.isSuccess()) {
                    return;
                }
                if (bl.booleanValue()) {
                    if (ParticleManager.CMIPresetAnimations.TpUp.isEnabled()) {
                        CMIPEAnimationInterface cMIPEAnimationInterface = ParticleManager.CMIPresetAnimations.TpUp.getInter();
                        cMIPEAnimationInterface.setColor(ElevatorListener.getColor(location2.clone().add(0.0, -1.0, 0.0).getBlock()));
                        cMIPEAnimationInterface.setCenter(location2);
                        cMIPEAnimationInterface.show();
                        cMIPEAnimationInterface = ParticleManager.CMIPresetAnimations.TpUp.getInter();
                        cMIPEAnimationInterface.setColor(ElevatorListener.getColor(playerInteractEvent.getPlayer().getLocation().clone().add(0.0, -2.0, 0.0).getBlock()));
                        cMIPEAnimationInterface.setCenter(playerInteractEvent.getPlayer().getLocation().clone().add(0.0, -1.0, 0.0));
                        cMIPEAnimationInterface.show();
                    }
                    CMISoundPreset.TeleportUp.play(playerInteractEvent.getPlayer().getLocation());
                    CMISoundPreset.TeleportUp.play(location2);
                } else {
                    if (ParticleManager.CMIPresetAnimations.TpDown.isEnabled()) {
                        CMIPEAnimationInterface cMIPEAnimationInterface = ParticleManager.CMIPresetAnimations.TpDown.getInter();
                        cMIPEAnimationInterface.setColor(ElevatorListener.getColor(location2.clone().add(0.0, -1.0, 0.0).getBlock()));
                        cMIPEAnimationInterface.setCenter(location2);
                        cMIPEAnimationInterface.show();
                        cMIPEAnimationInterface = ParticleManager.CMIPresetAnimations.TpDown.getInter();
                        cMIPEAnimationInterface.setColor(ElevatorListener.getColor(playerInteractEvent.getPlayer().getLocation().clone().add(0.0, -2.0, 0.0).getBlock()));
                        cMIPEAnimationInterface.setCenter(playerInteractEvent.getPlayer().getLocation().clone().add(0.0, -1.0, 0.0));
                        cMIPEAnimationInterface.show();
                    }
                    CMISoundPreset.TeleportDown.play(playerInteractEvent.getPlayer().getLocation());
                    CMISoundPreset.TeleportDown.play(location2);
                }
            });
        });
        playerInteractEvent.setCancelled(true);
    }

    private static Color getColor(Block block) {
        CMIMaterial cMIMaterial = CMIMaterial.get((Block)block);
        CMIColors cMIColors = CMIColors.getColor((CMIMaterial)cMIMaterial);
        Color color = null;
        if (cMIColors != null) {
            color = cMIColors.getColor();
        }
        if (color == null) {
            color = Color.CYAN;
        }
        return color;
    }

    private CompletableFuture<CMITeleportFeedback> findTeleportLocation(Player player, Location location, boolean bl) {
        if (bl) {
            Location location2 = location.clone().add(0.0, 2.0, 0.0);
            int n = location2.getBlockY();
            while (n < location2.getWorld().getHighestBlockAt(location2).getY()) {
                location2.add(0.0, 1.0, 0.0);
                Block block = location2.getBlock();
                if (block.getState() instanceof Sign) {
                    Sign sign = (Sign)block.getState();
                    String string = CMIChatColor.stripColor((String)sign.getLine(0));
                    if (this.plugin.getConfigManager().getElevatorIndicators().contains(string.toLowerCase())) {
                        Location location3 = location2.clone();
                        boolean bl2 = CMIChatColor.stripColor((String)sign.getLine(1)).equalsIgnoreCase(this.plugin.getConfigManager().getElevatorStaticIndicator());
                        if (bl2) {
                            CMIBlock cMIBlock = new CMIBlock(block);
                            Location location4 = sign.getLocation().clone();
                            if (cMIBlock.getFacing() != null) {
                                location4.add((double)cMIBlock.getFacing().getModX(), 0.0, (double)cMIBlock.getFacing().getModZ());
                            }
                            location3.setX((double)location4.getBlockX() + 0.5);
                            location3.setZ((double)location4.getBlockZ() + 0.5);
                        } else {
                            location3.setX(player.getLocation().getX());
                            location3.setZ(player.getLocation().getZ());
                        }
                        return this.plugin.getTeleportHandler().getSafeLocation(player, location3.clone(), 2, 2, false);
                    }
                }
                ++n;
            }
        } else {
            Location location5 = location.clone().add(0.0, -2.0, 0.0);
            int n = location5.getBlockY();
            while (n > CMIWorld.getMinHeight((World)location.getWorld()) + 1) {
                location5.setY((double)n + 0.01);
                Block block = location5.getBlock();
                if (block.getState() instanceof Sign) {
                    Sign sign = (Sign)block.getState();
                    String string = CMIChatColor.stripColor((String)sign.getLine(0));
                    if (this.plugin.getConfigManager().getElevatorIndicators().contains(string.toLowerCase())) {
                        Location location6 = location5.clone().add(0.0, -0.9, 0.0);
                        boolean bl3 = CMIChatColor.stripColor((String)sign.getLine(1)).equalsIgnoreCase(this.plugin.getConfigManager().getElevatorStaticIndicator());
                        if (bl3) {
                            CMIBlock cMIBlock = new CMIBlock(block);
                            Location location7 = sign.getLocation().clone();
                            if (cMIBlock.getFacing() != null) {
                                location7.add((double)cMIBlock.getFacing().getModX(), 0.0, (double)cMIBlock.getFacing().getModZ());
                            }
                            location6.setX((double)location7.getBlockX() + 0.5);
                            location6.setZ((double)location7.getBlockZ() + 0.5);
                        } else {
                            location6.setX(player.getLocation().getX());
                            location6.setZ(player.getLocation().getZ());
                        }
                        return this.plugin.getTeleportHandler().getSafeLocation(player, location6.clone(), 2, 2, false);
                    }
                }
                --n;
            }
        }
        return CompletableFuture.completedFuture(null);
    }
}

